/*
SQLyog Community v13.1.5  (64 bit)
MySQL - 5.7.26 : Database - gzczxuxknk
*********************************************************************
*/

/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

/*Table structure for table `acrm_accounts` */

DROP TABLE IF EXISTS `acrm_accounts`;

CREATE TABLE `acrm_accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `initial_balance` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_person` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `accounts_deleted_at_index` (`deleted_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_accounts` */

/*Table structure for table `acrm_accounts_actions` */

DROP TABLE IF EXISTS `acrm_accounts_actions`;

CREATE TABLE `acrm_accounts_actions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_model` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `record` text COLLATE utf8mb4_unicode_ci,
  `amount` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_acrm_accounts_actions_user_id_idx` (`user_id`),
  CONSTRAINT `fk_acrm_accounts_actions_user_id` FOREIGN KEY (`user_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_accounts_actions` */

/*Table structure for table `acrm_admin_menu_items` */

DROP TABLE IF EXISTS `acrm_admin_menu_items`;

CREATE TABLE `acrm_admin_menu_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` int(10) unsigned NOT NULL DEFAULT '0',
  `sort` int(11) NOT NULL DEFAULT '0',
  `class` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `menu` int(10) unsigned NOT NULL,
  `depth` int(11) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `permission` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_html` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `theme` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `admin_menu_items_menu_foreign` (`menu`),
  CONSTRAINT `admin_menu_items_menu_foreign` FOREIGN KEY (`menu`) REFERENCES `acrm_admin_menus` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_admin_menu_items` */

/*Table structure for table `acrm_admin_menus` */

DROP TABLE IF EXISTS `acrm_admin_menus`;

CREATE TABLE `acrm_admin_menus` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_admin_menus` */

/*Table structure for table `acrm_article_content_category` */

DROP TABLE IF EXISTS `acrm_article_content_category`;

CREATE TABLE `acrm_article_content_category` (
  `article_id` int(10) unsigned DEFAULT NULL,
  `content_category_id` int(10) unsigned DEFAULT NULL,
  KEY `fk_p_259566_259301_conten_5c5036ef1e1ea` (`article_id`),
  KEY `fk_p_259301_259566_articl_5c5036ef1e28b` (`content_category_id`),
  CONSTRAINT `fk_p_259301_259566_articl_5c5036ef1e28b` FOREIGN KEY (`content_category_id`) REFERENCES `acrm_content_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_p_259566_259301_conten_5c5036ef1e1ea` FOREIGN KEY (`article_id`) REFERENCES `acrm_articles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_article_content_category` */

/*Table structure for table `acrm_article_content_tag` */

DROP TABLE IF EXISTS `acrm_article_content_tag`;

CREATE TABLE `acrm_article_content_tag` (
  `article_id` int(10) unsigned DEFAULT NULL,
  `content_tag_id` int(10) unsigned DEFAULT NULL,
  KEY `fk_p_259566_259302_conten_5c5036ef21e14` (`article_id`),
  KEY `fk_p_259302_259566_articl_5c5036ef21ee1` (`content_tag_id`),
  CONSTRAINT `fk_p_259302_259566_articl_5c5036ef21ee1` FOREIGN KEY (`content_tag_id`) REFERENCES `acrm_content_tags` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_p_259566_259302_conten_5c5036ef21e14` FOREIGN KEY (`article_id`) REFERENCES `acrm_articles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_article_content_tag` */

/*Table structure for table `acrm_article_role` */

DROP TABLE IF EXISTS `acrm_article_role`;

CREATE TABLE `acrm_article_role` (
  `article_id` int(10) unsigned DEFAULT NULL,
  `role_id` int(10) unsigned DEFAULT NULL,
  KEY `fk_p_259566_259279_role_a_5c5036ef25cd9` (`article_id`),
  KEY `fk_p_259279_259566_articl_5c5036ef25db4` (`role_id`),
  CONSTRAINT `fk_p_259279_259566_articl_5c5036ef25db4` FOREIGN KEY (`role_id`) REFERENCES `acrm_roles` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_p_259566_259279_role_a_5c5036ef25cd9` FOREIGN KEY (`article_id`) REFERENCES `acrm_articles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_article_role` */

/*Table structure for table `acrm_articles` */

DROP TABLE IF EXISTS `acrm_articles`;

CREATE TABLE `acrm_articles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `page_text` text COLLATE utf8mb4_unicode_ci,
  `excerpt` text COLLATE utf8mb4_unicode_ci,
  `featured_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_articles` */

/*Table structure for table `acrm_assets` */

DROP TABLE IF EXISTS `acrm_assets`;

CREATE TABLE `acrm_assets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `serial_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `photo1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `photo2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `status_id` int(10) unsigned DEFAULT NULL,
  `location_id` int(10) unsigned DEFAULT NULL,
  `assigned_user_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `259312_5c4fd97bee5f9` (`status_id`),
  KEY `259312_5c4fd97c1c3b2` (`location_id`),
  KEY `259312_5c4fd97c37c6b` (`assigned_user_id`),
  KEY `259312_5c4fd97bd71bf_idx` (`category_id`),
  CONSTRAINT `259312_5c4fd97bd71bf` FOREIGN KEY (`category_id`) REFERENCES `acrm_assets_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `259312_5c4fd97bee5f9` FOREIGN KEY (`status_id`) REFERENCES `acrm_assets_statuses` (`id`) ON DELETE CASCADE,
  CONSTRAINT `259312_5c4fd97c1c3b2` FOREIGN KEY (`location_id`) REFERENCES `acrm_assets_locations` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_acrm_assets_assigned_user_id` FOREIGN KEY (`assigned_user_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_assets` */

/*Table structure for table `acrm_assets_categories` */

DROP TABLE IF EXISTS `acrm_assets_categories`;

CREATE TABLE `acrm_assets_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_assets_categories` */

/*Table structure for table `acrm_assets_histories` */

DROP TABLE IF EXISTS `acrm_assets_histories`;

CREATE TABLE `acrm_assets_histories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `asset_id` int(10) unsigned DEFAULT NULL,
  `status_id` int(10) unsigned DEFAULT NULL,
  `location_id` int(10) unsigned DEFAULT NULL,
  `assigned_user_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `259313_5c4fd98601861` (`asset_id`),
  KEY `259313_5c4fd98619efc` (`status_id`),
  KEY `259313_5c4fd98631757` (`location_id`),
  KEY `fk_acrm_assets_histories_assigned_user_id` (`assigned_user_id`),
  CONSTRAINT `259313_5c4fd98601861` FOREIGN KEY (`asset_id`) REFERENCES `acrm_assets` (`id`) ON DELETE CASCADE,
  CONSTRAINT `259313_5c4fd98619efc` FOREIGN KEY (`status_id`) REFERENCES `acrm_assets_statuses` (`id`) ON DELETE CASCADE,
  CONSTRAINT `259313_5c4fd98631757` FOREIGN KEY (`location_id`) REFERENCES `acrm_assets_locations` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_acrm_assets_histories_assigned_user_id` FOREIGN KEY (`assigned_user_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_assets_histories` */

/*Table structure for table `acrm_assets_locations` */

DROP TABLE IF EXISTS `acrm_assets_locations`;

CREATE TABLE `acrm_assets_locations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_assets_locations` */

/*Table structure for table `acrm_assets_statuses` */

DROP TABLE IF EXISTS `acrm_assets_statuses`;

CREATE TABLE `acrm_assets_statuses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_assets_statuses` */

/*Table structure for table `acrm_brands` */

DROP TABLE IF EXISTS `acrm_brands`;

CREATE TABLE `acrm_brands` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('Active','Inactive') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `brands_deleted_at_index` (`deleted_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_brands` */

/*Table structure for table `acrm_cache` */

DROP TABLE IF EXISTS `acrm_cache`;

CREATE TABLE `acrm_cache` (
  `key` varchar(255) NOT NULL,
  `value` longtext,
  `expiration` int(11) DEFAULT NULL,
  PRIMARY KEY (`key`),
  UNIQUE KEY `key_UNIQUE` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `acrm_cache` */

/*Table structure for table `acrm_cart_orders` */

DROP TABLE IF EXISTS `acrm_cart_orders`;

CREATE TABLE `acrm_cart_orders` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('Pending','Active') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price` decimal(15,2) DEFAULT NULL,
  `products` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `customer_id` int(10) unsigned DEFAULT NULL,
  `billing_cycle_id` int(10) unsigned DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `cart_orders_deleted_at_index` (`deleted_at`),
  KEY `270937_5c7544840ggggdff5` (`customer_id`),
  KEY `270937_5c754ggggd484400c2` (`billing_cycle_id`),
  CONSTRAINT `270937_5c7544840ggggdff5` FOREIGN KEY (`customer_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `270937_5c754ggggd484400c2` FOREIGN KEY (`billing_cycle_id`) REFERENCES `acrm_recurring_periods` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_cart_orders` */

/*Table structure for table `acrm_cart_orders_products` */

DROP TABLE IF EXISTS `acrm_cart_orders_products`;

CREATE TABLE `acrm_cart_orders_products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `quantity` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `cart_order_id` int(10) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `270937_5c75448ffff40ggggdff5` (`cart_order_id`),
  KEY `270937_5c7rerre54ggggd484400c2` (`product_id`),
  CONSTRAINT `270937_5c7rerre54ggggd484400c2` FOREIGN KEY (`product_id`) REFERENCES `acrm_products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_cart_orders_products` */

/*Table structure for table `acrm_client_project_notes` */

DROP TABLE IF EXISTS `acrm_client_project_notes`;

CREATE TABLE `acrm_client_project_notes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(10) unsigned NOT NULL,
  `description` longtext NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_project_id_project_notes` (`project_id`),
  KEY `fk_acrm_client_project_notes_user_id_idx` (`user_id`),
  CONSTRAINT `fk_acrm_client_project_notes_user_id` FOREIGN KEY (`user_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_project_id_project_notes` FOREIGN KEY (`project_id`) REFERENCES `acrm_client_projects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `acrm_client_project_notes` */

/*Table structure for table `acrm_client_project_project_tab` */

DROP TABLE IF EXISTS `acrm_client_project_project_tab`;

CREATE TABLE `acrm_client_project_project_tab` (
  `client_project_id` int(10) unsigned DEFAULT NULL,
  `project_tab_id` int(10) unsigned DEFAULT NULL,
  KEY `fk_p_259358_299518_projec_5cca76c1b594a` (`client_project_id`),
  KEY `fk_p_299518_259358_client_5cca76c1b5a79` (`project_tab_id`),
  CONSTRAINT `fk_p_259358_299518_projec_5cca76c1b594a` FOREIGN KEY (`client_project_id`) REFERENCES `acrm_client_projects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_p_299518_259358_client_5cca76c1b5a79` FOREIGN KEY (`project_tab_id`) REFERENCES `acrm_project_tabs` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_client_project_project_tab` */

/*Table structure for table `acrm_client_project_user` */

DROP TABLE IF EXISTS `acrm_client_project_user`;

CREATE TABLE `acrm_client_project_user` (
  `client_project_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  KEY `fk_p_259358_259280_user_c_5c4ff9d6745f6` (`client_project_id`),
  KEY `fk_p_259280_259358_client_5c4ff9d674690_idx` (`user_id`),
  CONSTRAINT `fk_acrm_client_project_user_1` FOREIGN KEY (`user_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_p_259358_259280_user_c_5c4ff9d6745f6` FOREIGN KEY (`client_project_id`) REFERENCES `acrm_client_projects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_client_project_user` */

/*Table structure for table `acrm_client_projects` */

DROP TABLE IF EXISTS `acrm_client_projects`;

CREATE TABLE `acrm_client_projects` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `budget` double DEFAULT NULL,
  `phase` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `due_date` date DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `priority` enum('Low','Medium','High','Urgent') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status_id` int(10) unsigned DEFAULT NULL,
  `demo_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `client_id` int(10) unsigned DEFAULT NULL,
  `billing_type_id` int(10) unsigned DEFAULT NULL,
  `date_finished` date DEFAULT NULL,
  `progress` int(10) DEFAULT '0',
  `progress_from_tasks` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'yes',
  `project_rate_per_hour` double DEFAULT NULL,
  `estimated_hours` int(10) DEFAULT NULL,
  `hourly_rate` double DEFAULT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client_projects_deleted_at_index` (`deleted_at`),
  KEY `259358_5c4ff380bc7e4` (`status_id`),
  KEY `259358_5c4ff9d6a3140` (`client_id`),
  KEY `259358_5c4ff9d6b9c2b` (`billing_type_id`),
  KEY `fk_acrm_client_projects_currency_id_idx` (`currency_id`),
  CONSTRAINT `259358_5c4ff380bc7e4` FOREIGN KEY (`status_id`) REFERENCES `acrm_project_statuses` (`id`) ON DELETE CASCADE,
  CONSTRAINT `259358_5c4ff9d6a3140` FOREIGN KEY (`client_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `259358_5c4ff9d6b9c2b` FOREIGN KEY (`billing_type_id`) REFERENCES `acrm_project_billing_types` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_acrm_client_projects_currency_id` FOREIGN KEY (`currency_id`) REFERENCES `acrm_currencies` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_client_projects` */

/*Table structure for table `acrm_contact_companies` */

DROP TABLE IF EXISTS `acrm_contact_companies`;

CREATE TABLE `acrm_contact_companies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_by_id` int(10) unsigned DEFAULT NULL,
  `country_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_country_id` (`country_id`),
  KEY `fk_contact_companies_created_by_id_idx` (`created_by_id`),
  CONSTRAINT `fk_contact_companies_created_by_id` FOREIGN KEY (`created_by_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `fk_country_id` FOREIGN KEY (`country_id`) REFERENCES `acrm_countries` (`id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_contact_companies` */

/*Table structure for table `acrm_contact_contact_type` */

DROP TABLE IF EXISTS `acrm_contact_contact_type`;

CREATE TABLE `acrm_contact_contact_type` (
  `contact_id` int(10) unsigned DEFAULT NULL,
  `contact_type_id` int(10) unsigned DEFAULT NULL,
  KEY `fk_p_259284_259435_contac_5c501141edc45` (`contact_id`),
  KEY `fk_p_259435_259284_contac_5c501141edcee` (`contact_type_id`),
  CONSTRAINT `fk_p_259284_259435_contac_5c501141edc45` FOREIGN KEY (`contact_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_p_259435_259284_contac_5c501141edcee` FOREIGN KEY (`contact_type_id`) REFERENCES `acrm_roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_contact_contact_type` */

/*Table structure for table `acrm_contact_documents` */

DROP TABLE IF EXISTS `acrm_contact_documents`;

CREATE TABLE `acrm_contact_documents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `contact_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contact_documents_deleted_at_index` (`deleted_at`),
  KEY `259458_5c501af71b1d4` (`contact_id`),
  CONSTRAINT `259458_5c501af71b1d4` FOREIGN KEY (`contact_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_contact_documents` */

/*Table structure for table `acrm_contact_email_campaigns` */

DROP TABLE IF EXISTS `acrm_contact_email_campaigns`;

CREATE TABLE `acrm_contact_email_campaigns` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `list_id` varchar(191) DEFAULT NULL,
  `list_name` varchar(191) DEFAULT NULL,
  `subject` varchar(191) DEFAULT NULL,
  `from_name` varchar(191) DEFAULT NULL,
  `from_email` varchar(191) DEFAULT NULL,
  `is_schedule` enum('yes','no') DEFAULT 'no',
  `schedule_date` datetime DEFAULT NULL,
  `content` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT '0000-00-00 00:00:00',
  `campaign_id` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `acrm_contact_email_campaigns` */

/*Table structure for table `acrm_contact_groups` */

DROP TABLE IF EXISTS `acrm_contact_groups`;

CREATE TABLE `acrm_contact_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contact_groups_deleted_at_index` (`deleted_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_contact_groups` */

/*Table structure for table `acrm_contact_language` */

DROP TABLE IF EXISTS `acrm_contact_language`;

CREATE TABLE `acrm_contact_language` (
  `contact_id` int(10) unsigned DEFAULT NULL,
  `language_id` int(10) unsigned DEFAULT NULL,
  KEY `fk_p_259284_259346_langua_5c501141f1b07` (`contact_id`),
  KEY `fk_p_259346_259284_contac_5c501141f1ba0` (`language_id`),
  CONSTRAINT `fk_p_259284_259346_langua_5c501141f1b07` FOREIGN KEY (`contact_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_p_259346_259284_contac_5c501141f1ba0` FOREIGN KEY (`language_id`) REFERENCES `acrm_languages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_contact_language` */

/*Table structure for table `acrm_contact_notes` */

DROP TABLE IF EXISTS `acrm_contact_notes`;

CREATE TABLE `acrm_contact_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `contact_id` int(10) unsigned DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contact_notes_deleted_at_index` (`deleted_at`),
  KEY `259436_5c500fb829d8c` (`contact_id`),
  CONSTRAINT `259436_5c500fb829d8c` FOREIGN KEY (`contact_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_contact_notes` */

/*Table structure for table `acrm_contacts` */

DROP TABLE IF EXISTS `acrm_contacts`;

CREATE TABLE `acrm_contacts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `first_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `thumbnail` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone1_code` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone2_code` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `skype` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `company_id` int(10) unsigned DEFAULT NULL,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state_region` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip_postal_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `group_id` int(10) unsigned DEFAULT NULL,
  `country_id` int(10) unsigned DEFAULT NULL,
  `delivery_address` text COLLATE utf8mb4_unicode_ci,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `language_id` int(10) unsigned DEFAULT NULL,
  `ticket_emails` tinyint(1) DEFAULT '1' COMMENT '1 - Can Receive Ticket Email, 0 - Not receive Support Ticket Emails',
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fulladdress` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL COMMENT 'User Specific fields',
  `password` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `department_id` int(10) unsigned DEFAULT NULL,
  `ticketit_admin` tinyint(1) DEFAULT '0',
  `ticketit_agent` tinyint(1) DEFAULT '0',
  `status` enum('Registered','Supended','Active','Deleted') COLLATE utf8mb4_unicode_ci DEFAULT 'Active',
  `theme` char(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `portal_language` char(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `confirmation_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_login_from` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hourly_rate` double DEFAULT NULL,
  `is_user` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `color_theme` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color_skin` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT 'skin-blue',
  PRIMARY KEY (`id`),
  KEY `259284_5c4fd316a790e` (`company_id`),
  KEY `259284_5c5011422b03a` (`group_id`),
  KEY `259284_5c5148b6efcd4` (`country_id`),
  KEY `fk_contacts_currency_id` (`currency_id`),
  KEY `fk_contacts_language_id` (`language_id`),
  CONSTRAINT `259284_5c4fd316a790e` FOREIGN KEY (`company_id`) REFERENCES `acrm_contact_companies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `259284_5c5011422b03a` FOREIGN KEY (`group_id`) REFERENCES `acrm_contact_groups` (`id`) ON DELETE SET NULL,
  CONSTRAINT `259284_5c5148b6efcd4` FOREIGN KEY (`country_id`) REFERENCES `acrm_countries` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_contacts_currency_id` FOREIGN KEY (`currency_id`) REFERENCES `acrm_currencies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_contacts_language_id` FOREIGN KEY (`language_id`) REFERENCES `acrm_languages` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


/*Table structure for table `acrm_content_categories` */

DROP TABLE IF EXISTS `acrm_content_categories`;

CREATE TABLE `acrm_content_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_content_categories` */

/*Table structure for table `acrm_content_category_content_page` */

DROP TABLE IF EXISTS `acrm_content_category_content_page`;

CREATE TABLE `acrm_content_category_content_page` (
  `content_category_id` int(10) unsigned DEFAULT NULL,
  `content_page_id` int(10) unsigned DEFAULT NULL,
  KEY `fk_p_259301_259303_conten_5c4fd82ff2c4c` (`content_category_id`),
  KEY `fk_p_259303_259301_conten_5c4fd82ff2cf2` (`content_page_id`),
  CONSTRAINT `fk_p_259301_259303_conten_5c4fd82ff2c4c` FOREIGN KEY (`content_category_id`) REFERENCES `acrm_content_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_p_259303_259301_conten_5c4fd82ff2cf2` FOREIGN KEY (`content_page_id`) REFERENCES `acrm_content_pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_content_category_content_page` */

/*Table structure for table `acrm_content_page_content_tag` */

DROP TABLE IF EXISTS `acrm_content_page_content_tag`;

CREATE TABLE `acrm_content_page_content_tag` (
  `content_page_id` int(10) unsigned DEFAULT NULL,
  `content_tag_id` int(10) unsigned DEFAULT NULL,
  KEY `fk_p_259303_259302_conten_5c4fd83002c71` (`content_page_id`),
  KEY `fk_p_259302_259303_conten_5c4fd83002d39` (`content_tag_id`),
  CONSTRAINT `fk_p_259302_259303_conten_5c4fd83002d39` FOREIGN KEY (`content_tag_id`) REFERENCES `acrm_content_tags` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_p_259303_259302_conten_5c4fd83002c71` FOREIGN KEY (`content_page_id`) REFERENCES `acrm_content_pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_content_page_content_tag` */

/*Table structure for table `acrm_content_pages` */

DROP TABLE IF EXISTS `acrm_content_pages`;

CREATE TABLE `acrm_content_pages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `page_text` text COLLATE utf8mb4_unicode_ci,
  `excerpt` text COLLATE utf8mb4_unicode_ci,
  `featured_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_content_pages` */

/*Table structure for table `acrm_content_tags` */

DROP TABLE IF EXISTS `acrm_content_tags`;

CREATE TABLE `acrm_content_tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_content_tags` */

/*Table structure for table `acrm_contract_task_user` */

DROP TABLE IF EXISTS `acrm_contract_task_user`;

CREATE TABLE `acrm_contract_task_user` (
  `id` int(10) unsigned NOT NULL,
  `contract_task_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `acrm_contract_task_user` */

/*Table structure for table `acrm_contract_tasks` */

DROP TABLE IF EXISTS `acrm_contract_tasks`;

CREATE TABLE `acrm_contract_tasks` (
  `id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci,
  `priority_id` int(10) unsigned DEFAULT NULL,
  `startdate` date DEFAULT NULL,
  `duedate` date DEFAULT NULL,
  `datefinished` date DEFAULT NULL,
  `status_id` int(10) unsigned DEFAULT NULL,
  `recurring_type` enum('day','week','month','year') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `recurring_value` int(10) unsigned DEFAULT '0' COMMENT '''0'' means not recurring',
  `cycles` int(11) DEFAULT NULL,
  `total_cycles` int(10) unsigned DEFAULT NULL,
  `last_recurring_date` date DEFAULT NULL,
  `is_public` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'yes',
  `billable` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'yes',
  `billed` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `hourly_rate` double DEFAULT '0',
  `kanban_order` int(11) DEFAULT NULL,
  `milestone_order` int(11) DEFAULT NULL,
  `visible_to_client` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `deadline_notified` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `recurring_id` int(10) unsigned DEFAULT NULL,
  `contract_id` int(10) unsigned DEFAULT NULL,
  `created_by_id` int(10) unsigned DEFAULT NULL,
  `mile_stone_id` int(10) unsigned DEFAULT NULL,
  `is_recurring_from` int(10) unsigned DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_contract_tasks` */

/*Table structure for table `acrm_contract_types` */

DROP TABLE IF EXISTS `acrm_contract_types`;

CREATE TABLE `acrm_contract_types` (
  `id` int(50) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(300) CHARACTER SET utf8 NOT NULL,
  `description` text CHARACTER SET utf8,
  `created_at` date NOT NULL,
  `updated_at` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

/*Data for the table `acrm_contract_types` */

insert  into `acrm_contract_types`(`id`,`name`,`description`,`created_at`,`updated_at`) values 
(2,'Express Contracts',NULL,'2019-09-25','2019-09-25'),
(3,'Contracts under Seal',NULL,'2019-09-25','2019-09-25'),
(4,'Implied Contracts',NULL,'2019-09-25','2019-09-25');

/*Table structure for table `acrm_contracts` */

DROP TABLE IF EXISTS `acrm_contracts`;

CREATE TABLE `acrm_contracts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `invoice_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_quantity_as` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contract_value` int(100) unsigned NOT NULL,
  `contract_type_id` int(50) unsigned NOT NULL,
  `visible_to_customer` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `invoice_no` bigint(22) DEFAULT NULL,
  `status` enum('Published','Draft') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_date` date DEFAULT NULL,
  `invoice_due_date` date DEFAULT NULL,
  `invoice_notes` text COLLATE utf8mb4_unicode_ci COMMENT 'Client Notes',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `customer_id` int(10) unsigned DEFAULT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `tax_id` int(10) unsigned DEFAULT NULL,
  `discount_id` int(10) unsigned DEFAULT NULL,
  `recurring_period_id` int(10) unsigned DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `products` longtext COLLATE utf8mb4_unicode_ci,
  `paymentstatus` char(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_id` int(10) unsigned DEFAULT NULL,
  `created_by_id` int(10) unsigned DEFAULT NULL,
  `delivery_address` text COLLATE utf8mb4_unicode_ci COMMENT 'Shipping address',
  `show_delivery_address` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `admin_notes` text COLLATE utf8mb4_unicode_ci,
  `sale_agent` int(10) unsigned DEFAULT NULL,
  `terms_conditions` longtext COLLATE utf8mb4_unicode_ci,
  `prevent_overdue_reminders` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `is_expiry_notified` tinyint(1) DEFAULT '0',
  `invoice_number_format` char(20) COLLATE utf8mb4_unicode_ci DEFAULT 'numberbased',
  `invoice_number_separator` char(5) COLLATE utf8mb4_unicode_ci DEFAULT '-',
  `invoice_number_length` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_contracts` */

/*Table structure for table `acrm_contracts_history` */

DROP TABLE IF EXISTS `acrm_contracts_history`;

CREATE TABLE `acrm_contracts_history` (
  `id` int(10) unsigned NOT NULL,
  `ip_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` text COLLATE utf8mb4_unicode_ci,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `browser` text COLLATE utf8mb4_unicode_ci,
  `comments` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `contract_id` int(10) unsigned DEFAULT NULL,
  `operation_type` char(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'general, crud, email, sms, cron, payment, status'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_contracts_history` */

/*Table structure for table `acrm_contracts_notes` */

DROP TABLE IF EXISTS `acrm_contracts_notes`;

CREATE TABLE `acrm_contracts_notes` (
  `id` int(10) unsigned NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `date_contacted` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `contract_id` int(10) unsigned DEFAULT NULL,
  `created_by_id` int(10) unsigned DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_contracts_notes` */

/*Table structure for table `acrm_contracts_reminders` */

DROP TABLE IF EXISTS `acrm_contracts_reminders`;

CREATE TABLE `acrm_contracts_reminders` (
  `id` int(10) unsigned NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `date` date DEFAULT NULL,
  `isnotified` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notify_by_email` enum('no','yes') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `contract_id` int(10) unsigned DEFAULT NULL,
  `reminder_to_id` int(10) unsigned DEFAULT NULL,
  `created_by_id` int(10) unsigned DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_contracts_reminders` */

/*Table structure for table `acrm_controllers` */

DROP TABLE IF EXISTS `acrm_controllers`;

CREATE TABLE `acrm_controllers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `acrm_controllers` */

/*Table structure for table `acrm_countries` */

DROP TABLE IF EXISTS `acrm_countries`;

CREATE TABLE `acrm_countries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `shortcode` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `dialcode` varchar(6) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `countries_deleted_at_index` (`deleted_at`)
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_countries` */

insert  into `acrm_countries`(`id`,`shortcode`,`title`,`created_at`,`updated_at`,`deleted_at`,`dialcode`) values 
(1,'IN','INDIA','2019-09-20 10:15:41','2019-09-20 10:16:10',NULL,'+91'),
(46,'AF','Afghanistan','2019-10-03 12:20:15','2019-10-03 12:20:15',NULL,'+93'),
(47,'DZ','Algeria','2019-10-03 12:30:01','2019-10-03 12:30:01',NULL,'213'),
(48,'AS','American Samoa','2019-10-03 12:30:25','2019-10-03 12:30:25',NULL,'1-684'),
(49,'AD','Andorra','2019-10-03 12:31:02','2019-10-03 12:31:02',NULL,'376'),
(50,'AO','Angola','2019-10-03 12:31:22','2019-10-03 12:31:22',NULL,'244'),
(52,'AQ','Antarctica','2019-10-03 12:32:47','2019-10-03 12:32:47',NULL,'672'),
(53,'AG','Antigua and Barbuda','2019-10-03 12:33:09','2019-10-03 12:33:09',NULL,'1-268'),
(54,'AR','Argentina','2019-10-03 12:33:26','2019-10-03 12:33:26',NULL,'54'),
(55,'AM','Armenia','2019-10-03 12:33:43','2019-10-03 12:33:43',NULL,'374'),
(56,'aaa','aaaa','2019-10-03 12:34:03','2019-10-03 12:34:03',NULL,'aaaa'),
(57,'AW','Aruba','2019-10-03 12:34:06','2019-10-03 12:34:06',NULL,'297'),
(58,'AU','Australia','2019-10-03 12:34:29','2019-10-03 12:34:29',NULL,'61'),
(59,'sss','sss','2019-10-03 12:34:35','2019-10-03 12:34:35',NULL,'sss'),
(60,'AT','Austria','2019-10-03 12:34:50','2019-10-03 12:34:50',NULL,'43'),
(61,'AZ','Azerbaijan','2019-10-03 12:35:09','2019-10-03 12:35:09',NULL,'994'),
(62,'BS','Bahamas','2019-10-03 12:35:30','2019-10-03 12:35:30',NULL,'1-242'),
(63,'BH','Bahrain','2019-10-03 12:35:51','2019-10-03 12:35:51',NULL,'973'),
(64,'BD','Bangladesh','2019-10-03 12:36:12','2019-10-03 12:36:12',NULL,'880'),
(65,'BB','Barbados','2019-10-03 12:36:30','2019-10-03 12:36:30',NULL,'1-246'),
(66,'BY','Belarus','2019-10-03 12:36:48','2019-10-03 12:36:48',NULL,'375'),
(67,'BE','Belgium','2019-10-03 12:37:09','2019-10-03 12:37:09',NULL,'32'),
(68,'BZ','Belize','2019-10-03 12:37:25','2019-10-03 12:37:25',NULL,'501'),
(69,'BJ','Benin','2019-10-03 12:37:44','2019-10-03 12:37:44',NULL,'229'),
(70,'BM','Bermuda','2019-10-03 12:38:03','2019-10-03 12:38:03',NULL,'1-441'),
(71,'BT','Bhutan','2019-10-03 12:38:21','2019-10-03 12:38:21',NULL,'975'),
(72,'BO','Bolivia','2019-10-03 12:38:49','2019-10-03 12:38:49',NULL,'591'),
(73,'BQ','Bonaire','2019-10-03 12:39:08','2019-10-03 12:39:08',NULL,'599'),
(74,'BA','Bosnia and Herzegovina','2019-10-03 12:39:27','2019-10-03 12:39:27',NULL,'387'),
(75,'BW','Botswana','2019-10-03 12:39:48','2019-10-03 12:39:48',NULL,'267'),
(76,'BV','Bouvet Island','2019-10-03 12:40:11','2019-10-03 12:40:11',NULL,'47'),
(77,'BR','Brazil','2019-10-03 12:40:32','2019-10-03 12:40:32',NULL,'55'),
(78,'IO','British Indian Ocean Territory','2019-10-03 12:41:00','2019-10-03 12:41:00',NULL,'246'),
(79,'BN','Brunei Darussalam','2019-10-03 12:41:23','2019-10-03 12:41:23',NULL,'673'),
(80,'BG','Bulgaria','2019-10-03 12:41:44','2019-10-03 12:41:44',NULL,'359'),
(81,'BF','Burkina Faso','2019-10-03 12:42:00','2019-10-03 12:42:00',NULL,'226'),
(82,'BI','Burundi','2019-10-03 12:43:08','2019-10-03 12:43:08',NULL,'257'),
(83,'KH','Cambodia','2019-10-03 12:43:27','2019-10-03 12:43:27',NULL,'855'),
(84,'CM','Cameroon','2019-10-03 12:43:48','2019-10-03 12:43:48',NULL,'237'),
(85,'CA','Canada','2019-10-03 12:44:09','2019-10-03 12:44:09',NULL,'1'),
(86,'CV','Cape Verde','2019-10-03 12:44:28','2019-10-03 12:44:28',NULL,'238'),
(87,'KY','Cayman Islands','2019-10-03 12:45:00','2019-10-03 12:45:00',NULL,'1-345'),
(88,'CF','Central African Republic','2019-10-03 12:45:30','2019-10-03 12:45:30',NULL,'236'),
(89,'ZW','Zimbabwe','2019-10-03 12:45:47','2019-10-03 12:45:47',NULL,'263'),
(90,'ZM','Zambia','2019-10-03 12:46:13','2019-10-03 12:46:13',NULL,'260'),
(91,'TD','Chad','2019-10-03 12:46:13','2019-10-03 12:46:13',NULL,'235'),
(92,'YE','Yemen','2019-10-03 12:46:34','2019-10-03 12:46:34',NULL,'967'),
(93,'EH','Western Sahara','2019-10-03 12:47:08','2019-10-03 12:47:08',NULL,'212'),
(94,'CL','Chile','2019-10-03 12:47:09','2019-10-03 12:47:09',NULL,'56'),
(95,'CN','China','2019-10-03 12:47:24','2019-10-03 12:47:24',NULL,'86'),
(96,'WF','Wallis and Futuna','2019-10-03 12:47:32','2019-10-03 12:47:32',NULL,'681'),
(97,'CX','Christmas Island','2019-10-03 12:47:43','2019-10-03 12:47:43',NULL,'61'),
(98,'VI','US Virgin Islands','2019-10-03 12:47:55','2019-10-03 12:47:55',NULL,'1-340'),
(99,'CC','Cocos (Keeling) Islands','2019-10-03 12:48:02','2019-10-03 12:48:02',NULL,'61'),
(100,'CO','Colombia','2019-10-03 12:48:42','2019-10-03 12:48:42',NULL,'57'),
(101,'KM','Comoros','2019-10-03 12:49:05','2019-10-03 12:49:05',NULL,'269'),
(102,'VG','British Virgin Islands','2019-10-03 12:49:20','2019-10-03 12:49:20',NULL,'1-284'),
(103,'CG','Congo','2019-10-03 12:49:31','2019-10-03 12:49:31',NULL,'242'),
(104,'VN','Viet Nam','2019-10-03 12:49:41','2019-10-03 12:52:40',NULL,'84'),
(105,'VE','Venezuela','2019-10-03 12:49:56','2019-10-03 12:49:56',NULL,'58'),
(106,'CD','Democratic Republic of the Congo','2019-10-03 12:49:58','2019-10-03 12:49:58',NULL,'243'),
(107,'CK','Cook Islands','2019-10-03 12:50:13','2019-10-03 12:50:13',NULL,'682'),
(108,'VU','Vanuatu','2019-10-03 12:50:14','2019-10-03 12:50:14',NULL,'678'),
(109,'UZ','Uzbekistan','2019-10-03 12:50:32','2019-10-03 12:50:32',NULL,'998'),
(110,'UY','Uruguay','2019-10-03 12:50:51','2019-10-03 12:50:51',NULL,'598'),
(111,'UM','United States Minor Outlying Islands','2019-10-03 12:51:07','2019-10-03 12:51:07',NULL,'1'),
(112,'GB','United Kingdom','2019-10-03 12:51:36','2019-10-03 12:51:36',NULL,'44'),
(113,'AE','United Arab Emirates','2019-10-03 12:51:53','2019-10-03 12:51:53',NULL,'971'),
(114,'CR','Costa Rica','2019-10-03 12:52:00','2019-10-03 12:52:00',NULL,'506'),
(115,'UA','Ukraine','2019-10-03 12:52:13','2019-10-03 12:52:13',NULL,'380'),
(116,'HR','Croatia','2019-10-03 12:52:21','2019-10-03 12:52:21',NULL,'385'),
(117,'UG','Uganda','2019-10-03 12:52:28','2019-10-03 12:52:28',NULL,'256'),
(118,'TV','Tuvalu','2019-10-03 12:52:42','2019-10-03 12:52:42',NULL,'688'),
(119,'TC','Turks and Caicos Islands','2019-10-03 12:53:00','2019-10-03 12:53:00',NULL,'1-649'),
(120,'CU','Cuba','2019-10-03 12:53:10','2019-10-03 12:53:10',NULL,'53'),
(121,'TM','Turkmenistan','2019-10-03 12:53:12','2019-10-03 12:53:12',NULL,'993'),
(122,'TR','Turkey','2019-10-03 12:53:28','2019-10-03 12:53:28',NULL,'90'),
(123,'CW','Curacao','2019-10-03 12:53:28','2019-10-03 12:53:28',NULL,'599'),
(124,'TN','Tunisia','2019-10-03 12:53:40','2019-10-03 12:53:40',NULL,'216'),
(125,'CY','Cyprus','2019-10-03 12:53:46','2019-10-03 12:53:46',NULL,'357'),
(126,'TT','Trinidad and Tobago','2019-10-03 12:54:01','2019-10-03 12:54:01',NULL,'1-868'),
(127,'CZ','Czech Republic','2019-10-03 12:54:04','2019-10-03 12:54:04',NULL,'420'),
(128,'TO','Tonga','2019-10-03 12:54:17','2019-10-03 12:54:17',NULL,'676'),
(129,'CI','Cote d\'Ivoire','2019-10-03 12:54:22','2019-10-03 12:54:22',NULL,'225'),
(130,'TK','Tokelau','2019-10-03 12:54:35','2019-10-03 12:54:35',NULL,'690'),
(131,'DK','Denmark','2019-10-03 12:54:42','2019-10-03 12:54:42',NULL,'45'),
(132,'TG','Togo','2019-10-03 12:54:51','2019-10-03 12:54:51',NULL,'228'),
(133,'DJ','Djibouti','2019-10-03 12:54:58','2019-10-03 12:54:58',NULL,'253'),
(134,'TL','Timor-Leste','2019-10-03 12:55:07','2019-10-03 12:55:07',NULL,'670'),
(135,'DM','Dominica','2019-10-03 12:55:19','2019-10-03 12:55:19',NULL,'1-767'),
(136,'TH','Thailand','2019-10-03 12:55:21','2019-10-03 12:55:21',NULL,'66'),
(137,'TZ','United Republic of Tanzania','2019-10-03 12:55:42','2019-10-03 12:55:42',NULL,'225'),
(138,'TJ','Tajikistan','2019-10-03 12:55:56','2019-10-03 12:55:56',NULL,'992'),
(139,'DO','Dominican Republic','2019-10-03 12:56:19','2019-10-03 12:56:19',NULL,'1-809,'),
(140,'TW','Taiwan','2019-10-03 12:56:20','2019-10-03 12:56:20',NULL,'886'),
(141,'SY','Syrian Arab Republic','2019-10-03 12:56:31','2019-10-03 12:56:31',NULL,'963'),
(142,'EC','Ecuador','2019-10-03 12:56:42','2019-10-03 12:56:42',NULL,'593'),
(143,'CH','Switzerland','2019-10-03 12:56:54','2019-10-03 12:56:54',NULL,'41'),
(144,'EG','Egypt','2019-10-03 12:56:59','2019-10-03 12:56:59',NULL,'20'),
(145,'SE','Sweden','2019-10-03 12:57:06','2019-10-03 12:57:20',NULL,'46'),
(146,'SV','El Salvador','2019-10-03 12:57:16','2019-10-03 12:57:16',NULL,'503'),
(147,'GQ','Equatorial Guinea','2019-10-03 12:57:34','2019-10-03 12:57:34',NULL,'240'),
(148,'SZ','Swaziland','2019-10-03 12:57:41','2019-10-03 12:57:53',NULL,'268'),
(149,'ER','Eritrea','2019-10-03 12:57:58','2019-10-03 12:57:58',NULL,'291'),
(150,'SJ','Svalbard and Jan Mayen','2019-10-03 12:58:11','2019-10-03 12:58:11',NULL,'47'),
(151,'EE','Estonia','2019-10-03 12:58:16','2019-10-03 12:58:16',NULL,'372'),
(152,'SR','Suriname','2019-10-03 12:58:23','2019-10-03 12:58:23',NULL,'597'),
(153,'ET','Ethiopia','2019-10-03 12:58:34','2019-10-03 12:58:34',NULL,'251'),
(154,'SD','Sudan','2019-10-03 12:58:50','2019-10-03 12:58:50',NULL,'249'),
(155,'FK','Falkland Islands (Malvinas)','2019-10-03 12:58:51','2019-10-03 12:58:51',NULL,'500'),
(156,'LK','Sri Lanka','2019-10-03 12:59:13','2019-10-03 12:59:13',NULL,'94'),
(157,'ES','Spain','2019-10-03 12:59:39','2019-10-03 12:59:39',NULL,'34'),
(158,'SS','South Sudan','2019-10-03 12:59:50','2019-10-03 12:59:50',NULL,'211'),
(159,'GS','South Georgia and the South Sandwich Islands','2019-10-03 13:00:06','2019-10-03 13:00:06',NULL,'500'),
(160,'FO','Faroe Islands','2019-10-03 13:00:20','2019-10-03 13:00:20',NULL,'298'),
(161,'ZA','South Africa','2019-10-03 13:00:45','2019-10-03 13:00:45',NULL,'27'),
(162,'FJ','Fiji','2019-10-03 13:00:46','2019-10-03 13:00:46',NULL,'679'),
(163,'SO','Somalia','2019-10-03 13:01:04','2019-10-03 13:01:04',NULL,'252'),
(164,'FI','Finland','2019-10-03 13:01:12','2019-10-03 13:01:12',NULL,'358'),
(165,'SB','Solomon Islands','2019-10-03 13:01:28','2019-10-03 13:01:28',NULL,'677'),
(166,'FR','France','2019-10-03 13:01:45','2019-10-03 13:01:45',NULL,'33'),
(167,'SI','Slovenia','2019-10-03 13:01:56','2019-10-03 13:01:56',NULL,'386'),
(168,'SK','Slovakia','2019-10-03 13:02:11','2019-10-03 13:02:11',NULL,'421'),
(169,'GF','French Guiana','2019-10-03 13:02:18','2019-10-03 13:02:18',NULL,'594'),
(170,'SX','Sint Maarten (Dutch part)','2019-10-03 13:02:28','2019-10-03 13:02:43',NULL,'1-721'),
(171,'PF','French Polynesia','2019-10-03 13:02:35','2019-10-03 13:02:35',NULL,'689'),
(172,'TF','French Southern Territories','2019-10-03 13:02:55','2019-10-03 13:02:55',NULL,'262'),
(173,'SG','`Singapore','2019-10-03 13:03:06','2019-10-03 13:03:06',NULL,'65'),
(174,'GA','Gabon','2019-10-03 13:03:18','2019-10-03 13:03:18',NULL,'241'),
(175,'SL','Sierra Leone','2019-10-03 13:03:21','2019-10-03 13:03:21',NULL,'232'),
(176,'SC','Seychelles','2019-10-03 13:03:39','2019-10-03 13:03:39',NULL,'248'),
(177,'GM','Gambia','2019-10-03 13:03:43','2019-10-03 13:03:43',NULL,'220'),
(178,'RS','Serbia','2019-10-03 13:03:56','2019-10-03 13:03:56',NULL,'381'),
(179,'SN','Senegal','2019-10-03 13:04:37','2019-10-03 13:04:37',NULL,'221'),
(180,'SA','Saudi Arabia','2019-10-03 13:04:49','2019-10-03 13:04:49',NULL,'966'),
(181,'ST','Sao Tome and Principe','2019-10-03 13:07:57','2019-10-03 13:07:57',NULL,'239'),
(182,'SM','San Marino','2019-10-03 13:08:09','2019-10-03 13:08:09',NULL,'378'),
(183,'WS','Samoa','2019-10-03 13:08:39','2019-10-03 13:08:39',NULL,'685'),
(184,'VC','Saint Vincent and the Grenadines','2019-10-03 13:08:53','2019-10-03 13:09:18',NULL,'1-784'),
(185,'PM','Saint Pierre and Miquelon','2019-10-03 13:09:37','2019-10-03 13:09:37',NULL,'508'),
(186,'MF','Saint Martin (French part)','2019-10-03 13:09:49','2019-10-03 13:09:49',NULL,'590'),
(187,'LC','Saint Lucia','2019-10-03 13:10:05','2019-10-03 13:11:40',NULL,'1-758'),
(188,'KN','Saint Kitts and Nevis','2019-10-03 13:11:18','2019-10-03 13:11:18',NULL,'1-869'),
(189,'SH','Saint Helena','2019-10-03 13:11:54','2019-10-03 13:11:54',NULL,'290'),
(190,'BL','Saint Barthelemy','2019-10-03 13:12:12','2019-10-03 13:12:12',NULL,'590'),
(191,'RE','Reunion','2019-10-03 13:12:26','2019-10-03 13:12:26',NULL,'262'),
(192,'RW','Rwanda','2019-10-03 13:12:38','2019-10-03 13:12:38',NULL,'250'),
(193,'RU','Russian Federation','2019-10-03 13:12:53','2019-10-03 13:12:53',NULL,'7'),
(194,'RO','Romania','2019-10-03 13:13:09','2019-10-03 13:13:09',NULL,'40'),
(195,'QA','Qatar','2019-10-03 13:13:26','2019-10-03 13:13:26',NULL,'974'),
(196,'PR','Puerto Rico','2019-10-03 13:13:38','2019-10-03 13:13:38',NULL,'1'),
(197,'PT','Portugal','2019-10-03 13:13:54','2019-10-03 13:13:54',NULL,'351'),
(198,'PL','Poland','2019-10-03 13:14:05','2019-10-03 13:14:05',NULL,'48'),
(199,'PN','Pitcairn','2019-10-03 13:14:25','2019-10-03 13:14:25',NULL,'870'),
(200,'PH','Philippines','2019-10-03 13:14:38','2019-10-03 13:14:38',NULL,'63'),
(201,'PE','Peru','2019-10-03 13:14:54','2019-10-03 13:14:54',NULL,'51'),
(202,'PY','Paraguay','2019-10-03 13:15:19','2019-10-03 13:15:19',NULL,'595'),
(203,'pg','Papua New Guinea','2019-10-03 13:15:34','2019-10-03 13:15:34',NULL,'675'),
(204,'PA','Panama','2019-10-03 13:15:49','2019-10-03 13:15:49',NULL,'507'),
(205,'PS','Palestine, State of','2019-10-03 13:16:07','2019-10-03 13:16:07',NULL,'970'),
(206,'PW','Palau','2019-10-03 13:16:26','2019-10-03 13:16:26',NULL,'680'),
(207,'PK','Pakistan','2019-10-03 13:16:50','2019-10-03 13:16:50',NULL,'92'),
(208,'OM','Oman','2019-10-03 13:17:12','2019-10-03 13:17:12',NULL,'968'),
(209,'NO','Norway','2019-10-03 13:19:16','2019-10-03 13:19:16',NULL,'47'),
(210,'MP','Northern Mariana Islands','2019-10-03 13:19:33','2019-10-03 13:19:33',NULL,'1-670'),
(211,'NF','Norfolk Island','2019-10-03 13:19:43','2019-10-03 13:19:43',NULL,'672'),
(212,'NU','Niue','2019-10-03 13:20:06','2019-10-03 13:20:06',NULL,'673'),
(213,'NG','Nigeria','2019-10-03 13:20:21','2019-10-03 13:20:21',NULL,'234'),
(214,'NE','Niger','2019-10-03 13:20:33','2019-10-03 13:20:33',NULL,'227'),
(215,'NI','Nicaragua','2019-10-03 13:20:53','2019-10-03 13:20:53',NULL,'505'),
(216,'NZ','New Zealand','2019-10-03 13:21:18','2019-10-03 13:21:18',NULL,'64'),
(217,'NC','New Caledonia','2019-10-03 13:21:34','2019-10-03 13:21:34',NULL,'687'),
(218,'NL','Netherlands','2019-10-03 13:21:49','2019-10-03 13:21:49',NULL,'31'),
(219,'NP','Nepal','2019-10-03 13:22:10','2019-10-03 13:22:10',NULL,'977'),
(220,'NR','Nauru','2019-10-03 13:22:28','2019-10-03 13:22:28',NULL,'674'),
(221,'NA','Namibia','2019-10-03 13:22:46','2019-10-03 13:22:46',NULL,'264'),
(222,'MM','Myanmar','2019-10-03 13:25:02','2019-10-03 13:25:02',NULL,'95'),
(223,'MZ','Mozambique','2019-10-03 13:25:13','2019-10-03 13:25:13',NULL,'258'),
(224,'MA','Morocco','2019-10-03 13:25:27','2019-10-03 13:25:27',NULL,'212'),
(225,'MS','Montserrat','2019-10-03 13:25:43','2019-10-03 13:25:43',NULL,'1-664'),
(226,'ME','Montenegro','2019-10-03 13:25:52','2019-10-03 13:25:52',NULL,'382'),
(227,'MN','Mongolia','2019-10-03 13:26:11','2019-10-03 13:26:27',NULL,'976'),
(228,'MC','Monaco','2019-10-03 13:26:43','2019-10-03 13:26:43',NULL,'377'),
(229,'MD','Moldova, Republic of','2019-10-03 13:26:57','2019-10-03 13:26:57',NULL,'373'),
(230,'FM','Micronesia, Federated States of','2019-10-03 13:27:24','2019-10-03 13:27:24',NULL,'691'),
(231,'MX','Mexico','2019-10-03 13:28:24','2019-10-03 13:28:24',NULL,'52'),
(232,'YT','Mayotte','2019-10-03 13:28:38','2019-10-03 13:33:16',NULL,'262'),
(233,'MU','Mauritius','2019-10-03 13:28:51','2019-10-03 13:29:06',NULL,'230'),
(234,'MR','Mauritania','2019-10-03 13:29:23','2019-10-03 13:29:23',NULL,'222'),
(235,'MQ','Martinique','2019-10-03 13:29:35','2019-10-03 13:29:35',NULL,'596'),
(236,'MH','Marshall Islands','2019-10-03 13:29:58','2019-10-03 13:29:58',NULL,'692'),
(237,'MT','Malta','2019-10-03 13:30:09','2019-10-03 13:30:09',NULL,'356'),
(238,'ML','Mali','2019-10-03 13:30:23','2019-10-03 13:30:23',NULL,'223'),
(239,'MV','Maldives','2019-10-03 13:30:47','2019-10-03 13:30:47',NULL,'960'),
(240,'MY','Malaysia','2019-10-03 13:30:55','2019-10-03 13:33:11',NULL,'60'),
(241,'MW','Malawi','2019-10-03 13:31:24','2019-10-03 13:31:24',NULL,'265'),
(242,'MG','Madagascar','2019-10-03 13:31:32','2019-10-03 13:31:32',NULL,'261'),
(243,'MK','Macedonia, the Former Yugoslav Republic of','2019-10-03 13:31:56','2019-10-03 13:31:56',NULL,'389'),
(244,'MO','Macao','2019-10-03 13:32:07','2019-10-03 13:32:07',NULL,'853'),
(245,'GE','Georgia','2019-10-03 13:54:18','2019-10-03 13:54:18',NULL,'995'),
(246,'DE','Germany','2019-10-03 13:54:37','2019-10-03 13:54:37',NULL,'49'),
(247,'GH','Ghana','2019-10-03 13:54:57','2019-10-03 13:54:57',NULL,'233'),
(248,'GI','Gibraltar','2019-10-03 13:55:29','2019-10-03 13:55:29',NULL,'350'),
(249,'GR','Greece','2019-10-03 13:55:44','2019-10-03 13:55:44',NULL,'30'),
(250,'GL','Greenland','2019-10-03 13:56:03','2019-10-03 13:56:03',NULL,'299'),
(251,'GD','Grenada','2019-10-03 13:56:26','2019-10-03 13:56:26',NULL,'1-473'),
(252,'GP','Guadeloupe','2019-10-03 13:56:40','2019-10-03 13:56:40',NULL,'590'),
(253,'GU','Guam','2019-10-03 13:57:07','2019-10-03 13:57:07',NULL,'1-671'),
(254,'GT','Guatemala','2019-10-03 13:59:58','2019-10-03 13:59:58',NULL,'502'),
(255,'GG','Guernsey','2019-10-03 14:00:13','2019-10-03 14:00:13',NULL,'44'),
(256,'LU','Luxembourg','2019-10-03 14:00:37','2019-10-03 14:00:37',NULL,'352'),
(257,'GN','Guinea','2019-10-03 14:00:38','2019-10-03 14:00:38',NULL,'224'),
(258,'GW','Guinea-Bissau','2019-10-03 14:00:55','2019-10-03 14:00:55',NULL,'245'),
(259,'GY','Guyana','2019-10-03 14:01:10','2019-10-03 14:01:10',NULL,'592'),
(260,'LT','Lithuania','2019-10-03 14:01:22','2019-10-03 14:01:22',NULL,'370'),
(261,'HT','Haiti','2019-10-03 14:01:29','2019-10-03 14:01:29',NULL,'509'),
(262,'HM','Heard Island and McDonald Islands','2019-10-03 14:01:50','2019-10-03 14:01:50',NULL,'672'),
(263,'LI','Liechtenstein','2019-10-03 14:01:59','2019-10-03 14:01:59',NULL,'423'),
(264,'VA','Holy See (Vatican City State)','2019-10-03 14:02:09','2019-10-03 14:02:09',NULL,'379'),
(265,'HN','Honduras','2019-10-03 14:02:24','2019-10-03 14:02:24',NULL,'504'),
(266,'HK','Hong Kong','2019-10-03 14:02:41','2019-10-03 14:02:41',NULL,'852'),
(267,'HU','Hungary','2019-10-03 14:02:59','2019-10-03 14:02:59',NULL,'36'),
(268,'LY','Libya','2019-10-03 14:03:12','2019-10-03 14:03:12',NULL,'218'),
(269,'IS','Iceland','2019-10-03 14:03:14','2019-10-03 14:03:14',NULL,'354'),
(270,'ID','Indonesia','2019-10-03 14:03:39','2019-10-03 14:03:39',NULL,'62'),
(271,'LR','Liberia','2019-10-03 14:03:46','2019-10-03 14:03:46',NULL,'231'),
(272,'IR','Iran, Islamic Republic of','2019-10-03 14:03:53','2019-10-03 14:03:53',NULL,'98'),
(273,'IQ','Iraq','2019-10-03 14:04:14','2019-10-03 14:04:14',NULL,'964'),
(274,'LS','Lesotho','2019-10-03 14:04:25','2019-10-03 14:04:25',NULL,'266'),
(275,'IE','Ireland','2019-10-03 14:04:43','2019-10-03 14:04:43',NULL,'353'),
(276,'IM','Isle of Man','2019-10-03 14:05:00','2019-10-03 14:05:00',NULL,'44'),
(277,'LB','Lebanon','2019-10-03 14:05:10','2019-10-03 14:05:10',NULL,'961'),
(278,'IL','Israel','2019-10-03 14:05:41','2019-10-03 14:05:41',NULL,'972'),
(279,'IT','Italy','2019-10-03 14:05:55','2019-10-03 14:05:55',NULL,'39'),
(280,'LV','Latvia','2019-10-03 14:06:03','2019-10-03 14:06:03',NULL,'371'),
(281,'LA','Lao People\'s Democratic Republic','2019-10-03 14:06:41','2019-10-03 14:06:41',NULL,'856'),
(282,'JM','Jamaica','2019-10-03 14:06:42','2019-10-03 14:06:42',NULL,'1-876'),
(283,'JP','Japan','2019-10-03 14:06:57','2019-10-03 14:06:57',NULL,'81'),
(284,'JO','Jordan','2019-10-03 14:07:48','2019-10-03 14:07:48',NULL,'962'),
(285,'KR','Korea, Republic of','2019-10-03 14:07:56','2019-10-03 14:07:56',NULL,'82'),
(286,'KP','Korea, Democratic People\'s Republic of','2019-10-03 14:08:34','2019-10-03 14:08:34',NULL,'850'),
(287,'KZ','Kazakhstan','2019-10-03 14:08:55','2019-10-03 14:08:55',NULL,'7'),
(288,'KI','Kiribati','2019-10-03 14:09:06','2019-10-03 14:09:06',NULL,'686'),
(289,'KE','Kenya','2019-10-03 14:09:12','2019-10-03 14:09:12',NULL,'254');

/*Table structure for table `acrm_credit_note_credits` */

DROP TABLE IF EXISTS `acrm_credit_note_credits`;

CREATE TABLE `acrm_credit_note_credits` (
  `credit_note_id` int(10) unsigned NOT NULL,
  `invoice_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  KEY `fk_acrm_credits_invoice_id_idx` (`invoice_id`),
  KEY `fk_acrm_credits_credit_note_id_idx` (`credit_note_id`),
  KEY `fk_acrm_credits_user_id_idx` (`user_id`),
  CONSTRAINT `fk_acrm_credits_credit_note_id` FOREIGN KEY (`credit_note_id`) REFERENCES `acrm_credit_notes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_acrm_credits_invoice_id` FOREIGN KEY (`invoice_id`) REFERENCES `acrm_invoices` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  CONSTRAINT `fk_acrm_credits_user_id` FOREIGN KEY (`user_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `acrm_credit_note_credits` */

/*Table structure for table `acrm_credit_note_paymentmodes` */

DROP TABLE IF EXISTS `acrm_credit_note_paymentmodes`;

CREATE TABLE `acrm_credit_note_paymentmodes` (
  `credit_note_id` int(10) unsigned DEFAULT NULL,
  `payment_gateway_id` int(10) unsigned DEFAULT NULL,
  KEY `fk_p_259566_259301_conten_5c5036ef1e1ea` (`credit_note_id`),
  KEY `fk_p_259301_259566_articl_5c5036ef1e28b` (`payment_gateway_id`),
  CONSTRAINT `fk_credit_note_id_paymodes` FOREIGN KEY (`credit_note_id`) REFERENCES `acrm_credit_notes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_payment_gateway_id_creditpaymodes` FOREIGN KEY (`payment_gateway_id`) REFERENCES `acrm_payment_gateways` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_credit_note_paymentmodes` */

/*Table structure for table `acrm_credit_note_payments` */

DROP TABLE IF EXISTS `acrm_credit_note_payments`;

CREATE TABLE `acrm_credit_note_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `account_id` int(10) unsigned DEFAULT NULL,
  `credit_note_id` int(10) unsigned DEFAULT NULL,
  `paymentmethod` char(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `payment_status` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT 'Success',
  `transaction_data` text COLLATE utf8mb4_unicode_ci,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_payments_deleted_at_index` (`deleted_at`),
  KEY `263295_5c5d41a961b5c` (`account_id`),
  KEY `263295_5c5d41a961b9c` (`credit_note_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_credit_note_payments` */

/*Table structure for table `acrm_credit_note_products` */

DROP TABLE IF EXISTS `acrm_credit_note_products`;

CREATE TABLE `acrm_credit_note_products` (
  `credit_note_id` int(10) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `product_name` varchar(191) DEFAULT NULL,
  `product_qty` int(11) DEFAULT NULL,
  `product_price` decimal(10,2) DEFAULT NULL,
  `product_tax` decimal(10,2) DEFAULT NULL COMMENT 'Tax Rate',
  `tax_type` varchar(10) DEFAULT NULL,
  `tax_value` decimal(10,2) DEFAULT NULL,
  `product_discount` decimal(10,2) DEFAULT NULL COMMENT 'Discount Rate',
  `discount_type` varchar(10) DEFAULT NULL,
  `discount_value` decimal(10,0) DEFAULT NULL,
  `product_subtotal` decimal(10,0) DEFAULT NULL,
  `product_amount` decimal(10,2) DEFAULT NULL,
  `pid` int(11) DEFAULT NULL,
  `unit` varchar(15) DEFAULT NULL,
  `hsn` varchar(45) DEFAULT NULL,
  `alert` int(11) DEFAULT NULL,
  `stock_quantity` int(11) DEFAULT NULL,
  `product_description` text,
  KEY `fk_credit_note_id_credit_note_products` (`credit_note_id`),
  KEY `fk_product_id_credit_note_products` (`credit_note_id`),
  KEY `fk_product_id_credit_note_products2` (`product_id`),
  CONSTRAINT `fk_credit_note_id_credit_note_products` FOREIGN KEY (`credit_note_id`) REFERENCES `acrm_credit_notes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_product_id_credit_note_products2` FOREIGN KEY (`product_id`) REFERENCES `acrm_products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `acrm_credit_note_products` */

/*Table structure for table `acrm_credit_note_refunds` */

DROP TABLE IF EXISTS `acrm_credit_note_refunds`;

CREATE TABLE `acrm_credit_note_refunds` (
  `id` int(10) NOT NULL,
  `credit_note_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `refunded_on` date NOT NULL,
  `payment_mode` varchar(40) NOT NULL,
  `note` text,
  `amount` decimal(10,0) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `acrm_credit_note_refunds` */

/*Table structure for table `acrm_credit_notes` */

DROP TABLE IF EXISTS `acrm_credit_notes`;

CREATE TABLE `acrm_credit_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci COMMENT 'Billing Address',
  `invoice_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_quantity_as` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_no` bigint(22) DEFAULT NULL,
  `status` enum('Published','Draft') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_date` date DEFAULT NULL,
  `invoice_due_date` date DEFAULT NULL,
  `invoice_notes` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `customer_id` int(10) unsigned DEFAULT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `tax_id` int(10) unsigned DEFAULT NULL,
  `discount_id` int(10) unsigned DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `products` longtext COLLATE utf8mb4_unicode_ci,
  `paymentstatus` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT 'unpaid',
  `signature` longblob,
  `created_by_id` int(10) unsigned DEFAULT NULL,
  `delivery_address` text COLLATE utf8mb4_unicode_ci COMMENT 'Shipping Address',
  `show_delivery_address` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no' COMMENT 'Show shipping details in invoice',
  `admin_notes` text COLLATE utf8mb4_unicode_ci,
  `sale_agent` int(10) unsigned DEFAULT NULL,
  `terms_conditions` longtext COLLATE utf8mb4_unicode_ci,
  `prevent_overdue_reminders` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `total_cycles` int(10) DEFAULT '0' COMMENT 'Total completed cycles',
  `cycles` int(11) DEFAULT '0',
  `is_recurring` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `recurring_period_id` int(10) unsigned DEFAULT NULL,
  `recurring_type` char(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Eg: Day, Month, Year',
  `recurring_value` int(10) DEFAULT NULL,
  `last_recurring_date` date DEFAULT NULL,
  `is_recurring_from` int(10) DEFAULT NULL,
  `last_overdue_reminder` date DEFAULT NULL,
  `quote_id` int(10) unsigned DEFAULT NULL,
  `project_id` int(10) unsigned DEFAULT NULL,
  `devery_note_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `po_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_number_format` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT 'numberbased',
  `invoice_number_separator` char(5) COLLATE utf8mb4_unicode_ci DEFAULT '-',
  `invoice_number_length` int(10) DEFAULT '0',
  `credit_status` enum('Open','Closed') COLLATE utf8mb4_unicode_ci DEFAULT 'Open',
  `remaining_amount` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoices_deleted_at_index` (`deleted_at`),
  KEY `259415_5c500ae98af17` (`customer_id`),
  KEY `259415_5c500ae9b10d1` (`currency_id`),
  KEY `259415_5c500ae9d6387` (`tax_id`),
  KEY `259415_5c500aea0188f` (`discount_id`),
  KEY `fk_created_by_id` (`created_by_id`),
  KEY `fk_invoices_sale_agent` (`sale_agent`),
  KEY `fk_recurring_period_id_invoices` (`recurring_period_id`),
  KEY `fk_quote_id_quotes` (`quote_id`),
  KEY `fk_project_id_invoices` (`project_id`),
  CONSTRAINT `fk_currency_id_creditnotes` FOREIGN KEY (`currency_id`) REFERENCES `acrm_currencies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_discount_id_creditnotes` FOREIGN KEY (`discount_id`) REFERENCES `acrm_discounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_project_id_creditnotes` FOREIGN KEY (`project_id`) REFERENCES `acrm_client_projects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_tax_id_creditnames` FOREIGN KEY (`tax_id`) REFERENCES `acrm_taxes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ft_customer_id_creditnotes` FOREIGN KEY (`customer_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_credit_notes` */

/*Table structure for table `acrm_credit_notes_history` */

DROP TABLE IF EXISTS `acrm_credit_notes_history`;

CREATE TABLE `acrm_credit_notes_history` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ip_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` text COLLATE utf8mb4_unicode_ci,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `browser` text COLLATE utf8mb4_unicode_ci,
  `comments` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `credit_note_id` int(10) unsigned DEFAULT NULL,
  `operation_type` char(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'general, crud, email, sms, cron',
  PRIMARY KEY (`id`),
  KEY `credit_notes_history_deleted_at_index` (`deleted_at`),
  KEY `259415_5c500ae99af17dfdfd` (`credit_note_id`),
  CONSTRAINT `259415_5c500ae99af17fdfd` FOREIGN KEY (`credit_note_id`) REFERENCES `acrm_credit_notes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_credit_notes_history` */

/*Table structure for table `acrm_currencies` */

DROP TABLE IF EXISTS `acrm_currencies`;

CREATE TABLE `acrm_currencies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rate` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('Active','Inactive') COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `is_default` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  PRIMARY KEY (`id`),
  KEY `currencies_deleted_at_index` (`deleted_at`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_currencies` */

INSERT INTO `acrm_currencies` VALUES (1,'USD','$','USD','1','Active',NULL,'2019-10-05 05:27:42',NULL,'yes'),(2,'Isle of Man','COP','GHS','77','','2019-09-28 20:45:01','2019-10-03 11:36:43','2019-10-03 11:36:43','no'),(3,'Poland Zloty','zł','PLN','3.913797','Active','2019-09-28 20:47:14','2019-10-11 05:35:43',NULL,'no'),(4,'Indonesia Rupiah','Rp','IDR','14116.05','Active','2019-09-28 20:57:15','2019-10-11 05:35:43',NULL,'no'),(5,'Burundi','GHS','SGD','47','','2019-09-28 20:59:15','2019-10-03 11:34:55','2019-10-03 11:34:55','no'),(6,'Zambia','MGA','TTD','38','Inactive','2019-09-28 21:01:36','2019-10-03 11:35:03','2019-10-03 11:35:03','no'),(7,'Cayman Islands Dollar','$','KYD','0.83328','Inactive','2019-09-28 21:06:42','2019-10-11 05:35:43',NULL,'no'),(8,'Kazakhstan Tenge','лв','KZT','390.179788','Inactive','2019-09-28 21:13:37','2019-10-11 05:35:43',NULL,'no'),(9,'Albania Lek','Lek','ALL','111.795167','Inactive','2019-10-03 10:46:08','2019-10-11 05:35:43',NULL,'no'),(10,'Afghanistan Afghani','؋','AFN','78.302631','Inactive','2019-10-03 10:50:57','2019-10-11 05:35:43',NULL,'no'),(11,'Argentina Peso','$','ARS','57.9847','Inactive','2019-10-03 10:51:36','2019-10-11 05:35:43',NULL,'no'),(12,'Aruba Guilder','ƒ','AWG','1.8','Inactive','2019-10-03 10:52:32','2019-10-03 12:14:28',NULL,'no'),(13,'Australia Dollar','$','AUD','1.477705','Inactive','2019-10-03 10:53:21','2019-10-11 05:35:43',NULL,'no'),(14,'Azerbaijan Manat','₼','AZN','1.703419','Inactive','2019-10-03 10:54:07','2019-10-11 05:35:43',NULL,'no'),(15,'Bahamas Dollar','$','BSD','0.99996','Inactive','2019-10-03 10:54:43','2019-10-11 05:35:43',NULL,'no'),(16,'Barbados Dollar','$','BBD','2.01905','Inactive','2019-10-03 10:55:22','2019-10-11 05:35:43',NULL,'no'),(17,'Belarus Ruble','Br','BYN','2.060804','Inactive','2019-10-03 10:57:15','2019-10-11 05:35:43',NULL,'no'),(18,'Belize Dollar','BZ$','BZD','2.01565','Inactive','2019-10-03 10:58:05','2019-10-11 05:35:43',NULL,'no'),(19,'Bermuda Dollar','$','BMD','1','Inactive','2019-10-03 10:59:00','2019-10-03 12:14:28',NULL,'no'),(20,'Bolivia Bolíviano','$b','BOB','6.914899','Inactive','2019-10-03 11:00:07','2019-10-11 05:35:43',NULL,'no'),(21,'Bosnia and Herzegovina Convertible Mark','KM','BAM','1.77375','Inactive','2019-10-03 11:00:44','2019-10-11 05:35:43',NULL,'no'),(22,'Botswana Pula','P','BWP','11.043497','Inactive','2019-10-03 11:01:24','2019-10-11 05:35:43',NULL,'no'),(23,'Bulgaria Lev','лв','BGN','1.775803','Inactive','2019-10-03 11:02:06','2019-10-11 05:35:43',NULL,'no'),(24,'Brazil Real','R$','BRL','4.107905','Inactive','2019-10-03 11:02:45','2019-10-11 05:35:43',NULL,'no'),(25,'Brunei Darussalam Dollar','$','BND','1.37705','Inactive','2019-10-03 11:03:31','2019-10-11 05:35:43',NULL,'no'),(26,'Cambodia Riel','៛','KHR','4075.00044','Inactive','2019-10-03 11:04:10','2019-10-11 05:35:43',NULL,'no'),(27,'Canada Dollar','$','CAD','1.32719','Inactive','2019-10-03 11:04:50','2019-10-11 05:35:43',NULL,'no'),(28,'Cayman Islands Dollar','$','KYD','0.83328','Inactive','2019-10-03 11:05:27','2019-10-11 05:35:43',NULL,'no'),(29,'Chile Peso','$','CLP','717.698945','Inactive','2019-10-03 11:06:10','2019-10-11 05:35:43',NULL,'no'),(30,'China Yuan Renminbi','¥','CNY','7.116297','Inactive','2019-10-03 11:06:52','2019-10-11 05:35:43',NULL,'no'),(31,'Colombia Peso','$','COP','3467','Inactive','2019-10-03 11:07:29','2019-10-11 05:35:43',NULL,'no'),(32,'Costa Rica Colon','₡','CRC','581.584996','Inactive','2019-10-03 11:08:05','2019-10-11 05:35:43',NULL,'no'),(33,'Croatia Kuna','kn','HRK','6.73935','Inactive','2019-10-03 11:09:00','2019-10-11 05:35:43',NULL,'no'),(34,'Cuba Peso','₱','CUP','26.5','Inactive','2019-10-03 11:09:30','2019-10-03 12:14:28',NULL,'no'),(35,'Czech Republic Koruna','Kč','CZK','23.437504','Inactive','2019-10-03 11:10:03','2019-10-11 05:35:43',NULL,'no'),(36,'Denmark Krone','kr','DKK','6.77621','Inactive','2019-10-03 11:10:42','2019-10-11 05:35:43',NULL,'no'),(37,'Dominican Republic Peso','RD$','DOP','52.985035','Inactive','2019-10-03 11:11:14','2019-10-11 05:35:43',NULL,'no'),(38,'East Caribbean Dollar','$','XCD','2.70255','Inactive','2019-10-03 11:11:50','2019-10-03 12:14:28',NULL,'no'),(39,'Egypt Pound','£','EGP','16.279797','Inactive','2019-10-03 11:12:20','2019-10-11 05:35:43',NULL,'no'),(40,'El Salvador Colon','$','SVC','8.750291','Inactive','2019-10-03 11:12:55','2019-10-11 05:35:43',NULL,'no'),(41,'Euro Member Countries','€','EUR','0.90736','Inactive','2019-10-03 11:13:28','2019-10-11 05:35:43',NULL,'no'),(42,'Falkland Islands (Malvinas) Pound','£','FKP','0.81288','Inactive','2019-10-03 11:14:03','2019-10-03 12:14:28',NULL,'no'),(43,'Fiji Dollar','$','FJD','2.2075','Inactive','2019-10-03 11:14:36','2019-10-11 05:35:43',NULL,'no'),(44,'Ghana Cedi','¢','GHS','5.444978','Inactive','2019-10-03 11:15:03','2019-10-11 05:35:43',NULL,'no'),(45,'Gibraltar Pound','£','GIP','0.81288','Inactive','2019-10-03 11:15:35','2019-10-03 12:14:28',NULL,'no'),(46,'Guatemala Quetzal','Q','GTQ','7.764898','Inactive','2019-10-03 11:16:23','2019-10-11 05:35:43',NULL,'no'),(47,'Guernsey Pound','Q','GTQ','7.764898','Inactive','2019-10-03 11:38:11','2019-10-11 05:35:43',NULL,'no'),(48,'Guyana Dollar','$','GYD','208.654991','Inactive','2019-10-03 11:39:01','2019-10-11 05:35:43',NULL,'no'),(49,'Honduras Lempira','L','HNL','24.764961','Inactive','2019-10-03 11:39:35','2019-10-11 05:35:43',NULL,'no'),(50,'Hong Kong Dollar','$','HKD','7.84145','Inactive','2019-10-03 11:40:13','2019-10-11 05:35:43',NULL,'no'),(51,'Hungary Forint','Ft','HUF','301.605959','Inactive','2019-10-03 11:40:50','2019-10-11 05:35:43',NULL,'no'),(52,'Iceland Krona','kr','ISK','124.940205','Inactive','2019-10-03 11:42:07','2019-10-11 05:35:43',NULL,'no'),(53,'India Rupee','₹','INR','70.831501','Inactive','2019-10-03 11:43:22','2019-10-11 05:35:43',NULL,'no'),(54,'Indonesia Rupiah','Rp','IDR','14116.05','Inactive','2019-10-03 11:43:50','2019-10-11 05:35:43',NULL,'no'),(55,'Iran Rial','﷼','IRR','42104.999747','Inactive','2019-10-03 11:44:15','2019-10-11 05:35:43',NULL,'no'),(56,'Isle of Man Pound','£','IMP','0.808541','Inactive','2019-10-03 11:44:44','2019-10-11 05:35:43',NULL,'no'),(57,'Israel Shekel','₪','ILS','3.508899','Inactive','2019-10-03 11:45:12','2019-10-11 05:35:43',NULL,'no'),(58,'Jamaica Dollar','J$','JMD','134.000112','Inactive','2019-10-03 11:45:39','2019-10-11 05:35:43',NULL,'no'),(59,'Japan Yen','¥','JPY','107.899045','Inactive','2019-10-03 11:46:05','2019-10-11 05:35:43',NULL,'no'),(60,'Jersey Pound','£','JEP','0.808541','Inactive','2019-10-03 11:46:39','2019-10-11 05:35:43',NULL,'no'),(61,'Kazakhstan Tenge','лв','KZT','390.179788','Inactive','2019-10-03 11:47:16','2019-10-11 05:35:43',NULL,'no'),(62,'Korea (North) Won','₩','KPW','900.084541','Inactive','2019-10-03 11:47:50','2019-10-11 05:35:43',NULL,'no'),(63,'Korea (South) Won','₩','KRW','1189.729687','Inactive','2019-10-03 11:48:13','2019-10-11 05:35:43',NULL,'no'),(64,'Kyrgyzstan Som','лв','KGS','69.849923','Inactive','2019-10-03 11:48:37','2019-10-11 05:35:43',NULL,'no'),(65,'Laos Kip','₭','LAK','8822.496299','Inactive','2019-10-03 11:49:01','2019-10-11 05:35:43',NULL,'no'),(66,'Lebanon Pound','£','LBP','1504.650356','Inactive','2019-10-03 11:49:25','2019-10-11 05:35:43',NULL,'no'),(67,'Liberia Dollar','$','LRD','210.999983','Inactive','2019-10-03 11:49:54','2019-10-11 05:35:43',NULL,'no'),(68,'Macedonia Denar','ден','MKD','55.800497','Inactive','2019-10-03 11:50:17','2019-10-11 05:35:43',NULL,'no'),(69,'Malaysia Ringgit','RM','MYR','4.189005','Inactive','2019-10-03 11:50:44','2019-10-11 05:35:43',NULL,'no'),(70,'Mauritius Rupee','₨','MUR','36.494975','Inactive','2019-10-03 11:51:10','2019-10-11 05:35:43',NULL,'no'),(71,'Mexico Peso','$','MXN','19.45858','Inactive','2019-10-03 11:51:42','2019-10-11 05:35:43',NULL,'no'),(72,'Mongolia Tughrik','₮','MNT','2668.932375','Inactive','2019-10-03 11:52:09','2019-10-11 05:35:43',NULL,'no'),(73,'Mozambique Metical','MT','MZN','62.124963','Inactive','2019-10-03 11:52:30','2019-10-11 05:35:43',NULL,'no'),(74,'Namibia Dollar','$','NAD','15.169795','Inactive','2019-10-03 11:52:56','2019-10-11 05:35:43',NULL,'no'),(75,'Nepal Rupee','₨','NPR','113.714973','Inactive','2019-10-03 11:53:24','2019-10-11 05:35:43',NULL,'no'),(76,'Netherlands Antilles Guilder','ƒ','ANG','1.75495','Inactive','2019-10-03 11:53:52','2019-10-11 05:35:43',NULL,'no'),(77,'New Zealand Dollar','$','NZD','1.58129','Inactive','2019-10-03 11:54:14','2019-10-11 05:35:43',NULL,'no'),(78,'Nicaragua Cordoba','C$','NIO','33.649962','Inactive','2019-10-03 11:54:44','2019-10-11 05:35:43',NULL,'no'),(79,'Nigeria Naira','₦','NGN','361.999876','Inactive','2019-10-03 11:55:17','2019-10-11 05:35:43',NULL,'no'),(80,'Norway Krone','kr','NOK','9.11604','Inactive','2019-10-03 11:55:43','2019-10-11 05:35:43',NULL,'no'),(81,'Oman Rial','﷼','OMR','0.38504','Inactive','2019-10-03 11:57:14','2019-10-11 05:35:43',NULL,'no'),(82,'Pakistan Rupee','₨','PKR','156.508627','Inactive','2019-10-03 11:57:44','2019-10-11 05:35:43',NULL,'no'),(83,'Panama Balboa','B/.','PAB','0.99995','Inactive','2019-10-03 11:58:13','2019-10-11 05:35:43',NULL,'no'),(84,'Paraguay Guarani','Gs','PYG','6405.399248','Inactive','2019-10-03 11:58:37','2019-10-11 05:35:43',NULL,'no'),(85,'Peru Sol','S/.','PEN','3.354939','Inactive','2019-10-03 11:59:00','2019-10-11 05:35:43',NULL,'no'),(86,'Philippines Peso','₱','PHP','51.550502','Inactive','2019-10-03 11:59:28','2019-10-11 05:35:43',NULL,'no'),(87,'Poland Zloty','zł','PLN','3.913797','Inactive','2019-10-03 11:59:53','2019-10-11 05:35:43',NULL,'no'),(88,'Qatar Riyal','﷼','QAR','3.641018','Inactive','2019-10-03 12:00:18','2019-10-11 05:35:43',NULL,'no'),(89,'Romania Leu','lei','RON','4.315798','Inactive','2019-10-03 12:00:46','2019-10-11 05:35:43',NULL,'no'),(90,'Russia Ruble','₽','RUB','64.466697','Inactive','2019-10-03 12:01:15','2019-10-11 05:35:43',NULL,'no'),(91,'Saint Helena Pound','£','SHP','1.320902','Inactive','2019-10-03 12:01:41','2019-10-11 05:35:43',NULL,'no'),(92,'Saudi Arabia Riyal','﷼','SAR','3.75065','Inactive','2019-10-03 12:02:10','2019-10-11 05:35:43',NULL,'no'),(93,'Serbia Dinar','Дин.','RSD','106.624975','Inactive','2019-10-03 12:02:39','2019-10-11 05:35:43',NULL,'no'),(94,'Seychelles Rupee','₨','SCR','13.700974','Inactive','2019-10-03 12:03:06','2019-10-11 05:35:43',NULL,'no'),(95,'Singapore Dollar','$','SGD','1.37498','Inactive','2019-10-03 12:03:33','2019-10-11 05:35:43',NULL,'no'),(96,'Solomon Islands Dollar','$','SBD','8.23545','Inactive','2019-10-03 12:03:59','2019-10-11 05:35:43',NULL,'no'),(97,'Somalia Shilling','S','SOS','579.999749','Inactive','2019-10-03 12:04:24','2019-10-11 05:35:43',NULL,'no'),(98,'South Africa Rand','R','ZAR','15.022401','Inactive','2019-10-03 12:04:47','2019-10-11 05:35:43',NULL,'no'),(99,'Sri Lanka Rupee','₨','LKR','180.594992','Inactive','2019-10-03 12:05:13','2019-10-11 05:35:43',NULL,'no'),(100,'Sweden Krona','kr','SEK','9.83567','Inactive','2019-10-03 12:05:40','2019-10-11 05:35:43',NULL,'no'),(101,'Switzerland Franc','CHF','CHF','0.995025','Inactive','2019-10-03 12:06:08','2019-10-11 05:35:43',NULL,'no'),(102,'Suriname Dollar','$','SRD','7.458035','Inactive','2019-10-03 12:06:31','2019-10-11 05:35:43',NULL,'no'),(103,'Syria Pound','£','SYP','515.000187','Inactive','2019-10-03 12:07:01','2019-10-11 05:35:43',NULL,'no'),(104,'Taiwan New Dollar','NT$','TWD','30.643032','Inactive','2019-10-03 12:07:25','2019-10-11 05:35:43',NULL,'no'),(105,'Thailand Baht','฿','THB','30.382503','Inactive','2019-10-03 12:08:00','2019-10-11 05:35:43',NULL,'no'),(106,'Trinidad and Tobago Dollar','TT$','TTD','6.77655','Inactive','2019-10-03 12:08:23','2019-10-11 05:35:43',NULL,'no'),(107,'Turkey Lira','₺','TRY','5.83466','Inactive','2019-10-03 12:09:15','2019-10-11 05:35:43',NULL,'no'),(108,'Tuvalu Dollar','$','TVD','23','Inactive','2019-10-03 12:09:53','2019-10-03 12:09:53',NULL,'no'),(109,'Ukraine Hryvnia','₴','UAH','24.525984','Inactive','2019-10-03 12:10:18','2019-10-11 05:35:43',NULL,'no'),(110,'United Kingdom Pound','£','GBP','0.80827','Inactive','2019-10-03 12:10:44','2019-10-11 05:35:43',NULL,'no'),(111,'Uruguay Peso','$U','UYU','37.224499','Inactive','2019-10-03 12:11:25','2019-10-11 05:35:43',NULL,'no'),(112,'Uzbekistan Som','лв','UZS','9420.000417','Inactive','2019-10-03 12:11:48','2019-10-11 05:35:43',NULL,'no'),(113,'Venezuela Bolívar','Bs','VEF','9.987501','Inactive','2019-10-03 12:12:13','2019-10-11 05:35:43',NULL,'no'),(114,'Viet Nam Dong','₫','VND','23208.5','Inactive','2019-10-03 12:12:42','2019-10-05 05:27:42',NULL,'no'),(115,'Yemen Rial','﷼','YER','250.350071','Inactive','2019-10-03 12:13:05','2019-10-11 05:35:43',NULL,'no'),(116,'Zimbabwe Dollar','Z$','ZWD','85','Inactive','2019-10-03 12:13:38','2019-10-03 12:13:38',NULL,'no'),(117,'dfg','gf','fgd','1','Active','2019-10-05 05:27:31','2019-10-05 05:28:45','2019-10-05 05:28:45','no');


/*Table structure for table `acrm_dashboard_widgets` */

DROP TABLE IF EXISTS `acrm_dashboard_widgets`;

CREATE TABLE `acrm_dashboard_widgets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) DEFAULT NULL,
  `status` enum('active','inactive') DEFAULT 'active',
  `type` enum('numbers','chart','list','view') DEFAULT 'numbers',
  `slug` varchar(45) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `columns` int(11) DEFAULT '4',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=latin1;

/*Data for the table `acrm_dashboard_widgets` */

insert  into `acrm_dashboard_widgets`(`id`,`title`,`status`,`type`,`slug`,`created_at`,`updated_at`,`columns`) values 
(1,'Income amount','active','numbers','income-amount',NULL,'2019-09-05 12:40:50',2),
(2,'Users Count','active','numbers','users-count',NULL,'2019-09-05 12:40:52',2),
(3,'Expenses','active','numbers','expenses',NULL,'2019-09-05 12:40:54',2),
(4,'Products','active','numbers','products',NULL,'2019-09-05 12:40:48',2),
(5,'YEARLY INVOICES AMOUNT','active','chart','yearly-invoices-amount',NULL,'2019-09-05 12:38:29',12),
(6,'YEARLY ORDERS AMOUNT','active','chart','yearly-orders-amount',NULL,'2019-09-05 12:38:34',12),
(9,'Income Vs Category','active','chart','incomecategorydonutChart','0000-00-00 00:00:00','2019-09-05 12:38:39',4),
(10,'Contacts Vs Types','active','chart','ContactTypesdonutChart','0000-00-00 00:00:00','2019-09-27 17:33:23',4),
(11,'Expense Vs Category','active','numbers','expensecategorydonutChart','0000-00-00 00:00:00','2019-09-05 12:39:08',4),
(12,'Expense Vs Category Barchart','inactive','chart','expenseCategoryBarchart','0000-00-00 00:00:00','2019-09-30 12:01:43',6),
(13,'Last 12 months Income','active','chart','last12monthsincome','0000-00-00 00:00:00','2019-09-05 12:39:55',6),
(14,'Tasks','active','chart','dashboard-tasks','0000-00-00 00:00:00','2019-09-05 12:39:13',4),
(17,'Products','active','list','products','2019-09-28 04:12:54','2019-09-28 04:12:54',4),
(25,'incomeCategoryBarchart','active','chart','incomeCategoryBarchart','2019-09-28 05:05:14','2019-09-28 05:05:14',2),
(28,'profile','active','view','profile','2019-09-28 05:08:08','2019-09-28 05:08:08',2),
(29,'recent-expenses','active','list','recent-expenses','2019-09-28 05:08:35','2019-09-28 05:08:35',2),
(30,'recent-incomes','active','list','recent-incomes','2019-09-28 05:08:53','2019-09-28 05:08:53',2),
(31,'recent-invoices','active','list','recent-invoices','2019-09-28 05:15:18','2019-09-28 05:15:18',2),
(32,'recent-orders','active','list','recent-orders','2019-09-28 05:15:37','2019-09-28 05:15:37',2),
(33,'recent-quotes','active','list','recent-quotes','2019-09-28 05:15:52','2019-09-28 05:15:52',2),
(38,'InvoicesYearsDataAreaChart','active','chart','InvoicesYearsDataAreaChart','2019-09-28 06:50:39','2019-09-28 06:50:39',2);

/*Table structure for table `acrm_dashboard_widgets_role` */

DROP TABLE IF EXISTS `acrm_dashboard_widgets_role`;

CREATE TABLE `acrm_dashboard_widgets_role` (
  `dash_board_id` int(10) unsigned NOT NULL,
  `role_id` int(10) unsigned NOT NULL,
  `display_order` int(11) DEFAULT NULL,
  `display_columns` int(2) DEFAULT NULL,
  KEY `fk_acrm_dashboard_widgets_role_2_idx` (`role_id`),
  KEY `fk_acrm_dashboard_widgets_role_1` (`dash_board_id`),
  CONSTRAINT `fk_acrm_dashboard_widgets_role_1` FOREIGN KEY (`dash_board_id`) REFERENCES `acrm_dashboard_widgets` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_acrm_dashboard_widgets_role_2` FOREIGN KEY (`role_id`) REFERENCES `acrm_roles` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `acrm_dashboard_widgets_role` */

insert  into `acrm_dashboard_widgets_role`(`dash_board_id`,`role_id`,`display_order`,`display_columns`) values 
(10,1,5,4),
(11,1,7,4),
(12,1,9,2),
(3,1,1,2),
(1,1,3,2),
(9,1,6,4),
(25,1,10,2),
(13,1,11,2),
(4,1,4,2),
(14,1,12,2),
(2,1,2,2),
(5,1,13,12),
(6,1,8,12);

/*Table structure for table `acrm_database_backups` */

DROP TABLE IF EXISTS `acrm_database_backups`;

CREATE TABLE `acrm_database_backups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `storage_location` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `database_backups_deleted_at_index` (`deleted_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_database_backups` */

/*Table structure for table `acrm_departments` */

DROP TABLE IF EXISTS `acrm_departments`;

CREATE TABLE `acrm_departments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_by_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `departments_deleted_at_index` (`deleted_at`),
  KEY `259532_5c502ed3cb5ec_idx` (`created_by_id`),
  CONSTRAINT `259532_5c502ed3cb5ec` FOREIGN KEY (`created_by_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_departments` */

/*Table structure for table `acrm_discounts` */

DROP TABLE IF EXISTS `acrm_discounts`;

CREATE TABLE `acrm_discounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount` double DEFAULT NULL,
  `discount_type` enum('percent','value') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `discounts_deleted_at_index` (`deleted_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_discounts` */

/*Table structure for table `acrm_dynamic_options` */

DROP TABLE IF EXISTS `acrm_dynamic_options`;

CREATE TABLE `acrm_dynamic_options` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `module` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '1',
  `type` char(10) COLLATE utf8mb4_unicode_ci DEFAULT 'priorities',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `color` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recurring_periods_deleted_at_index` (`deleted_at`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_dynamic_options` */

insert  into `acrm_dynamic_options`(`id`,`title`,`description`,`module`,`type`,`created_at`,`updated_at`,`deleted_at`,`color`) values 
(1,'Medium',NULL,'projecttasks','priorities','2019-09-20 12:18:51','2019-09-20 12:18:51',NULL,NULL),
(2,'Low',NULL,'projecttasks','taskstatus','2019-09-20 12:19:20','2019-09-26 09:19:13',NULL,NULL),
(3,'Medium',NULL,'invoices','priorities','2019-09-23 13:36:44','2019-09-23 13:36:44',NULL,NULL),
(4,'Pending',NULL,'invoices','taskstatus','2019-09-23 13:37:10','2019-09-23 13:37:10',NULL,NULL),
(5,'Medium',NULL,'quotes','priorities','2019-09-23 13:48:39','2019-09-23 13:48:39',NULL,NULL),
(6,'Pending',NULL,'quotes','taskstatus','2019-09-23 13:48:55','2019-09-23 13:48:55',NULL,NULL),
(7,'High','vdfvd','proposaltasks','priorities','2019-09-24 12:24:10','2019-09-25 12:10:47',NULL,'#7b2323'),
(9,'High','fdv','proposals','priorities','2019-09-24 12:44:32','2019-09-24 12:44:32',NULL,'#000000'),
(10,'high',NULL,'contracts','priorities','2019-09-25 09:00:09','2019-09-25 09:00:09',NULL,'#5c3838'),
(11,'Complete','','projecttasks','taskstatus','2019-09-25 11:46:45','2019-09-25 12:10:16','0000-00-00 00:00:00','');

/*Table structure for table `acrm_email_templates_delete` */

DROP TABLE IF EXISTS `acrm_email_templates_delete`;

CREATE TABLE `acrm_email_templates_delete` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` char(50) COLLATE utf8mb4_unicode_ci DEFAULT 'email',
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `body` text COLLATE utf8mb4_unicode_ci,
  `from_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `from_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `status` enum('active','inactive') COLLATE utf8mb4_unicode_ci DEFAULT 'active',
  PRIMARY KEY (`id`,`key`),
  KEY `email_templates_deleted_at_index` (`deleted_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_email_templates_delete` */

/*Table structure for table `acrm_expense_categories` */

DROP TABLE IF EXISTS `acrm_expense_categories`;

CREATE TABLE `acrm_expense_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_expense_categories` */

/*Table structure for table `acrm_expenses` */

DROP TABLE IF EXISTS `acrm_expenses`;

CREATE TABLE `acrm_expenses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `entry_date` date DEFAULT NULL,
  `amount` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expense_category_id` int(10) unsigned DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `ref_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_id` int(10) unsigned DEFAULT NULL,
  `payee_id` int(10) unsigned DEFAULT NULL,
  `payment_method_id` int(10) unsigned DEFAULT NULL,
  `is_recurring` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `recurring_period_id` int(10) unsigned DEFAULT NULL,
  `recurring_value` int(10) DEFAULT NULL,
  `recurring_type` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cycles` int(10) DEFAULT '0',
  `total_cycles` int(10) DEFAULT '0',
  `last_recurring_date` date DEFAULT NULL,
  `is_recurring_from` int(10) unsigned DEFAULT NULL,
  `project_id` int(10) unsigned DEFAULT NULL,
  `create_invoice_billable` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `send_invoice_to_customer` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `billable` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `billed` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `invoice_id` int(10) unsigned DEFAULT NULL,
  `tax_id` int(10) unsigned DEFAULT NULL,
  `tax_value` double DEFAULT '0',
  `tax_type` enum('value','percent') COLLATE utf8mb4_unicode_ci DEFAULT 'value',
  `currency_id` int(10) unsigned DEFAULT NULL,
  `credit_notes_id` int(10) unsigned DEFAULT NULL,
  `payee_name` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'If the contact is deleted we can use this name, so that admin have track on all expenses even when contact deleted',
  PRIMARY KEY (`id`),
  KEY `259289_5c4fd436771c8` (`expense_category_id`),
  KEY `259289_5c5008723efd5` (`account_id`),
  KEY `259289_5c50087269673` (`payee_id`),
  KEY `259289_5c50087283e58` (`payment_method_id`),
  KEY `fk_recurring_id_expenses` (`recurring_period_id`),
  KEY `fk_project_id_expenses` (`project_id`),
  KEY `fk_invoice_id_expenses` (`invoice_id`),
  KEY `fk_currency_id_expenses` (`currency_id`),
  KEY `fk_tax_id_expenses` (`tax_id`),
  CONSTRAINT `259289_5c4fd436771c8` FOREIGN KEY (`expense_category_id`) REFERENCES `acrm_expense_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `259289_5c5008723efd5` FOREIGN KEY (`account_id`) REFERENCES `acrm_accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `259289_5c50087269673` FOREIGN KEY (`payee_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `259289_5c50087283e58` FOREIGN KEY (`payment_method_id`) REFERENCES `acrm_payment_gateways` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_currency_id_expenses` FOREIGN KEY (`currency_id`) REFERENCES `acrm_currencies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_invoice_id_expenses` FOREIGN KEY (`invoice_id`) REFERENCES `acrm_invoices` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_project_id_expenses` FOREIGN KEY (`project_id`) REFERENCES `acrm_client_projects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_recurring_id_expenses` FOREIGN KEY (`recurring_period_id`) REFERENCES `acrm_recurring_periods` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_tax_id_expenses` FOREIGN KEY (`tax_id`) REFERENCES `acrm_taxes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_expenses` */

/*Table structure for table `acrm_failed_jobs` */

DROP TABLE IF EXISTS `acrm_failed_jobs`;

CREATE TABLE `acrm_failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_failed_jobs` */

/*Table structure for table `acrm_faq_categories` */

DROP TABLE IF EXISTS `acrm_faq_categories`;

CREATE TABLE `acrm_faq_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_faq_categories` */

/*Table structure for table `acrm_faq_questions` */

DROP TABLE IF EXISTS `acrm_faq_questions`;

CREATE TABLE `acrm_faq_questions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `question_text` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer_text` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `259293_5c4fd46b088cb` (`category_id`),
  CONSTRAINT `259293_5c4fd46b088cb` FOREIGN KEY (`category_id`) REFERENCES `acrm_faq_categories` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_faq_questions` */

/*Table structure for table `acrm_income_categories` */

DROP TABLE IF EXISTS `acrm_income_categories`;

CREATE TABLE `acrm_income_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_income_categories` */

/*Table structure for table `acrm_incomes` */

DROP TABLE IF EXISTS `acrm_incomes`;

CREATE TABLE `acrm_incomes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `entry_date` date DEFAULT NULL,
  `amount` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `original_amount` double DEFAULT NULL,
  `original_currency_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `income_category_id` int(10) unsigned DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `ref_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_id` int(10) unsigned DEFAULT NULL,
  `payer_id` int(10) unsigned DEFAULT NULL,
  `payer_name` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'If the contact is deleted we can use this name, so that admin have track on all incomes even when contact deleted',
  `pay_method_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `259288_5c4fd43129965` (`income_category_id`),
  KEY `259288_5c500722c2930` (`account_id`),
  KEY `259288_5c500722ee978` (`payer_id`),
  KEY `259288_5c5007230da07` (`pay_method_id`),
  KEY `fk_original_currency_id` (`original_currency_id`),
  CONSTRAINT `259288_5c4fd43129965` FOREIGN KEY (`income_category_id`) REFERENCES `acrm_income_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `259288_5c500722c2930` FOREIGN KEY (`account_id`) REFERENCES `acrm_accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `259288_5c500722ee978` FOREIGN KEY (`payer_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_original_currency_id` FOREIGN KEY (`original_currency_id`) REFERENCES `acrm_currencies` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_incomes` */

/*Table structure for table `acrm_internal_notification_user` */

DROP TABLE IF EXISTS `acrm_internal_notification_user`;

CREATE TABLE `acrm_internal_notification_user` (
  `internal_notification_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  KEY `fk_p_259294_259280_user_i_5c4fd78fc5f92` (`internal_notification_id`),
  KEY `fk_acrm_contacts_internal_notification_user_id` (`user_id`),
  CONSTRAINT `fk_acrm_contacts_internal_notification_user_id` FOREIGN KEY (`user_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_p_259294_259280_user_i_5c4fd78fc5f92` FOREIGN KEY (`internal_notification_id`) REFERENCES `acrm_internal_notifications` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_internal_notification_user` */

/*Table structure for table `acrm_internal_notifications` */

DROP TABLE IF EXISTS `acrm_internal_notifications`;

CREATE TABLE `acrm_internal_notifications` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `text` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_internal_notifications` */

/*Table structure for table `acrm_invoice_notes` */

DROP TABLE IF EXISTS `acrm_invoice_notes`;

CREATE TABLE `acrm_invoice_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` text COLLATE utf8mb4_unicode_ci,
  `date_contacted` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `invoice_id` int(10) unsigned DEFAULT NULL,
  `created_by_id` int(10) unsigned DEFAULT NULL,
  `quote_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `quotes_notes_deleted_at_index` (`deleted_at`),
  KEY `298254_5cc692936db0a` (`invoice_id`),
  KEY `298711_5cc8034fec12d` (`quote_id`),
  KEY `fk_acrm_contacts_invoice_notes_createdby_id_idx` (`created_by_id`),
  CONSTRAINT `298711_5cc8034fec12d` FOREIGN KEY (`quote_id`) REFERENCES `acrm_quotes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_acrm_contacts_invoice_notes_createdby` FOREIGN KEY (`created_by_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_invoice_id_notes` FOREIGN KEY (`invoice_id`) REFERENCES `acrm_invoices` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_invoice_notes` */

/*Table structure for table `acrm_invoice_paymentmodes` */

DROP TABLE IF EXISTS `acrm_invoice_paymentmodes`;

CREATE TABLE `acrm_invoice_paymentmodes` (
  `invoice_id` int(10) unsigned DEFAULT NULL,
  `payment_gateway_id` int(10) unsigned DEFAULT NULL,
  KEY `fk_p_259566_259301_conten_5c5036ef1e1ea` (`invoice_id`),
  KEY `fk_p_259301_259566_articl_5c5036ef1e28b` (`payment_gateway_id`),
  CONSTRAINT `fk_paymodes_invoice_id` FOREIGN KEY (`invoice_id`) REFERENCES `acrm_invoices` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_paymodes_paymode_id` FOREIGN KEY (`payment_gateway_id`) REFERENCES `acrm_payment_gateways` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_invoice_paymentmodes` */

/*Table structure for table `acrm_invoice_payments` */

DROP TABLE IF EXISTS `acrm_invoice_payments`;

CREATE TABLE `acrm_invoice_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `account_id` int(10) unsigned DEFAULT NULL,
  `invoice_id` int(10) unsigned DEFAULT NULL,
  `paymentmethod` char(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `payment_status` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT 'Success',
  `transaction_data` text COLLATE utf8mb4_unicode_ci,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `credit_note_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_payments_deleted_at_index` (`deleted_at`),
  KEY `263295_5c5d41a961b5c` (`account_id`),
  KEY `263295_5c5d41a961b9c` (`invoice_id`),
  KEY `fk_credit_note_id_invoicepayments` (`credit_note_id`),
  CONSTRAINT `263295_5c5d41a961b5c` FOREIGN KEY (`account_id`) REFERENCES `acrm_accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `263295_5c5d41a961b9c` FOREIGN KEY (`invoice_id`) REFERENCES `acrm_invoices` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_credit_note_id_invoicepayments` FOREIGN KEY (`credit_note_id`) REFERENCES `acrm_credit_notes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_invoice_payments` */

/*Table structure for table `acrm_invoice_products` */

DROP TABLE IF EXISTS `acrm_invoice_products`;

CREATE TABLE `acrm_invoice_products` (
  `invoice_id` int(10) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `product_name` varchar(191) DEFAULT NULL,
  `product_qty` decimal(10,2) DEFAULT NULL COMMENT 'Quantity may have decimal value in case of project task invoice',
  `product_price` decimal(10,2) DEFAULT NULL,
  `product_tax` decimal(10,2) DEFAULT NULL COMMENT 'Tax Rate',
  `tax_type` varchar(10) DEFAULT NULL,
  `tax_value` decimal(10,2) DEFAULT NULL,
  `product_discount` decimal(10,2) DEFAULT NULL COMMENT 'Discount Rate',
  `discount_type` varchar(10) DEFAULT NULL,
  `discount_value` decimal(10,0) DEFAULT NULL,
  `product_subtotal` decimal(10,0) DEFAULT NULL,
  `product_amount` decimal(10,2) DEFAULT NULL,
  `pid` int(11) DEFAULT NULL,
  `unit` varchar(15) DEFAULT NULL,
  `hsn` varchar(45) DEFAULT NULL,
  `alert` int(11) DEFAULT NULL,
  `stock_quantity` int(11) DEFAULT NULL,
  `product_description` text,
  KEY `fk_invoice_id_invoice_products` (`invoice_id`),
  KEY `fk_product_id_invoice_products` (`invoice_id`),
  KEY `fk_product_id_invoice_products2` (`product_id`),
  CONSTRAINT `fk_invoice_id_invoice_products` FOREIGN KEY (`invoice_id`) REFERENCES `acrm_invoices` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_product_id_invoice_products2` FOREIGN KEY (`product_id`) REFERENCES `acrm_products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `acrm_invoice_products` */

/*Table structure for table `acrm_invoice_products_expenses` */

DROP TABLE IF EXISTS `acrm_invoice_products_expenses`;

CREATE TABLE `acrm_invoice_products_expenses` (
  `invoice_id` int(10) unsigned DEFAULT NULL,
  `expense_id` int(10) unsigned DEFAULT NULL,
  `product_name` varchar(191) DEFAULT NULL,
  `product_qty` decimal(10,2) DEFAULT NULL COMMENT 'Quantity may have decimal value in case of project task invoice',
  `product_price` decimal(10,2) DEFAULT NULL,
  `product_tax` decimal(10,2) DEFAULT NULL COMMENT 'Tax Rate',
  `tax_type` varchar(10) DEFAULT NULL,
  `tax_value` decimal(10,2) DEFAULT NULL,
  `product_discount` decimal(10,2) DEFAULT NULL COMMENT 'Discount Rate',
  `discount_type` varchar(10) DEFAULT NULL,
  `discount_value` decimal(10,0) DEFAULT NULL,
  `product_subtotal` decimal(10,0) DEFAULT NULL,
  `product_amount` decimal(10,2) DEFAULT NULL,
  `pid` int(11) DEFAULT NULL,
  `unit` varchar(15) DEFAULT NULL,
  `hsn` varchar(45) DEFAULT NULL,
  `alert` int(11) DEFAULT NULL,
  `stock_quantity` int(11) DEFAULT NULL,
  `product_description` text,
  KEY `fk_invoice_id_invoice_products223` (`invoice_id`),
  KEY `fk_product_id_invoice_products223` (`invoice_id`),
  KEY `fk_acrm_invoice_products_1_idx223` (`expense_id`),
  CONSTRAINT `fk_acrm_invoice_products_1223` FOREIGN KEY (`expense_id`) REFERENCES `acrm_expenses` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_invoice_id_invoice_products223` FOREIGN KEY (`invoice_id`) REFERENCES `acrm_invoices` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `acrm_invoice_products_expenses` */

/*Table structure for table `acrm_invoice_products_tasks` */

DROP TABLE IF EXISTS `acrm_invoice_products_tasks`;

CREATE TABLE `acrm_invoice_products_tasks` (
  `invoice_id` int(10) unsigned DEFAULT NULL,
  `task_id` int(10) unsigned DEFAULT NULL,
  `product_name` varchar(191) DEFAULT NULL,
  `product_qty` decimal(10,2) DEFAULT NULL COMMENT 'Quantity may have decimal value in case of project task invoice',
  `product_price` decimal(10,2) DEFAULT NULL,
  `product_tax` decimal(10,2) DEFAULT NULL COMMENT 'Tax Rate',
  `tax_type` varchar(10) DEFAULT NULL,
  `tax_value` decimal(10,2) DEFAULT NULL,
  `product_discount` decimal(10,2) DEFAULT NULL COMMENT 'Discount Rate',
  `discount_type` varchar(10) DEFAULT NULL,
  `discount_value` decimal(10,0) DEFAULT NULL,
  `product_subtotal` decimal(10,0) DEFAULT NULL,
  `product_amount` decimal(10,2) DEFAULT NULL,
  `pid` int(11) DEFAULT NULL,
  `unit` varchar(15) DEFAULT NULL,
  `hsn` varchar(45) DEFAULT NULL,
  `alert` int(11) DEFAULT NULL,
  `stock_quantity` int(11) DEFAULT NULL,
  `product_description` text,
  `time_entry_id` int(10) unsigned DEFAULT NULL,
  KEY `fk_invoice_id_invoice_products22` (`invoice_id`),
  KEY `fk_product_id_invoice_products22` (`invoice_id`),
  KEY `fk_acrm_invoice_products_task_id_idx22` (`task_id`),
  KEY `fk_acrm_invoice_products_tasks_time_entry_id_idx` (`time_entry_id`),
  CONSTRAINT `fk_acrm_invoice_products_task_id22` FOREIGN KEY (`task_id`) REFERENCES `acrm_project_tasks` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_acrm_invoice_products_tasks_time_entry_id` FOREIGN KEY (`time_entry_id`) REFERENCES `acrm_time_entries` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_invoice_id_invoice_products22` FOREIGN KEY (`invoice_id`) REFERENCES `acrm_invoices` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `acrm_invoice_products_tasks` */

/*Table structure for table `acrm_invoice_reminders` */

DROP TABLE IF EXISTS `acrm_invoice_reminders`;

CREATE TABLE `acrm_invoice_reminders` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` text COLLATE utf8mb4_unicode_ci,
  `date` date DEFAULT NULL,
  `isnotified` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notify_by_email` enum('no','yes') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `invoice_id` int(10) unsigned DEFAULT NULL,
  `reminder_to_id` int(10) unsigned DEFAULT NULL,
  `created_by_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `quotes_reminders_deleted_at_index` (`deleted_at`),
  KEY `298253_5cc691865346c` (`invoice_id`),
  KEY `fk_contacts_acrm_invoice_created_by_id_idx` (`created_by_id`),
  KEY `fk_contacts_acrm_invoice_reminders_id_idx` (`reminder_to_id`),
  CONSTRAINT `fk_contacts_acrm_invoice_created_by_id` FOREIGN KEY (`created_by_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_contacts_acrm_invoice_reminders_id` FOREIGN KEY (`reminder_to_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_invoice_id_reminders` FOREIGN KEY (`invoice_id`) REFERENCES `acrm_invoices` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_invoice_reminders` */

/*Table structure for table `acrm_invoice_task_user` */

DROP TABLE IF EXISTS `acrm_invoice_task_user`;

CREATE TABLE `acrm_invoice_task_user` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `invoice_task_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_invoice_task_id` (`invoice_task_id`),
  KEY `fk_acrm_contacts_invoice_task_user_id_idx` (`user_id`),
  CONSTRAINT `fk_acrm_contacts_invoice_task_user_id` FOREIGN KEY (`user_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_invoice_task_id` FOREIGN KEY (`invoice_task_id`) REFERENCES `acrm_invoice_tasks` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `acrm_invoice_task_user` */

/*Table structure for table `acrm_invoice_tasks` */

DROP TABLE IF EXISTS `acrm_invoice_tasks`;

CREATE TABLE `acrm_invoice_tasks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `startdate` date DEFAULT NULL,
  `duedate` date DEFAULT NULL,
  `datefinished` date DEFAULT NULL,
  `recurring_type` enum('day','week','month','year') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `recurring_value` int(10) unsigned DEFAULT '0' COMMENT '''0'' means not rec urring',
  `cycles` int(11) DEFAULT NULL,
  `total_cycles` int(10) unsigned DEFAULT NULL,
  `last_recurring_date` date DEFAULT NULL,
  `is_public` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'yes',
  `billable` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'yes',
  `billed` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `hourly_rate` decimal(15,2) DEFAULT '0.00',
  `kanban_order` int(11) DEFAULT NULL,
  `milestone_order` int(11) DEFAULT NULL,
  `visible_to_client` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `deadline_notified` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `priority_id` int(10) unsigned DEFAULT NULL,
  `status_id` int(10) unsigned DEFAULT NULL,
  `recurring_id` int(10) unsigned DEFAULT NULL,
  `invoice_id` int(10) unsigned DEFAULT NULL,
  `created_by_id` int(10) unsigned DEFAULT NULL,
  `mile_stone_id` int(10) unsigned DEFAULT NULL,
  `is_recurring_from` int(10) unsigned DEFAULT NULL,
  `attachments` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_tasks_deleted_at_index` (`deleted_at`),
  KEY `298700_5cc801277056b` (`priority_id`),
  KEY `298700_5cc801279da9f` (`status_id`),
  KEY `298700_5cc80127c8e38` (`recurring_id`),
  KEY `298700_5cc8012800e26` (`invoice_id`),
  KEY `298700_5cc801285d6cf` (`mile_stone_id`),
  KEY `fk_is_recurring_from_invoice_tasks` (`is_recurring_from`),
  KEY `fk_contacts_acrm_invoice_tasks_users_idx` (`created_by_id`),
  CONSTRAINT `298700_5cc801277056b` FOREIGN KEY (`priority_id`) REFERENCES `acrm_dynamic_options` (`id`) ON DELETE CASCADE,
  CONSTRAINT `298700_5cc801279da9f` FOREIGN KEY (`status_id`) REFERENCES `acrm_dynamic_options` (`id`) ON DELETE CASCADE,
  CONSTRAINT `298700_5cc80127c8e38` FOREIGN KEY (`recurring_id`) REFERENCES `acrm_recurring_periods` (`id`) ON DELETE CASCADE,
  CONSTRAINT `298700_5cc8012800e26` FOREIGN KEY (`invoice_id`) REFERENCES `acrm_invoices` (`id`) ON DELETE CASCADE,
  CONSTRAINT `298700_5cc801285d6cf` FOREIGN KEY (`mile_stone_id`) REFERENCES `acrm_mile_stones` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_contacts_acrm_invoice_tasks_users` FOREIGN KEY (`created_by_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_is_recurring_from_invoice_tasks` FOREIGN KEY (`is_recurring_from`) REFERENCES `acrm_invoice_tasks` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_invoice_tasks` */

/*Table structure for table `acrm_invoices` */

DROP TABLE IF EXISTS `acrm_invoices`;

CREATE TABLE `acrm_invoices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci COMMENT 'Billing Address',
  `invoice_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_quantity_as` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_no` bigint(22) DEFAULT NULL,
  `status` enum('Published','Draft') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_date` date DEFAULT NULL,
  `invoice_due_date` date DEFAULT NULL,
  `invoice_notes` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `customer_id` int(10) unsigned DEFAULT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `tax_id` int(10) unsigned DEFAULT NULL,
  `discount_id` int(10) unsigned DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `products` longtext COLLATE utf8mb4_unicode_ci,
  `paymentstatus` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT 'unpaid',
  `signature` longblob,
  `created_by_id` int(10) unsigned DEFAULT NULL,
  `delivery_address` text COLLATE utf8mb4_unicode_ci COMMENT 'Shipping Address',
  `show_delivery_address` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no' COMMENT 'Show shipping details in invoice',
  `admin_notes` text COLLATE utf8mb4_unicode_ci,
  `sale_agent` int(10) unsigned DEFAULT NULL,
  `terms_conditions` longtext COLLATE utf8mb4_unicode_ci,
  `prevent_overdue_reminders` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `total_cycles` int(10) DEFAULT '0' COMMENT 'Total completed cycles',
  `cycles` int(11) DEFAULT '0',
  `is_recurring` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `recurring_period_id` int(10) unsigned DEFAULT NULL,
  `recurring_type` char(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Eg: Day, Month, Year',
  `recurring_value` int(10) DEFAULT NULL,
  `last_recurring_date` date DEFAULT NULL,
  `is_recurring_from` int(10) DEFAULT NULL,
  `last_overdue_reminder` date DEFAULT NULL,
  `quote_id` int(10) unsigned DEFAULT NULL,
  `project_id` int(10) unsigned DEFAULT NULL,
  `devery_note_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `po_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_number_format` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT 'numberbased',
  `invoice_number_separator` char(5) COLLATE utf8mb4_unicode_ci DEFAULT '-',
  `invoice_number_length` int(10) DEFAULT '0',
  `order_id` int(10) unsigned DEFAULT NULL,
  `proposal_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoices_deleted_at_index` (`deleted_at`),
  KEY `259415_5c500ae98af17` (`customer_id`),
  KEY `259415_5c500ae9b10d1` (`currency_id`),
  KEY `259415_5c500ae9d6387` (`tax_id`),
  KEY `259415_5c500aea0188f` (`discount_id`),
  KEY `fk_invoices_sale_agent` (`sale_agent`),
  KEY `fk_recurring_period_id_invoices` (`recurring_period_id`),
  KEY `fk_quote_id_quotes` (`quote_id`),
  KEY `fk_project_id_invoices` (`project_id`),
  KEY `fk_acrm_invoices_orderid_idx` (`order_id`),
  KEY `fk_acrm_invoices_created_by_id_idx` (`created_by_id`),
  KEY `fk_acrm_invoices_proposal_id_idx` (`proposal_id`),
  CONSTRAINT `259415_5c500ae98af17` FOREIGN KEY (`customer_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `259415_5c500ae9b10d1` FOREIGN KEY (`currency_id`) REFERENCES `acrm_currencies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `259415_5c500ae9d6387` FOREIGN KEY (`tax_id`) REFERENCES `acrm_taxes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `259415_5c500aea0188f` FOREIGN KEY (`discount_id`) REFERENCES `acrm_discounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_acrm_invoices_created_by_id` FOREIGN KEY (`created_by_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_acrm_invoices_proposal_id` FOREIGN KEY (`proposal_id`) REFERENCES `acrm_proposals` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_invoices_sale_agent` FOREIGN KEY (`sale_agent`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_project_id_invoices` FOREIGN KEY (`project_id`) REFERENCES `acrm_client_projects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_quote_id_quotes` FOREIGN KEY (`quote_id`) REFERENCES `acrm_quotes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_recurring_period_id_invoices` FOREIGN KEY (`recurring_period_id`) REFERENCES `acrm_recurring_periods` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_invoices` */

/*Table structure for table `acrm_invoices_history` */

DROP TABLE IF EXISTS `acrm_invoices_history`;

CREATE TABLE `acrm_invoices_history` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ip_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` text COLLATE utf8mb4_unicode_ci,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `browser` text COLLATE utf8mb4_unicode_ci,
  `comments` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `invoice_id` int(10) unsigned DEFAULT NULL,
  `operation_type` char(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'general, crud, email, sms, cron',
  PRIMARY KEY (`id`),
  KEY `invoices_history_deleted_at_index` (`deleted_at`),
  KEY `259415_5c500ae99af17` (`invoice_id`),
  CONSTRAINT `259415_5c500ae99af17` FOREIGN KEY (`invoice_id`) REFERENCES `acrm_invoices` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_invoices_history` */

/*Table structure for table `acrm_jobs` */

DROP TABLE IF EXISTS `acrm_jobs`;

CREATE TABLE `acrm_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL,
  `reserved_at` int(10) unsigned DEFAULT NULL,
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_jobs` */

/*Table structure for table `acrm_languages` */

DROP TABLE IF EXISTS `acrm_languages`;

CREATE TABLE `acrm_languages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `language` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_rtl` enum('Yes','No') COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `languages_deleted_at_index` (`deleted_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_languages` */

insert  into `acrm_languages`(`id`,`language`,`code`,`is_rtl`,`created_at`,`updated_at`,`deleted_at`) values 
(1,'English','en','No','2019-10-01 10:17:05','2019-10-01 10:17:05',NULL);

/*Table structure for table `acrm_ltm_translations` */

DROP TABLE IF EXISTS `acrm_ltm_translations`;

CREATE TABLE `acrm_ltm_translations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` int(11) NOT NULL DEFAULT '0',
  `locale` varchar(191) COLLATE utf8mb4_bin NOT NULL,
  `group` varchar(191) COLLATE utf8mb4_bin NOT NULL,
  `key` text COLLATE utf8mb4_bin NOT NULL,
  `value` text COLLATE utf8mb4_bin,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;

/*Data for the table `acrm_ltm_translations` */

/*Table structure for table `acrm_master_settings` */

DROP TABLE IF EXISTS `acrm_master_settings`;

CREATE TABLE `acrm_master_settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `settings_data` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `moduletype` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('Active','Inactive') COLLATE utf8mb4_unicode_ci DEFAULT 'Active',
  PRIMARY KEY (`id`),
  KEY `master_settings_deleted_at_index` (`deleted_at`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_master_settings` */

insert  into `acrm_master_settings`(`id`,`module`,`slug`,`key`,`description`,`settings_data`,`created_at`,`updated_at`,`deleted_at`,`moduletype`,`status`) values 
(1,'Seo Settings','seo-settings','seo_settings','Contains all SEO settings','{\"meta_description\":{\"value\":\"LaraOffice - Ultimate CRM, Project Management, Accounting and Invoicing System\",\"type\":\"textarea\",\"extra\":\"\",\"tool_tip\":\"Site Meta Description\"},\"meta_keywords\":{\"value\":\"LaraOffice - Ultimate CRM, Project Management, Accounting and Invoicing System\",\"type\":\"textarea\",\"extra\":\"\",\"tool_tip\":\"Site Meta Keywords\"},\"google_analytics\":{\"value\":\"<!-- Google Analytics -->\\r\\n<script>\\r\\n(function(i,s,o,g,r,a,m){i[\'GoogleAnalyticsObject\']=r;i[r]=i[r]||function(){\\r\\n(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),\\r\\nm=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)\\r\\n})(window,document,\'script\',\'https:\\/\\/www.google-analytics.com\\/analytics.js\',\'ga\');\\r\\n\\r\\nga(\'create\', \'UA-XXXXX-Y\', \'auto\');\\r\\nga(\'send\', \'pageview\');\\r\\n<\\/script>\\r\\n<!-- End Google Analytics -->\",\"type\":\"textarea\",\"extra\":\"\",\"tool_tip\":\"Update your google analytics code\"}}','2019-01-30 12:52:16','2019-08-26 09:30:10',NULL,'general','Active'),
(2,'SMS Settings','sms-settings','sms_settings','Contains settings for SMS','{\"sms_driver\":{\"value\":\"plivo\",\"type\":\"select\",\"extra\":{\"options\":{\"plivo\":\"PLIVO\",\"twilio\":\"TWILIO\"},\"total_options\":\"3\"},\"tool_tip\":\"Select SMS driver\"},\"twilio_sid\":{\"value\":\"TWILIO_SID\",\"type\":\"text\",\"extra\":{\"options\":{\"plivo\":\"PLIVO\",\"twilio\":\"TWILIO\"},\"total_options\":\"3\"},\"tool_tip\":\"Twilio SID\"},\"twilio_token\":{\"value\":\"TWILIO_TOKEN EDIT\",\"type\":\"text\",\"extra\":{\"options\":{\"plivo\":\"PLIVO\",\"twilio\":\"TWILIO\"},\"total_options\":\"3\"},\"tool_tip\":\"Twilio Token\"},\"plivo_auth_id\":{\"value\":\"MANGM1ZGY5ZTE2ZGI3ND\",\"type\":\"text\",\"extra\":{\"options\":{\"plivo\":\"PLIVO\",\"twilio\":\"TWILIO\"},\"total_options\":\"3\"},\"tool_tip\":\"Enter Plivo Auth ID\"},\"plivo_auth_token\":{\"value\":\"ZTNkYWEzOTE3MTRkMTkzMGE2MTljNGU1OTIwZDJk\",\"type\":\"text\",\"extra\":{\"options\":{\"plivo\":\"PLIVO\",\"twilio\":\"TWILIO\"},\"total_options\":\"3\"},\"tool_tip\":\"Plivo Auth Token\"}}','2019-01-30 12:52:16','2019-05-01 05:53:51',NULL,'general','Active'),
(3,'Stripe','stripe','stripe','Stripe Settings','{\n  \"stripe_key\": {\n   \"value\": \"pk_test_BwFHanUSeVVsUwZTv33KCoXG\",\n    \"type\": \"text\",\n   \"extra\": \"\",\n    \"tool_tip\": \"Stripe live key\"\n },\n  \"stripe_secret\": {\n    \"value\": \"sk_test_jxMAHpVvwcmHvv1343esaLgz\",\n    \"type\": \"text\",\n   \"extra\": \"\",\n    \"tool_tip\": \"Stripe live secret\"\n  },\n  \"stripe_mode\": {\n    \"value\": \"sandbox\",\n   \"type\": \"select\",\n   \"extra\": {\n      \"total_options\": \"2\",\n     \"options\": {\n        \"sandbox\": \"sandbox\",\n       \"live\": \"live\"\n      }\n   },\n    \"tool_tip\": \"Stripe mode\"\n },\n  \"hide_stripe_remember_me_box\": {\n    \"value\": \"yes\",\n   \"type\": \"select\",\n   \"extra\": {\n      \"total_options\": \"2\",\n     \"options\": {\n        \"yes\": \"yes\",\n       \"no\": \"no\"\n      }\n   },\n    \"tool_tip\": \"Hide remember me box\"\n  },\n  \"require_billing_address\": {\n    \"value\": \"yes\",\n   \"type\": \"select\",\n   \"extra\": {\n      \"total_options\": \"2\",\n     \"options\": {\n        \"yes\": \"yes\",\n       \"no\": \"no\"\n      }\n   },\n    \"tool_tip\": \"Require billing address\"\n },\n  \"stripe_checkout_popup_image\": {\n    \"value\": \"BOxAsLnvjae0Cxg.png\",\n   \"type\": \"file\",\n   \"extra\": {\n      \"total_options\": \"2\",\n     \"options\": {\n        \"yes\": \"yes\",\n       \"no\": \"no\"\n      }\n   },\n    \"tool_tip\": \"Popup image\"\n },\n  \"stripe_checkout_popup_title\": {\n    \"value\": \"Pay with Stripe\",\n   \"type\": \"text\",\n   \"extra\": {\n      \"total_options\": \"2\",\n     \"options\": {\n        \"yes\": \"yes\",\n       \"no\": \"no\"\n      }\n   },\n    \"tool_tip\": \"Stripe checkout popup title\"\n },\n  \"stripe_checkout_popup_description\": {\n    \"value\": \"Stripe payment\",\n    \"type\": \"text\",\n   \"extra\": {\n      \"total_options\": \"2\",\n     \"options\": {\n        \"yes\": \"yes\",\n       \"no\": \"no\"\n      }\n   },\n    \"tool_tip\": \"Stripe checkout popup description\"\n },\n  \"require_shipping_address\": {\n   \"value\": \"yes\",\n   \"type\": \"select\",\n   \"extra\": {\n      \"total_options\": \"2\",\n     \"options\": {\n        \"yes\": \"Yes\",\n       \"no\": \"No\"\n      }\n   },\n    \"tool_tip\": \"Shipping address\"\n  }\n}','2019-01-30 12:52:16','2019-07-30 11:32:27',NULL,'payment','Active'),
(4,'Site Settings','site-settings','site_settings','Here you can manage the title, logo, favicon and all general settings','{\"site_title\":{\"value\":\"LaraOffice - Ultimate CRM, Project Management, Accounting and Invoicing System\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Site Title\"},\"site_logo\":{\"value\":\"yo9alUTR5nOsVNp.png\",\"type\":\"file\",\"extra\":\"\",\"tool_tip\":\"Site Logo\"},\"site_favicon\":{\"value\":\"Jl2nhreFpkxrUSx.png\",\"type\":\"file\",\"extra\":\"\",\"tool_tip\":\"Favicon\"},\"site_address\":{\"value\":\"8929  Mchenry,IL 6005022\",\"type\":\"textarea\",\"extra\":\"\",\"tool_tip\":\"Address\"},\"site_city\":{\"value\":\"Hyderabad\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"City\"},\"site_state\":{\"value\":\"TS\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"State\"},\"site_country\":{\"value\":\"India\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Country\"},\"site_zipcode\":{\"value\":\"500018\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Zip Code\"},\"country_code\":{\"value\":\"91\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Country Code\"},\"site_phone\":{\"value\":\"1234567891\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Site Phone\"},\"system_timezone\":{\"value\":\"Asia\\/Kolkata\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Refer http:\\/\\/php.net\\/manual\\/en\\/timezones.php\"},\"contact_email\":{\"value\":\"info@laraoffice.com\",\"type\":\"email\",\"extra\":\"\",\"tool_tip\":\"Contact Email\"},\"rights_reserved\":{\"value\":\"@2019 LaraOffice All Rights Reserved.\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Rights Reserved\"},\"date_format\":{\"value\":\"mm-dd-yyyy\",\"type\":\"select\",\"extra\":{\"total_options\":\"3\",\"options\":{\"yyyy-mm-dd\":\"yyyy-mm-dd\",\"mm-dd-yyyy\":\"mm-dd-yyyy\",\"dd-mm-yyyy\":\"dd-mm-yyyy\"}},\"tool_tip\":\"Javascript Date Format.\"},\"products_selection\":{\"value\":\"select2\",\"type\":\"select\",\"extra\":{\"total_options\":\"3\",\"options\":{\"ajax\":\"Ajax\",\"select\":\"Select\",\"select2\":\"Select2\"}},\"tool_tip\":\"Product Select Option\"},\"enable_products_slider\":{\"value\":\"no\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"yes\":\"Yes\",\"no\":\"No\"}},\"tool_tip\":\"Product Slider\"},\"slider_type\":{\"value\":\"slick\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"slick\":\"Slick Slider\",\"jssor\":\"Jssor Slider\"}},\"tool_tip\":\"Slider Type\"},\"message_type\":{\"value\":\"sweetalert\",\"type\":\"select\",\"extra\":{\"total_options\":\"3\",\"options\":{\"onpage\":\"On Page\",\"notify\":\"Notify\",\"sweetalert\":\"Sweet alert\"}},\"tool_tip\":\"Message Type\"},\"use-dynamic-menu\":{\"value\":\"No\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"No\":\"No\",\"Yes\":\"Yes\"}},\"tool_tip\":\"Use Dynamic Menu?\"},\"statistics-type\":{\"value\":\"default\",\"type\":\"select\",\"extra\":{\"total_options\":\"3\",\"options\":{\"circle\":\"Circle\",\"progress\":\"Progress\",\"default\":\"Default\"}},\"tool_tip\":\"Summary\\/Statistics type of display\"},\"autoclose_tickets_after\":{\"value\":\"48\",\"type\":\"number\",\"extra\":{\"total_options\":\"3\",\"options\":{\"circle\":\"Circle\",\"progress\":\"Progress\",\"default\":\"Default\"}},\"tool_tip\":\"Autoclose tickets after (In Hours). If this value is 0, then tickets will not close automatically.\"},\"delete_activity_log_older_than\":{\"value\":\"2\",\"type\":\"number\",\"extra\":{\"total_options\":\"3\",\"options\":{\"circle\":\"Circle\",\"progress\":\"Progress\",\"default\":\"Default\"}},\"tool_tip\":\"Delete activity log older than (In Days). If you enter 0, system wont delete activity log\"},\"addnew_type\":{\"value\":\"symbol\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"button\":\"Button\",\"symbol\":\"Symbol\"}},\"tool_tip\":\"Add new button type\"},\"default_payment_gateway\":{\"value\":\"paypal\",\"type\":\"select\",\"extra\":\"\",\"tool_tip\":\"Default Payment Gateway\"},\"default_sms_gateway\":{\"value\":\"nexmo\",\"type\":\"select\",\"extra\":\"\",\"tool_tip\":\"Default SMS Gateway\"}}','2019-01-30 12:52:16','2019-10-01 13:31:08',NULL,'general','Active'),
(5,'Email Settings','email-settings','email_settings','Contains all the settings related to emails','{\"mail_host\":{\"value\":\"smtp.mailtrap.io\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Mail Host\"},\"mail_port\":{\"value\":\"2525\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Mail Port no\"},\"mail_driver\":{\"value\":\"smtp\",\"type\":\"select\",\"extra\":{\"options\":{\"log\":\"Log\",\"ses\":\"SES\",\"mail\":\"Mail\",\"smtp\":\"SMTP\",\"mailgun\":\"Mailgun\",\"mandrill\":\"Mandrill\",\"sendmail\":\"Sendmail\",\"sparkpost\":\"Sparkpost\"},\"total_options\":\"8\"},\"tool_tip\":\"Driver\"},\"mail_password\":{\"value\":\"b220c0374cb52c\",\"type\":\"password\",\"extra\":{\"options\":{\"log\":\"Log\",\"ses\":\"SES\",\"mail\":\"Mail\",\"smtp\":\"SMTP\",\"mailgun\":\"Mailgun\",\"mandrill\":\"Mandrill\",\"sendmail\":\"Sendmail\",\"sparkpost\":\"Sparkpost\"},\"total_options\":\"8\"},\"tool_tip\":\"Password\"},\"mail_username\":{\"value\":\"ef9db05dbb46ce\",\"type\":\"text\",\"extra\":{\"options\":{\"log\":\"Log\",\"ses\":\"SES\",\"mail\":\"Mail\",\"smtp\":\"SMTP\",\"mailgun\":\"Mailgun\",\"mandrill\":\"Mandrill\",\"sendmail\":\"Sendmail\",\"sparkpost\":\"Sparkpost\"},\"total_options\":\"8\"},\"tool_tip\":\"Mail Username\"},\"mail_encryption\":{\"value\":\"TLS\",\"type\":\"text\",\"extra\":{\"options\":{\"log\":\"Log\",\"ses\":\"SES\",\"mail\":\"Mail\",\"smtp\":\"SMTP\",\"mailgun\":\"Mailgun\",\"mandrill\":\"Mandrill\",\"sendmail\":\"Sendmail\",\"sparkpost\":\"Sparkpost\"},\"total_options\":\"8\"},\"tool_tip\":\"Mail Encryption\"}}','2019-01-30 12:52:16','2019-09-26 04:47:42',NULL,'general','Active'),
(6,'Paypal','paypal','paypal','Contains paypal config details','{\"email\":{\"value\":\"adiyya@gmail.com\",\"type\":\"email\",\"extra\":\"\",\"tool_tip\":\"Paypal Email\"},\"image\":{\"value\":\"Jzzi3R580kd0gS1.png\",\"type\":\"file\",\"extra\":\"\",\"tool_tip\":\"Image to display at Paypal payment gateway\"},\"currency\":{\"value\":\"USD\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Default Currency\"},\"account_type\":{\"value\":\"sandbox\",\"type\":\"select\",\"extra\":{\"options\":{\"live\":\"Live\",\"sandbox\":\"Sandbox\"},\"total_options\":\"2\"},\"tool_tip\":\"Account Type Development (sandbox)\\/ Production (live)\"}}','2019-01-30 12:52:16','2019-05-07 11:17:44',NULL,'payment','Active'),
(7,'PayU','payu','payu','PayU Settings','{\"payu_salt\":{\"value\":\"eCwWELxi\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"PayU Salt\"},\"payu_testmode\":{\"value\":\"true\",\"type\":\"select\",\"extra\":{\"options\":{\"true\":\"Yes\",\"false\":\"No\"},\"total_options\":\"2\"},\"tool_tip\":\"Set PayU in Test Mode\"},\"payu_working_key\":{\"value\":\"4941163\",\"type\":\"text\",\"extra\":{\"options\":{\"true\":\"Yes\",\"false\":\"No\"},\"total_options\":\"2\"},\"tool_tip\":\"PayU Working Key\"},\"payu_merchant_key\":{\"value\":\"gtKFFx\",\"type\":\"text\",\"extra\":{\"options\":{\"true\":\"Yes\",\"false\":\"No\"},\"total_options\":\"2\"},\"tool_tip\":\"PayU Merchent Key\"},\"payu-provider\":{\"value\":\"payumoney\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"payubiz\":\"payubiz\",\"payumoney\":\"payumoney\"}},\"tool_tip\":\"PayU Provider\"},\"stripe_checkout_popup_title\":{\"value\":\"Digi Accounting, Invoicing & Billing\",\"type\":\"text\",\"extra\":{\"total_options\":\"2\",\"options\":{\"payubiz\":\"payubiz\",\"payumoney\":\"payumoney\"}},\"tool_tip\":\"Pop up title\"}}','2019-01-30 12:52:16','2019-05-25 09:28:23',NULL,'payment','Active'),
(8,'Currency Settings','currency-settings','currency_settings','Currency Settings','{\r\n \"currency_position\": {\r\n    \"value\": \"right_with_space\",\r\n    \"type\": \"select\",\r\n   \"extra\": {\r\n      \"options\": {\r\n        \"left\": \"Left\",\r\n       \"right\": \"Right\",\r\n       \"left_with_space\": \"Left with space\",\r\n       \"right_with_space\": \"Right with space\"\r\n      },\r\n      \"total_options\": \"4\"\r\n    },\r\n    \"tool_tip\": \"Currency Position\"\r\n },\r\n  \"display_currency\": {\r\n   \"value\": \"Code\",\r\n    \"type\": \"select\",\r\n   \"extra\": {\r\n      \"options\": {\r\n        \"symbol\": \"Symbol\",\r\n       \"Code\": \"code\"\r\n      },\r\n      \"total_options\": \"2\"\r\n    },\r\n    \"tool_tip\": \"Display Currency\"\r\n  },\r\n  \"toundsand_separator\": {\r\n    \"value\": \"0\",\r\n   \"type\": \"text\",\r\n   \"extra\": {\r\n      \"options\": {\r\n        \"symbol\": \"Symbol\",\r\n       \"Code\": \"code\"\r\n      },\r\n      \"total_options\": \"2\"\r\n    },\r\n    \"tool_tip\": \"Thousand Separator\"\r\n  },\r\n  \"decimal_separator\": {\r\n    \"value\": \".\",\r\n   \"type\": \"text\",\r\n   \"extra\": {\r\n      \"options\": {\r\n        \"symbol\": \"Symbol\",\r\n       \"Code\": \"code\"\r\n      },\r\n      \"total_options\": \"2\"\r\n    },\r\n    \"tool_tip\": \"Decimal Separator\"\r\n },\r\n  \"decimals\": {\r\n   \"value\": \"2\",\r\n   \"type\": \"text\",\r\n   \"extra\": {\r\n      \"options\": {\r\n        \"symbol\": \"Symbol\",\r\n       \"Code\": \"code\"\r\n      },\r\n      \"total_options\": \"2\"\r\n    },\r\n    \"tool_tip\": \"Number of Decimals\"\r\n  },\r\n\r\n  \"currencylayer_api_key\": {\r\n    \"value\": \"aee44c30f89a4ab18df7bce6a77308da\",\r\n    \"type\": \"text\",\r\n   \"extra\": {\r\n      \"options\": {\r\n        \"symbol\": \"Symbol\",\r\n       \"Code\": \"code\"\r\n      },\r\n      \"total_options\": \"2\"\r\n    },\r\n    \"tool_tip\": \"currencylayer API Key\"\r\n }\r\n}','2019-02-04 06:23:27','2019-05-10 07:09:14',NULL,'general','Active'),
(9,'Plivo','plivo','plivo','Plivo SMS gateway','{\"auth_id\":{\"value\":\"MAZJFJY2EYYJBHZJQ2ZG\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Auth ID\"},\"auth_token\":{\"value\":\"YTZmNTRjYzdmY2Y4YTgxNWRiYTBiYzAxZjQzNTQ2\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Auth Token\"}}','2019-02-15 05:32:09','2019-07-31 10:22:47',NULL,'sms','Active'),
(10,'Nexmo','nexmo','nexmo','Nexmo SMS Gateway','{\"Auth_ID\":{\"value\":\"MANGM1ZGY5ZTE2ZGI3ND\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Auth ID\"},\"NEXMO_API_KEY\":{\"value\":\"d7a4e8a8\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Your Nexmo API key.\"},\"NEXMO_API_SECRET\":{\"value\":\"8ddf3501\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Your Nexmo API secret.\"}}','2019-02-15 05:33:31','2019-07-31 07:59:32',NULL,'sms','Active'),
(11,'Twilio','twilio','twilio','Twilio SMS gateway','{\"TWILIO_SID\":{\"value\":\"AC287dbc955dd9c5d4616929be59f4e492\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"TWILIO_SID\"},\"TWILIO_TOKEN_EDIT\":{\"value\":\"b8e4f9fafa8cdeed7878b00f50de4b49\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"TWILIO_TOKEN EDIT\"},\"TWILIO_FROM\":{\"value\":\"12028499176\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"TWILIO_FROM\"}}','2019-02-15 05:40:58','2019-07-31 05:51:19',NULL,'sms','Active'),
(12,'Credit Note Settings','credit-note-settings','credit-note-settings','Credit Note Settings','{\"Company_Name_On_Credit_Note\":{\"value\":\"LaraOffice - Ultimate CRM, Project\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Company Name on Credit Note\"},\"Company-Address\":{\"value\":\"8929 Mchenry, IL 600502\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Company Address\"},\"Authorized-Person\":{\"value\":\"Samson Sudhakar P\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Authorized Person\"},\"Authorized-Person-Designation\":{\"value\":\"Business Owner\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Authorized Person Designation\"},\"Authorized-Person-Signature\":{\"value\":\"VUjnUYg06gdWQeL.png\",\"type\":\"file\",\"extra\":\"\",\"tool_tip\":\"Authorized Person Signature\"},\"Credit-Note-Logo\":{\"value\":\"MUZULZOU493jC2L.png\",\"type\":\"file\",\"extra\":\"\",\"tool_tip\":\"Invoice Logo\"},\"enable-signature-part\":{\"value\":\"No\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Yes\":\"Yes\",\"No\":\"No\"}},\"tool_tip\":\"enable-signature-part\"},\"add-to-expense-credit-note\":{\"value\":\"yes\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"no\":\"No\",\"yes\":\"Yes\"}},\"tool_tip\":\"Add Credit Note payments to expense\"},\"credit-note-prefix\":{\"value\":\"CR\",\"type\":\"text\",\"extra\":{\"total_options\":\"2\",\"options\":{\"no\":\"No\",\"yes\":\"Yes\"}},\"tool_tip\":\"Credit Note Number Prefix\"},\"credit_note_start\":{\"value\":\"0\",\"type\":\"number\",\"extra\":{\"total_options\":\"2\",\"options\":{\"no\":\"No\",\"yes\":\"Yes\"}},\"tool_tip\":\"Set this field to 1 if you want to start from beginning\"},\"show_quantity_as\":{\"value\":\"Quantity\",\"type\":\"text\",\"extra\":{\"total_options\":\"2\",\"options\":{\"no\":\"No\",\"yes\":\"Yes\"}},\"tool_tip\":\"Show quantity as\"},\"predefined_clientnote_credit_note\":{\"value\":\"Cicero famously orated against his political opponent Lucius Sergius Catilina. Occasionally the first Oration against Catiline is taken for type specimens: Quo usque tandem abutere, Catilina, patientia nostra? Quam diu etiam furor iste tuus nos eludet? (How long, O Catiline, will you abuse our patience? And for how long will that madness of yours mock us?\",\"type\":\"textarea\",\"extra\":{\"total_options\":\"2\",\"options\":{\"no\":\"No\",\"yes\":\"Yes\"}},\"tool_tip\":\"Predefined Client Note\"},\"predefined_terms_credit_note\":{\"value\":\"If any provision of these Terms and Conditions is held to be invalid or unenforceable, the provision shall be removed (or interpreted, if possible, in a manner as to be enforceable), and the remaining provisions shall be enforced. Headings are for reference purposes only and in no way define, limit, construe or describe the scope or extent of such section. Our failure to act with respect to a breach by you or others does not waive our right to act with respect to subsequent or similar breaches. These Terms and Conditions set forth the entire understanding and agreement between us with respect to the subject matter contained herein and supersede any other agreement, proposals and communications, written or oral, between our representatives and you with respect to the subject matter hereof, including any terms and conditions on any of customer\'s documents or purchase orders.\",\"type\":\"textarea\",\"extra\":{\"total_options\":\"2\",\"options\":{\"no\":\"No\",\"yes\":\"Yes\"}},\"tool_tip\":\"Predefined Terms & Conditions\"},\"predefined_adminnote_credit_note\":{\"value\":\"Asking the client to pay no attention Lorem Ipsum isn\'t hard as it doesn\\u2019t make sense in the first place, that will limit any initial interest soon enough. Try telling a client to ignore draft copy however, and you\'re up to something you can\'t win. Whenever draft copy comes up in a meeting confused questions about it ensue.\",\"type\":\"textarea\",\"extra\":{\"total_options\":\"2\",\"options\":{\"no\":\"No\",\"yes\":\"Yes\"}},\"tool_tip\":\"Predefined Admin Note\"},\"credit-note-number-format\":{\"value\":\"yearmonthnumber\",\"type\":\"select\",\"extra\":{\"total_options\":\"7\",\"options\":{\"numberbased\":\"Number Based (000001)\",\"yearbased\":\"Year Based (YYYY-000001)\",\"year2digits\":\"Year 2 Digits (YY-000001)\",\"yearmonthnumber\":\"YYYY-MM-000001\",\"yearbasedright\":\"Year Right Based (000001-YYYY)\",\"year2digitsright\":\"Year 2 Digits Right (000001-YY)\",\"numbermonthyear\":\"000001-MM-YYYY\"}},\"tool_tip\":\"Credit Note Number Format\"},\"credit-note-number-separator\":{\"value\":\"\\/\",\"type\":\"text\",\"extra\":{\"total_options\":\"7\",\"options\":{\"numberbased\":\"Number Based (000001)\",\"yearbased\":\"Year Based (YYYY-000001)\",\"year2digits\":\"Year 2 Digits (YY-000001)\",\"yearmonthnumber\":\"YYYY-MM-000001\",\"yearbasedright\":\"Year Right Based (000001-YYYY)\",\"year2digitsright\":\"Year 2 Digits Right (000001-YY)\",\"numbermonthyear\":\"000001-MM-YYYY\"}},\"tool_tip\":\"This will apply if the format is other than \'number\'\"},\"credit-note-number-length\":{\"value\":\"5\",\"type\":\"number\",\"extra\":{\"total_options\":\"7\",\"options\":{\"numberbased\":\"Number Based (000001)\",\"yearbased\":\"Year Based (YYYY-000001)\",\"year2digits\":\"Year 2 Digits (YY-000001)\",\"yearmonthnumber\":\"YYYY-MM-000001\",\"yearbasedright\":\"Year Right Based (000001-YYYY)\",\"year2digitsright\":\"Year 2 Digits Right (000001-YY)\",\"numbermonthyear\":\"000001-MM-YYYY\"}},\"tool_tip\":\"Credit note number length. If it is greater than \\\"0\\\" system will fill the number with \\\"0\\\" based on length. Ex: if this value is 4 and the generated credit note number is 28, then system will display the credit no. as \\\"0028\\\"\"},\"credit-note-footer\":{\"value\":\"LARAOFFICE(CRM)\",\"type\":\"textarea\",\"extra\":{\"total_options\":\"7\",\"options\":{\"numberbased\":\"Number Based (000001)\",\"yearbased\":\"Year Based (YYYY-000001)\",\"year2digits\":\"Year 2 Digits (YY-000001)\",\"yearmonthnumber\":\"YYYY-MM-000001\",\"yearbasedright\":\"Year Right Based (000001-YYYY)\",\"year2digitsright\":\"Year 2 Digits Right (000001-YY)\",\"numbermonthyear\":\"000001-MM-YYYY\"}},\"tool_tip\":\"Credit note footer\"},\"credit-note-footer-enable\":{\"value\":\"Yes\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Yes\":\"Yes\",\"No\":\"No\"}},\"tool_tip\":\"Credit note footer enable\"},\"default_expense_caterory\":{\"value\":\"3\",\"type\":\"select\",\"extra\":\"\",\"tool_tip\":\"Default expense category\"},\"default-account\":{\"value\":0,\"type\":\"select\",\"extra\":\"\",\"tool_tip\":\"Default account for payments\"}}','2019-02-20 05:20:25','2019-10-10 12:13:27',NULL,'general','Active'),
(13,'Invoice Settings','invoice-settings','invoice-settings','Invoice Settings','{\"Company_Name_On_Invoice\":{\"value\":\"LaraOffice - Ultimate CRM\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Company Name on Invoice\"},\"Company-Address\":{\"value\":\"8929 Machenry, IL 6005022\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Company Address\"},\"Authorized-Person\":{\"value\":\"Samson Sudhakar P\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Authorized Person\"},\"Authorized-Person-Designation\":{\"value\":\"Business Owner\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Authorized Person Designation\"},\"Authorized-Person-Signature\":{\"value\":\"VUjnUYg06gdWQeL.png\",\"type\":\"file\",\"extra\":\"\",\"tool_tip\":\"Authorized Person Signature\"},\"Invoice-Logo\":{\"value\":\"1XvBEZflSYCvNvn.png\",\"type\":\"file\",\"extra\":\"\",\"tool_tip\":\"Invoice Logo\"},\"enable-signature-part\":{\"value\":\"Yes\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Yes\":\"Yes\",\"No\":\"No\"}},\"tool_tip\":\"enable-signature-part\"},\"add-to-income-invoice\":{\"value\":\"yes\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"no\":\"No\",\"yes\":\"Yes\"}},\"tool_tip\":\"Add Invoice payments to incomes\"},\"invoice-prefix\":{\"value\":\"INV\",\"type\":\"text\",\"extra\":{\"total_options\":\"2\",\"options\":{\"no\":\"No\",\"yes\":\"Yes\"}},\"tool_tip\":\"Invoice Number Prefix\"},\"invoice_start\":{\"value\":\"0\",\"type\":\"number\",\"extra\":{\"total_options\":\"2\",\"options\":{\"no\":\"No\",\"yes\":\"Yes\"}},\"tool_tip\":\"Set this field to 1 if you want to start from beginning\"},\"invoice_due_after\":{\"value\":\"200\",\"type\":\"text\",\"extra\":{\"total_options\":\"2\",\"options\":{\"no\":\"No\",\"yes\":\"Yes\"}},\"tool_tip\":\"Invoice due after (days)\"},\"show_sale_agent_on_invoices\":{\"value\":\"yes\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"yes\":\"Yes\",\"no\":\"No\"}},\"tool_tip\":\"Show Sale Agent On Invoice\"},\"show_quantity_as\":{\"value\":\"Quantity\",\"type\":\"text\",\"extra\":{\"total_options\":\"2\",\"options\":{\"yes\":\"Yes\",\"no\":\"No\"}},\"tool_tip\":\"Show quantity as\"},\"predefined_clientnote_invoice\":{\"value\":\"Cicero famously orated against his political opponent Lucius Sergius Catilina. Occasionally the first Oration against Catiline is taken for type specimens: Quo usque tandem abutere, Catilina, patientia nostra? Quam diu etiam furor iste tuus nos eludet? (How long, O Catiline, will you abuse our patience? And for how long will that madness of yours mock us?\",\"type\":\"textarea\",\"extra\":{\"total_options\":\"2\",\"options\":{\"yes\":\"Yes\",\"no\":\"No\"}},\"tool_tip\":\"Predefined Client Note\"},\"predefined_terms_invoice\":{\"value\":\"If any provision of these Terms and Conditions is held to be invalid or unenforceable, the provision shall be removed (or interpreted, if possible, in a manner as to be enforceable), and the remaining provisions shall be enforced. Headings are for reference purposes only and in no way define, limit, construe or describe the scope or extent of such section. Our failure to act with respect to a breach by you or others does not waive our right to act with respect to subsequent or similar breaches. These Terms and Conditions set forth the entire understanding and agreement between us with respect to the subject matter contained herein and supersede any other agreement, proposals and communications, written or oral, between our representatives and you with respect to the subject matter hereof, including any terms and conditions on any of customer\'s documents or purchase orders.\",\"type\":\"textarea\",\"extra\":{\"total_options\":\"2\",\"options\":{\"yes\":\"Yes\",\"no\":\"No\"}},\"tool_tip\":\"Predefined Terms & Conditions\"},\"predefined_adminnote_invoice\":{\"value\":\"Asking the client to pay no attention Lorem Ipsum isn\'t hard as it doesn\\u2019t make sense in the first place, that will limit any initial interest soon enough. Try telling a client to ignore draft copy however, and you\'re up to something you can\'t win. Whenever draft copy comes up in a meeting confused questions about it ensue.\",\"type\":\"textarea\",\"extra\":{\"total_options\":\"2\",\"options\":{\"yes\":\"Yes\",\"no\":\"No\"}},\"tool_tip\":\"Predefined Admin Note\"},\"invoice-number-format\":{\"value\":\"yearmonthnumber\",\"type\":\"select\",\"extra\":{\"total_options\":\"7\",\"options\":{\"numberbased\":\"Number Based (000001)\",\"yearbased\":\"Year Based (YYYY-000001)\",\"year2digits\":\"Year 2 Digits (YY-000001)\",\"yearmonthnumber\":\"YYYY-MM-000001\",\"yearbasedright\":\"Year Right Based (000001-YYYY)\",\"year2digitsright\":\"Year 2 Digits Right (000001-YY)\",\"numbermonthyear\":\"000001-MM-YYYY\"}},\"tool_tip\":\"Invoice Number Format\"},\"invoice-number-separator\":{\"value\":\"-\",\"type\":\"text\",\"extra\":{\"total_options\":\"7\",\"options\":{\"numberbased\":\"Number Based (000001)\",\"yearbased\":\"Year Based (YYYY-000001)\",\"year2digits\":\"Year 2 Digits (YY-000001)\",\"yearmonthnumber\":\"YYYY-MM-000001\",\"yearbasedright\":\"Year Right Based (000001-YYYY)\",\"year2digitsright\":\"Year 2 Digits Right (000001-YY)\",\"numbermonthyear\":\"000001-MM-YYYY\"}},\"tool_tip\":\"This will apply if the format is other than \'number\'\"},\"invoice-number-length\":{\"value\":\"5\",\"type\":\"number\",\"extra\":{\"total_options\":\"7\",\"options\":{\"numberbased\":\"Number Based (000001)\",\"yearbased\":\"Year Based (YYYY-000001)\",\"year2digits\":\"Year 2 Digits (YY-000001)\",\"yearmonthnumber\":\"YYYY-MM-000001\",\"yearbasedright\":\"Year Right Based (000001-YYYY)\",\"year2digitsright\":\"Year 2 Digits Right (000001-YY)\",\"numbermonthyear\":\"000001-MM-YYYY\"}},\"tool_tip\":\"Invoice number length. If it is greater than \\\"0\\\" system will fill the number with \\\"0\\\" based on length. Ex: if this value is 4 and the generated invoice number is 28, then system will display the invoice no. as \\\"0028\\\"\"},\"invoice-footer\":{\"value\":\"LARAOFFICE(CRM)\",\"type\":\"textarea\",\"extra\":{\"total_options\":\"7\",\"options\":{\"numberbased\":\"Number Based (000001)\",\"yearbased\":\"Year Based (YYYY-000001)\",\"year2digits\":\"Year 2 Digits (YY-000001)\",\"yearmonthnumber\":\"YYYY-MM-000001\",\"yearbasedright\":\"Year Right Based (000001-YYYY)\",\"year2digitsright\":\"Year 2 Digits Right (000001-YY)\",\"numbermonthyear\":\"000001-MM-YYYY\"}},\"tool_tip\":\"Invoice footer\"},\"invoice-footer-enable\":{\"value\":\"Yes\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Yes\":\"Yes\",\"No\":\"No\"}},\"tool_tip\":\"Invoice footer enable\"},\"default-account\":{\"value\":0,\"type\":\"select\",\"extra\":\"\",\"tool_tip\":\"Default account for payments\"},\"default-category\":{\"value\":0,\"type\":\"select\",\"extra\":\"\",\"tool_tip\":\"Default category\"},\"default-category-recurring\":{\"value\":0,\"type\":\"select\",\"extra\":\"\",\"tool_tip\":\"Default category for recurring invoice\"}}','2019-02-20 05:20:25','2019-09-30 13:30:21',NULL,'general','Active'),
(14,'Receipt Settings','receipt-settings','receipt-settings','Receipt Settings','{\"company-name\":{\"value\":\"LaraOffice - Ultimate CRM, Project Management, Accounting and Invoicing System.\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Company Name\"},\"address\":{\"value\":\"Plot No.16, 3rd Floor, Silicon Valley, Madhapur, Hitech city, Near Cyber Towers, Hyderabad \\u2013 500081, Telangana.\",\"type\":\"textarea\",\"extra\":\"\",\"tool_tip\":\"Address\"},\"phone\":{\"value\":\"9866211264\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Phone\"},\"email\":{\"value\":\"info@laraoffice.com\",\"type\":\"email\",\"extra\":\"\",\"tool_tip\":\"Email\"},\"receipt-logo\":{\"value\":\"QbT5pwRCXuPgzjS.png\",\"type\":\"file\",\"extra\":\"\",\"tool_tip\":\"Receipt logo\"}}','2019-02-22 10:28:37','2019-10-03 09:17:20',NULL,'general','Active'),
(15,'Order Settings','order-settings','order-settings','Order related Settings','{\"payment-record-max-time-minutes\":{\"value\":\"30\",\"type\":\"number\",\"extra\":\"\",\"tool_tip\":\"Payment Record Max Time in Minutes\"},\"add-to-income\":{\"value\":\"yes\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"yes\":\"Yes\",\"no\":\"No\"}},\"tool_tip\":\"Add Order payments to incomes\"},\"payment-success-order-status\":{\"value\":\"Active\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Pending\":\"Pending\",\"Active\":\"Active\"}},\"tool_tip\":\"payment-success-order-status\"},\"mark-generated-invoice-as\":{\"value\":\"Pending\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Paid\":\"Paid\",\"Pending\":\"Pending\"}},\"tool_tip\":\"Mark generated invoice as\"},\"default-account\":{\"value\":\"1\",\"type\":\"select\",\"extra\":\"\",\"tool_tip\":\"Default account for payments\"}}','2019-02-28 12:57:54','2019-09-25 09:03:50',NULL,'general','Active'),
(29,'Translations','translations','translations',NULL,'{\"api_key\":{\"value\":\"AIzaSyDoKNAWR3TU1j7KlfLmY8XfTHiwCP6jiVc\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Google API Key\"}}','2019-03-26 09:21:42','2019-08-26 08:58:54',NULL,'general','Active'),
(31,'Quote Settings','quote-settings','quote-settings','Quote Settings','{\"Company_Name_On_Quote\":{\"value\":\"LaraOffice - Ultimate CRM, Project Management, Accounting and Invoicing Systemr\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Company Name on Quote\"},\"Company-Address\":{\"value\":\"8929 Mchenry, IL 600502r\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Company Address\"},\"Authorized-Person\":{\"value\":\"Samson Sudhakar\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Authorized Person\"},\"Authorized-Person-Designation\":{\"value\":\"Business Owner\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Authorized Person Designation\"},\"Authorized-Person-Signature\":{\"value\":\"ft5H0TKzvrtgs5S.png\",\"type\":\"file\",\"extra\":\"\",\"tool_tip\":\"Authorized Person Signature\"},\"Quote-Logo\":{\"value\":\"36MPz6JNr0HhdcZ.png\",\"type\":\"file\",\"extra\":\"\",\"tool_tip\":\"Quote Logo\"},\"enable-signature-part\":{\"value\":\"Yes\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Yes\":\"Yes\",\"No\":\"No\"}},\"tool_tip\":\"enable-signature-part\"},\"quote-prefix\":{\"value\":\"QUO\",\"type\":\"text\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Yes\":\"Yes\",\"No\":\"No\"}},\"tool_tip\":\"Quote Number Prefix\"},\"quote_start\":{\"value\":\"0\",\"type\":\"number\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Yes\":\"Yes\",\"No\":\"No\"}},\"tool_tip\":\"Set this field to 1 if you want to start from beginning\"},\"quote_due_after\":{\"value\":\"30\",\"type\":\"text\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Yes\":\"Yes\",\"No\":\"No\"}},\"tool_tip\":\"Quote due after (days)\"},\"show_sale_agent_on_quote\":{\"value\":\"yes\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"yes\":\"Yes\",\"no\":\"No\"}},\"tool_tip\":\"Show Sale Agent On Quote\"},\"show_quantity_as\":{\"value\":\"Qnty\",\"type\":\"text\",\"extra\":{\"total_options\":\"2\",\"options\":{\"yes\":\"Yes\",\"no\":\"No\"}},\"tool_tip\":\"Show quantity as\"},\"predefined_clientnote_quote\":{\"value\":\"Most text editors like MS Word or Lotus Notes generate random lorem text when needed, either as pre-installed module or plug-in to be added. Word selection or sequence don\'t necessarily match the original, which is intended to add variety. Presentation software like Keynote or Pages use it as a samples for screenplay layout. Content management software as Joomla, Drupal, Mambo, PHP-Nuke, WordPress, or Movable Type offer Lorem Ipsum plug-ins with the same functionality.\",\"type\":\"textarea\",\"extra\":{\"total_options\":\"2\",\"options\":{\"yes\":\"Yes\",\"no\":\"No\"}},\"tool_tip\":\"Predefined Client Note\"},\"predefined_terms_quote\":{\"value\":\"If any provision of these Terms and Conditions is held to be invalid or unenforceable, the provision shall be removed (or interpreted, if possible, in a manner as to be enforceable), and the remaining provisions shall be enforced. Headings are for reference purposes only and in no way define, limit, construe or describe the scope or extent of such section. Our failure to act with respect to a breach by you or others does not waive our right to act with respect to subsequent or similar breaches. These Terms and Conditions set forth the entire understanding and agreement between us with respect to the subject matter contained herein and supersede any other agreement, proposals and communications, written or oral, between our representatives and you with respect to the subject matter hereof, including any terms and conditions on any of customer\'s documents or purchase orders.\",\"type\":\"textarea\",\"extra\":{\"total_options\":\"2\",\"options\":{\"yes\":\"Yes\",\"no\":\"No\"}},\"tool_tip\":\"Predefined Terms & Conditions\"},\"predefined_adminnote_quote\":{\"value\":\"Cicero famously orated against his political opponent Lucius Sergius Catilina. Occasionally the first Oration against Catiline is taken for type specimens: Quo usque tandem abutere, Catilina, patientia nostra? Quam diu etiam furor iste tuus nos eludet? (How long, O Catiline, will you abuse our patience? And for how long will that madness of yours mock us?)\",\"type\":\"textarea\",\"extra\":{\"total_options\":\"2\",\"options\":{\"yes\":\"Yes\",\"no\":\"No\"}},\"tool_tip\":\"Predefined Admin Note\"},\"quote-number-format\":{\"value\":\"yearbased\",\"type\":\"select\",\"extra\":{\"total_options\":\"7\",\"options\":{\"numberbased\":\"Number Based (000001)\",\"yearbased\":\"Year Based (YYYY-000001)\",\"year2digits\":\"Year 2 Digits (YY-000001)\",\"yearmonthnumber\":\"YYYY-MM-000001\",\"yearbasedright\":\"Year Right Based (000001-YYYY)\",\"year2digitsright\":\"Year 2 Digits Right (000001-YY)\",\"numbermonthyear\":\"000001-MM-YYYY\"}},\"tool_tip\":\"Quote Number Format\"},\"quote-number-separator\":{\"value\":\"\\/\",\"type\":\"text\",\"extra\":{\"total_options\":\"7\",\"options\":{\"numberbased\":\"Number Based (000001)\",\"yearbased\":\"Year Based (YYYY-000001)\",\"year2digits\":\"Year 2 Digits (YY-000001)\",\"yearmonthnumber\":\"YYYY-MM-000001\",\"yearbasedright\":\"Year Right Based (000001-YYYY)\",\"year2digitsright\":\"Year 2 Digits Right (000001-YY)\",\"numbermonthyear\":\"000001-MM-YYYY\"}},\"tool_tip\":\"This will apply if the format is other than \'number\'\"},\"quote-number-length\":{\"value\":\"5\",\"type\":\"number\",\"extra\":{\"total_options\":\"7\",\"options\":{\"numberbased\":\"Number Based (000001)\",\"yearbased\":\"Year Based (YYYY-000001)\",\"year2digits\":\"Year 2 Digits (YY-000001)\",\"yearmonthnumber\":\"YYYY-MM-000001\",\"yearbasedright\":\"Year Right Based (000001-YYYY)\",\"year2digitsright\":\"Year 2 Digits Right (000001-YY)\",\"numbermonthyear\":\"000001-MM-YYYY\"}},\"tool_tip\":\"Quote number length. If it is greater than \\\"0\\\" system will fill the number with \\\"0\\\" based on length. Ex: if this value is 4 and the generated quote number is 28, then system will display the quote no. as \\\"0028\\\"\"},\"quote-footer\":{\"value\":\"LARAOFFICE(CRM)\",\"type\":\"textarea\",\"extra\":{\"total_options\":\"7\",\"options\":{\"numberbased\":\"Number Based (000001)\",\"yearbased\":\"Year Based (YYYY-000001)\",\"year2digits\":\"Year 2 Digits (YY-000001)\",\"yearmonthnumber\":\"YYYY-MM-000001\",\"yearbasedright\":\"Year Right Based (000001-YYYY)\",\"year2digitsright\":\"Year 2 Digits Right (000001-YY)\",\"numbermonthyear\":\"000001-MM-YYYY\"}},\"tool_tip\":\"Quote footer\"},\"quote-footer-enable\":{\"value\":\"Yes\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Yes\":\"Yes\",\"No\":\"No\"}},\"tool_tip\":\"quote footer enable\"}}','2019-02-20 05:20:25','2019-09-30 13:31:31',NULL,'general','Active'),
(32,'Invoice Cron Job Settings','invoice-cronjob','invoice-cronjob','Invoice Cron Job Settings','{\"invoice_auto_operations_hour\":{\"value\":\"12\",\"type\":\"number\",\"extra\":\"\",\"tool_tip\":\"Hour of day to perform automatic operations\"},\"automatically_send_invoice_overdue_reminder_after\":{\"value\":\"1\",\"type\":\"number\",\"extra\":\"\",\"tool_tip\":\"Auto send reminder after (days)\"},\"automatically_resend_invoice_overdue_reminder_after\":{\"value\":\"1\",\"type\":\"number\",\"extra\":\"\",\"tool_tip\":\"Auto re-send reminder after (days)\"},\"new_recurring_invoice_action\":{\"value\":\"generate_and_send\",\"type\":\"select\",\"extra\":{\"total_options\":\"3\",\"options\":{\"generate_and_send\":\"Generate and autosend the renewed invoice to the customer\",\"generate_unpaid\":\"Generate a Unpaid Invoice\",\"new_recurring_invoice_action\":\"Generate a Draft Invoice\"}},\"tool_tip\":\"Recurring Invoices\"},\"create_invoice_from_recurring_only_on_paid_invoices\":{\"value\":\"yes\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"yes\":\"Yes\",\"no\":\"No\"}},\"tool_tip\":\"Create new invoice from recurring invoice only if the invoice is with status paid?\"},\"tasks_reminder_notification_before\":{\"value\":\"1\",\"type\":\"number\",\"extra\":{\"total_options\":\"2\",\"options\":{\"yes\":\"Yes\",\"no\":\"No\"}},\"tool_tip\":\"Tasks reminder notification before (In days)\"},\"enable_task_reminders\":{\"value\":\"yes\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"yes\":\"Yes\",\"no\":\"No\"}},\"tool_tip\":\"Enable task reminders?\"},\"enable_general_reminders\":{\"value\":\"yes\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"yes\":\"Yes\",\"no\":\"No\"}},\"tool_tip\":\"Enable Reminders\"}}','2019-04-25 13:45:00','2019-09-24 04:48:58',NULL,'general','Active'),
(33,'Quote Cron Job Settings','quote-cronjob','quote-cronjob',NULL,'{\n \"quotes_auto_operations_hour\": {\n    \"value\": \"12\",\n    \"type\": \"number\",\n   \"extra\": \"\",\n    \"tool_tip\": \"24 hours format eq. 8 for 8AM or 19 for 5PM.\"\n  },\n  \"send_quote_expiry_reminder_before\": {\n    \"value\": \"1\",\n   \"type\": \"number\",\n   \"extra\": \"\",\n    \"tool_tip\": \"Send expiration reminder before (DAYS)\"\n  },\n  \"tasks_reminder_notification_before\": {\n   \"value\": \"1\",\n   \"type\": \"number\",\n   \"extra\": \"\",\n    \"tool_tip\": \"Tasks reminder notification before in days\"\n  },\n  \"enable_task_reminders\": {\n    \"value\": \"yes\",\n   \"type\": \"select\",\n   \"extra\": {\n      \"total_options\": \"2\",\n     \"options\": {\n        \"yes\": \"Yes\",\n       \"no\": \"No\"\n      }\n   },\n    \"tool_tip\": \"Enable task reminders\"\n },\n  \"enable_general_reminders\": {\n   \"value\": \"yes\",\n   \"type\": \"select\",\n   \"extra\": {\n      \"total_options\": \"2\",\n     \"options\": {\n        \"yes\": \"Yes\",\n       \"no\": \"No\"\n      }\n   },\n    \"tool_tip\": \"Enable general reminders\"\n  }\n}','2019-04-26 05:28:43','2019-06-04 08:31:13',NULL,'general','Active'),
(35,'Login Settings','login-settings','login-settings','Login Setting','{\"carousel_one\":{\"value\":\"2dtt8vg1Y6DGA71.jpg\",\"type\":\"file\",\"extra\":\"\",\"tool_tip\":null},\"carousel_two\":{\"value\":\"GJHqMWiigxChRbX.jpg\",\"type\":\"file\",\"extra\":\"\",\"tool_tip\":null},\"carousel_three\":{\"value\":\"J8jfMlQcUgoyOf7.jpg\",\"type\":\"file\",\"extra\":\"\",\"tool_tip\":null},\"carousel_head_one\":{\"value\":\"Email marketing software that drives sales\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":null},\"carousel_para_one\":{\"value\":\"Create, send, and track email campaigns that help you build a strong customer base. Digi Accounting Campaigns has it all.\",\"type\":\"textarea\",\"extra\":\"\",\"tool_tip\":null},\"carousel_head_two\":{\"value\":\"Email marketing software that drives sales.\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":null},\"carousel_para_two\":{\"value\":\"Create, send, and track email campaigns that help you build a strong customer base. Digi Accounting Campaigns has it all. carousel_para_two\",\"type\":\"textarea\",\"extra\":\"\",\"tool_tip\":null},\"carousel_head_three\":{\"value\":\"Email marketing software that drives sales. carousel_head_three\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":null},\"login_logo\":{\"value\":\"ZgV2kIOA4eWN4R2.png\",\"type\":\"file\",\"extra\":\"\",\"tool_tip\":null},\"login_logo_enable\":{\"value\":\"Yes\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Yes\":\"Yes\",\"No\":\"No\"}},\"tool_tip\":null}}','2019-05-07 12:36:38','2019-09-27 08:04:25',NULL,'general','Active'),
(37,'Purchase Orders Settings','purchase-orders-settings','purchase-orders-settings','Purchase Orders Invoice Settings','{\"Company_Name_On_Po\":{\"value\":\"LaraOffice - Ultimate CRM Project\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Company Name On Purchase Orders\"},\"Company_Address\":{\"value\":\"8929 Mchenry\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Company Address\"},\"Authorized_Person\":{\"value\":\"Samson Sudhakar P\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Authorized Person\"},\"Authorized_Person_Designation\":{\"value\":\"Business Owner\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Authorized Person Designation\"},\"Authorized_Person_Signature\":{\"value\":\"0qklBDxXycKC7jq.png\",\"type\":\"file\",\"extra\":\"\",\"tool_tip\":\"Authorized Person Signature\"},\"Po_Logo\":{\"value\":\"rdsT9tnHMNOSFD6.png\",\"type\":\"file\",\"extra\":\"\",\"tool_tip\":\"Purchase Orders Logo\"},\"enable_signature_part\":{\"value\":\"No\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Yes\":\"Yes\",\"No\":\"No\"}},\"tool_tip\":\"Enable Signature Part\"},\"Po_Number_Prefix\":{\"value\":\"PO\",\"type\":\"text\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Yes\":\"Yes\",\"No\":\"No\"}},\"tool_tip\":\"Purchase Order Number Prefix\"},\"Po_Start\":{\"value\":\"0\",\"type\":\"number\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Yes\":\"Yes\",\"No\":\"No\"}},\"tool_tip\":\"Purchase Orders Start\"},\"show_quantity_as\":{\"value\":\"Quantity\",\"type\":\"text\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Yes\":\"Yes\",\"No\":\"No\"}},\"tool_tip\":\"Show quantity as\"},\"predefined_notes\":{\"value\":\"Any provision of these Terms and Conditions is held to be invalid or unenforceable, the provision shall be removed (or interpreted, if possible, in a manner as to be enforceable), and the remaining provisions shall be enforced. Headings are for reference purposes only and in no way define, limit, construe or describe the scope or extent of such section. Our failure to act with respect to a breach by you or others does not waive our right to act with respect to subsequent or similar breaches. These Terms and Conditions set forth the entire understanding and agreement between us with respect to the subject matter contained herein and supersede any other agreement, proposals and communications, written or oral, between our representatives and you with respect to the subject matter hereof, including any terms and conditions on any of customer\'s documents or purchase orders.\",\"type\":\"textarea\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Yes\":\"Yes\",\"No\":\"No\"}},\"tool_tip\":\"Pre-defined notes\"},\"po-number-format\":{\"value\":\"year2digitsright\",\"type\":\"select\",\"extra\":{\"total_options\":\"7\",\"options\":{\"numberbased\":\"Number Based (000001)\",\"yearbased\":\"Year Based (YYYY-000001)\",\"year2digits\":\"Year 2 Digits (YY-000001)\",\"yearmonthnumber\":\"YYYY-MM-000001\",\"yearbasedright\":\"Year Right Based (000001-YYYY)\",\"year2digitsright\":\"Year 2 Digits Right (000001-YY)\",\"numbermonthyear\":\"000001-MM-YYYY\"}},\"tool_tip\":\"Purchase Order Number Format\"},\"po-number-separator\":{\"value\":\"-\",\"type\":\"text\",\"extra\":{\"total_options\":\"7\",\"options\":{\"numberbased\":\"Number Based (000001)\",\"yearbased\":\"Year Based (YYYY-000001)\",\"year2digits\":\"Year 2 Digits (YY-000001)\",\"yearmonthnumber\":\"YYYY-MM-000001\",\"yearbasedright\":\"Year Right Based (000001-YYYY)\",\"year2digitsright\":\"Year 2 Digits Right (000001-YY)\",\"numbermonthyear\":\"000001-MM-YYYY\"}},\"tool_tip\":\"This will apply if the format is other than \'number\'\"},\"po-number-length\":{\"value\":\"2\",\"type\":\"number\",\"extra\":{\"total_options\":\"7\",\"options\":{\"numberbased\":\"Number Based (000001)\",\"yearbased\":\"Year Based (YYYY-000001)\",\"year2digits\":\"Year 2 Digits (YY-000001)\",\"yearmonthnumber\":\"YYYY-MM-000001\",\"yearbasedright\":\"Year Right Based (000001-YYYY)\",\"year2digitsright\":\"Year 2 Digits Right (000001-YY)\",\"numbermonthyear\":\"000001-MM-YYYY\"}},\"tool_tip\":\"Purchase order number length. If it is greater than \\\"0\\\" system will fill the number with \\\"0\\\" based on length. Ex: if this value is 4 and the generated purchase order number is 28, then system will display the purchase order no. as \\\"0028\\\"\"},\"add-to-expense-purchase-order\":{\"value\":\"Yes\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Yes\":\"Yes\",\"No\":\"No\"}},\"tool_tip\":\"Add to expense purchase order\"},\"po-footer\":{\"value\":\"LARAOFFICE(CRM)\",\"type\":\"textarea\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Yes\":\"Yes\",\"No\":\"No\"}},\"tool_tip\":\"Purchase order footer\"},\"po-footer-enable\":{\"value\":\"Yes\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Yes\":\"Yes\",\"No\":\"No\"}},\"tool_tip\":\"Purchase order footer enable\"},\"default-account\":{\"type\":\"select\",\"value\":\"Yes\",\"extra\":{\"total_options\":\"1\",\"options\":{\"Yes\":\"Paid\"}},\"tool_tip\":\"When your paying to a supplier amount will be deducted from this account\"}}','2019-05-24 06:18:11','2019-10-03 08:17:59',NULL,'general','Active'),
(38,'Mailchimp Settings','mailchimp-settings','mailchimp-settings','Mailchimp Settings','{\"enable_mailchimp\":{\"value\":\"Yes\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Yes\":\"Yes\",\"No\":\"No\"}},\"tool_tip\":\"Enable mailchimp?\"},\"mailchimp_api_key\":{\"value\":\"2d170d64780e8beebb2fb2351cf0981a-us2\",\"type\":\"text\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Yes\":\"Yes\",\"No\":\"No\"}},\"tool_tip\":\"Mailchimp API Key\"},\"default-mailchimplist-admin\":{\"value\":0,\"type\":\"select\",\"extra\":\"\",\"tool_tip\":\"Default mailchimp list for: <i> Administrator (can create other users)<\\/i>\"},\"default-mailchimplist-customer\":{\"value\":\"9d241c177b\",\"type\":\"select\",\"extra\":\"\",\"tool_tip\":\"Default mailchimp list for: <i> Customer<\\/i>\"},\"default-mailchimplist-businessmanager\":{\"value\":0,\"type\":\"select\",\"extra\":\"\",\"tool_tip\":\"Default mailchimp list for: <i> Business Manager<\\/i>\"},\"default-mailchimplist-salesmanager\":{\"value\":0,\"type\":\"select\",\"extra\":\"\",\"tool_tip\":\"Default mailchimp list for: <i> Sales Manager<\\/i>\"},\"default-mailchimplist-salesperson\":{\"value\":\"9d241c177b\",\"type\":\"select\",\"extra\":\"\",\"tool_tip\":\"Default mailchimp list for: <i> Sale Agent<\\/i>\"},\"default-mailchimplist-projectmanager\":{\"value\":0,\"type\":\"select\",\"extra\":\"\",\"tool_tip\":\"Default mailchimp list for: <i> Project Manager<\\/i>\"},\"default-mailchimplist-stockmanager\":{\"value\":0,\"type\":\"select\",\"extra\":\"\",\"tool_tip\":\"Default mailchimp list for: <i> Stock Manager<\\/i>\"},\"default-mailchimplist-supplier\":{\"value\":\"9d241c177b\",\"type\":\"select\",\"extra\":\"\",\"tool_tip\":\"Default mailchimp list for: <i> Supplier<\\/i>\"},\"default-mailchimplist-client\":{\"value\":0,\"type\":\"select\",\"extra\":\"\",\"tool_tip\":\"Default mailchimp list for: <i> Client<\\/i>\"},\"default-mailchimplist-leads\":{\"value\":0,\"type\":\"select\",\"extra\":\"\",\"tool_tip\":\"Default mailchimp list for: <i> Lead<\\/i>\"},\"default-mailchimplist-employee\":{\"value\":0,\"type\":\"select\",\"extra\":\"\",\"tool_tip\":\"Default mailchimp list for: <i> Employee<\\/i>\"},\"default-mailchimplist-\":{\"value\":0,\"type\":\"select\",\"extra\":\"\",\"tool_tip\":\"Default mailchimp list for: <i> Test<\\/i>\"}}','2019-02-04 06:23:27','2019-10-01 06:40:25',NULL,'general','Active'),
(39,'Order Cron Job Settings','order-cronjob','order-cronjob',NULL,'{\"invoice_auto_operations_hour\":{\"value\":\"12\",\"type\":\"number\",\"extra\":\"\",\"tool_tip\":\"Hour of day to perform automatic operations\"},\"automatically_send_invoice_overdue_reminder_after\":{\"value\":\"1\",\"type\":\"number\",\"extra\":\"\",\"tool_tip\":\"Auto send reminder after (days)\"},\"automatically_resend_invoice_overdue_reminder_after\":{\"value\":\"1\",\"type\":\"number\",\"extra\":\"\",\"tool_tip\":\"Auto re-send reminder after (days)\"},\"create_neworder_from_only_on_paid_orders\":{\"value\":\"yes\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"yes\":\"Yes\",\"no\":\"No\"}},\"tool_tip\":\"Create new order from recurring order only if the order is with status paid?\"},\"generate_invoice\":{\"value\":\"no\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"yes\":\"Yes\",\"no\":\"No\"}},\"tool_tip\":\"Generate invoice while genearting new order?\"},\"new_invoice_action\":{\"value\":\"generate_and_send\",\"type\":\"select\",\"extra\":{\"total_options\":\"3\",\"options\":{\"generate_and_send\":\"Generate and autosend the generated invoice to the customer\",\"generate_unpaid\":\"Generate a Unpaid Invoice\",\"generate_draft_invoice\":\"Generate a Draft Invoice\"}},\"tool_tip\":\"Recurring Invoices\"}}','0000-00-00 00:00:00','2019-08-26 06:15:14',NULL,'general','Active'),
(41,'Contract Settings','contract-settings','contract-settings','Contract Settings','{\"Company_Name_On_Contract\":{\"value\":\"LaraOffice - Ultimate CRM, Project Management, Accounting and Invoicing System\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Company Name on Contract\"},\"Company-Address\":{\"value\":\"8929 Mchenry, IL 600502\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Company Address\"},\"Authorized-Person\":{\"value\":\"Samson Sudhakar\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Authorized Person\"},\"Authorized-Person-Designation\":{\"value\":\"Business Owner\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Authorized Person Designation\"},\"Authorized-Person-Signature\":{\"value\":\"ft5H0TKzvrtgs5S.png\",\"type\":\"file\",\"extra\":\"\",\"tool_tip\":\"Authorized Person Signature\"},\"Contract-Logo\":{\"value\":\"C8LikyuS9D8IHj5.png\",\"type\":\"file\",\"extra\":\"\",\"tool_tip\":\"Contract Logo\"},\"enable-signature-part\":{\"value\":\"Yes\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Yes\":\"Yes\",\"No\":\"No\"}},\"tool_tip\":\"enable-signature-part\"},\"contract-prefix\":{\"value\":\"CON\",\"type\":\"text\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Yes\":\"Yes\",\"No\":\"No\"}},\"tool_tip\":\"Contract Number Prefix\"},\"contract_start\":{\"value\":\"0\",\"type\":\"number\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Yes\":\"Yes\",\"No\":\"No\"}},\"tool_tip\":\"Set this field to 1 if you want to start from beginning\"},\"contract_due_after\":{\"value\":\"30\",\"type\":\"text\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Yes\":\"Yes\",\"No\":\"No\"}},\"tool_tip\":\"Contract due after (days)\"},\"show_sale_agent_on_contract\":{\"value\":\"yes\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"yes\":\"Yes\",\"no\":\"No\"}},\"tool_tip\":\"Show Sale Agent On Contract\"},\"show_quantity_as\":{\"value\":\"Qnty\",\"type\":\"text\",\"extra\":{\"total_options\":\"2\",\"options\":{\"yes\":\"Yes\",\"no\":\"No\"}},\"tool_tip\":\"Show quantity as\"},\"predefined_clientnote_contract\":{\"value\":\"Most text editors like MS Word or Lotus Notes generate random lorem text when needed, either as pre-installed module or plug-in to be added. Word selection or sequence don\'t necessarily match the original, which is intended to add variety. Presentation software like Keynote or Pages use it as a samples for screenplay layout. Content management software as Joomla, Drupal, Mambo, PHP-Nuke, WordPress, or Movable Type offer Lorem Ipsum plug-ins with the same functionality.\",\"type\":\"textarea\",\"extra\":{\"total_options\":\"2\",\"options\":{\"yes\":\"Yes\",\"no\":\"No\"}},\"tool_tip\":\"Predefined Client Note\"},\"predefined_terms_contract\":{\"value\":\"If any provision of these Terms and Conditions is held to be invalid or unenforceable, the provision shall be removed (or interpreted, if possible, in a manner as to be enforceable), and the remaining provisions shall be enforced. Headings are for reference purposes only and in no way define, limit, construe or describe the scope or extent of such section. Our failure to act with respect to a breach by you or others does not waive our right to act with respect to subsequent or similar breaches. These Terms and Conditions set forth the entire understanding and agreement between us with respect to the subject matter contained herein and supersede any other agreement, proposals and communications, written or oral, between our representatives and you with respect to the subject matter hereof, including any terms and conditions on any of customer\'s documents or purchase orders.\",\"type\":\"textarea\",\"extra\":{\"total_options\":\"2\",\"options\":{\"yes\":\"Yes\",\"no\":\"No\"}},\"tool_tip\":\"Predefined Terms & Conditions\"},\"predefined_adminnote_contract\":{\"value\":\"Cicero famously orated against his political opponent Lucius Sergius Catilina. Occasionally the first Oration against Catiline is taken for type specimens: Quo usque tandem abutere, Catilina, patientia nostra? Quam diu etiam furor iste tuus nos eludet? (How long, O Catiline, will you abuse our patience? And for how long will that madness of yours mock us?)\",\"type\":\"textarea\",\"extra\":{\"total_options\":\"2\",\"options\":{\"yes\":\"Yes\",\"no\":\"No\"}},\"tool_tip\":\"Predefined Admin Note\"},\"contract-number-format\":{\"value\":\"yearmonthnumber\",\"type\":\"select\",\"extra\":{\"total_options\":\"7\",\"options\":{\"numberbased\":\"Number Based (000001)\",\"yearbased\":\"Year Based (YYYY-000001)\",\"year2digits\":\"Year 2 Digits (YY-000001)\",\"yearmonthnumber\":\"YYYY-MM-000001\",\"yearbasedright\":\"Year Right Based (000001-YYYY)\",\"year2digitsright\":\"Year 2 Digits Right (000001-YY)\",\"numbermonthyear\":\"000001-MM-YYYY\"}},\"tool_tip\":\"Contract Number Format\"},\"contract-number-separator\":{\"value\":\"\\/\",\"type\":\"text\",\"extra\":{\"total_options\":\"7\",\"options\":{\"numberbased\":\"Number Based (000001)\",\"yearbased\":\"Year Based (YYYY-000001)\",\"year2digits\":\"Year 2 Digits (YY-000001)\",\"yearmonthnumber\":\"YYYY-MM-000001\",\"yearbasedright\":\"Year Right Based (000001-YYYY)\",\"year2digitsright\":\"Year 2 Digits Right (000001-YY)\",\"numbermonthyear\":\"000001-MM-YYYY\"}},\"tool_tip\":\"This will apply if the format is other than \'number\'\"},\"contract-number-length\":{\"value\":\"5\",\"type\":\"number\",\"extra\":{\"total_options\":\"7\",\"options\":{\"numberbased\":\"Number Based (000001)\",\"yearbased\":\"Year Based (YYYY-000001)\",\"year2digits\":\"Year 2 Digits (YY-000001)\",\"yearmonthnumber\":\"YYYY-MM-000001\",\"yearbasedright\":\"Year Right Based (000001-YYYY)\",\"year2digitsright\":\"Year 2 Digits Right (000001-YY)\",\"numbermonthyear\":\"000001-MM-YYYY\"}},\"tool_tip\":\"Contract number length. If it is greater than \\\"0\\\" system will fill the number with \\\"0\\\" based on length. Ex: if this value is 4 and the generated contract number is 28, then system will display the contract no. as \\\"0028\\\"\"},\"contract-footer\":{\"value\":\"LARAOFFICE(CRM)\",\"type\":\"textarea\",\"extra\":{\"total_options\":\"7\",\"options\":{\"numberbased\":\"Number Based (000001)\",\"yearbased\":\"Year Based (YYYY-000001)\",\"year2digits\":\"Year 2 Digits (YY-000001)\",\"yearmonthnumber\":\"YYYY-MM-000001\",\"yearbasedright\":\"Year Right Based (000001-YYYY)\",\"year2digitsright\":\"Year 2 Digits Right (000001-YY)\",\"numbermonthyear\":\"000001-MM-YYYY\"}},\"tool_tip\":\"Contract footer\"},\"contract-footer-enable\":{\"value\":\"Yes\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Yes\":\"Yes\",\"No\":\"No\"}},\"tool_tip\":\"contract footer enable\"}}','2019-09-12 04:26:36','2019-09-30 13:32:21',NULL,'general','Active'),
(42,'Proposal Settings','proposal-settings','proposal-settings','Proposal Settings','{\"Company_Name_On_Proposal\":{\"value\":\"LaraOffice - Ultimate CRM, Project Management, Accounting and Invoicing System\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Company Name on Proposal\"},\"Company-Address\":{\"value\":\"8929 Mchenry, IL 600502\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Company Address\"},\"Authorized-Person\":{\"value\":\"Samson Sudhakar\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Authorized Person\"},\"Authorized-Person-Designation\":{\"value\":\"Business Owner\",\"type\":\"text\",\"extra\":\"\",\"tool_tip\":\"Authorized Person Designation\"},\"Authorized-Person-Signature\":{\"value\":\"ft5H0TKzvrtgs5S.png\",\"type\":\"file\",\"extra\":\"\",\"tool_tip\":\"Authorized Person Signature\"},\"Proposal-Logo\":{\"value\":\"eeFNN5LykoHwm9m.png\",\"type\":\"file\",\"extra\":\"\",\"tool_tip\":\"Proposal Logo\"},\"enable-signature-part\":{\"value\":\"Yes\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Yes\":\"Yes\",\"No\":\"No\"}},\"tool_tip\":\"enable-signature-part\"},\"proposal-prefix\":{\"value\":\"PRO\",\"type\":\"text\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Yes\":\"Yes\",\"No\":\"No\"}},\"tool_tip\":\"Proposal Number Prefix\"},\"proposal_start\":{\"value\":\"0\",\"type\":\"number\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Yes\":\"Yes\",\"No\":\"No\"}},\"tool_tip\":\"Set this field to 1 if you want to start from beginning\"},\"proposal_due_after\":{\"value\":\"30\",\"type\":\"text\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Yes\":\"Yes\",\"No\":\"No\"}},\"tool_tip\":\"Proposal due after (days)\"},\"show_sale_agent_on_proposal\":{\"value\":\"yes\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"yes\":\"Yes\",\"no\":\"No\"}},\"tool_tip\":\"Show Sale Agent On Proposal\"},\"show_quantity_as\":{\"value\":\"Qnty\",\"type\":\"text\",\"extra\":{\"total_options\":\"2\",\"options\":{\"yes\":\"Yes\",\"no\":\"No\"}},\"tool_tip\":\"Show quantity as\"},\"predefined_clientnote_proposal\":{\"value\":\"Most text editors like MS Word or Lotus Notes generate random lorem text when needed, either as pre-installed module or plug-in to be added. Word selection or sequence don\'t necessarily match the original, which is intended to add variety. Presentation software like Keynote or Pages use it as a samples for screenplay layout. Content management software as Joomla, Drupal, Mambo, PHP-Nuke, WordPress, or Movable Type offer Lorem Ipsum plug-ins with the same functionality.\",\"type\":\"textarea\",\"extra\":{\"total_options\":\"2\",\"options\":{\"yes\":\"Yes\",\"no\":\"No\"}},\"tool_tip\":\"Predefined Client Note\"},\"predefined_terms_proposal\":{\"value\":\"If any provision of these Terms and Conditions is held to be invalid or unenforceable, the provision shall be removed (or interpreted, if possible, in a manner as to be enforceable), and the remaining provisions shall be enforced. Headings are for reference purposes only and in no way define, limit, construe or describe the scope or extent of such section. Our failure to act with respect to a breach by you or others does not waive our right to act with respect to subsequent or similar breaches. These Terms and Conditions set forth the entire understanding and agreement between us with respect to the subject matter contained herein and supersede any other agreement, proposals and communications, written or oral, between our representatives and you with respect to the subject matter hereof, including any terms and conditions on any of customer\'s documents or purchase orders.\",\"type\":\"textarea\",\"extra\":{\"total_options\":\"2\",\"options\":{\"yes\":\"Yes\",\"no\":\"No\"}},\"tool_tip\":\"Predefined Terms & Conditions\"},\"predefined_adminnote_proposal\":{\"value\":\"Cicero famously orated against his political opponent Lucius Sergius Catilina. Occasionally the first Oration against Catiline is taken for type specimens: Quo usque tandem abutere, Catilina, patientia nostra? Quam diu etiam furor iste tuus nos eludet? (How long, O Catiline, will you abuse our patience? And for how long will that madness of yours mock us?)\",\"type\":\"textarea\",\"extra\":{\"total_options\":\"2\",\"options\":{\"yes\":\"Yes\",\"no\":\"No\"}},\"tool_tip\":\"Predefined Admin Note\"},\"proposal-number-format\":{\"value\":\"yearbased\",\"type\":\"select\",\"extra\":{\"total_options\":\"7\",\"options\":{\"numberbased\":\"Number Based (000001)\",\"yearbased\":\"Year Based (YYYY-000001)\",\"year2digits\":\"Year 2 Digits (YY-000001)\",\"yearmonthnumber\":\"YYYY-MM-000001\",\"yearbasedright\":\"Year Right Based (000001-YYYY)\",\"year2digitsright\":\"Year 2 Digits Right (000001-YY)\",\"numbermonthyear\":\"000001-MM-YYYY\"}},\"tool_tip\":\"Proposal Number Format\"},\"proposal-number-separator\":{\"value\":\"\\/\",\"type\":\"text\",\"extra\":{\"total_options\":\"7\",\"options\":{\"numberbased\":\"Number Based (000001)\",\"yearbased\":\"Year Based (YYYY-000001)\",\"year2digits\":\"Year 2 Digits (YY-000001)\",\"yearmonthnumber\":\"YYYY-MM-000001\",\"yearbasedright\":\"Year Right Based (000001-YYYY)\",\"year2digitsright\":\"Year 2 Digits Right (000001-YY)\",\"numbermonthyear\":\"000001-MM-YYYY\"}},\"tool_tip\":\"This will apply if the format is other than \'number\'\"},\"proposal-number-length\":{\"value\":\"5\",\"type\":\"number\",\"extra\":{\"total_options\":\"7\",\"options\":{\"numberbased\":\"Number Based (000001)\",\"yearbased\":\"Year Based (YYYY-000001)\",\"year2digits\":\"Year 2 Digits (YY-000001)\",\"yearmonthnumber\":\"YYYY-MM-000001\",\"yearbasedright\":\"Year Right Based (000001-YYYY)\",\"year2digitsright\":\"Year 2 Digits Right (000001-YY)\",\"numbermonthyear\":\"000001-MM-YYYY\"}},\"tool_tip\":\"Proposal number length. If it is greater than \\\"0\\\" system will fill the number with \\\"0\\\" based on length. Ex: if this value is 4 and the generated proposal number is 28, then system will display the proposal no. as \\\"0028\\\"\"},\"proposal-footer\":{\"value\":\"LARAOFFICE(CRM)\",\"type\":\"textarea\",\"extra\":{\"total_options\":\"7\",\"options\":{\"numberbased\":\"Number Based (000001)\",\"yearbased\":\"Year Based (YYYY-000001)\",\"year2digits\":\"Year 2 Digits (YY-000001)\",\"yearmonthnumber\":\"YYYY-MM-000001\",\"yearbasedright\":\"Year Right Based (000001-YYYY)\",\"year2digitsright\":\"Year 2 Digits Right (000001-YY)\",\"numbermonthyear\":\"000001-MM-YYYY\"}},\"tool_tip\":\"Proposal footer\"},\"proposal-footer-enable\":{\"value\":\"Yes\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Yes\":\"Yes\",\"No\":\"No\"}},\"tool_tip\":\"proposal footer enable\"}}','2019-09-13 05:28:23','2019-10-10 06:20:32',NULL,'general','Active'),
(43,'Proposal Cron Job Settings','proposal-cronjob','proposal-cronjob',NULL,'{\"proposals_auto_operations_hour\":{\"value\":\"12\",\"type\":\"number\",\"extra\":\"\",\"tool_tip\":\"24 hours format eq. 8 for 8AM or 19 for 5PM.\"},\"send_proposal_expiry_reminder_before\":{\"value\":\"1\",\"type\":\"number\",\"extra\":\"\",\"tool_tip\":\"Send expiration reminder before (DAYS)\"},\"tasks_reminder_notification_before\":{\"value\":\"1\",\"type\":\"number\",\"extra\":\"\",\"tool_tip\":\"Tasks reminder notification before in days\"},\"enable_task_reminders\":{\"value\":\"yes\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"yes\":\"Yes\",\"no\":\"No\"}},\"tool_tip\":\"Enable task reminders\"},\"enable_general_reminders\":{\"value\":\"yes\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"yes\":\"Yes\",\"no\":\"No\"}},\"tool_tip\":\"Enable general reminders\"}}','2019-09-14 04:05:50','2019-10-05 04:42:00',NULL,'general','Active');
/*Table structure for table `acrm_measurement_units` */

DROP TABLE IF EXISTS `acrm_measurement_units`;

CREATE TABLE `acrm_measurement_units` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('Active','Inactive') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `measurement_units_deleted_at_index` (`deleted_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_measurement_units` */

/*Table structure for table `acrm_media` */

DROP TABLE IF EXISTS `acrm_media`;

CREATE TABLE `acrm_media` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `model_id` bigint(20) unsigned DEFAULT NULL,
  `collection_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `disk` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` int(10) unsigned NOT NULL,
  `manipulations` text NOT NULL,
  `custom_properties` text NOT NULL,
  `responsive_images` text NOT NULL,
  `order_column` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_model_type_model_id_index` (`model_type`,`model_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_media` */

/*Table structure for table `acrm_messenger_messages` */

DROP TABLE IF EXISTS `acrm_messenger_messages`;

CREATE TABLE `acrm_messenger_messages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `topic_id` int(10) unsigned NOT NULL,
  `sender_id` int(11) NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `sent_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `messenger_messages_topic_id_foreign` (`topic_id`),
  CONSTRAINT `messenger_messages_topic_id_foreign` FOREIGN KEY (`topic_id`) REFERENCES `acrm_messenger_topics` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_messenger_messages` */

/*Table structure for table `acrm_messenger_topics` */

DROP TABLE IF EXISTS `acrm_messenger_topics`;

CREATE TABLE `acrm_messenger_topics` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `subject` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sender_id` int(11) NOT NULL,
  `receiver_id` int(11) NOT NULL,
  `sent_at` timestamp NULL DEFAULT NULL,
  `sender_read_at` timestamp NULL DEFAULT NULL,
  `receiver_read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_messenger_topics` */

/*Table structure for table `acrm_migrations` */

DROP TABLE IF EXISTS `acrm_migrations`;

CREATE TABLE `acrm_migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=270 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_migrations` */

insert  into `acrm_migrations`(`id`,`migration`,`batch`) values 
(1,'2014_10_12_000000_create_users_table',1),
(2,'2014_10_12_100000_create_password_resets_table',1),
(3,'2019_01_29_061110_create_1548735070_permissions_table',1),
(4,'2019_01_29_061114_create_1548735074_roles_table',1),
(5,'2019_01_29_061118_create_5c4fd266c9938_permission_role_table',1),
(6,'2019_01_29_061119_create_1548735079_users_table',1),
(7,'2019_01_29_061123_create_5c4fd26c5ac88_role_user_table',1),
(8,'2019_01_29_061209_create_1548735128_user_actions_table',1),
(9,'2019_01_29_061210_add_5c4fd29cef77e_relationships_to_useraction_table',1),
(10,'2019_01_29_061409_create_1548735249_contact_companies_table',1),
(11,'2019_01_29_061413_create_1548735252_contacts_table',1),
(12,'2019_01_29_061414_add_5c4fd3188dee7_relationships_to_contact_table',1),
(13,'2019_01_29_061849_create_1548735529_expense_categories_table',1),
(14,'2019_01_29_061852_create_1548735532_income_categories_table',1),
(15,'2019_01_29_061856_create_1548735535_incomes_table',1),
(16,'2019_01_29_061857_add_5c4fd43353a6e_relationships_to_income_table',1),
(17,'2019_01_29_061901_create_1548735540_expenses_table',1),
(18,'2019_01_29_061902_add_5c4fd438338b8_relationships_to_expense_table',1),
(19,'2019_01_29_061948_create_1548735588_faq_categories_table',1),
(20,'2019_01_29_061953_create_1548735592_faq_questions_table',1),
(21,'2019_01_29_061954_add_5c4fd46cc843b_relationships_to_faqquestion_table',1),
(22,'2019_01_29_063314_create_1548736394_internal_notifications_table',1),
(23,'2019_01_29_063318_create_5c4fd78fc5dbc_internal_notification_user_table',1),
(24,'2019_01_29_063348_create_messenger_topics_table',1),
(25,'2019_01_29_063349_create_messenger_messages_table',1),
(26,'2019_01_29_063430_create_1548736470_task_statuses_table',1),
(27,'2019_01_29_063436_create_1548736476_task_tags_table',1),
(28,'2019_01_29_063442_create_1548736481_tasks_table',1),
(29,'2019_01_29_063443_add_5c4fd7e7a8338_relationships_to_task_table',1),
(30,'2019_01_29_063446_create_5c4fd7e7a4f04_task_task_tag_table',1),
(31,'2019_01_29_063543_create_1548736543_content_categories_table',1),
(32,'2019_01_29_063549_create_1548736549_content_tags_table',1),
(33,'2019_01_29_063554_create_1548736554_content_pages_table',1),
(34,'2019_01_29_063558_create_5c4fd82ff2aaf_content_category_content_page_table',1),
(35,'2019_01_29_063559_create_5c4fd83002b34_content_page_content_tag_table',1),
(36,'2019_01_29_063656_create_1548736616_product_categories_table',1),
(37,'2019_01_29_063704_create_1548736624_product_tags_table',1),
(38,'2019_01_29_063709_create_1548736629_products_table',1),
(39,'2019_01_29_063713_create_5c4fd87b37502_product_product_category_table',1),
(40,'2019_01_29_063714_create_5c4fd87b3b086_product_product_tag_table',1),
(41,'2019_01_29_064113_create_1548736873_assets_categories_table',1),
(42,'2019_01_29_064119_create_1548736879_assets_statuses_table',1),
(43,'2019_01_29_064124_create_1548736884_assets_locations_table',1),
(44,'2019_01_29_064130_create_1548736889_assets_table',1),
(45,'2019_01_29_064131_add_5c4fd97e6d8d1_relationships_to_asset_table',1),
(46,'2019_01_29_064141_create_1548736900_assets_histories_table',1),
(47,'2019_01_29_064142_add_5c4fd9883abd7_relationships_to_assetshistory_table',1),
(48,'2019_01_29_064251_create_1548736971_coupon_campaigns_table',1),
(49,'2019_01_29_064259_create_1548736978_coupons_table',1),
(50,'2019_01_29_064300_add_5c4fd9d6ccc90_relationships_to_coupon_table',1),
(51,'2019_01_29_065055_create_1548737455_expense_types_table',1),
(52,'2019_01_29_065639_create_1548737799_currencies_table',1),
(53,'2019_01_29_065906_create_1548737946_sales_taxes_table',1),
(55,'2019_01_29_070423_create_1548738263_companies_table',1),
(56,'2019_01_29_070707_create_1548738427_accounts_table',1),
(57,'2019_01_29_070914_create_1548738554_payment_gateways_table',1),
(58,'2019_01_29_071125_create_1548738685_warehouses_table',1),
(59,'2019_01_29_071531_create_1548738931_taxes_table',1),
(60,'2019_01_29_071904_create_1548739144_discounts_table',1),
(61,'2019_01_29_072050_create_1548739250_recurring_periods_table',1),
(62,'2019_01_29_072314_create_1548739394_languages_table',1),
(63,'2019_01_29_072513_create_1548739513_purchase_orders_table',1),
(64,'2019_01_29_082314_create_1548742994_project_statuses_table',1),
(65,'2019_01_29_082503_create_1548743103_client_projects_table',1),
(66,'2019_01_29_082615_create_1548743175_project_billing_types_table',1),
(67,'2019_01_29_083232_update_1548743552_client_projects_table',1),
(68,'2019_01_29_083235_add_5c4ff383295dd_relationships_to_clientproject_table',1),
(69,'2019_01_29_085932_update_1548745172_client_projects_table',1),
(70,'2019_01_29_085936_add_5c4ff9d8959e0_relationships_to_clientproject_table',1),
(71,'2019_01_29_085937_create_5c4ff9d67448b_client_project_user_table',1),
(72,'2019_01_29_090711_create_1548745630_time_entries_table',1),
(73,'2019_01_29_090712_add_5c4ffba26d948_relationships_to_timeentry_table',1),
(74,'2019_01_29_090757_add_5c4ffbcdb18e6_relationships_to_timeentry_table',1),
(75,'2019_01_29_095618_update_1548748578_incomes_table',1),
(76,'2019_01_29_095621_add_5c50072561b1f_relationships_to_income_table',1),
(77,'2019_01_29_095621_create_media_table',1),
(78,'2019_01_29_100154_update_1548748914_expenses_table',1),
(79,'2019_01_29_100157_add_5c500874c6433_relationships_to_expense_table',1),
(80,'2019_01_29_101223_create_1548749542_invoices_table',1),
(81,'2019_01_29_101224_add_5c500aecd0471_relationships_to_invoice_table',1),
(82,'2019_01_29_101708_create_1548749827_quotes_table',1),
(83,'2019_01_29_101709_add_5c500c0ab5d65_relationships_to_quote_table',1),
(84,'2019_01_29_102056_create_1548750055_recurring_invoices_table',1),
(85,'2019_01_29_102057_add_5c500ced7363b_relationships_to_recurringinvoice_table',1),
(86,'2019_01_29_102342_add_5c500d8e0195a_relationships_to_user_table',1),
(87,'2019_01_29_102456_add_5c500dd863636_relationships_to_user_table',1),
(88,'2019_01_29_102827_create_1548750507_contact_groups_table',1),
(89,'2019_01_29_103003_create_1548750603_contact_types_table',1),
(90,'2019_01_29_103254_create_1548750773_contact_notes_table',1),
(91,'2019_01_29_103255_add_5c500fba3692a_relationships_to_contactnote_table',1),
(92,'2019_01_29_103926_update_1548751166_contacts_table',1),
(93,'2019_01_29_103932_add_5c501143f3509_relationships_to_contact_table',1),
(94,'2019_01_29_103932_create_5c501141edb0a_contact_contact_type_table',1),
(95,'2019_01_29_103933_create_5c501141f19f1_contact_language_table',1),
(96,'2019_01_29_112053_create_1548753652_contact_documents_table',1),
(97,'2019_01_29_112054_add_5c501af95db02_relationships_to_contactdocument_table',1),
(98,'2019_01_29_112150_add_5c501b2e78502_relationships_to_contactdocument_table',1),
(99,'2019_01_29_112949_create_1548754188_products_returns_table',1),
(100,'2019_01_29_112950_add_5c501d12dec0d_relationships_to_productsreturn_table',1),
(101,'2019_01_29_113515_add_5c501e535f89c_relationships_to_productsreturn_table',1),
(102,'2019_01_29_114149_update_1548754909_products_returns_table',1),
(103,'2019_01_29_114152_add_5c501fdfb2a42_relationships_to_productsreturn_table',1),
(104,'2019_01_29_114342_create_1548755022_brands_table',1),
(105,'2019_01_29_115352_update_1548755632_products_table',1),
(106,'2019_01_29_115354_add_5c5022b292be5_relationships_to_product_table',1),
(107,'2019_01_29_124344_add_5c502e5f82192_relationships_to_purchaseorder_table',1),
(108,'2019_01_29_124538_create_1548758737_departments_table',1),
(109,'2019_01_29_124539_add_5c502ed58cbf9_relationships_to_department_table',1),
(110,'2019_01_29_124811_add_5c502f6bc30af_relationships_to_user_table',1),
(111,'2019_01_29_125012_add_5c502fe47702c_relationships_to_invoice_table',1),
(112,'2019_01_29_125131_add_5c5030329376d_relationships_to_quote_table',1),
(113,'2019_01_29_125700_create_1548759419_supports_table',1),
(114,'2019_01_29_125701_add_5c5031817c6a5_relationships_to_support_table',1),
(115,'2019_01_29_125856_add_5c5031f08dc56_relationships_to_support_table',1),
(116,'2019_01_29_130219_add_5c5032bad76f5_relationships_to_support_table',1),
(117,'2019_01_29_131044_create_1548760243_transfers_table',1),
(118,'2019_01_29_131045_add_5c5034baee410_relationships_to_transfer_table',1),
(119,'2019_01_29_132005_create_1548760805_articles_table',1),
(120,'2019_01_29_132009_create_5c5036ef1e0cb_article_content_category_table',1),
(121,'2019_01_29_132010_create_5c5036ef21cd0_article_content_tag_table',1),
(122,'2019_01_29_132011_create_5c5036ef25b53_article_role_table',1),
(123,'2019_01_29_144554_add_5c504b021f762_relationships_to_transfer_table',1),
(124,'2019_01_29_145327_drop_5c504cc7e99be_expense_types_table',1),
(125,'2019_01_29_145354_add_5c504ce1e4909_relationships_to_income_table',1),
(126,'2019_01_29_150102_add_5c504e8e4b019_relationships_to_invoice_table',1),
(127,'2019_01_29_150301_add_5c504f04d469e_relationships_to_invoice_table',1),
(128,'2019_01_29_150920_update_1548767360_invoices_table',1),
(129,'2019_01_29_150923_add_5c50508343e2d_relationships_to_invoice_table',1),
(130,'2019_01_29_151255_update_1548767575_quotes_table',1),
(131,'2019_01_29_151258_add_5c505159e4675_relationships_to_quote_table',1),
(132,'2019_01_29_151512_update_1548767712_recurring_invoices_table',1),
(133,'2019_01_29_151516_add_5c5051e35bf47_relationships_to_recurringinvoice_table',1),
(134,'2019_01_29_151949_add_5c5052f52767e_relationships_to_purchaseorder_table',1),
(135,'2019_01_29_152125_add_5c50535476c76_relationships_to_purchaseorder_table',1),
(136,'2019_01_29_152330_update_1548768210_purchase_orders_table',1),
(137,'2019_01_29_152333_add_5c5053d4ae5d6_relationships_to_purchaseorder_table',1),
(138,'2019_01_29_153021_add_5c50556dcedfd_relationships_to_department_table',1),
(139,'2019_01_29_153528_add_5c50569fd640e_relationships_to_contact_table',1),
(140,'2019_01_29_154116_update_1548769276_contact_notes_table',1),
(141,'2019_01_29_154119_add_5c5057ff0e068_relationships_to_contactnote_table',1),
(142,'2019_01_30_071624_add_5c51332834daf_relationships_to_clientproject_table',1),
(143,'2019_01_30_071949_add_5c5133f5a7131_relationships_to_clientproject_table',1),
(144,'2019_01_30_072809_update_1548826089_assets_table',1),
(145,'2019_01_30_072812_add_5c5135ec5f7f8_relationships_to_asset_table',1),
(146,'2019_01_30_073209_update_1548826329_assets_table',1),
(147,'2019_01_30_073212_add_5c5136dc28281_relationships_to_asset_table',1),
(148,'2019_01_30_073401_add_5c5137492b0e6_relationships_to_faqquestion_table',1),
(149,'2019_01_30_074045_add_5c5138dd98f2d_relationships_to_product_table',1),
(150,'2019_01_30_074544_add_5c513a07af7c6_relationships_to_productsreturn_table',1),
(151,'2019_01_30_075033_update_1548827433_brands_table',1),
(152,'2019_01_30_082328_create_1548829408_master_settings_table',1),
(153,'2019_01_30_084151_update_1548830511_currencies_table',1),
(154,'2019_01_30_084321_create_1548830600_countries_table',1),
(155,'2019_01_30_084322_add_5c51478eb1ad9_relationships_to_country_table',1),
(156,'2019_01_30_084509_update_1548830709_countries_table',1),
(157,'2019_01_30_084822_update_1548830902_contacts_table',1),
(158,'2019_01_30_084825_add_5c5148b98d89a_relationships_to_contact_table',1),
(159,'2019_01_30_085311_update_1548831191_sales_taxes_table',1),
(160,'2019_01_30_085826_update_1548831506_companies_table',1),
(161,'2019_01_30_085828_add_5c514b14beb83_relationships_to_company_table',1),
(162,'2019_01_30_090151_add_5c514bdf86d38_relationships_to_company_table',1),
(163,'2019_01_30_090552_update_1548831952_warehouses_table',1),
(164,'2019_01_30_091059_drop_5c514e036bba8_sales_taxes_table',1),
(165,'2019_01_30_091123_add_5c514e1b7d191_relationships_to_income_table',1),
(166,'2019_01_30_121102_add_5c5178353f8ed_relationships_to_recurringinvoice_table',1),
(167,'2019_01_30_135325_update_1548849205_invoices_table',1),
(168,'2019_01_30_135328_add_5c519037c29f3_relationships_to_invoice_table',1),
(169,'2019_01_30_140623_update_1548849983_quotes_table',1),
(170,'2019_01_30_140626_add_5c519341b9e24_relationships_to_quote_table',1),
(171,'2019_01_30_140712_update_1548850032_recurring_invoices_table',1),
(172,'2019_01_30_140716_add_5c519373853c3_relationships_to_recurringinvoice_table',1),
(173,'2014_04_02_193005_create_translations_table',2),
(174,'2019_02_02_102123_create_1549095683_measurement_units_table',3),
(178,'2019_02_08_104525_create_1549615524_invoice_payments_table',4),
(179,'2019_02_08_104526_add_5c5d41aba8191_relationships_to_invoicepayment_table',4),
(180,'2019_02_08_104529_create_5c5d41aba4518_invoice_invoice_payment_table',5),
(181,'2019_02_11_082715_drop_5c6115c3c3d0c5c6115c3c083f_invoice_invoice_payment_table',5),
(182,'2019_02_11_082719_add_5c6115c6e1845_relationships_to_invoicepayment_table',5),
(183,'2019_01_29_070050_create_1548738050_email_templates_table',6),
(187,'2019_02_11_134008_create_1549885208_templates_table',7),
(188,'2019_02_11_134008_create_1549885208_smstemplates_table',8),
(189,'2019_02_14_150030_create_1550149230_smstemplates_table',9),
(191,'2019_02_15_073004_invocie_history_table',10),
(192,'2019_02_18_115345_update_1550483625_recurring_invoices_table',11),
(193,'2019_02_18_115348_add_5c6a80ac3474a_relationships_to_recurringinvoice_table',11),
(195,'2019_01_29_102056_create_1548750055_quotes_table',12),
(196,'2019_02_26_155200_create_1551189119_orders_table',13),
(197,'2019_02_26_155201_add_5c75448707c97_relationships_to_order_table',13),
(198,'2019_02_26_155200_create_1551189119_cart_orders_table',14),
(199,'2019_02_26_155201_add_5c75448707c97_relationships_to_cart_order_table',14),
(200,'2019_02_26_155200_create_1551189119_cart_orders_products_table',15),
(201,'2019_02_26_155201_add_5c75448707c97_relationships_to_cart_order_products_table',15),
(202,'2016_12_03_000000_create_payu_payments_table',16),
(220,'2015_07_22_115516_create_ticketit_tables',17),
(221,'2015_07_22_123254_alter_users_table',17),
(222,'2015_09_29_123456_add_completed_at_column_to_ticketit_table',17),
(223,'2015_10_08_123457_create_settings_table',17),
(224,'2016_01_15_002617_add_htmlcontent_to_ticketit_and_comments',17),
(225,'2016_01_15_040207_enlarge_settings_columns',17),
(226,'2016_01_15_120557_add_indexes',17),
(227,'2017_08_11_073824_create_menus_wp_table',18),
(228,'2017_08_11_074006_create_menu_items_wp_table',18),
(229,'2019_03_12_124615_create_1552387575_database_backups_table',19),
(230,'2019_03_12_124751_update_1552387671_database_backups_table',19),
(231,'2019_03_13_133411_create_1552476851_site_themes_table',20),
(232,'2019_03_15_064916_create_1552625356_modules_managements_table',21),
(233,'2019_03_15_081817_create_1552630696_send_sms_table',22),
(234,'2019_03_15_081528_create_1552630528_sms_gateways_table',23),
(235,'2019_03_15_081818_add_5c8b43ae71e14_relationships_to_sendsm_table',23),
(236,'2016_06_01_000001_create_oauth_auth_codes_table',24),
(237,'2016_06_01_000002_create_oauth_access_tokens_table',24),
(238,'2016_06_01_000003_create_oauth_refresh_tokens_table',24),
(239,'2016_06_01_000004_create_oauth_clients_table',24),
(240,'2016_06_01_000005_create_oauth_personal_access_clients_table',24),
(241,'2019_03_19_115828_create_1552989508_permissions_table',24),
(242,'2019_03_19_115829_create_1552989509_roles_table',24),
(243,'2019_03_19_115831_create_1552989511_users_table',24),
(244,'2019_03_19_115833_create_5c90bd466c4f8_permission_role_table',24),
(245,'2019_03_19_115835_create_5c90bd4835f48_role_user_table',24),
(246,'2019_03_19_120152_create_1552989712_product_tags_table',24),
(247,'2019_03_28_131625_create_notifications_table',24),
(248,'2019_04_29_083129_create_1556515888_quote_tasks_table',25),
(249,'2019_04_29_083130_add_5cc68c39d7da7_relationships_to_quotetask_table',25),
(250,'2019_04_29_083906_create_1556516345_mile_stones_table',26),
(251,'2019_04_29_083907_add_5cc68dff5aa00_relationships_to_milestone_table',26),
(252,'2019_04_29_084601_add_5cc68f98bb8b1_relationships_to_quotetask_table',26),
(253,'2019_04_29_085411_create_1556517250_quotes_reminders_table',26),
(254,'2019_04_29_085412_add_5cc6918a06bce_relationships_to_quotesreminder_table',26),
(255,'2019_04_29_085839_create_1556517518_quotes_notes_table',26),
(256,'2019_04_29_085840_add_5cc6929682595_relationships_to_quotesnote_table',26),
(257,'2019_04_29_093409_add_5cc69ae12afd4_relationships_to_quotetask_table',27),
(258,'2019_04_30_110242_create_1556611361_invoice_tasks_table',28),
(259,'2019_04_30_110243_add_5cc8012e66f2b_relationships_to_invoicetask_table',28),
(260,'2019_04_30_110507_add_5cc801b248400_relationships_to_invoicetask_table',28),
(261,'2019_04_30_110818_add_5cc80278d88af_relationships_to_invoicereminder_table',29),
(262,'2019_04_30_110951_add_5cc802cf782e5_relationships_to_invoicereminder_table',29),
(263,'2019_04_30_111157_create_1556611916_invoice_notes_table',29),
(264,'2019_04_30_111158_add_5cc80353ca96a_relationships_to_invoicenote_table',29),
(265,'2019_04_30_162614_drop_5cc84cf63263b5cc84cf62fa01_invoice_task_user_table',29),
(266,'2019_05_02_074014_create_1556772014_project_tabs_table',30),
(267,'2019_05_02_074908_create_5cca76c1b578f_client_project_project_tab_table',31),
(268,'2019_07_08_083429_create_jobs_table',32),
(269,'2019_07_08_083443_create_failed_jobs_table',32);


/*Table structure for table `acrm_mile_stones` */

DROP TABLE IF EXISTS `acrm_mile_stones`;

CREATE TABLE `acrm_mile_stones` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `description_visible_to_customer` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `due_date` date DEFAULT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `milestone_order` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `project_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mile_stones_deleted_at_index` (`deleted_at`),
  KEY `298246_5cc68dfc5f286` (`project_id`),
  CONSTRAINT `298246_5cc68dfc5f286` FOREIGN KEY (`project_id`) REFERENCES `acrm_client_projects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_mile_stones` */

/*Table structure for table `acrm_modules_managements` */

DROP TABLE IF EXISTS `acrm_modules_managements`;

CREATE TABLE `acrm_modules_managements` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` enum('Core','Custom') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enabled` enum('Yes','No') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `settings_data` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `can_inactive` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'yes',
  PRIMARY KEY (`id`),
  KEY `modules_managements_deleted_at_index` (`deleted_at`)
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_modules_managements` */

insert  into `acrm_modules_managements`(`id`,`name`,`slug`,`type`,`enabled`,`description`,`settings_data`,`created_at`,`updated_at`,`deleted_at`,`can_inactive`) values 
(1,'Invoices','invoice','Core','Yes',NULL,NULL,NULL,'2019-09-28 05:04:29',NULL,'yes'),
(2,'Quotes','quotes','Core','Yes',NULL,NULL,'2019-03-15 05:43:03','2019-09-28 05:05:07',NULL,'yes'),
(3,'RecurringInvoices','recurringinvoices','Core','Yes',NULL,NULL,'2019-03-15 05:44:14','2019-09-28 04:42:10',NULL,'yes'),
(4,'Products','product','Core','Yes',NULL,NULL,'2019-03-15 05:45:38','2019-09-30 14:05:07',NULL,'yes'),
(6,'ModulesManagement','modulesmanagement','Core','Yes',NULL,NULL,'2019-03-15 11:56:05','2019-09-16 06:59:14',NULL,'no'),
(14,'Sendsms','Sendsms','Custom','Yes',NULL,'','2019-03-16 06:20:54','2019-09-27 13:53:40',NULL,'yes'),
(15,'Purchase Orders','purchase_order','Core','Yes','<p>Purchase Orders</p>',NULL,'2019-09-14 05:38:49','2019-09-16 09:51:24',NULL,'yes'),
(16,'Accounts','account','Core','Yes','<p>You will find all your Bank &amp; Cash Accounts in Accounting &rarr; Accounts. In that page, you will able to-</p>\r\n\r\n<ul>\r\n  <li>See balances breakdown, cash flow. Like Total in and out &amp; the current Balances</li>\r\n  <li>You can Record initial balance</li>\r\n</ul>',NULL,'2019-09-14 09:19:54','2019-09-26 05:29:50',NULL,'yes'),
(17,'Cart Orders','order','Core','Yes','<p>An order is a customer&#39;s completed request to purchase one or more products from your business. In Laraoffice, An order is created when your customer completes the checkout process from the client portal, admin can create an order on behalf of a customer.<br />\r\n&nbsp;</p>',NULL,'2019-09-14 09:40:52','2019-09-16 03:40:58',NULL,'yes'),
(18,'Client Projects','client_project','Core','Yes',NULL,NULL,'2019-09-14 09:43:33','2019-09-27 14:54:53',NULL,'yes'),
(19,'Task Management','task','Core','Yes','<p>In this module can manage your daily tasks and track their statuses</p>',NULL,'2019-09-14 10:03:39','2019-09-23 12:45:10',NULL,'yes'),
(20,'Assets Management','asset','Core','Yes',NULL,NULL,'2019-09-14 10:04:22','2019-09-23 12:44:11',NULL,'yes'),
(21,'Quick notifications','quick_notification','Core','Yes',NULL,NULL,'2019-09-14 10:05:28','2019-09-23 12:42:25',NULL,'yes'),
(22,'Knowledge base','knowledge_base','Core','Yes',NULL,NULL,'2019-09-14 10:05:58','2019-09-14 10:05:58',NULL,'yes'),
(23,'Content Management','content_management','Core','Yes','<p>From this module, admin can publish/share with all users any useful content. These are public pages <strong>visible to all users</strong> who are logged into the system.</p>',NULL,'2019-09-14 10:07:49','2019-09-23 10:45:10',NULL,'yes'),
(24,'Articles','article','Core','Yes','<p>Articles are pages admin want to share with the particular <strong>role of users</strong></p>',NULL,'2019-09-14 10:10:54','2019-09-16 08:00:16',NULL,'yes'),
(25,'Messages','message','Core','Yes','<p>This module useful to send a message to a particular user.</p>',NULL,'2019-09-14 10:12:24','2019-09-16 08:05:23',NULL,'yes'),
(26,'Credit Notes','credit_note','Core','Yes',NULL,NULL,'2019-09-14 10:15:01','2019-09-28 11:08:27',NULL,'yes'),
(27,'Support','support','Core','Yes',NULL,NULL,'2019-09-14 12:10:06','2019-09-23 12:47:09',NULL,'yes'),
(28,'FAQs','faq','Core','Yes',NULL,NULL,'2019-09-14 12:10:23','2019-09-16 08:09:12',NULL,'yes'),
(29,'DatabaseBackup','databasebackup','Core','Yes',NULL,NULL,'2019-09-14 13:18:23','2019-09-27 14:19:06',NULL,'yes'),
(30,'Languages','languages','Core','Yes',NULL,NULL,'2019-09-14 13:18:49','2019-09-16 09:08:29',NULL,'yes'),
(31,'SiteThemes','sitethemes','Core','Yes',NULL,NULL,'2019-09-14 13:19:55','2019-09-16 09:20:51',NULL,'yes'),
(32,'Dashboard widgets','dashboardwidgets','Core','Yes',NULL,NULL,'2019-09-14 13:21:17','2019-09-27 14:20:48',NULL,'yes'),
(33,'DynamicOptions','dynamicoptions','Core','Yes',NULL,NULL,'2019-09-14 13:23:19','2019-09-27 14:22:16',NULL,'yes'),
(34,'Product Categories','productcategory','Core','Yes',NULL,NULL,'2019-09-16 05:33:09','2019-09-28 03:42:51',NULL,'yes'),
(35,'Product Brands','productbrand','Core','Yes',NULL,NULL,'2019-09-16 05:33:38','2019-09-28 03:42:53',NULL,'yes'),
(36,'Product Measurement Units','productmeasurementunits','Core','Yes',NULL,NULL,'2019-09-16 05:34:17','2019-09-28 03:42:54',NULL,'yes'),
(37,'Product Warehouses','productwarehouse','Core','Yes',NULL,NULL,'2019-09-16 05:34:42','2019-09-28 03:42:55',NULL,'yes'),
(38,'User Management','user','Core','Yes',NULL,NULL,'2019-09-16 05:35:03','2019-09-27 14:53:02',NULL,'yes'),
(39,'Lead Management','lead','Core','Yes','<p>Lead Management</p>',NULL,'2019-09-21 03:49:01','2019-09-27 14:53:30',NULL,'yes'),
(40,'Contracts Management','contracts','Core','Yes','<p>Contracts Management</p>',NULL,'2019-09-24 05:05:28','2019-09-24 05:55:49',NULL,'yes'),
(41,'Proposals','proposals','Core','Yes',NULL,NULL,'2019-09-24 05:06:06','2019-09-28 11:14:38',NULL,'yes');

/*Table structure for table `acrm_notifications` */

DROP TABLE IF EXISTS `acrm_notifications`;

CREATE TABLE `acrm_notifications` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_id` bigint(20) unsigned NOT NULL,
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_notifications` */

/*Table structure for table `acrm_oauth_access_tokens` */

DROP TABLE IF EXISTS `acrm_oauth_access_tokens`;

CREATE TABLE `acrm_oauth_access_tokens` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `scopes` text COLLATE utf8mb4_unicode_ci,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_access_tokens_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_oauth_access_tokens` */

/*Table structure for table `acrm_oauth_auth_codes` */

DROP TABLE IF EXISTS `acrm_oauth_auth_codes`;

CREATE TABLE `acrm_oauth_auth_codes` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(11) NOT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `scopes` text COLLATE utf8mb4_unicode_ci,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_oauth_auth_codes` */

/*Table structure for table `acrm_oauth_clients` */

DROP TABLE IF EXISTS `acrm_oauth_clients`;

CREATE TABLE `acrm_oauth_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `redirect` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `personal_access_client` tinyint(1) NOT NULL,
  `password_client` tinyint(1) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_clients_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_oauth_clients` */

/*Table structure for table `acrm_oauth_personal_access_clients` */

DROP TABLE IF EXISTS `acrm_oauth_personal_access_clients`;

CREATE TABLE `acrm_oauth_personal_access_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `client_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_personal_access_clients_client_id_index` (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_oauth_personal_access_clients` */

/*Table structure for table `acrm_oauth_refresh_tokens` */

DROP TABLE IF EXISTS `acrm_oauth_refresh_tokens`;

CREATE TABLE `acrm_oauth_refresh_tokens` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `access_token_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_refresh_tokens_access_token_id_index` (`access_token_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_oauth_refresh_tokens` */

/*Table structure for table `acrm_options` */

DROP TABLE IF EXISTS `acrm_options`;

CREATE TABLE `acrm_options` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) DEFAULT NULL,
  `value` text,
  `auto_load` tinyint(1) DEFAULT '0',
  `comments` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

/*Data for the table `acrm_options` */

insert  into `acrm_options`(`id`,`name`,`value`,`auto_load`,`comments`) values 
(1,'last_cron_checked','',0,NULL),
(2,'last_cron_run','',0,NULL),
(3,'show_page_heading','no',0,NULL);

/*Table structure for table `acrm_order_products` */

DROP TABLE IF EXISTS `acrm_order_products`;

CREATE TABLE `acrm_order_products` (
  `order_id` int(10) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `product_name` varchar(191) DEFAULT NULL,
  `product_qty` int(11) DEFAULT NULL,
  `product_price` decimal(10,2) DEFAULT NULL,
  `product_tax` decimal(10,2) DEFAULT NULL COMMENT 'Tax Rate',
  `tax_type` varchar(10) DEFAULT NULL,
  `tax_value` decimal(10,2) DEFAULT NULL,
  `product_discount` decimal(10,2) DEFAULT NULL COMMENT 'Discount Rate',
  `discount_type` varchar(10) DEFAULT NULL,
  `discount_value` decimal(10,0) DEFAULT NULL,
  `product_subtotal` decimal(10,0) DEFAULT NULL,
  `product_amount` decimal(10,2) DEFAULT NULL,
  `pid` int(11) DEFAULT NULL,
  `unit` varchar(15) DEFAULT NULL,
  `hsn` varchar(45) DEFAULT NULL,
  `alert` int(11) DEFAULT NULL,
  `stock_quantity` int(11) DEFAULT NULL,
  `product_description` text,
  KEY `fk_order_id_order_products` (`order_id`),
  KEY `fk_product_id_order_products` (`order_id`),
  KEY `fk_product_id_order_products2` (`product_id`),
  CONSTRAINT `fk_order_id_order_products` FOREIGN KEY (`order_id`) REFERENCES `acrm_orders` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_product_id_order_products2` FOREIGN KEY (`product_id`) REFERENCES `acrm_products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `acrm_order_products` */

/*Table structure for table `acrm_orders` */

DROP TABLE IF EXISTS `acrm_orders`;

CREATE TABLE `acrm_orders` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` char(50) COLLATE utf8mb4_unicode_ci DEFAULT 'Pending',
  `price` decimal(15,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `customer_id` int(10) unsigned DEFAULT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `billing_cycle_id` int(10) unsigned DEFAULT NULL,
  `products` text COLLATE utf8mb4_unicode_ci,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_recurring` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `total_cycles` int(10) DEFAULT '0',
  `cycles` int(10) DEFAULT '0',
  `recurring_type` char(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `recurring_value` int(10) DEFAULT NULL,
  `last_recurring_date` date DEFAULT NULL,
  `is_recurring_from` int(10) unsigned DEFAULT NULL,
  `prevent_overdue_reminders` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `last_overdue_reminder` date DEFAULT NULL,
  `invoice_date` date DEFAULT NULL,
  `invoice_due_date` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `delivery_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stock_updated` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'yes',
  PRIMARY KEY (`id`),
  KEY `orders_deleted_at_index` (`deleted_at`),
  KEY `270937_5c7544840dff5` (`customer_id`),
  KEY `270937_5c754484400c2` (`billing_cycle_id`),
  KEY `fk_is_recurring_from_orders` (`is_recurring_from`),
  KEY `fk_currency_id_orders` (`currency_id`),
  CONSTRAINT `270937_5c7544840dff5` FOREIGN KEY (`customer_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `270937_5c754484400c2` FOREIGN KEY (`billing_cycle_id`) REFERENCES `acrm_recurring_periods` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_currency_id_orders` FOREIGN KEY (`currency_id`) REFERENCES `acrm_currencies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_is_recurring_from_orders` FOREIGN KEY (`is_recurring_from`) REFERENCES `acrm_orders` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_orders` */

/*Table structure for table `acrm_orders_history` */

DROP TABLE IF EXISTS `acrm_orders_history`;

CREATE TABLE `acrm_orders_history` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ip_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` text COLLATE utf8mb4_unicode_ci,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `browser` text COLLATE utf8mb4_unicode_ci,
  `comments` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `quote_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoices_history_deleted_at_index` (`deleted_at`),
  KEY `259415_5c500ae99af17` (`quote_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_orders_history` */

/*Table structure for table `acrm_orders_payments` */

DROP TABLE IF EXISTS `acrm_orders_payments`;

CREATE TABLE `acrm_orders_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `account_id` int(10) unsigned DEFAULT NULL,
  `order_id` int(10) unsigned DEFAULT NULL,
  `paymentmethod` char(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_status` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_data` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `invoice_payments_deleted_at_index` (`deleted_at`),
  KEY `263295_5c5d41a961b5c` (`account_id`),
  KEY `263295_5c5d41a961b9c` (`order_id`),
  CONSTRAINT `fk_order_payments_account_id` FOREIGN KEY (`account_id`) REFERENCES `acrm_accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_order_payments_order_id` FOREIGN KEY (`order_id`) REFERENCES `acrm_orders` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_orders_payments` */

/*Table structure for table `acrm_password_resets` */

DROP TABLE IF EXISTS `acrm_password_resets`;

CREATE TABLE `acrm_password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_password_resets` */

/*Table structure for table `acrm_payment_gateways` */

DROP TABLE IF EXISTS `acrm_payment_gateways`;

CREATE TABLE `acrm_payment_gateways` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `status` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payment_gateways_deleted_at_index` (`deleted_at`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_payment_gateways` */

insert  into `acrm_payment_gateways`(`id`,`key`,`name`,`description`,`logo`,`created_at`,`updated_at`,`deleted_at`,`status`) values 
(1,'stripe','Stripe','Stripe Settings',NULL,'2019-02-22 08:45:49','2019-04-13 05:36:45',NULL,'Active'),
(2,'paypal','Paypal','Contains paypal config details',NULL,'2019-02-22 08:45:49','2019-04-17 11:36:32',NULL,'Active'),
(3,'payu','PayU','PayU Settings',NULL,'2019-02-22 08:45:49','2019-05-25 09:28:23',NULL,'Active');

/*Table structure for table `acrm_permission_role` */

DROP TABLE IF EXISTS `acrm_permission_role`;

CREATE TABLE `acrm_permission_role` (
  `permission_id` int(10) unsigned DEFAULT NULL,
  `role_id` int(10) unsigned DEFAULT NULL,
  KEY `fk_p_259278_259279_role_p_5c4fd266c9ac3` (`permission_id`),
  KEY `fk_p_259279_259278_permis_5c4fd266c9bbd` (`role_id`),
  CONSTRAINT `fk_permission_id_permissionrole` FOREIGN KEY (`permission_id`) REFERENCES `acrm_permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_role_id_permissionsrole` FOREIGN KEY (`role_id`) REFERENCES `acrm_roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_permission_role` */

insert  into `acrm_permission_role`(`permission_id`,`role_id`) values 
(1,1),
(2,1),
(3,1),
(4,1),
(5,1),
(6,1),
(7,1),
(8,1),
(9,1),
(10,1),
(11,1),
(12,1),
(13,1),
(14,1),
(15,1),
(16,1),
(17,1),
(18,1),
(19,1),
(20,1),
(21,1),
(22,1),
(23,1),
(24,1),
(25,1),
(26,1),
(27,1),
(28,1),
(29,1),
(30,1),
(31,1),
(32,1),
(33,1),
(34,1),
(35,1),
(36,1),
(37,1),
(38,1),
(39,1),
(40,1),
(41,1),
(42,1),
(43,1),
(44,1),
(45,1),
(46,1),
(47,1),
(48,1),
(49,1),
(50,1),
(51,1),
(62,1),
(63,1),
(64,1),
(65,1),
(66,1),
(67,1),
(68,1),
(69,1),
(70,1),
(71,1),
(72,1),
(73,1),
(74,1),
(75,1),
(76,1),
(77,1),
(78,1),
(79,1),
(80,1),
(81,1),
(82,1),
(83,1),
(84,1),
(85,1),
(86,1),
(92,1),
(93,1),
(94,1),
(95,1),
(96,1),
(97,1),
(98,1),
(99,1),
(100,1),
(101,1),
(102,1),
(103,1),
(104,1),
(105,1),
(106,1),
(107,1),
(108,1),
(109,1),
(110,1),
(111,1),
(112,1),
(113,1),
(114,1),
(115,1),
(116,1),
(117,1),
(118,1),
(119,1),
(120,1),
(121,1),
(122,1),
(123,1),
(124,1),
(125,1),
(126,1),
(127,1),
(128,1),
(129,1),
(130,1),
(131,1),
(132,1),
(133,1),
(134,1),
(135,1),
(136,1),
(137,1),
(138,1),
(139,1),
(140,1),
(141,1),
(142,1),
(143,1),
(144,1),
(145,1),
(146,1),
(147,1),
(148,1),
(149,1),
(150,1),
(151,1),
(152,1),
(153,1),
(154,1),
(155,1),
(156,1),
(157,1),
(158,1),
(159,1),
(160,1),
(161,1),
(162,1),
(163,1),
(164,1),
(165,1),
(166,1),
(167,1),
(168,1),
(169,1),
(170,1),
(171,1),
(172,1),
(173,1),
(174,1),
(175,1),
(176,1),
(177,1),
(178,1),
(179,1),
(180,1),
(181,1),
(182,1),
(183,1),
(184,1),
(185,1),
(186,1),
(187,1),
(188,1),
(189,1),
(190,1),
(191,1),
(192,1),
(193,1),
(194,1),
(195,1),
(196,1),
(202,1),
(203,1),
(204,1),
(205,1),
(206,1),
(207,1),
(213,1),
(214,1),
(215,1),
(216,1),
(217,1),
(218,1),
(219,1),
(220,1),
(221,1),
(222,1),
(223,1),
(224,1),
(225,1),
(226,1),
(227,1),
(228,1),
(229,1),
(230,1),
(231,1),
(233,1),
(234,1),
(235,1),
(236,1),
(237,1),
(238,1),
(240,1),
(241,1),
(242,1),
(243,1),
(244,1),
(245,1),
(246,1),
(247,1),
(248,1),
(249,1),
(250,1),
(251,1),
(252,1),
(253,1),
(254,1),
(255,1),
(256,1),
(257,1),
(258,1),
(259,1),
(260,1),
(261,1),
(262,1),
(264,1),
(265,1),
(266,1),
(267,1),
(268,1),
(269,1),
(270,1),
(271,1),
(272,1),
(273,1),
(274,1),
(275,1),
(276,1),
(277,1),
(278,1),
(279,1),
(280,1),
(281,1),
(282,1),
(283,1),
(284,1),
(285,1),
(286,1),
(287,1),
(288,1),
(289,1),
(290,1),
(291,1),
(292,1),
(293,1),
(294,1),
(295,1),
(296,1),
(297,1),
(298,1),
(299,1),
(300,1),
(301,1),
(302,1),
(303,1),
(304,1),
(305,1),
(306,1),
(307,1),
(308,1),
(309,1),
(310,1),
(311,1),
(312,1),
(313,1),
(314,1),
(315,1),
(316,1),
(317,1),
(318,1),
(319,1),
(320,1),
(321,1),
(322,1),
(323,1),
(324,1),
(325,1),
(326,1),
(327,1),
(328,1),
(329,1),
(330,1),
(331,1),
(332,1),
(333,1),
(334,1),
(335,1),
(336,1),
(337,1),
(338,1),
(339,1),
(340,1),
(341,1),
(342,1),
(343,1),
(344,1),
(345,1),
(346,1),
(347,1),
(348,1),
(349,1),
(350,1),
(351,1),
(352,1),
(353,1),
(52,1),
(53,1),
(54,1),
(55,1),
(56,1),
(356,1),
(357,1),
(358,1),
(359,1),
(361,1),
(362,1),
(363,1),
(364,1),
(365,1),
(366,1),
(367,1),
(368,1),
(369,1),
(370,1),
(371,1),
(372,1),
(360,1),
(383,1),
(384,1),
(385,1),
(386,1),
(387,1),
(398,1),
(403,1),
(404,1),
(405,1),
(406,1),
(407,1),
(373,1),
(374,1),
(375,1),
(376,1),
(377,1),
(388,1),
(389,1),
(390,1),
(391,1),
(392,1),
(408,1),
(409,1),
(410,1),
(411,1),
(412,1),
(413,1),
(414,1),
(415,1),
(416,1),
(417,1),
(419,1),
(418,1),
(420,1),
(421,1),
(422,1),
(423,1),
(424,1),
(425,1),
(426,1),
(427,1),
(428,1),
(429,1),
(430,1),
(431,1),
(432,1),
(433,1),
(434,1),
(435,1),
(436,1),
(437,1),
(438,1),
(439,1),
(440,1),
(441,1),
(442,1),
(443,1),
(444,1),
(445,1),
(446,1),
(447,1),
(448,1),
(449,1),
(450,1),
(451,1),
(452,1),
(453,1),
(454,1),
(455,1),
(456,1),
(457,1),
(458,1),
(459,1),
(460,1),
(461,1),
(462,1),
(463,1),
(464,1),
(465,1),
(466,1),
(467,1),
(468,1),
(469,1),
(470,1),
(471,1),
(472,1),
(473,1),
(474,1),
(475,1),
(476,1),
(477,1),
(478,1),
(479,1),
(480,1),
(481,1),
(482,1),
(483,1),
(484,1),
(485,1),
(486,1),
(487,1),
(488,1),
(489,1),
(490,1),
(491,1),
(492,1),
(495,1),
(496,1),
(497,1),
(498,1),
(499,1),
(500,1),
(501,1),
(502,1),
(503,1),
(504,1),
(505,1),
(506,1),
(507,1),
(508,1),
(494,1),
(493,1),
(378,1),
(379,1),
(380,1),
(381,1),
(382,1),
(87,1),
(88,1),
(89,1),
(90,1),
(91,1),
(509,1),
(57,1),
(58,1),
(59,1),
(60,1),
(61,1),
(510,1),
(511,1),
(512,1),
(513,1),
(515,1),
(516,1),
(517,1),
(518,1),
(519,1),
(520,1),
(521,1),
(522,1),
(523,1),
(524,1),
(525,1),
(526,1),
(527,1),
(528,1),
(529,1),
(530,1),
(531,1),
(532,1),
(533,1),
(534,1),
(535,1),
(536,1),
(537,1),
(538,1),
(539,1),
(541,1),
(542,1),
(543,1),
(544,1),
(545,1),
(546,1),
(547,1),
(548,1),
(549,1),
(550,1),
(551,1),
(552,1),
(553,1),
(554,1),
(555,1),
(556,1),
(232,1),
(557,1),
(559,1),
(560,1),
(561,1),
(562,1),
(563,1),
(564,1),
(565,1),
(566,1),
(567,1),
(568,1),
(569,1),
(570,1),
(571,1),
(572,1),
(573,1),
(574,1),
(575,1),
(576,1),
(577,1),
(578,1),
(579,1),
(580,1),
(581,1),
(582,1),
(583,1),
(584,1),
(585,1),
(586,1),
(587,1),
(588,1),
(589,1),
(590,1),
(591,1),
(592,1),
(593,1),
(594,1),
(595,1),
(596,1),
(597,1),
(598,1),
(599,1),
(600,1),
(601,1),
(602,1),
(603,1),
(604,1),
(605,1),
(606,1),
(607,1),
(608,1),
(609,1),
(610,1),
(611,1),
(612,1),
(613,1),
(614,1),
(615,1),
(616,1),
(617,1),
(618,1),
(619,1),
(620,1),
(621,1),
(622,1),
(623,1),
(624,1),
(625,1),
(626,1),
(627,1),
(628,1),
(629,1),
(630,1),
(631,1),
(632,1),
(633,1),
(634,1),
(635,1),
(636,1),
(637,1),
(638,1),
(639,1),
(640,1),
(641,1),
(642,1),
(643,1),
(644,1),
(645,1),
(646,1),
(647,1),
(648,1),
(649,1),
(650,1),
(651,1),
(652,1),
(653,1),
(654,1),
(655,1),
(656,1),
(657,1),
(658,1),
(659,1),
(660,1),
(661,1),
(662,1),
(663,1),
(664,1),
(665,1),
(666,1),
(667,1),
(668,1),
(669,1),
(670,1),
(671,1),
(672,1),
(673,1),
(674,1),
(675,1),
(676,1),
(677,1),
(678,1),
(679,1),
(680,1),
(681,1),
(682,1),
(683,1),
(684,1),
(685,1),
(686,1),
(687,1),
(688,1),
(689,1),
(690,1),
(691,1),
(692,1),
(693,1),
(694,1),
(695,1),
(696,1),
(697,1),
(698,1),
(699,1),
(700,1),
(701,1),
(702,1),
(703,1),
(704,1),
(705,1),
(706,1),
(707,1),
(708,1),
(709,1),
(710,1),
(711,1),
(712,1),
(713,1),
(714,1),
(715,1),
(716,1),
(717,1),
(718,1),
(719,1),
(720,1),
(721,1),
(722,1),
(723,1),
(724,1),
(725,1),
(726,1),
(727,1),
(728,1),
(729,1),
(730,1),
(731,1),
(732,1),
(733,1),
(734,1),
(735,1),
(736,1),
(737,1),
(738,1),
(739,1),
(740,1),
(741,1),
(742,1),
(743,1),
(744,1),
(745,1),
(746,1),
(747,1),
(748,1),
(749,1),
(750,1),
(751,1),
(752,1),
(753,1),
(754,1),
(755,1),
(756,1),
(757,1),
(758,1),
(759,1),
(760,1),
(761,1),
(762,1),
(763,1),
(764,1),
(765,1),
(766,1),
(767,1),
(768,1),
(769,1),
(770,1),
(771,1),
(772,1),
(773,1),
(774,1),
(775,1),
(776,1),
(777,1),
(778,1),
(779,1),
(780,1),
(781,1),
(782,1),
(783,1),
(784,1),
(785,1),
(786,1),
(787,1),
(788,1),
(789,1),
(790,1),
(791,1),
(792,1),
(793,1),
(239,1),
(794,1),
(795,1),
(796,1),
(797,1),
(798,1),
(799,1),
(800,1),
(801,1),
(802,1),
(803,1),
(804,1),
(805,1),
(806,1),
(807,1),
(808,1),
(809,1),
(810,1),
(811,1),
(812,1),
(813,1),
(814,1),
(815,1),
(816,1),
(817,1),
(818,1),
(819,1),
(820,1),
(821,1),
(822,1),
(823,1),
(824,1),
(825,1),
(826,1),
(827,1),
(828,1),
(829,1),
(830,1),
(831,1),
(832,1),
(833,1),
(834,1),
(835,1),
(836,1),
(837,1),
(838,1),
(839,1),
(840,1),
(841,1),
(842,1),
(843,1),
(844,1),
(845,1),
(846,1),
(847,1),
(848,1),
(849,1),
(850,1),
(851,1),
(852,1),
(853,1),
(854,1),
(855,1),
(856,1),
(857,1),
(858,1),
(859,1),
(860,1),
(861,1),
(862,1),
(863,1),
(864,1),
(865,1),
(866,1),
(867,1),
(868,1),
(869,1),
(870,1),
(871,1),
(872,1),
(873,1),
(874,1),
(875,1),
(876,1),
(877,1),
(878,1),
(879,1),
(880,1),
(881,1),
(882,1),
(883,1),
(884,1),
(885,1),
(886,1),
(887,1),
(888,1),
(889,1),
(890,1),
(891,1),
(892,1),
(893,1),
(894,1),
(895,1),
(896,1),
(897,1),
(1,1),
(2,1),
(3,1),
(4,1),
(5,1),
(6,1),
(7,1),
(8,1),
(9,1),
(10,1),
(11,1),
(12,1),
(13,1),
(14,1),
(15,1),
(16,1),
(17,1),
(18,1),
(19,1),
(20,1),
(21,1),
(22,1),
(23,1),
(24,1),
(25,1),
(26,1),
(27,1),
(28,1),
(29,1),
(30,1),
(31,1),
(32,1),
(33,1),
(34,1),
(35,1),
(36,1),
(37,1),
(38,1),
(39,1),
(40,1),
(41,1),
(42,1),
(43,1),
(44,1),
(45,1),
(46,1),
(47,1),
(48,1),
(49,1),
(50,1),
(51,1),
(62,1),
(63,1),
(64,1),
(65,1),
(66,1),
(67,1),
(68,1),
(69,1),
(70,1),
(71,1),
(72,1),
(73,1),
(74,1),
(75,1),
(76,1),
(77,1),
(78,1),
(79,1),
(80,1),
(81,1),
(82,1),
(83,1),
(84,1),
(85,1),
(86,1),
(92,1),
(93,1),
(94,1),
(95,1),
(96,1),
(97,1),
(98,1),
(99,1),
(100,1),
(101,1),
(102,1),
(103,1),
(104,1),
(105,1),
(106,1),
(107,1),
(108,1),
(109,1),
(110,1),
(111,1),
(112,1),
(113,1),
(114,1),
(115,1),
(116,1),
(117,1),
(118,1),
(119,1),
(120,1),
(121,1),
(122,1),
(123,1),
(124,1),
(125,1),
(126,1),
(127,1),
(128,1),
(129,1),
(130,1),
(131,1),
(132,1),
(133,1),
(134,1),
(135,1),
(136,1),
(137,1),
(138,1),
(139,1),
(140,1),
(141,1),
(142,1),
(143,1),
(144,1),
(145,1),
(146,1),
(147,1),
(148,1),
(149,1),
(150,1),
(151,1),
(152,1),
(153,1),
(154,1),
(155,1),
(156,1),
(157,1),
(158,1),
(159,1),
(160,1),
(161,1),
(162,1),
(163,1),
(164,1),
(165,1),
(166,1),
(167,1),
(168,1),
(169,1),
(170,1),
(171,1),
(172,1),
(173,1),
(174,1),
(175,1),
(176,1),
(177,1),
(178,1),
(179,1),
(180,1),
(181,1),
(182,1),
(183,1),
(184,1),
(185,1),
(186,1),
(187,1),
(188,1),
(189,1),
(190,1),
(191,1),
(192,1),
(193,1),
(194,1),
(195,1),
(196,1),
(202,1),
(203,1),
(204,1),
(205,1),
(206,1),
(207,1),
(213,1),
(214,1),
(215,1),
(216,1),
(217,1),
(218,1),
(219,1),
(220,1),
(221,1),
(222,1),
(223,1),
(224,1),
(225,1),
(226,1),
(227,1),
(228,1),
(229,1),
(230,1),
(231,1),
(233,1),
(234,1),
(235,1),
(236,1),
(237,1),
(238,1),
(240,1),
(241,1),
(242,1),
(243,1),
(244,1),
(245,1),
(246,1),
(247,1),
(248,1),
(249,1),
(250,1),
(251,1),
(252,1),
(253,1),
(254,1),
(255,1),
(256,1),
(257,1),
(258,1),
(259,1),
(260,1),
(261,1),
(262,1),
(264,1),
(265,1),
(266,1),
(267,1),
(268,1),
(269,1),
(270,1),
(271,1),
(272,1),
(273,1),
(274,1),
(275,1),
(276,1),
(277,1),
(278,1),
(279,1),
(280,1),
(281,1),
(282,1),
(283,1),
(284,1),
(285,1),
(286,1),
(287,1),
(288,1),
(289,1),
(290,1),
(291,1),
(292,1),
(293,1),
(294,1),
(295,1),
(296,1),
(297,1),
(298,1),
(299,1),
(300,1),
(301,1),
(302,1),
(303,1),
(304,1),
(305,1),
(306,1),
(307,1),
(308,1),
(309,1),
(310,1),
(311,1),
(312,1),
(313,1),
(314,1),
(315,1),
(316,1),
(317,1),
(318,1),
(319,1),
(320,1),
(321,1),
(322,1),
(323,1),
(324,1),
(325,1),
(326,1),
(327,1),
(328,1),
(329,1),
(330,1),
(331,1),
(332,1),
(333,1),
(334,1),
(335,1),
(336,1),
(337,1),
(338,1),
(339,1),
(340,1),
(341,1),
(342,1),
(343,1),
(344,1),
(345,1),
(346,1),
(347,1),
(348,1),
(349,1),
(350,1),
(351,1),
(352,1),
(353,1),
(52,1),
(53,1),
(54,1),
(55,1),
(56,1),
(356,1),
(357,1),
(358,1),
(359,1),
(361,1),
(362,1),
(363,1),
(364,1),
(365,1),
(366,1),
(367,1),
(368,1),
(369,1),
(370,1),
(371,1),
(372,1),
(360,1),
(383,1),
(384,1),
(385,1),
(386,1),
(387,1),
(398,1),
(403,1),
(404,1),
(405,1),
(406,1),
(407,1),
(373,1),
(374,1),
(375,1),
(376,1),
(377,1),
(388,1),
(389,1),
(390,1),
(391,1),
(392,1),
(408,1),
(409,1),
(410,1),
(411,1),
(412,1),
(413,1),
(414,1),
(415,1),
(416,1),
(417,1),
(419,1),
(418,1),
(420,1),
(421,1),
(422,1),
(423,1),
(424,1),
(425,1),
(426,1),
(427,1),
(428,1),
(429,1),
(430,1),
(431,1),
(432,1),
(433,1),
(434,1),
(435,1),
(436,1),
(437,1),
(438,1),
(439,1),
(440,1),
(441,1),
(442,1),
(443,1),
(444,1),
(445,1),
(446,1),
(447,1),
(448,1),
(449,1),
(450,1),
(451,1),
(452,1),
(453,1),
(454,1),
(455,1),
(456,1),
(457,1),
(458,1),
(459,1),
(460,1),
(461,1),
(462,1),
(463,1),
(464,1),
(465,1),
(466,1),
(467,1),
(468,1),
(469,1),
(470,1),
(471,1),
(472,1),
(473,1),
(474,1),
(475,1),
(476,1),
(477,1),
(478,1),
(479,1),
(480,1),
(481,1),
(482,1),
(483,1),
(484,1),
(485,1),
(486,1),
(487,1),
(488,1),
(489,1),
(490,1),
(491,1),
(492,1),
(495,1),
(496,1),
(497,1),
(498,1),
(499,1),
(500,1),
(501,1),
(502,1),
(503,1),
(504,1),
(505,1),
(506,1),
(507,1),
(508,1),
(494,1),
(493,1),
(378,1),
(379,1),
(380,1),
(381,1),
(382,1),
(87,1),
(88,1),
(89,1),
(90,1),
(91,1),
(509,1),
(57,1),
(58,1),
(59,1),
(60,1),
(61,1),
(510,1),
(511,1),
(512,1),
(513,1),
(515,1),
(516,1),
(517,1),
(518,1),
(519,1),
(520,1),
(521,1),
(522,1),
(523,1),
(524,1),
(525,1),
(526,1),
(527,1),
(528,1),
(529,1),
(530,1),
(531,1),
(532,1),
(533,1),
(534,1),
(535,1),
(536,1),
(537,1),
(538,1),
(539,1),
(541,1),
(542,1),
(543,1),
(544,1),
(545,1),
(546,1),
(547,1),
(548,1),
(549,1),
(550,1),
(551,1),
(552,1),
(553,1),
(554,1),
(555,1),
(556,1),
(232,1),
(557,1),
(559,1),
(560,1),
(561,1),
(562,1),
(563,1),
(564,1),
(565,1),
(566,1),
(567,1),
(568,1),
(569,1),
(570,1),
(571,1),
(572,1),
(573,1),
(574,1),
(575,1),
(576,1),
(577,1),
(578,1),
(579,1),
(580,1),
(581,1),
(582,1),
(583,1),
(584,1),
(585,1),
(586,1),
(587,1),
(588,1),
(589,1),
(590,1),
(591,1),
(592,1),
(593,1),
(594,1),
(595,1),
(596,1),
(597,1),
(598,1),
(599,1),
(600,1),
(601,1),
(602,1),
(603,1),
(604,1),
(605,1),
(606,1),
(607,1),
(608,1),
(609,1),
(610,1),
(611,1),
(612,1),
(613,1),
(614,1),
(615,1),
(616,1),
(617,1),
(618,1),
(619,1),
(620,1),
(621,1),
(622,1),
(623,1),
(624,1),
(625,1),
(626,1),
(627,1),
(628,1),
(629,1),
(630,1),
(631,1),
(632,1),
(633,1),
(634,1),
(635,1),
(636,1),
(637,1),
(638,1),
(639,1),
(640,1),
(641,1),
(642,1),
(643,1),
(644,1),
(645,1),
(646,1),
(647,1),
(648,1),
(649,1),
(650,1),
(651,1),
(652,1),
(653,1),
(654,1),
(655,1),
(656,1),
(657,1),
(658,1),
(659,1),
(660,1),
(661,1),
(662,1),
(663,1),
(664,1),
(665,1),
(666,1),
(667,1),
(668,1),
(669,1),
(670,1),
(671,1),
(672,1),
(673,1),
(674,1),
(675,1),
(676,1),
(677,1),
(678,1),
(679,1),
(680,1),
(681,1),
(682,1),
(683,1),
(684,1),
(685,1),
(686,1),
(687,1),
(688,1),
(689,1),
(690,1),
(691,1),
(692,1),
(693,1),
(694,1),
(695,1),
(696,1),
(697,1),
(698,1),
(699,1),
(700,1),
(701,1),
(702,1),
(703,1),
(704,1),
(705,1),
(706,1),
(707,1),
(708,1),
(709,1),
(710,1),
(711,1),
(712,1),
(713,1),
(714,1),
(715,1),
(716,1),
(717,1),
(718,1),
(719,1),
(720,1),
(721,1),
(722,1),
(723,1),
(724,1),
(725,1),
(726,1),
(727,1),
(728,1),
(729,1),
(730,1),
(731,1),
(732,1),
(733,1),
(734,1),
(735,1),
(736,1),
(737,1),
(738,1),
(739,1),
(740,1),
(741,1),
(742,1),
(743,1),
(744,1),
(745,1),
(746,1),
(747,1),
(748,1),
(749,1),
(750,1),
(751,1),
(752,1),
(753,1),
(754,1),
(755,1),
(756,1),
(757,1),
(758,1),
(759,1),
(760,1),
(761,1),
(762,1),
(763,1),
(764,1),
(765,1),
(766,1),
(767,1),
(768,1),
(769,1),
(770,1),
(771,1),
(772,1),
(773,1),
(774,1),
(775,1),
(776,1),
(777,1),
(778,1),
(779,1),
(780,1),
(781,1),
(782,1),
(783,1),
(784,1),
(785,1),
(786,1),
(787,1),
(788,1),
(789,1),
(790,1),
(791,1),
(792,1),
(793,1),
(239,1),
(794,1),
(795,1),
(796,1),
(797,1),
(798,1),
(799,1),
(800,1),
(801,1),
(802,1),
(803,1),
(804,1),
(805,1),
(806,1),
(807,1),
(808,1),
(809,1),
(810,1),
(811,1),
(812,1),
(813,1),
(814,1),
(815,1),
(816,1),
(817,1),
(818,1),
(819,1),
(820,1),
(821,1),
(822,1),
(823,1),
(824,1),
(825,1),
(826,1),
(827,1),
(828,1),
(829,1),
(830,1),
(831,1),
(832,1),
(833,1),
(834,1),
(835,1),
(836,1),
(837,1),
(838,1),
(839,1),
(840,1),
(841,1),
(842,1),
(843,1),
(844,1),
(845,1),
(846,1),
(847,1),
(848,1),
(849,1),
(850,1),
(851,1),
(852,1),
(853,1),
(854,1),
(855,1),
(856,1),
(857,1),
(858,1),
(859,1),
(860,1),
(861,1),
(862,1),
(863,1),
(864,1),
(865,1),
(866,1),
(867,1),
(868,1),
(869,1),
(870,1),
(871,1),
(872,1),
(873,1),
(874,1),
(875,1),
(876,1),
(877,1),
(878,1),
(879,1),
(880,1),
(881,1),
(882,1),
(883,1),
(884,1),
(885,1),
(886,1),
(887,1),
(888,1),
(889,1),
(890,1),
(891,1),
(892,1),
(893,1),
(894,1),
(895,1),
(896,1),
(897,1),
(418,2),
(1,14),
(2,14),
(3,14),
(4,14),
(5,14),
(6,14),
(7,14),
(8,14),
(9,14),
(10,14),
(11,14),
(12,14),
(13,14),
(14,14),
(15,14),
(16,14),
(17,14),
(18,14),
(19,14),
(20,14),
(21,14),
(22,14),
(23,14),
(24,14),
(25,14),
(26,14),
(27,14),
(28,14),
(29,14),
(30,14),
(31,14),
(32,14),
(33,14),
(34,14),
(35,14),
(36,14),
(37,14),
(38,14),
(39,14),
(40,14),
(41,14),
(42,14),
(43,14),
(44,14),
(45,14),
(46,14),
(47,14),
(48,14),
(49,14),
(50,14),
(51,14),
(52,14),
(53,14),
(54,14),
(55,14),
(56,14),
(57,14),
(58,14),
(59,14),
(60,14),
(61,14),
(62,14),
(63,14),
(64,14),
(65,14),
(66,14),
(67,14),
(68,14),
(69,14),
(70,14),
(71,14),
(72,14),
(73,14),
(74,14),
(75,14),
(76,14),
(77,14),
(78,14),
(79,14),
(80,14),
(81,14),
(82,14),
(83,14),
(84,14),
(85,14),
(86,14),
(87,14),
(88,14),
(89,14),
(90,14),
(91,14),
(92,14),
(93,14),
(94,14),
(95,14),
(96,14),
(97,14),
(98,14),
(99,14),
(100,14),
(101,14),
(102,14),
(103,14),
(104,14),
(105,14),
(106,14),
(107,14),
(108,14),
(109,14),
(110,14),
(111,14),
(112,14),
(113,14),
(114,14),
(115,14),
(116,14),
(117,14),
(118,14),
(119,14),
(120,14),
(121,14),
(122,14),
(123,14),
(124,14),
(125,14),
(126,14),
(127,14),
(128,14),
(129,14),
(130,14),
(131,14),
(132,14),
(133,14),
(134,14),
(135,14),
(136,14),
(137,14),
(138,14),
(139,14),
(140,14),
(141,14),
(142,14),
(143,14),
(144,14),
(145,14),
(146,14),
(147,14),
(148,14),
(149,14),
(150,14),
(151,14),
(152,14),
(153,14),
(154,14),
(155,14),
(156,14),
(157,14),
(158,14),
(159,14),
(160,14),
(161,14),
(162,14),
(163,14),
(164,14),
(165,14),
(166,14),
(167,14),
(168,14),
(169,14),
(170,14),
(171,14),
(172,14),
(173,14),
(174,14),
(175,14),
(176,14),
(177,14),
(178,14),
(179,14),
(180,14),
(181,14),
(182,14),
(183,14),
(184,14),
(185,14),
(186,14),
(187,14),
(188,14),
(189,14),
(190,14),
(191,14),
(192,14),
(193,14),
(194,14),
(195,14),
(196,14),
(202,14),
(203,14),
(204,14),
(205,14),
(206,14),
(207,14),
(213,14),
(214,14),
(215,14),
(216,14),
(217,14),
(218,14),
(219,14),
(220,14),
(221,14),
(222,14),
(223,14),
(224,14),
(225,14),
(226,14),
(227,14),
(228,14),
(229,14),
(230,14),
(231,14),
(232,14),
(233,14),
(234,14),
(235,14),
(236,14),
(237,14),
(238,14),
(239,14),
(240,14),
(241,14),
(242,14),
(243,14),
(244,14),
(245,14),
(246,14),
(247,14),
(248,14),
(249,14),
(250,14),
(251,14),
(252,14),
(253,14),
(254,14),
(255,14),
(256,14),
(257,14),
(258,14),
(259,14),
(260,14),
(261,14),
(262,14),
(264,14),
(265,14),
(266,14),
(267,14),
(268,14),
(269,14),
(270,14),
(271,14),
(272,14),
(273,14),
(274,14),
(275,14),
(276,14),
(277,14),
(278,14),
(279,14),
(280,14),
(281,14),
(282,14),
(283,14),
(284,14),
(285,14),
(286,14),
(287,14),
(288,14),
(289,14),
(290,14),
(291,14),
(292,14),
(293,14),
(294,14),
(295,14),
(296,14),
(297,14),
(298,14),
(299,14),
(300,14),
(301,14),
(302,14),
(303,14),
(304,14),
(305,14),
(306,14),
(307,14),
(308,14),
(309,14),
(310,14),
(311,14),
(312,14),
(313,14),
(314,14),
(315,14),
(316,14),
(317,14),
(318,14),
(319,14),
(320,14),
(321,14),
(322,14),
(323,14),
(324,14),
(325,14),
(326,14),
(327,14),
(328,14),
(329,14),
(330,14),
(331,14),
(332,14),
(333,14),
(334,14),
(335,14),
(336,14),
(337,14),
(338,14),
(339,14),
(340,14),
(341,14),
(342,14),
(343,14),
(344,14),
(345,14),
(346,14),
(347,14),
(348,14),
(349,14),
(350,14),
(351,14),
(352,14),
(353,14),
(356,14),
(357,14),
(358,14),
(359,14),
(360,14),
(361,14),
(362,14),
(363,14),
(364,14),
(365,14),
(366,14),
(367,14),
(368,14),
(369,14),
(370,14),
(371,14),
(372,14),
(373,14),
(374,14),
(375,14),
(376,14),
(377,14),
(378,14),
(379,14),
(380,14),
(381,14),
(382,14),
(383,14),
(384,14),
(385,14),
(386,14),
(387,14),
(388,14),
(389,14),
(390,14),
(391,14),
(392,14),
(398,14),
(403,14),
(404,14),
(405,14),
(406,14),
(407,14),
(408,14),
(409,14),
(410,14),
(411,14),
(412,14),
(413,14),
(414,14),
(415,14),
(416,14),
(417,14),
(418,14),
(419,14),
(420,14),
(421,14),
(422,14),
(423,14),
(424,14),
(425,14),
(426,14),
(427,14),
(428,14),
(429,14),
(430,14),
(431,14),
(432,14),
(433,14),
(434,14),
(435,14),
(436,14),
(437,14),
(438,14),
(439,14),
(440,14),
(441,14),
(442,14),
(443,14),
(444,14),
(445,14),
(446,14),
(447,14),
(448,14),
(449,14),
(450,14),
(451,14),
(452,14),
(453,14),
(454,14),
(455,14),
(456,14),
(457,14),
(458,14),
(459,14),
(460,14),
(461,14),
(462,14),
(463,14),
(464,14),
(465,14),
(466,14),
(467,14),
(468,14),
(469,14),
(470,14),
(471,14),
(472,14),
(473,14),
(474,14),
(475,14),
(476,14),
(477,14),
(478,14),
(479,14),
(480,14),
(481,14),
(482,14),
(483,14),
(484,14),
(485,14),
(486,14),
(487,14),
(488,14),
(489,14),
(490,14),
(491,14),
(492,14),
(493,14),
(494,14),
(495,14),
(496,14),
(497,14),
(498,14),
(499,14),
(500,14),
(501,14),
(502,14),
(503,14),
(504,14),
(505,14),
(506,14),
(507,14),
(508,14),
(509,14),
(510,14),
(511,14),
(512,14),
(513,14),
(515,14),
(516,14),
(517,14),
(518,14),
(519,14),
(520,14),
(521,14),
(522,14),
(523,14),
(524,14),
(525,14),
(526,14),
(527,14),
(528,14),
(529,14),
(530,14),
(531,14),
(532,14),
(533,14),
(534,14),
(535,14),
(536,14),
(537,14),
(538,14),
(539,14),
(541,14),
(542,14),
(543,14),
(544,14),
(545,14),
(546,14),
(547,14),
(548,14),
(549,14),
(550,14),
(551,14),
(552,14),
(553,14),
(554,14),
(555,14),
(556,14),
(557,14),
(559,14),
(560,14),
(561,14),
(562,14),
(563,14),
(564,14),
(565,14),
(566,14),
(567,14),
(568,14),
(569,14),
(570,14),
(571,14),
(572,14),
(573,14),
(574,14),
(575,14),
(576,14),
(577,14),
(578,14),
(579,14),
(580,14),
(581,14),
(582,14),
(583,14),
(584,14),
(585,14),
(586,14),
(587,14),
(588,14),
(589,14),
(590,14),
(591,14),
(592,14),
(593,14),
(594,14),
(595,14),
(596,14),
(597,14),
(598,14),
(599,14),
(600,14),
(601,14),
(602,14),
(603,14),
(604,14),
(605,14),
(606,14),
(607,14),
(608,14),
(609,14),
(610,14),
(611,14),
(612,14),
(613,14),
(614,14),
(615,14),
(616,14),
(617,14),
(618,14),
(619,14),
(620,14),
(621,14),
(622,14),
(623,14),
(624,14),
(625,14),
(626,14),
(627,14),
(723,14),
(724,14),
(725,14),
(726,14),
(727,14),
(728,14),
(729,14),
(730,14),
(731,14),
(732,14),
(733,14),
(734,14),
(735,14),
(736,14),
(737,14),
(738,14),
(739,14),
(740,14),
(741,14),
(742,14),
(743,14),
(744,14),
(745,14),
(746,14),
(747,14),
(748,14),
(749,14),
(750,14),
(751,14),
(752,14),
(753,14),
(754,14),
(755,14),
(756,14),
(757,14),
(758,14),
(759,14),
(760,14),
(761,14),
(762,14),
(763,14),
(764,14),
(765,14),
(766,14),
(767,14),
(768,14),
(769,14),
(770,14),
(771,14),
(772,14),
(773,14),
(774,14),
(775,14),
(776,14),
(777,14),
(778,14),
(779,14),
(780,14),
(781,14),
(782,14),
(783,14),
(784,14),
(785,14),
(786,14),
(787,14),
(788,14),
(793,14),
(794,14),
(795,14),
(796,14),
(797,14),
(798,14),
(799,14),
(800,14),
(801,14),
(802,14),
(803,14),
(804,14),
(805,14),
(806,14),
(807,14),
(808,14),
(809,14),
(810,14),
(811,14),
(812,14),
(813,14),
(814,14),
(815,14),
(816,14),
(817,14),
(818,14),
(819,14),
(820,14),
(821,14),
(822,14),
(823,14),
(824,14),
(825,14),
(826,14),
(827,14),
(828,14),
(829,14),
(830,14),
(831,14),
(832,14),
(833,14),
(834,14),
(835,14),
(840,14),
(841,14),
(842,14),
(843,14),
(844,14),
(847,14),
(848,14),
(849,14),
(850,14),
(851,14),
(852,14),
(853,14),
(854,14),
(855,14),
(856,14),
(857,14),
(858,14),
(859,14),
(860,14),
(861,14),
(862,14),
(863,14),
(864,14),
(865,14),
(866,14),
(867,14),
(868,14),
(869,14),
(870,14),
(871,14),
(872,14),
(873,14),
(874,14),
(875,14),
(876,14),
(877,14),
(878,14),
(879,14),
(880,14),
(881,14),
(882,14),
(883,14),
(884,14),
(885,14),
(886,14),
(887,14),
(888,14),
(889,14),
(890,14),
(895,14),
(896,14),
(82,12),
(85,12),
(112,12),
(264,12),
(270,12),
(273,12),
(280,12),
(281,12),
(283,12),
(284,12),
(566,12),
(567,12),
(568,12),
(569,12),
(580,12),
(609,12),
(610,12),
(611,12),
(612,12),
(613,12),
(614,12),
(615,12),
(618,12),
(620,12),
(621,12),
(622,12),
(623,12),
(624,12),
(721,12),
(722,12),
(82,2),
(85,2),
(112,2),
(285,2),
(286,2),
(289,2),
(291,2),
(294,2),
(296,2),
(299,2),
(349,2),
(352,2),
(373,2),
(413,2),
(414,2),
(416,2),
(420,2),
(421,2),
(439,2),
(440,2),
(441,2),
(442,2),
(443,2),
(459,2),
(461,2),
(462,2),
(463,2),
(464,2),
(465,2),
(475,2),
(515,2),
(516,2),
(517,2),
(518,2),
(520,2),
(538,2),
(539,2),
(727,2),
(728,2),
(729,2),
(730,2),
(731,2),
(732,2),
(736,2),
(82,10),
(85,10),
(112,10),
(115,10),
(264,10),
(268,10),
(270,10),
(273,10),
(280,10),
(283,10),
(349,10),
(352,10),
(418,10),
(568,10),
(580,10),
(609,10),
(610,10),
(611,10),
(612,10),
(613,10),
(615,10),
(618,10),
(620,10),
(621,10),
(622,10),
(623,10),
(82,8),
(85,8),
(112,8),
(115,8),
(258,8),
(261,8),
(349,8),
(352,8),
(418,8),
(82,5),
(85,5),
(285,5),
(286,5),
(287,5),
(288,5),
(289,5),
(290,5),
(291,5),
(292,5),
(293,5),
(294,5),
(295,5),
(296,5),
(297,5),
(298,5),
(299,5),
(300,5),
(373,5),
(374,5),
(375,5),
(376,5),
(377,5),
(388,5),
(389,5),
(390,5),
(391,5),
(392,5),
(420,5),
(421,5),
(422,5),
(423,5),
(424,5),
(425,5),
(426,5),
(427,5),
(428,5),
(429,5),
(430,5),
(431,5),
(432,5),
(433,5),
(434,5),
(435,5),
(436,5),
(437,5),
(440,5),
(441,5),
(442,5),
(443,5),
(444,5),
(445,5),
(446,5),
(447,5),
(448,5),
(449,5),
(450,5),
(451,5),
(452,5),
(453,5),
(454,5),
(455,5),
(456,5),
(457,5),
(459,5),
(462,5),
(463,5),
(464,5),
(465,5),
(515,5),
(516,5),
(517,5),
(520,5),
(521,5),
(522,5),
(523,5),
(524,5),
(525,5),
(526,5),
(527,5),
(528,5),
(529,5),
(530,5),
(531,5),
(532,5),
(533,5),
(534,5),
(535,5),
(536,5),
(537,5),
(538,5),
(539,5),
(553,5),
(554,5),
(555,5),
(556,5),
(32,7),
(82,7),
(85,7),
(112,7),
(115,7),
(132,7),
(133,7),
(134,7),
(135,7),
(136,7),
(137,7),
(138,7),
(139,7),
(140,7),
(141,7),
(147,7),
(148,7),
(149,7),
(151,7),
(233,7),
(234,7),
(235,7),
(236,7),
(237,7),
(349,7),
(352,7),
(22,6),
(25,6),
(82,6),
(85,6),
(92,6),
(102,6),
(103,6),
(104,6),
(105,6),
(106,6),
(107,6),
(108,6),
(109,6),
(110,6),
(111,6),
(264,6),
(270,6),
(271,6),
(272,6),
(273,6),
(274,6),
(349,6),
(352,6),
(566,6),
(569,6),
(609,6),
(610,6),
(611,6),
(612,6),
(613,6),
(625,6),
(626,6),
(627,6),
(649,6),
(82,4),
(85,4),
(132,4),
(133,4),
(134,4),
(136,4),
(137,4),
(138,4),
(139,4),
(141,4),
(147,4),
(148,4),
(149,4),
(151,4),
(258,4),
(259,4),
(260,4),
(262,4),
(285,4),
(286,4),
(287,4),
(288,4),
(289,4),
(290,4),
(291,4),
(292,4),
(293,4),
(294,4),
(295,4),
(296,4),
(297,4),
(298,4),
(299,4),
(300,4),
(321,4),
(338,4),
(373,4),
(374,4),
(375,4),
(376,4),
(377,4),
(388,4),
(389,4),
(390,4),
(391,4),
(392,4),
(413,4),
(414,4),
(415,4),
(416,4),
(417,4),
(420,4),
(421,4),
(422,4),
(423,4),
(424,4),
(425,4),
(426,4),
(427,4),
(434,4),
(435,4),
(436,4),
(437,4),
(440,4),
(441,4),
(442,4),
(443,4),
(444,4),
(445,4),
(446,4),
(451,4),
(452,4),
(453,4),
(454,4),
(455,4),
(456,4),
(457,4),
(459,4),
(462,4),
(463,4),
(464,4),
(465,4),
(474,4),
(515,4),
(516,4),
(517,4),
(520,4),
(521,4),
(523,4),
(524,4),
(525,4),
(526,4),
(527,4),
(528,4),
(534,4),
(535,4),
(536,4),
(537,4),
(538,4),
(539,4),
(541,4),
(542,4),
(543,4),
(544,4),
(545,4),
(547,4),
(548,4),
(549,4),
(550,4),
(551,4),
(553,4),
(554,4),
(555,4),
(556,4),
(735,2),
(37,3),
(40,3),
(41,3),
(52,3),
(53,3),
(54,3),
(55,3),
(56,3),
(57,3),
(60,3),
(61,3),
(82,3),
(85,3),
(112,3),
(132,3),
(133,3),
(134,3),
(135,3),
(136,3),
(137,3),
(138,3),
(139,3),
(140,3),
(141,3),
(147,3),
(148,3),
(149,3),
(150,3),
(151,3),
(223,3),
(224,3),
(225,3),
(226,3),
(227,3),
(233,3),
(234,3),
(235,3),
(236,3),
(237,3),
(258,3),
(259,3),
(260,3),
(261,3),
(262,3),
(270,3),
(273,3),
(274,3),
(285,3),
(286,3),
(287,3),
(288,3),
(289,3),
(290,3),
(291,3),
(292,3),
(293,3),
(294,3),
(295,3),
(296,3),
(297,3),
(298,3),
(299,3),
(300,3),
(321,3),
(373,3),
(374,3),
(375,3),
(376,3),
(377,3),
(388,3),
(389,3),
(390,3),
(391,3),
(392,3),
(398,3),
(420,3),
(421,3),
(422,3),
(423,3),
(424,3),
(425,3),
(426,3),
(427,3),
(434,3),
(435,3),
(436,3),
(437,3),
(440,3),
(441,3),
(442,3),
(444,3),
(445,3),
(446,3),
(447,3),
(448,3),
(449,3),
(450,3),
(451,3),
(452,3),
(453,3),
(454,3),
(455,3),
(456,3),
(457,3),
(458,3),
(459,3),
(462,3),
(463,3),
(464,3),
(465,3),
(515,3),
(516,3),
(517,3),
(520,3),
(521,3),
(522,3),
(523,3),
(524,3),
(525,3),
(526,3),
(527,3),
(528,3),
(534,3),
(535,3),
(536,3),
(537,3),
(538,3),
(539,3),
(545,3),
(548,3),
(549,3),
(609,3),
(610,3),
(611,3),
(612,3),
(613,3),
(338,3),
(341,3),
(342,3),
(625,3),
(569,3),
(580,3),
(344,3),
(345,3),
(349,3),
(352,3),
(626,3),
(746,2),
(749,2),
(765,2),
(767,2),
(768,2),
(769,2),
(770,2),
(771,2),
(827,2),
(867,2),
(870,2),
(871,2),
(872,2),
(873,2),
(834,2),
(815,2),
(847,2),
(848,2);

/*Table structure for table `acrm_permissions` */

DROP TABLE IF EXISTS `acrm_permissions`;

CREATE TABLE `acrm_permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status` enum('active','inactive') COLLATE utf8mb4_unicode_ci DEFAULT 'active',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=898 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_permissions` */

insert  into `acrm_permissions`(`id`,`title`,`module`,`created_at`,`updated_at`,`status`) values 
(1,'user_management_access','Users','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(2,'permission_access','Permissions','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(3,'permission_create','Permissions','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(4,'permission_edit','Permissions','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(5,'permission_view','Permissions','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(6,'permission_delete','Permissions','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(7,'role_access','Roles','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(8,'role_create','Roles','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(9,'role_edit','Roles','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(10,'role_view','Roles','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(11,'role_delete','Roles','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(12,'user_access','Users','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(13,'user_create','Users','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(14,'user_edit','Users','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(15,'user_view','Users','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(16,'user_delete','Users','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(17,'user_action_access','Users','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(18,'user_action_create','Users','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(19,'user_action_edit','Users','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(20,'user_action_view','Users','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(21,'user_action_delete','Users','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(22,'contact_management_access','Contacts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(23,'contact_management_create','Contacts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(24,'contact_management_edit','Contacts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(25,'contact_management_view','Contacts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(26,'contact_management_delete','Contacts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(27,'contact_company_access','Contacts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(28,'contact_company_create','Contacts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(29,'contact_company_edit','Contacts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(30,'contact_company_view','Contacts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(31,'contact_company_delete','Contacts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(32,'contact_access','Contacts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(33,'contact_create','Contacts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(34,'contact_edit','Contacts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(35,'contact_view','Contacts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(36,'contact_delete','Contacts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(37,'expense_management_access','Expenses','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(38,'expense_management_create','Expenses','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(39,'expense_management_edit','Expenses','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(40,'expense_management_view','Expenses','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(41,'expense_management_delete','Expenses','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(42,'expense_category_access','Expenses','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(43,'expense_category_create','Expenses','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(44,'expense_category_edit','Expenses','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(45,'expense_category_view','Expenses','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(46,'expense_category_delete','Expenses','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(47,'income_category_access','Income','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(48,'income_category_create','Income','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(49,'income_category_edit','Income','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(50,'income_category_view','Income','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(51,'income_category_delete','Income','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(52,'income_access','Income','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(53,'income_create','Income','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(54,'income_edit','Income','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(55,'income_view','Income','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(56,'income_delete','Income','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(57,'expense_access','Expenses','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(58,'expense_create','Expenses','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(59,'expense_edit','Expenses','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(60,'expense_view','Expenses','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(61,'expense_delete','Expenses','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(62,'monthly_report_access','Monthly reports','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(63,'monthly_report_create','Monthly reports','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(64,'monthly_report_edit','Monthly reports','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(65,'monthly_report_view','Monthly reports','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(66,'monthly_report_delete','Monthly reports','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(67,'faq_management_access','FAQ management','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(68,'faq_management_create','FAQ management','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(69,'faq_management_edit','FAQ management','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(70,'faq_management_view','FAQ management','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(71,'faq_management_delete','FAQ management','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(72,'faq_category_access','FAQ categories','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(73,'faq_category_create','FAQ categories','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(74,'faq_category_edit','FAQ categories','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(75,'faq_category_view','FAQ categories','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(76,'faq_category_delete','FAQ categories','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(77,'faq_question_access','FAQs','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(78,'faq_question_create','FAQs','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(79,'faq_question_edit','FAQs','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(80,'faq_question_view','FAQs','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(81,'faq_question_delete','FAQs','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(82,'internal_notification_access','Quick notifications','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(83,'internal_notification_create','Quick notifications','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(84,'internal_notification_edit','Quick notifications','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(85,'internal_notification_view','Quick notifications','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(86,'internal_notification_delete','Quick notifications','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(87,'task_status_access','Tasks','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(88,'task_status_create','Tasks','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(89,'task_status_edit','Tasks','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(90,'task_status_view','Tasks','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(91,'task_status_delete','Tasks','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(92,'task_management_access','Tasks','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(93,'task_management_create','Tasks','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(94,'task_management_edit','Tasks','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(95,'task_management_view','Tasks','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(96,'task_management_delete','Tasks','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(97,'task_tag_access','Tasks','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(98,'task_tag_create','Tasks','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(99,'task_tag_edit','Tasks','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(100,'task_tag_view','Tasks','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(101,'task_tag_delete','Tasks','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(102,'task_access','Tasks','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(103,'task_create','Tasks','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(104,'task_edit','Tasks','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(105,'task_view','Tasks','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(106,'task_delete','Tasks','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(107,'task_calendar_access','Tasks','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(108,'task_calendar_create','Tasks','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(109,'task_calendar_edit','Tasks','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(110,'task_calendar_view','Tasks','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(111,'task_calendar_delete','Tasks','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(112,'content_management_access','Content management','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(113,'content_management_create','Content management','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(114,'content_management_edit','Content management','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(115,'content_management_view','Content management','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(116,'content_management_delete','Content management','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(117,'content_category_access','Content categories','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(118,'content_category_create','Content categories','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(119,'content_category_edit','Content categories','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(120,'content_category_view','Content categories','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(121,'content_category_delete','Content categories','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(122,'content_tag_access','Page tags','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(123,'content_tag_create','Page tags','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(124,'content_tag_edit','Page tags','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(125,'content_tag_view','Page tags','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(126,'content_tag_delete','Page tags','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(127,'content_page_access','Pages','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(128,'content_page_create','Pages','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(129,'content_page_edit','Pages','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(130,'content_page_view','Pages','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(131,'content_page_delete','Pages','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(132,'product_management_access','Products/Items','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(133,'product_management_create','Products/Items','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(134,'product_management_edit','Products/Items','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(135,'product_management_view','Products/Items','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(136,'product_management_delete','Products/Items','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(137,'product_category_access','Products/Items','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(138,'product_category_create','Products/Items','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(139,'product_category_edit','Products/Items','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(140,'product_category_view','Products/Items','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(141,'product_category_delete','Products/Items','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(142,'product_tag_access','Products/Items','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(143,'product_tag_create','Products/Items','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(144,'product_tag_edit','Products/Items','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(145,'product_tag_view','Products/Items','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(146,'product_tag_delete','Products/Items','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(147,'product_access','Products/Items','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(148,'product_create','Products/Items','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(149,'product_edit','Products/Items','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(150,'product_view','Products/Items','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(151,'product_delete','Products/Items','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(152,'assets_category_access','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(153,'assets_category_create','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(154,'assets_category_edit','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(155,'assets_category_view','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(156,'assets_category_delete','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(157,'assets_management_access','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(158,'assets_management_create','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(159,'assets_management_edit','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(160,'assets_management_view','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(161,'assets_management_delete','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(162,'assets_status_access','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(163,'assets_status_create','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(164,'assets_status_edit','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(165,'assets_status_view','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(166,'assets_status_delete','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(167,'assets_location_access','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(168,'assets_location_create','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(169,'assets_location_edit','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(170,'assets_location_view','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(171,'assets_location_delete','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(172,'asset_access','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(173,'asset_create','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(174,'asset_edit','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(175,'asset_view','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(176,'asset_delete','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(177,'assets_history_access','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(178,'assets_history_create','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(179,'assets_history_edit','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(180,'assets_history_view','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(181,'assets_history_delete','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(182,'coupon_management_access','Coupons','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(183,'coupon_management_create','Coupons','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(184,'coupon_management_edit','Coupons','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(185,'coupon_management_view','Coupons','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(186,'coupon_management_delete','Coupons','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(187,'coupon_campaign_access','Coupons','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(188,'coupon_campaign_create','Coupons','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(189,'coupon_campaign_edit','Coupons','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(190,'coupon_campaign_view','Coupons','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(191,'coupon_campaign_delete','Coupons','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(192,'coupon_access','Coupons','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(193,'coupon_create','Coupons','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(194,'coupon_edit','Coupons','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(195,'coupon_view','Coupons','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(196,'coupon_delete','Coupons','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(202,'global_setting_access','Settings','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(203,'currency_access','Currencies','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(204,'currency_create','Currencies','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(205,'currency_edit','Currencies','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(206,'currency_view','Currencies','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(207,'currency_delete','Currencies','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(213,'email_template_access','Email templates','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(214,'email_template_create','Email templates','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(215,'email_template_edit','Email templates','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(216,'email_template_view','Email templates','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(217,'email_template_delete','Email templates','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(218,'company_access','Companies','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(219,'company_create','Companies','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(220,'company_edit','Companies','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(221,'company_view','Companies','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(222,'company_delete','Companies','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(223,'account_access','Accounts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(224,'account_create','Accounts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(225,'account_edit','Accounts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(226,'account_view','Accounts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(227,'account_delete','Accounts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(228,'payment_gateway_access','Payment gateways','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(229,'payment_gateway_create','Payment gateways','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(230,'payment_gateway_edit','Payment gateways','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(231,'payment_gateway_view','Payment gateways','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(232,'payment_gateway_delete','Payment gateways','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(233,'warehouse_access','Warehouses','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(234,'warehouse_create','Warehouses','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(235,'warehouse_edit','Warehouses','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(236,'warehouse_view','Warehouses','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(237,'warehouse_delete','Warehouses','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(238,'tax_access','Tax','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(239,'tax_create','Tax','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(240,'tax_edit','Tax','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(241,'tax_view','Tax','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(242,'tax_delete','Tax','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(243,'discount_access','Discounts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(244,'discount_create','Discounts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(245,'discount_edit','Discounts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(246,'discount_view','Discounts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(247,'discount_delete','Discounts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(248,'recurring_period_access','Recurring periods','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(249,'recurring_period_create','Recurring periods','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(250,'recurring_period_edit','Recurring periods','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(251,'recurring_period_view','Recurring periods','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(252,'recurring_period_delete','Recurring periods','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(253,'language_access','Languages','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(254,'language_create','Languages','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(255,'language_edit','Languages','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(256,'language_view','Languages','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(257,'language_delete','Languages','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(258,'purchase_order_access','Purchase orders','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(259,'purchase_order_create','Purchase orders','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(260,'purchase_order_edit','Purchase orders','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(261,'purchase_order_view','Purchase orders','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(262,'purchase_order_delete','Purchase orders','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(264,'project_access','Projects','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(265,'project_status_access','Project status','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(266,'project_status_create','Project status','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(267,'project_status_edit','Project status','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(268,'project_status_view','Project status','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(269,'project_status_delete','Project status','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(270,'client_project_access','Projects','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(271,'client_project_create','Projects','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(272,'client_project_edit','Projects','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(273,'client_project_view','Projects','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(274,'client_project_delete','Projects','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(275,'project_billing_type_access','Project billing types','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(276,'project_billing_type_create','Project billing types','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(277,'project_billing_type_edit','Project billing types','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(278,'project_billing_type_view','Project billing types','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(279,'project_billing_type_delete','Project billing types','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(280,'time_entry_access','Time entry','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(281,'time_entry_create','Time entry','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(282,'time_entry_edit','Time entry','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(283,'time_entry_view','Time entry','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(284,'time_entry_delete','Time entry','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(285,'sale_access',NULL,'2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(286,'invoice_access','Invoices','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(287,'invoice_create','Invoices','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(288,'invoice_edit','Invoices','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(289,'invoice_view','Invoices','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(290,'invoice_delete','Invoices','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(291,'quote_access','Quotes','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(292,'quote_create','Quotes','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(293,'quote_edit','Quotes','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(294,'quote_view','Quotes','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(295,'quote_delete','Quotes','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(296,'recurring_invoice_access','Recurring invoices','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(297,'recurring_invoice_create','Recurring invoices','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(298,'recurring_invoice_edit','Recurring invoices','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(299,'recurring_invoice_view','Recurring invoices','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(300,'recurring_invoice_delete','Recurring invoices','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(301,'contact_group_access','Contacts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(302,'contact_group_create','Contacts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(303,'contact_group_edit','Contacts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(304,'contact_group_view','Contacts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(305,'contact_group_delete','Contacts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(306,'contact_type_access','Contacts','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(307,'contact_type_create','Contacts','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(308,'contact_type_edit','Contacts','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(309,'contact_type_view','Contacts','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(310,'contact_type_delete','Contacts','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(311,'contact_note_access','Contacts','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(312,'contact_note_create','Contacts','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(313,'contact_note_edit','Contacts','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(314,'contact_note_view','Contacts','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(315,'contact_note_delete','Contacts','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(316,'contact_document_access','Contacts','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(317,'contact_document_create','Contacts','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(318,'contact_document_edit','Contacts','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(319,'contact_document_view','Contacts','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(320,'contact_document_delete','Contacts','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(321,'products_transfer_access','Products/Items','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(322,'products_return_access','Products/Items','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(323,'products_return_create','Products/Items','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(324,'products_return_edit','Products/Items','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(325,'products_return_view','Products/Items','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(326,'products_return_delete','Products/Items','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(327,'brand_access','Brands','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(328,'brand_create','Brands','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(329,'brand_edit','Brands','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(330,'brand_view','Brands','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(331,'brand_delete','Brands','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(332,'database_backup_access','Backups','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(333,'department_access','Departments','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(334,'department_create','Departments','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(335,'department_edit','Departments','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(336,'department_view','Departments','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(337,'department_delete','Departments','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(338,'support_access','Support','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(339,'support_create','Support','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(340,'support_edit','Support','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(341,'support_view','Support','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(342,'support_delete','Support','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(343,'knowledgebase_access','Support','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(344,'transfer_access','Transfers','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(345,'transfer_create','Transfers','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(346,'transfer_edit','Transfers','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(347,'transfer_view','Transfers','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(348,'transfer_delete','Transfers','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(349,'article_access','Articles','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(350,'article_create','Articles','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(351,'article_edit','Articles','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(352,'article_view','Articles','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(353,'article_delete','Articles','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(356,'master_setting_access','Settings','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(357,'master_setting_create','Settings','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(358,'master_setting_edit','Settings','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(359,'master_setting_view','Settings','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(360,'master_setting_delete','Settings','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(361,'country_access','Countries','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(362,'country_create','Countries','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(363,'country_edit','Countries','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(364,'country_view','Countries','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(365,'country_delete','Countries','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(366,'translation_manager','Translations','2019-01-31 07:09:40','2019-01-31 07:09:40','active'),
(367,'measurement_unit_access','Measurement units',NULL,NULL,'active'),
(368,'measurement_unit_create','Measurement units',NULL,NULL,'active'),
(369,'measurement_unit_edit','Measurement units',NULL,NULL,'active'),
(370,'measurement_unit_view','Measurement units',NULL,NULL,'active'),
(371,'measurement_unit_delete','Measurement units',NULL,NULL,'active'),
(372,'general_setting_access','Settings',NULL,NULL,'active'),
(373,'invoice_payment_access','Invoices',NULL,NULL,'active'),
(374,'invoice_payment_create','Invoices',NULL,NULL,'active'),
(375,'invoice_payment_edit','Invoices',NULL,NULL,'active'),
(376,'invoice_payment_view','Invoices',NULL,NULL,'active'),
(377,'invoice_payment_delete','Invoices',NULL,NULL,'active'),
(378,'template_access','Templates',NULL,NULL,'active'),
(379,'template_create','Templates',NULL,NULL,'active'),
(380,'template_edit','Templates',NULL,NULL,'active'),
(381,'template_view','Templates',NULL,NULL,'active'),
(382,'template_delete','Templates',NULL,NULL,'active'),
(383,'smstemplate_access','SMS templates',NULL,NULL,'active'),
(384,'smstemplate_create','SMS templates',NULL,NULL,'active'),
(385,'smstemplate_edit','SMS templates',NULL,NULL,'active'),
(386,'smstemplate_view','SMS templates',NULL,NULL,'active'),
(387,'smstemplate_delete','SMS templates',NULL,NULL,'active'),
(388,'recurring_invoice_payment_access','Recurring invoices',NULL,NULL,'active'),
(389,'recurring_invoice_payment_create','Recurring invoices',NULL,NULL,'active'),
(390,'recurring_invoice_payment_edit','Recurring invoices',NULL,NULL,'active'),
(391,'recurring_invoice_payment_view','Recurring invoices',NULL,NULL,'active'),
(392,'recurring_invoice_payment_delete','Recurring invoices',NULL,NULL,'active'),
(398,'income_receipt','Income',NULL,NULL,'active'),
(403,'supplier_access','Suppliers','2019-02-26 04:10:09','2019-02-26 04:10:09','active'),
(404,'supplier_create','Suppliers','2019-02-26 04:10:22','2019-02-26 04:10:22','active'),
(405,'supplier_edit','Suppliers','2019-02-26 04:10:53','2019-02-26 04:10:53','active'),
(406,'supplier_view','Suppliers','2019-02-26 04:11:05','2019-02-26 04:11:05','active'),
(407,'supplier_delete','Suppliers','2019-02-26 04:11:20','2019-02-26 04:11:20','active'),
(408,'lead_access','Leads','2019-02-26 05:51:43','2019-02-26 05:51:43','active'),
(409,'lead_create','Leads','2019-02-26 05:51:55','2019-02-26 05:51:55','active'),
(410,'lead_edit','Leads','2019-02-26 05:52:06','2019-02-26 05:52:06','active'),
(411,'lead_view','Leads','2019-02-26 05:52:22','2019-02-26 05:52:22','active'),
(412,'lead_delete','Leads','2019-02-26 05:52:33','2019-02-26 05:52:33','active'),
(413,'order_access','Orders','2019-02-27 04:20:06','2019-02-27 04:20:06','active'),
(414,'order_create','Orders','2019-02-27 04:20:48','2019-02-27 04:20:48','active'),
(415,'order_edit','Orders','2019-02-27 04:20:57','2019-02-27 04:20:57','active'),
(416,'order_view','Orders','2019-02-27 04:21:05','2019-02-27 04:21:05','active'),
(417,'order_delete','Orders','2019-02-27 04:21:13','2019-02-27 04:21:13','active'),
(418,'profile_edit','Profile','2019-02-27 06:49:00','2019-02-27 06:49:00','active'),
(419,'order_cancel','Orders','2019-02-27 09:36:32','2019-02-27 09:36:32','active'),
(420,'invoice_preview','Invoices',NULL,NULL,'active'),
(421,'invoice_make_payment','Invoices',NULL,NULL,'active'),
(422,'invoice_email_access','Invoices',NULL,NULL,'active'),
(423,'invoice_email_created','Invoices',NULL,NULL,'active'),
(424,'invoice_email_reminder','Invoices',NULL,NULL,'active'),
(425,'invoice_email_received','Invoices',NULL,NULL,'active'),
(426,'invoice_email_overdue','Invoices',NULL,NULL,'active'),
(427,'invoice_email_refund','Invoices',NULL,NULL,'active'),
(428,'invoice_sms_access','Invoices',NULL,NULL,'active'),
(429,'invoice_sms_created','Invoices',NULL,NULL,'active'),
(430,'invoice_sms_reminder','Invoices',NULL,NULL,'active'),
(431,'invoice_sms_received','Invoices',NULL,NULL,'active'),
(432,'invoice_sms_overdue','Invoices',NULL,NULL,'active'),
(433,'invoice_sms_refund','Invoices',NULL,NULL,'active'),
(434,'invoice_changestatus_paid','Invoices',NULL,NULL,'active'),
(435,'invoice_changestatus_due','Invoices',NULL,NULL,'active'),
(436,'invoice_changestatus_partial','Invoices',NULL,NULL,'active'),
(437,'invoice_changestatus_cancelled','Invoices',NULL,NULL,'active'),
(438,'invoice_duplicate','Invoices',NULL,NULL,'active'),
(439,'invoice_uploads','Invoices',NULL,NULL,'active'),
(440,'invoice_pdf_access','Invoices',NULL,NULL,'active'),
(441,'invoice_pdf_view','Invoices',NULL,NULL,'active'),
(442,'invoice_pdf_download','Invoices',NULL,NULL,'active'),
(443,'invoice_print','Invoices',NULL,NULL,'active'),
(444,'invoice_changestatus_access','Invoices',NULL,NULL,'active'),
(445,'quote_email_access','Quotes',NULL,NULL,'active'),
(446,'quote_email_created','Quotes',NULL,NULL,'active'),
(447,'quote_sms_access','Quotes',NULL,NULL,'active'),
(448,'quote_sms_created','Quotes',NULL,NULL,'active'),
(449,'quote_sms_accepted','Quotes',NULL,NULL,'active'),
(450,'quote_sms_cancelled','Quotes',NULL,NULL,'active'),
(451,'quote_changestatus_access','Quotes',NULL,NULL,'active'),
(452,'quote_changestatus_delivered','Quotes',NULL,NULL,'active'),
(453,'quote_changestatus_onhold','Quotes',NULL,NULL,'active'),
(454,'quote_changestatus_accepted','Quotes',NULL,NULL,'active'),
(455,'quote_changestatus_rejected','Quotes',NULL,NULL,'active'),
(456,'quote_changestatus_lost','Quotes',NULL,NULL,'active'),
(457,'quote_changestatus_dead','Quotes',NULL,NULL,'active'),
(458,'quote_convertinvoice','Quotes',NULL,NULL,'active'),
(459,'quote_preview','Quotes',NULL,NULL,'active'),
(460,'quote_duplicate','Quotes',NULL,NULL,'active'),
(461,'quote_upload','Quotes',NULL,NULL,'active'),
(462,'quote_pdf_access','Quotes',NULL,NULL,'active'),
(463,'quote_pdf_view','Quotes',NULL,NULL,'active'),
(464,'quote_pdf_download','Quotes',NULL,NULL,'active'),
(465,'quote_print','Quotes',NULL,NULL,'active'),
(466,'reports_access','Reports',NULL,NULL,'active'),
(467,'reports_expense_access','Reports',NULL,NULL,'active'),
(468,'reports_income_access','Reports',NULL,NULL,'active'),
(469,'reports_users_access','Reports',NULL,NULL,'active'),
(470,'reports_projects_access','Reports',NULL,NULL,'active'),
(471,'reports_tasks_access','Reports',NULL,NULL,'active'),
(472,'reports_assets_access','Reports',NULL,NULL,'active'),
(473,'reports_products_access','Reports',NULL,NULL,'active'),
(474,'reports_purchase_access','Reports',NULL,NULL,'active'),
(475,'customer_access','Customers',NULL,NULL,'active'),
(476,'customer_create','Customers',NULL,NULL,'active'),
(477,'customer_edit','Customers',NULL,NULL,'active'),
(478,'customer_delete','Customers',NULL,NULL,'active'),
(479,'customer_view','Customers',NULL,NULL,'active'),
(480,'navigation_menue_access','Menu',NULL,NULL,'active'),
(481,'database_backup_access','Backups',NULL,NULL,'active'),
(482,'database_backup_create','Backups',NULL,NULL,'active'),
(483,'database_backup_edit','Backups',NULL,NULL,'active'),
(484,'database_backup_delete','Backups',NULL,NULL,'active'),
(485,'database_backup_view','Backups',NULL,NULL,'active'),
(486,'site_theme_access','Site themes','2019-03-13 11:51:30','2019-03-13 11:51:30','active'),
(487,'site_theme_create','Site themes','2019-03-13 11:51:40','2019-03-13 11:51:40','active'),
(488,'site_theme_edit','Site themes','2019-03-13 11:51:52','2019-03-13 11:51:52','active'),
(489,'site_theme_delete','Site themes',NULL,NULL,'active'),
(490,'site_theme_view','Site themes',NULL,NULL,'active'),
(491,'site_theme_settings','Site themes',NULL,NULL,'active'),
(492,'site_theme_change','Site themes',NULL,NULL,'active'),
(493,'modules_management_access','Plugins',NULL,NULL,'active'),
(494,'modules_management_create','Plugins',NULL,NULL,'active'),
(495,'modules_management_edit','Plugins',NULL,NULL,'active'),
(496,'modules_management_delete','Plugins',NULL,NULL,'active'),
(497,'modules_management_view','Plugins',NULL,NULL,'active'),
(498,'send_sm_access','SMS',NULL,NULL,'active'),
(499,'send_sm_create','SMS',NULL,NULL,'active'),
(500,'send_sm_edit','SMS',NULL,NULL,'active'),
(501,'send_sm_delete','SMS',NULL,NULL,'active'),
(502,'send_sm_view','SMS',NULL,NULL,'active'),
(503,'sms_gateway_access','SMS gateways',NULL,NULL,'active'),
(504,'sms_gateway_create','SMS gateways',NULL,NULL,'active'),
(505,'sms_gateway_edit','SMS gateways',NULL,NULL,'active'),
(506,'sms_gateway_delete','SMS gateways',NULL,NULL,'active'),
(507,'sms_gateway_view','SMS gateways',NULL,NULL,'active'),
(508,'modules_management_changestatus','Plugins',NULL,NULL,'active'),
(509,'site_plugin_settings','Site plugins',NULL,NULL,'active'),
(510,'currency_makedefault','Currencies',NULL,NULL,'active'),
(511,'user_change_status','Users',NULL,NULL,'active'),
(512,'user_can_change_theme','Users',NULL,NULL,'active'),
(513,'user_can_change_language','Users',NULL,NULL,'active'),
(515,'recurring_invoice_make_payment','Recurring invoices',NULL,NULL,'active'),
(516,'recurring_invoice_print','Recurring invoices',NULL,NULL,'active'),
(517,'recurring_invoice_pdf_access','Recurring invoices',NULL,NULL,'active'),
(518,'recurring_invoice_uploads','Recurring invoices',NULL,NULL,'active'),
(519,'recurring_invoice_duplicate','Recurring invoices',NULL,NULL,'active'),
(520,'recurring_invoice_preview','Recurring invoices',NULL,NULL,'active'),
(521,'recurring_invoice_changestatus_access','Recurring invoices',NULL,NULL,'active'),
(522,'recurring_invoice_sms_access','Recurring invoices',NULL,NULL,'active'),
(523,'recurring_invoice_email_access','Recurring invoices',NULL,NULL,'active'),
(524,'recurring_invoice_email_created','Recurring invoices',NULL,NULL,'active'),
(525,'recurring_invoice_email_reminder','Recurring invoices',NULL,NULL,'active'),
(526,'recurring_invoice_email_received','Recurring invoices',NULL,NULL,'active'),
(527,'recurring_invoice_email_overdue','Recurring invoices',NULL,NULL,'active'),
(528,'recurring_invoice_email_refund','Recurring invoices',NULL,NULL,'active'),
(529,'recurring_invoice_sms_created','Recurring invoices',NULL,NULL,'active'),
(530,'recurring_invoice_sms_reminder','Recurring invoices',NULL,NULL,'active'),
(531,'recurring_invoice_sms_received','Recurring invoices',NULL,NULL,'active'),
(532,'recurring_invoice_sms_overdue','Recurring invoices',NULL,NULL,'active'),
(533,'recurring_invoice_sms_refund','Recurring invoices',NULL,NULL,'active'),
(534,'recurring_invoice_changestatus_paid','Recurring invoices',NULL,NULL,'active'),
(535,'recurring_invoice_changestatus_due','Recurring invoices',NULL,NULL,'active'),
(536,'recurring_invoice_changestatus_partial','Recurring invoices',NULL,NULL,'active'),
(537,'recurring_invoice_changestatus_cancelled','Recurring invoices',NULL,NULL,'active'),
(538,'recurring_invoice_pdf_view','Recurring invoices',NULL,NULL,'active'),
(539,'recurring_invoice_pdf_download','Recurring invoices',NULL,NULL,'active'),
(541,'purchase_order_make_payment','Purchase orders',NULL,NULL,'active'),
(542,'purchase_order_email_access','Purchase orders',NULL,NULL,'active'),
(543,'purchase_order_sms_access','Purchase orders',NULL,NULL,'active'),
(544,'purchase_order_changestatus_access','Purchase orders',NULL,NULL,'active'),
(545,'purchase_order_preview','Purchase orders',NULL,NULL,'active'),
(546,'purchase_order_duplicate','Purchase orders',NULL,NULL,'active'),
(547,'purchase_order_uploads','Purchase orders',NULL,NULL,'active'),
(548,'purchase_order_pdf_access','Purchase orders',NULL,NULL,'active'),
(549,'purchase_order_print','Purchase orders',NULL,NULL,'active'),
(550,'purchase_order_sms_created','Purchase orders',NULL,NULL,'active'),
(551,'purchase_order_sms_accepted','Purchase orders',NULL,NULL,'active'),
(552,'purchase_order_sms_cancelled','Purchase orders',NULL,NULL,'active'),
(553,'invoice_changestatus_accepted','Invoices',NULL,NULL,'active'),
(554,'invoice_changestatus_hold','Invoices',NULL,NULL,'active'),
(555,'invoice_changestatus_rejected','Invoices',NULL,NULL,'active'),
(556,'invoice_changestatus_cancelled','Invoices',NULL,NULL,'active'),
(557,'delivery_address_edit','Contacts','2019-04-15 12:44:01','2019-04-15 12:45:41','active'),
(559,'shipping_address_edit','Shipping address',NULL,NULL,'active'),
(560,'quote_more_options','Quotes',NULL,NULL,'active'),
(561,'quote_task_access','Quotes',NULL,NULL,'active'),
(562,'quote_task_create','Quotes',NULL,NULL,'active'),
(563,'quote_task_edit','Quotes',NULL,NULL,'active'),
(564,'quote_task_view','Quotes',NULL,NULL,'active'),
(565,'quote_task_delete','Quotes',NULL,NULL,'active'),
(566,'mile_stone_create','Mile stones',NULL,NULL,'active'),
(567,'mile_stone_edit','Mile stones',NULL,NULL,'active'),
(568,'mile_stone_view','Mile stones',NULL,NULL,'active'),
(569,'mile_stone_delete','Mile stones',NULL,NULL,'active'),
(570,'quotes_note_create','Quotes',NULL,NULL,'active'),
(571,'quotes_note_edit','Quotes',NULL,NULL,'active'),
(572,'quotes_note_view','Quotes',NULL,NULL,'active'),
(573,'quotes_note_delete','Quotes',NULL,NULL,'active'),
(574,'quote_reminder_create','Quotes',NULL,NULL,'active'),
(575,'quote_reminder_edit','Quotes',NULL,NULL,'active'),
(576,'quote_reminder_view','Quotes',NULL,NULL,'active'),
(577,'quote_reminder_delete','Quotes',NULL,NULL,'active'),
(578,'quote_reminder_access','Quotes',NULL,NULL,'active'),
(579,'quotes_note_access','Quotes',NULL,NULL,'active'),
(580,'mile_stone_access','Mile stones',NULL,NULL,'active'),
(581,'quote_task_access','Quotes',NULL,NULL,'active'),
(582,'dynamic_option_access','Options',NULL,NULL,'active'),
(583,'dynamic_option_create','Options',NULL,NULL,'active'),
(584,'dynamic_option_edit','Options',NULL,NULL,'active'),
(585,'dynamic_option_view','Options',NULL,NULL,'active'),
(586,'dynamic_option_delete','Options',NULL,NULL,'active'),
(587,'invoice_note_access','Invoices',NULL,NULL,'active'),
(588,'invoice_note_create','Invoices',NULL,NULL,'active'),
(589,'invoice_note_edit','Invoices',NULL,NULL,'active'),
(590,'invoice_note_view','Invoices',NULL,NULL,'active'),
(591,'invoice_note_delete','Invoices',NULL,NULL,'active'),
(592,'invoice_more_options','Invoices',NULL,NULL,'active'),
(593,'invoice_reminder_access','Invoices',NULL,NULL,'active'),
(594,'invoice_reminder_create','Invoices',NULL,NULL,'active'),
(595,'invoice_reminder_edit','Invoices',NULL,NULL,'active'),
(596,'invoice_reminder_view','Invoices',NULL,NULL,'active'),
(597,'invoice_reminder_delete','Invoices',NULL,NULL,'active'),
(598,'invoice_task_access','Invoices',NULL,NULL,'active'),
(599,'invoice_task_create','Invoices',NULL,NULL,'active'),
(600,'invoice_task_edit','Invoices',NULL,NULL,'active'),
(601,'invoice_task_view','Invoices',NULL,NULL,'active'),
(602,'invoice_task_delete','Invoices',NULL,NULL,'active'),
(603,'project_tab_access','Project tabs',NULL,NULL,'active'),
(604,'project_tab_create','Project tabs',NULL,NULL,'active'),
(605,'project_tab_edit','Project tabs',NULL,NULL,'active'),
(606,'project_tab_view','Project tabs',NULL,NULL,'active'),
(607,'project_tab_delete','Project tabs',NULL,NULL,'active'),
(608,'client_project_duplicate','Projects',NULL,NULL,'active'),
(609,'project_task_access','Project tasks',NULL,NULL,'active'),
(610,'project_task_create','Project tasks',NULL,NULL,'active'),
(611,'project_task_edit','Project tasks',NULL,NULL,'active'),
(612,'project_task_view','Project tasks',NULL,NULL,'active'),
(613,'project_task_delete','Project tasks',NULL,NULL,'active'),
(614,'project_task_duplicate','Project tasks',NULL,NULL,'active'),
(615,'project_ticket_access','Project tickets',NULL,NULL,'active'),
(616,'project_ticket_create','Project tickets',NULL,NULL,'active'),
(617,'project_ticket_edit','Project tickets',NULL,NULL,'active'),
(618,'project_ticket_view','Project tickets',NULL,NULL,'active'),
(619,'project_ticket_delete','Project tickets',NULL,NULL,'active'),
(620,'project_discussion_access','Project discussions',NULL,NULL,'active'),
(621,'project_discussion_create','Project discussions',NULL,NULL,'active'),
(622,'project_discussion_edit','Project discussions',NULL,NULL,'active'),
(623,'project_discussion_view','Project discussions',NULL,NULL,'active'),
(624,'project_discussion_delete','Project discussions',NULL,NULL,'active'),
(625,'project_files_access','Projects files',NULL,NULL,'active'),
(626,'project_sales_access','Project sales',NULL,NULL,'active'),
(627,'project_notes_access','Projects notes',NULL,NULL,'active'),
(628,'permission_delete_multi','Permissions','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(629,'role_delete_multi','Roles','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(630,'user_delete_multi','Users','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(631,'user_action_delete_multi','Users','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(632,'contact_management_delete_multi','Contacts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(633,'contact_company_delete_multi','Contacts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(634,'contact_delete_multi','Contacts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(635,'expense_management_delete_multi','Expenses','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(636,'expense_category_delete_multi','Expenses','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(637,'income_category_delete_multi','Income','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(638,'income_delete_multi','Income','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(639,'expense_delete_multi','Expenses','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(640,'monthly_report_delete_multi','Monthly reports','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(641,'faq_management_delete_multi','FAQ management','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(642,'faq_category_delete_multi','FAQ categories','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(643,'faq_question_delete_multi','FAQs','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(644,'internal_notification_delete_multi','Quick notifications','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(645,'task_status_delete_multi','Tasks','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(646,'task_management_delete_multi','Tasks','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(647,'task_tag_delete_multi','Tasks','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(648,'task_delete_multi','Tasks','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(649,'task_calendar_delete_multi','Tasks','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(650,'content_management_delete_multi','Content management','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(651,'content_category_delete_multi','Content categories','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(652,'content_tag_delete_multi','Page tags','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(653,'content_page_delete_multi','Pages','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(654,'product_management_delete_multi','Products/Items','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(655,'product_category_delete_multi','Products/Items','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(656,'product_tag_delete_multi','Products/Items','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(657,'product_delete_multi','Products/Items','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(658,'assets_category_delete_multi','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(659,'assets_management_delete_multi','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(660,'assets_status_delete_multi','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(661,'assets_location_delete_multi','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(662,'asset_delete_multi','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(663,'assets_history_delete_multi','Assets','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(664,'coupon_management_delete_multi','Coupons','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(665,'coupon_campaign_delete_multi','Coupons','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(666,'coupon_delete_multi','Coupons','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(667,'currency_delete_multi','Currencies','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(668,'email_template_delete_multi','Email templates','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(669,'company_delete_multi','Companies','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(670,'account_delete_multi','Accounts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(671,'payment_gateway_delete_multi','Payment gateways','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(672,'warehouse_delete_multi','Warehouses','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(673,'tax_delete_multi','Tax','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(674,'discount_delete_multi','Discounts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(675,'recurring_period_delete_multi','Recurring periods','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(676,'language_delete_multi','Languages','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(677,'purchase_order_delete_multi','Purchase orders','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(678,'project_status_delete_multi','Project status','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(679,'client_project_delete_multi','Projects','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(680,'project_billing_type_delete_multi','Project billing types','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(681,'time_entry_delete_multi','Time entry','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(682,'invoice_delete_multi','Invoices','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(683,'quote_delete_multi','Quotes','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(684,'recurring_invoice_delete_multi','Recurring invoices','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(685,'contact_group_delete_multi','Contacts','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(686,'contact_type_delete_multi','Contacts','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(687,'contact_note_delete_multi','Contacts','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(688,'contact_document_delete_multi','Contacts','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(689,'products_return_delete_multi','Products/Items','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(690,'brand_delete_multi','Brands','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(691,'department_delete_multi','Departments','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(692,'support_delete_multi','Support','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(693,'transfer_delete_multi','Transfers','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(694,'article_delete_multi','Articles','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(695,'master_setting_delete_multi','Settings','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(696,'country_delete_multi','Countries','2019-01-30 12:52:17','2019-01-30 12:52:17','active'),
(697,'measurement_unit_delete_multi','Measurement units',NULL,NULL,'active'),
(698,'invoice_payment_delete_multi','Invoices',NULL,NULL,'active'),
(699,'template_delete_multi','Templates',NULL,NULL,'active'),
(700,'smstemplate_delete_multi','SMS templates',NULL,NULL,'active'),
(701,'recurring_invoice_payment_delete_multi','Recurring invoices',NULL,NULL,'active'),
(702,'supplier_delete_multi','Suppliers','2019-02-26 04:11:20','2019-02-26 04:11:20','active'),
(703,'lead_delete_multi','Leads','2019-02-26 05:52:33','2019-02-26 05:52:33','active'),
(704,'order_delete_multi','Orders','2019-02-27 04:21:13','2019-02-27 04:21:13','active'),
(705,'customer_delete_multi','Customers',NULL,NULL,'active'),
(706,'database_backup_delete_multi','Backups',NULL,NULL,'active'),
(707,'site_theme_delete_multi','Site themes',NULL,NULL,'active'),
(708,'modules_management_delete_multi','Plugins',NULL,NULL,'active'),
(709,'send_sm_delete_multi','SMS',NULL,NULL,'active'),
(710,'sms_gateway_delete_multi','SMS gateways',NULL,NULL,'active'),
(711,'quote_task_delete_multi','Quotes',NULL,NULL,'active'),
(712,'mile_stone_delete_multi','Mile stones',NULL,NULL,'active'),
(713,'quotes_note_delete_multi','Quotes',NULL,NULL,'active'),
(714,'quote_reminder_delete_multi','Quotes',NULL,NULL,'active'),
(715,'dynamic_option_delete_multi','Options',NULL,NULL,'active'),
(716,'invoice_note_delete_multi','Invoices',NULL,NULL,'active'),
(717,'invoice_reminder_delete_multi','Invoices',NULL,NULL,'active'),
(718,'invoice_task_delete_multi','Invoices',NULL,NULL,'active'),
(719,'project_tab_delete_multi','Project tabs',NULL,NULL,'active'),
(720,'project_task_delete_multi','Project tasks',NULL,NULL,'active'),
(721,'project_ticket_delete_multi','Project tickets',NULL,NULL,'active'),
(722,'project_discussion_delete_multi','Project discussions',NULL,NULL,'active'),
(723,'contact_mailchimp_email_campaigns','Contacts',NULL,NULL,'active'),
(724,'credit_note_edit','Credit notes',NULL,NULL,'active'),
(725,'credit_note_make_payment','Credit notes',NULL,NULL,'active'),
(726,'credit_note_change_status','Credit notes',NULL,NULL,'active'),
(727,'credit_note_preview','Credit notes','0000-00-00 00:00:00','0000-00-00 00:00:00','active'),
(728,'credit_note_uploads','Credit notes',NULL,NULL,'active'),
(729,'credit_note_pdf_access','Credit notes',NULL,NULL,'active'),
(730,'credit_note_pdf_view','Credit notes','0000-00-00 00:00:00','0000-00-00 00:00:00','active'),
(731,'credit_note_pdf_download','Credit notes','0000-00-00 00:00:00','0000-00-00 00:00:00','active'),
(732,'credit_note_print','Credit notes','0000-00-00 00:00:00','0000-00-00 00:00:00','active'),
(733,'credit_note_create','Credit notes',NULL,NULL,'active'),
(734,'credit_note_delete','Credit notes',NULL,NULL,'active'),
(735,'credit_note_access','Credit notes',NULL,NULL,'active'),
(736,'credit_note_view','Credit notes','0000-00-00 00:00:00','0000-00-00 00:00:00','active'),
(737,'credit_note_change_status_access','Credit notes','0000-00-00 00:00:00','0000-00-00 00:00:00','active'),
(738,'credit_note_change_status_paid','Credit notes',NULL,NULL,'active'),
(739,'credit_note_apply_to_invoice','Credit notes',NULL,'0000-00-00 00:00:00','active'),
(740,'widget_create','Dashboard widgets','0000-00-00 00:00:00','0000-00-00 00:00:00','active'),
(741,'widget_edit','Dashboard widgets','0000-00-00 00:00:00','0000-00-00 00:00:00','active'),
(742,'widget_show','Dashboard widgets','0000-00-00 00:00:00','0000-00-00 00:00:00','active'),
(743,'widget_delete','Dashboard widgets','0000-00-00 00:00:00','0000-00-00 00:00:00','active'),
(744,'widget_assign','Dashboard widgets','0000-00-00 00:00:00','0000-00-00 00:00:00','active'),
(745,'widget_access','Dashboard widgets','0000-00-00 00:00:00','0000-00-00 00:00:00','active'),
(746,'proposal_access','Proposals','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(747,'proposal_create','Proposals','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(748,'proposal_edit','Proposals','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(749,'proposal_view','Proposals','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(750,'proposal_delete','Proposals','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(751,'proposal_email_access','Proposals',NULL,NULL,'active'),
(752,'proposal_email_created','Proposals',NULL,NULL,'active'),
(753,'proposal_sms_access','Proposals',NULL,NULL,'active'),
(754,'proposal_sms_created','Proposals',NULL,NULL,'active'),
(755,'proposal_sms_accepted','Proposals',NULL,NULL,'active'),
(756,'proposal_sms_cancelled','Proposals',NULL,NULL,'active'),
(757,'proposal_changestatus_access','Proposals',NULL,NULL,'active'),
(758,'proposal_changestatus_delivered','Proposals',NULL,NULL,'active'),
(759,'proposal_changestatus_onhold','Proposals',NULL,NULL,'active'),
(760,'proposal_changestatus_accepted','Proposals',NULL,NULL,'active'),
(761,'proposal_changestatus_rejected','Proposals',NULL,NULL,'active'),
(762,'proposal_changestatus_lost','Proposals',NULL,NULL,'active'),
(763,'proposal_changestatus_dead','Proposals',NULL,NULL,'active'),
(764,'proposal_convertinvoice','Proposals',NULL,NULL,'active'),
(765,'proposal_preview','Proposals',NULL,NULL,'active'),
(766,'proposal_duplicate','Proposals',NULL,NULL,'active'),
(767,'proposal_upload','Proposals',NULL,NULL,'active'),
(768,'proposal_pdf_access','Proposals',NULL,NULL,'active'),
(769,'proposal_pdf_view','Proposals',NULL,NULL,'active'),
(770,'proposal_pdf_download','Proposals',NULL,NULL,'active'),
(771,'proposal_print','Proposals',NULL,NULL,'active'),
(772,'proposal_more_options','Proposals',NULL,NULL,'active'),
(773,'proposal_task_access','Proposals',NULL,NULL,'active'),
(774,'proposal_task_create','Proposals',NULL,NULL,'active'),
(775,'proposal_task_edit','Proposals',NULL,NULL,'active'),
(776,'proposal_task_view','Proposals',NULL,NULL,'active'),
(777,'proposal_task_delete','Proposals',NULL,NULL,'active'),
(778,'proposals_note_create','Proposals',NULL,NULL,'active'),
(779,'proposals_note_edit','Proposals',NULL,NULL,'active'),
(780,'proposals_note_view','Proposals',NULL,NULL,'active'),
(781,'proposals_note_delete','Proposals',NULL,NULL,'active'),
(782,'proposal_reminder_create','Proposals',NULL,NULL,'active'),
(783,'proposal_reminder_edit','Proposals',NULL,NULL,'active'),
(784,'proposal_reminder_view','Proposals',NULL,NULL,'active'),
(785,'proposal_reminder_delete','Proposals',NULL,NULL,'active'),
(786,'proposal_reminder_access','Proposals',NULL,NULL,'active'),
(787,'proposals_note_access','Proposals',NULL,NULL,'active'),
(788,'proposal_task_access','Proposals',NULL,NULL,'active'),
(789,'proposal_delete_multi','Proposals','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(790,'proposal_task_delete_multi','Proposals',NULL,NULL,'active'),
(791,'proposals_note_delete_multi','Proposals',NULL,NULL,'active'),
(792,'proposal_reminder_delete_multi','Proposals',NULL,NULL,'active'),
(793,'modules_management_upload','Plugins',NULL,NULL,'active'),
(794,'contract_create','Contracts','2019-01-30 07:22:16','2019-01-30 07:22:16','active'),
(795,'contract_edit','Contracts','2019-01-30 07:22:16','2019-01-30 07:22:16','active'),
(796,'contract_view','Contracts','2019-01-30 07:22:16','2019-01-30 07:22:16','active'),
(797,'contract_delete','Contracts','2019-01-30 07:22:16','2019-01-30 07:22:16','active'),
(798,'contract_email_access','Contracts',NULL,NULL,'active'),
(799,'contract_email_created','Contracts',NULL,NULL,'active'),
(800,'contract_sms_access','Contracts',NULL,NULL,'active'),
(801,'contract_sms_created','Contracts',NULL,NULL,'active'),
(802,'contract_sms_accepted','Contracts',NULL,NULL,'active'),
(803,'contract_sms_cancelled','Contracts',NULL,NULL,'active'),
(804,'contract_changestatus_access','Contracts',NULL,NULL,'active'),
(805,'contract_changestatus_delivered','Contracts',NULL,NULL,'active'),
(806,'contract_changestatus_onhold','Contracts',NULL,NULL,'active'),
(807,'contract_changestatus_accepted','Contracts',NULL,NULL,'active'),
(808,'contract_changestatus_rejected','Contracts',NULL,NULL,'active'),
(809,'contract_changestatus_lost','Contracts',NULL,NULL,'active'),
(810,'contract_changestatus_dead','Contracts',NULL,NULL,'active'),
(811,'contract_convertinvoice','Contracts',NULL,NULL,'active'),
(812,'contract_preview','Contracts',NULL,NULL,'active'),
(813,'contract_duplicate','Contracts',NULL,NULL,'active'),
(814,'contract_upload','Contracts',NULL,NULL,'active'),
(815,'contract_pdf_access','Contracts',NULL,NULL,'active'),
(816,'contract_pdf_view','Contracts',NULL,NULL,'active'),
(817,'contract_pdf_download','Contracts',NULL,NULL,'active'),
(818,'contract_print','Contracts',NULL,NULL,'active'),
(819,'contract_more_options','Contracts',NULL,NULL,'active'),
(820,'contract_task_access','Contracts',NULL,NULL,'active'),
(821,'contract_task_create','Contracts',NULL,NULL,'active'),
(822,'contract_task_edit','Contracts',NULL,NULL,'active'),
(823,'contract_task_view','Contracts',NULL,NULL,'active'),
(824,'contract_task_delete','Contracts',NULL,NULL,'active'),
(825,'contracts_note_create','Contracts',NULL,NULL,'active'),
(826,'contracts_note_edit','Contracts',NULL,NULL,'active'),
(827,'contracts_note_view','Contracts',NULL,NULL,'active'),
(828,'contracts_note_delete','Contracts',NULL,NULL,'active'),
(829,'contract_reminder_create','Contracts',NULL,NULL,'active'),
(830,'contract_reminder_edit','Contracts',NULL,NULL,'active'),
(831,'contract_reminder_view','Contracts',NULL,NULL,'active'),
(832,'contract_reminder_delete','Contracts',NULL,NULL,'active'),
(833,'contract_reminder_access','Contracts',NULL,NULL,'active'),
(834,'contracts_note_access','Contracts',NULL,NULL,'active'),
(835,'contract_task_access','Contracts',NULL,NULL,'active'),
(836,'contract_delete_multi','Contracts','2019-01-30 07:22:16','2019-01-30 07:22:16','active'),
(837,'contract_task_delete_multi','Contracts',NULL,NULL,'active'),
(838,'contracts_note_delete_multi','Contracts',NULL,NULL,'active'),
(839,'contract_reminder_delete_multi','Contracts',NULL,NULL,'active'),
(840,'contract_type_access','ContractTypes','2019-01-30 07:22:16','2019-01-30 07:22:16','active'),
(841,'contract_type_create','ContractTypes','2019-01-30 07:22:16','2019-01-30 07:22:16','active'),
(842,'contract_type_edit','ContractTypes','2019-01-30 07:22:16','2019-01-30 07:22:16','active'),
(843,'contract_type_view','ContractTypes','2019-01-30 07:22:16','2019-01-30 07:22:16','active'),
(844,'contract_type_delete','ContractTypes','2019-01-30 07:22:16','2019-01-30 07:22:16','active'),
(845,'contract_type_delete_multi','ContractTypes','2019-01-30 07:22:16','2019-01-30 07:22:16','active'),
(846,'proposal_reminder_delete_multi','Proposals',NULL,NULL,'active'),
(847,'contract_access','Contracts','2019-01-30 07:22:16','2019-01-30 07:22:16','active'),
(848,'proposal_access','Proposals','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(849,'proposal_create','Proposals','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(850,'proposal_edit','Proposals','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(851,'proposal_view','Proposals','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(852,'proposal_delete','Proposals','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(853,'proposal_email_access','Proposals',NULL,NULL,'active'),
(854,'proposal_email_created','Proposals',NULL,NULL,'active'),
(855,'proposal_sms_access','Proposals',NULL,NULL,'active'),
(856,'proposal_sms_created','Proposals',NULL,NULL,'active'),
(857,'proposal_sms_accepted','Proposals',NULL,NULL,'active'),
(858,'proposal_sms_cancelled','Proposals',NULL,NULL,'active'),
(859,'proposal_changestatus_access','Proposals',NULL,NULL,'active'),
(860,'proposal_changestatus_delivered','Proposals',NULL,NULL,'active'),
(861,'proposal_changestatus_onhold','Proposals',NULL,NULL,'active'),
(862,'proposal_changestatus_accepted','Proposals',NULL,NULL,'active'),
(863,'proposal_changestatus_rejected','Proposals',NULL,NULL,'active'),
(864,'proposal_changestatus_lost','Proposals',NULL,NULL,'active'),
(865,'proposal_changestatus_dead','Proposals',NULL,NULL,'active'),
(866,'proposal_convertinvoice','Proposals',NULL,NULL,'active'),
(867,'proposal_preview','Proposals',NULL,NULL,'active'),
(868,'proposal_duplicate','Proposals',NULL,NULL,'active'),
(869,'proposal_upload','Proposals',NULL,NULL,'active'),
(870,'proposal_pdf_access','Proposals',NULL,NULL,'active'),
(871,'proposal_pdf_view','Proposals',NULL,NULL,'active'),
(872,'proposal_pdf_download','Proposals',NULL,NULL,'active'),
(873,'proposal_print','Proposals',NULL,NULL,'active'),
(874,'proposal_more_options','Proposals',NULL,NULL,'active'),
(875,'proposal_task_access','Proposals',NULL,NULL,'active'),
(876,'proposal_task_create','Proposals',NULL,NULL,'active'),
(877,'proposal_task_edit','Proposals',NULL,NULL,'active'),
(878,'proposal_task_view','Proposals',NULL,NULL,'active'),
(879,'proposal_task_delete','Proposals',NULL,NULL,'active'),
(880,'proposals_note_create','Proposals',NULL,NULL,'active'),
(881,'proposals_note_edit','Proposals',NULL,NULL,'active'),
(882,'proposals_note_view','Proposals',NULL,NULL,'active'),
(883,'proposals_note_delete','Proposals',NULL,NULL,'active'),
(884,'proposal_reminder_create','Proposals',NULL,NULL,'active'),
(885,'proposal_reminder_edit','Proposals',NULL,NULL,'active'),
(886,'proposal_reminder_view','Proposals',NULL,NULL,'active'),
(887,'proposal_reminder_delete','Proposals',NULL,NULL,'active'),
(888,'proposal_reminder_access','Proposals',NULL,NULL,'active'),
(889,'proposals_note_access','Proposals',NULL,NULL,'active'),
(890,'proposal_task_access','Proposals',NULL,NULL,'active'),
(891,'proposal_delete_multi','Proposals','2019-01-30 12:52:16','2019-01-30 12:52:16','active'),
(892,'proposal_task_delete_multi','Proposals',NULL,NULL,'active'),
(893,'proposals_note_delete_multi','Proposals',NULL,NULL,'active'),
(894,'proposal_reminder_delete_multi','Proposals',NULL,NULL,'active'),
(895,'proposal_convertquote','Proposals',NULL,NULL,'active'),
(896,'convert_to','Proposals',NULL,NULL,'active'),
(897,'credit_note_delete_multi','Credit notes',NULL,NULL,'active');

/*Table structure for table `acrm_product_categories` */

DROP TABLE IF EXISTS `acrm_product_categories`;

CREATE TABLE `acrm_product_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `photo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_product_categories` */

/*Table structure for table `acrm_product_currency` */

DROP TABLE IF EXISTS `acrm_product_currency`;

CREATE TABLE `acrm_product_currency` (
  `product_id` int(10) unsigned DEFAULT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `currency_code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency_actual_price` decimal(10,2) DEFAULT NULL,
  `currency_sale_price` decimal(10,2) DEFAULT NULL,
  KEY `fk_p_66365_259305_produc_5c4fd87b37625` (`product_id`),
  KEY `fk_p_36585_259307_produc_5c4fd87b376ec` (`currency_id`),
  CONSTRAINT `fk_p_36585_259307_produc_5c4fd87b376ec` FOREIGN KEY (`currency_id`) REFERENCES `acrm_currencies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_p_66365_259305_produc_5c4fd87b37625` FOREIGN KEY (`product_id`) REFERENCES `acrm_products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_product_currency` */

/*Table structure for table `acrm_product_product_category` */

DROP TABLE IF EXISTS `acrm_product_product_category`;

CREATE TABLE `acrm_product_product_category` (
  `product_id` int(10) unsigned DEFAULT NULL,
  `product_category_id` int(10) unsigned DEFAULT NULL,
  KEY `fk_p_259307_259305_produc_5c4fd87b37625` (`product_id`),
  KEY `fk_p_259305_259307_produc_5c4fd87b376ec` (`product_category_id`),
  CONSTRAINT `fk_p_259305_259307_produc_5c4fd87b376ec` FOREIGN KEY (`product_category_id`) REFERENCES `acrm_product_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_p_259307_259305_produc_5c4fd87b37625` FOREIGN KEY (`product_id`) REFERENCES `acrm_products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_product_product_category` */

/*Table structure for table `acrm_products` */

DROP TABLE IF EXISTS `acrm_products`;

CREATE TABLE `acrm_products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `excerpt` text COLLATE utf8mb4_unicode_ci,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `product_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `actual_price` double DEFAULT NULL,
  `sale_price` double DEFAULT NULL,
  `stock_quantity` int(10) unsigned DEFAULT NULL,
  `alert_quantity` int(10) unsigned DEFAULT NULL,
  `thumbnail` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hsn_sac_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_size` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_weight` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ware_house_id` int(10) unsigned DEFAULT NULL,
  `brand_id` int(10) unsigned DEFAULT NULL,
  `tax_id` int(10) unsigned DEFAULT NULL,
  `discount_id` int(10) unsigned DEFAULT NULL,
  `measurement_unit` int(10) unsigned DEFAULT NULL,
  `product_status` enum('Active','Inactive','Damaged','Fixed asset') COLLATE utf8mb4_unicode_ci DEFAULT 'Active',
  `prices` text COLLATE utf8mb4_unicode_ci,
  `prices_available` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `259307_5c5022b0a7c5f` (`ware_house_id`),
  KEY `259307_5c5022b0c1b14` (`brand_id`),
  KEY `259307_5c5022b0c1b15` (`tax_id`),
  KEY `259307_5c5022b0c1b16` (`discount_id`),
  KEY `259307_5c5022b0c1b17` (`measurement_unit`),
  CONSTRAINT `259307_5c5022b0a7c5f` FOREIGN KEY (`ware_house_id`) REFERENCES `acrm_warehouses` (`id`) ON DELETE CASCADE,
  CONSTRAINT `259307_5c5022b0c1b14` FOREIGN KEY (`brand_id`) REFERENCES `acrm_brands` (`id`) ON DELETE CASCADE,
  CONSTRAINT `259307_5c5022b0c1b15` FOREIGN KEY (`tax_id`) REFERENCES `acrm_taxes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `259307_5c5022b0c1b16` FOREIGN KEY (`discount_id`) REFERENCES `acrm_discounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `259307_5c5022b0c1b17` FOREIGN KEY (`measurement_unit`) REFERENCES `acrm_measurement_units` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_products` */

/*Table structure for table `acrm_project_billing_types` */

DROP TABLE IF EXISTS `acrm_project_billing_types`;

CREATE TABLE `acrm_project_billing_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_billing_types_deleted_at_index` (`deleted_at`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_project_billing_types` */

insert  into `acrm_project_billing_types`(`id`,`title`,`description`,`created_at`,`updated_at`,`deleted_at`) values 
(1,'Fixed Price',NULL,'2019-09-20 12:12:56','2019-09-20 12:12:56',NULL),
(2,'Project Hours','',NULL,NULL,NULL),
(3,'Task Hours',NULL,NULL,NULL,NULL);

/*Table structure for table `acrm_project_discussion_comments` */

DROP TABLE IF EXISTS `acrm_project_discussion_comments`;

CREATE TABLE `acrm_project_discussion_comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_by_id` int(10) unsigned DEFAULT NULL,
  `contact_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `project_id` int(10) unsigned DEFAULT NULL,
  `discussion_id` int(10) unsigned DEFAULT NULL,
  `parent_id` int(10) unsigned DEFAULT NULL,
  `attachment` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mile_stones_deleted_at_index` (`deleted_at`),
  KEY `298246_5cc68dfc5f286` (`project_id`),
  KEY `fk_created_by_project_discussions` (`created_by_id`),
  KEY `fk_contact_id_project_discussions` (`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_project_discussion_comments` */

/*Table structure for table `acrm_project_discussions` */

DROP TABLE IF EXISTS `acrm_project_discussions`;

CREATE TABLE `acrm_project_discussions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `subject` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `show_to_customer` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_activity` timestamp NULL DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `contact_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `project_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mile_stones_deleted_at_index` (`deleted_at`),
  KEY `298246_5cc68dfc5f286` (`project_id`),
  KEY `fk_created_by_project_discussions` (`created_by`),
  KEY `fk_contact_id_project_discussions` (`contact_id`),
  CONSTRAINT `fk_contact_id_project_discussions` FOREIGN KEY (`contact_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_contacts_acrm_created_by_id` FOREIGN KEY (`created_by`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_project_id_project_discussions` FOREIGN KEY (`project_id`) REFERENCES `acrm_client_projects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_project_discussions` */

/*Table structure for table `acrm_project_history` */

DROP TABLE IF EXISTS `acrm_project_history`;

CREATE TABLE `acrm_project_history` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `subject` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `show_to_customer` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_activity` timestamp NULL DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `contact_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `project_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mile_stones_deleted_at_index` (`deleted_at`),
  KEY `298246_5cc68dfc5f286` (`project_id`),
  KEY `fk_created_by_project_discussions` (`created_by`),
  KEY `fk_contact_id_project_discussions` (`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_project_history` */

/*Table structure for table `acrm_project_statuses` */

DROP TABLE IF EXISTS `acrm_project_statuses`;

CREATE TABLE `acrm_project_statuses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_statuses_deleted_at_index` (`deleted_at`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_project_statuses` */

insert  into `acrm_project_statuses`(`id`,`name`,`description`,`created_at`,`updated_at`,`deleted_at`) values 
(1,'Wating',NULL,'2019-09-20 12:12:44','2019-09-20 12:12:44',NULL),
(2,'Pending',NULL,NULL,NULL,NULL),
(3,'Terminated',NULL,NULL,NULL,NULL),
(4,'Finished',NULL,NULL,NULL,NULL),
(5,'In Progress',NULL,NULL,NULL,NULL),
(6,'Overdue',NULL,NULL,NULL,NULL),
(8,'On Hold',NULL,NULL,NULL,NULL),
(13,'Not Started',NULL,NULL,NULL,NULL),
(14,'Started',NULL,NULL,NULL,NULL);

/*Table structure for table `acrm_project_tabs` */

DROP TABLE IF EXISTS `acrm_project_tabs`;

CREATE TABLE `acrm_project_tabs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_tabs_deleted_at_index` (`deleted_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_project_tabs` */

/*Table structure for table `acrm_project_task_timers` */

DROP TABLE IF EXISTS `acrm_project_task_timers`;

CREATE TABLE `acrm_project_task_timers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `task_id` int(10) unsigned NOT NULL,
  `start_time` datetime NOT NULL,
  `end_time` datetime DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `hourly_rate` decimal(15,2) DEFAULT '0.00',
  `note` text,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_id` (`task_id`),
  CONSTRAINT `fk_contacts_acrm_project_task_timers_task_id` FOREIGN KEY (`task_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_task_id_tasktimers` FOREIGN KEY (`task_id`) REFERENCES `acrm_project_tasks` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `acrm_project_task_timers` */

/*Table structure for table `acrm_project_task_user` */

DROP TABLE IF EXISTS `acrm_project_task_user`;

CREATE TABLE `acrm_project_task_user` (
  `project_task_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  KEY `fk_p_259358_259280_user_c_5c4ff9d6745f6` (`project_task_id`),
  KEY `fk_acrm_project_task_user_id_idx` (`user_id`),
  CONSTRAINT `fk_acrm_project_task_user_id` FOREIGN KEY (`user_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_project_task_id_ass` FOREIGN KEY (`project_task_id`) REFERENCES `acrm_project_tasks` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_project_task_user` */

/*Table structure for table `acrm_project_tasks` */

DROP TABLE IF EXISTS `acrm_project_tasks`;

CREATE TABLE `acrm_project_tasks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `startdate` date DEFAULT NULL,
  `duedate` date DEFAULT NULL,
  `datefinished` date DEFAULT NULL,
  `recurring_type` enum('day','week','month','year') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `recurring_value` int(10) unsigned DEFAULT '0' COMMENT '''0'' means not rec urring',
  `cycles` int(11) DEFAULT NULL,
  `total_cycles` int(10) unsigned DEFAULT NULL,
  `last_recurring_date` date DEFAULT NULL,
  `is_public` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'yes',
  `billable` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'yes',
  `billed` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `hourly_rate` decimal(15,2) DEFAULT '0.00',
  `kanban_order` int(11) DEFAULT NULL,
  `milestone_order` int(11) DEFAULT NULL,
  `visible_to_client` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `deadline_notified` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `priority` int(10) unsigned DEFAULT NULL,
  `status` int(10) unsigned DEFAULT NULL,
  `recurring_id` int(10) unsigned DEFAULT NULL,
  `project_id` int(10) unsigned DEFAULT NULL,
  `created_by_id` int(10) unsigned DEFAULT NULL,
  `milestone` int(10) unsigned DEFAULT NULL,
  `is_recurring_from` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_tasks_deleted_at_index` (`deleted_at`),
  KEY `298700_5cc801277056bpp` (`priority`),
  KEY `298700_5cc801279da9fpp` (`status`),
  KEY `298700_5cc80127c8e38pp` (`recurring_id`),
  KEY `298700_5cc8012800e26pp` (`project_id`),
  KEY `298700_5cc801285d6cfpp` (`milestone`),
  KEY `fk_is_recurring_from_invoice_tasks` (`is_recurring_from`),
  KEY `fk_acrm_contacts_project_tasks_createdby_id_idx` (`created_by_id`),
  CONSTRAINT `298700_5cc801277056bpp` FOREIGN KEY (`priority`) REFERENCES `acrm_dynamic_options` (`id`) ON DELETE CASCADE,
  CONSTRAINT `298700_5cc801279da9fpp` FOREIGN KEY (`status`) REFERENCES `acrm_dynamic_options` (`id`) ON DELETE CASCADE,
  CONSTRAINT `298700_5cc80127c8e38pp` FOREIGN KEY (`recurring_id`) REFERENCES `acrm_recurring_periods` (`id`) ON DELETE CASCADE,
  CONSTRAINT `298700_5cc801285d6cfpp` FOREIGN KEY (`milestone`) REFERENCES `acrm_mile_stones` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_acrm_contacts_project_tasks_createdby_id` FOREIGN KEY (`created_by_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_is_recurring_from_invoice_taskspp` FOREIGN KEY (`is_recurring_from`) REFERENCES `acrm_project_tasks` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_project_id_project_tasks` FOREIGN KEY (`project_id`) REFERENCES `acrm_client_projects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_project_tasks` */

/*Table structure for table `acrm_proposal_products` */

DROP TABLE IF EXISTS `acrm_proposal_products`;

CREATE TABLE `acrm_proposal_products` (
  `proposal_id` int(10) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `product_name` varchar(191) DEFAULT NULL,
  `product_qty` decimal(10,2) DEFAULT NULL COMMENT 'Quantity may have decimal value in case of project task invoice',
  `product_price` decimal(10,2) DEFAULT NULL,
  `product_tax` decimal(10,2) DEFAULT NULL COMMENT 'Tax Rate',
  `tax_type` varchar(10) DEFAULT NULL,
  `tax_value` decimal(10,2) DEFAULT NULL,
  `product_discount` decimal(10,2) DEFAULT NULL COMMENT 'Discount Rate',
  `discount_type` varchar(10) DEFAULT NULL,
  `discount_value` decimal(10,0) DEFAULT NULL,
  `product_subtotal` decimal(10,0) DEFAULT NULL,
  `product_amount` decimal(10,2) DEFAULT NULL,
  `pid` int(11) DEFAULT NULL,
  `unit` varchar(15) DEFAULT NULL,
  `hsn` varchar(45) DEFAULT NULL,
  `alert` int(11) DEFAULT NULL,
  `stock_quantity` int(11) DEFAULT NULL,
  `product_description` text,
  KEY `fk_proposal_id_proposal_products` (`proposal_id`),
  KEY `fk_product_id_proposal_products` (`proposal_id`),
  KEY `fk_product_id_proposal_products2` (`product_id`),
  CONSTRAINT `fk_product_id_proposal_products2` FOREIGN KEY (`product_id`) REFERENCES `acrm_products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_proposal_id_proposal_products` FOREIGN KEY (`proposal_id`) REFERENCES `acrm_proposals` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `acrm_proposal_products` */

/*Table structure for table `acrm_proposal_task_user` */

DROP TABLE IF EXISTS `acrm_proposal_task_user`;

CREATE TABLE `acrm_proposal_task_user` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `proposal_task_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_proposal_task_id` (`proposal_task_id`),
  KEY `fk_acrm_contacts_proposal_task_user_id` (`user_id`),
  CONSTRAINT `fk_acrm_contacts_proposale_task_user_id` FOREIGN KEY (`user_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_quote_task_id_proposal_task_user` FOREIGN KEY (`proposal_task_id`) REFERENCES `acrm_proposal_tasks` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `acrm_proposal_task_user` */

/*Table structure for table `acrm_proposal_tasks` */

DROP TABLE IF EXISTS `acrm_proposal_tasks`;

CREATE TABLE `acrm_proposal_tasks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `priority_id` int(10) unsigned DEFAULT NULL,
  `startdate` date DEFAULT NULL,
  `duedate` date DEFAULT NULL,
  `datefinished` date DEFAULT NULL,
  `status_id` int(10) unsigned DEFAULT NULL,
  `recurring_type` enum('day','week','month','year') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `recurring_value` int(10) unsigned DEFAULT '0' COMMENT '''0'' means not recurring',
  `cycles` int(11) DEFAULT NULL,
  `total_cycles` int(10) unsigned DEFAULT NULL,
  `last_recurring_date` date DEFAULT NULL,
  `is_public` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'yes',
  `billable` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'yes',
  `billed` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `hourly_rate` double DEFAULT '0',
  `kanban_order` int(11) DEFAULT NULL,
  `milestone_order` int(11) DEFAULT NULL,
  `visible_to_client` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `deadline_notified` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `recurring_id` int(10) unsigned DEFAULT NULL,
  `proposal_id` int(10) unsigned DEFAULT NULL,
  `created_by_id` int(10) unsigned DEFAULT NULL,
  `mile_stone_id` int(10) unsigned DEFAULT NULL,
  `is_recurring_from` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `proposal_tasks_deleted_at_index` (`deleted_at`),
  KEY `298242_5cc68c34c3153proposal` (`recurring_id`),
  KEY `298242_5cc68c34eed43proposal` (`proposal_id`),
  KEY `fk_is_recurring_from_proposal_tasks` (`is_recurring_from`),
  KEY `fk_acrm_proposal_tasks_created_by_id` (`created_by_id`),
  CONSTRAINT `298242_5cc68c34c3153proposal` FOREIGN KEY (`recurring_id`) REFERENCES `acrm_recurring_periods` (`id`) ON DELETE CASCADE,
  CONSTRAINT `298242_5cc68c34eed43proposal` FOREIGN KEY (`proposal_id`) REFERENCES `acrm_proposals` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_acrm_proposal_tasks_created_by_id` FOREIGN KEY (`created_by_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_is_recurring_from_proposal_tasks` FOREIGN KEY (`is_recurring_from`) REFERENCES `acrm_proposal_tasks` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_proposal_tasks` */

/*Table structure for table `acrm_proposals` */

DROP TABLE IF EXISTS `acrm_proposals`;

CREATE TABLE `acrm_proposals` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `invoice_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_quantity_as` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_no` bigint(22) DEFAULT NULL,
  `status` enum('Published','Draft') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_date` date DEFAULT NULL,
  `invoice_due_date` date DEFAULT NULL,
  `invoice_notes` text COLLATE utf8mb4_unicode_ci COMMENT 'Client Notes',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `customer_id` int(10) unsigned DEFAULT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `tax_id` int(10) unsigned DEFAULT NULL,
  `discount_id` int(10) unsigned DEFAULT NULL,
  `recurring_period_id` int(10) unsigned DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `products` longtext COLLATE utf8mb4_unicode_ci,
  `paymentstatus` char(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_id` int(10) unsigned DEFAULT NULL,
  `created_by_id` int(10) unsigned DEFAULT NULL,
  `delivery_address` text COLLATE utf8mb4_unicode_ci COMMENT 'Shipping address',
  `show_delivery_address` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `admin_notes` text COLLATE utf8mb4_unicode_ci,
  `sale_agent` int(10) unsigned DEFAULT NULL,
  `terms_conditions` longtext COLLATE utf8mb4_unicode_ci,
  `prevent_overdue_reminders` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `is_expiry_notified` tinyint(1) DEFAULT '0',
  `invoice_number_format` char(20) COLLATE utf8mb4_unicode_ci DEFAULT 'numberbased',
  `invoice_number_separator` char(5) COLLATE utf8mb4_unicode_ci DEFAULT '-',
  `invoice_number_length` int(11) DEFAULT NULL,
  `quote_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recurring_proposals_deleted_at_index` (`deleted_at`),
  KEY `259430_5c500cea0e179proposal` (`customer_id`),
  KEY `259430_5c500cea382acproposal` (`currency_id`),
  KEY `259430_5c500cea57b0dproposal` (`tax_id`),
  KEY `259430_5c500cea7d32dproposal` (`discount_id`),
  KEY `259430_5c500ceaa1e4cproposal` (`recurring_period_id`),
  KEY `fk_proposals_sale_agent` (`sale_agent`),
  KEY `fk_invoice_id_proposals` (`invoice_id`),
  KEY `fk_acrm_proposals_created_by_id` (`created_by_id`),
  KEY `fk_acrm_proposals_quote_id_idx` (`quote_id`),
  CONSTRAINT `fk_acrm_proposals_created_by_id` FOREIGN KEY (`created_by_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_acrm_proposals_quote_id` FOREIGN KEY (`quote_id`) REFERENCES `acrm_quotes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_invoice_id_proposals` FOREIGN KEY (`invoice_id`) REFERENCES `acrm_invoices` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_proposals_currency_id` FOREIGN KEY (`currency_id`) REFERENCES `acrm_currencies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_proposals_customerid` FOREIGN KEY (`customer_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_proposals_discount_id` FOREIGN KEY (`discount_id`) REFERENCES `acrm_discounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_proposals_recurring_period_id` FOREIGN KEY (`recurring_period_id`) REFERENCES `acrm_recurring_periods` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_proposals_sale_agent` FOREIGN KEY (`sale_agent`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_proposals_tax_id` FOREIGN KEY (`tax_id`) REFERENCES `acrm_taxes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_proposals` */

/*Table structure for table `acrm_proposals_history` */

DROP TABLE IF EXISTS `acrm_proposals_history`;

CREATE TABLE `acrm_proposals_history` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ip_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` text COLLATE utf8mb4_unicode_ci,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `browser` text COLLATE utf8mb4_unicode_ci,
  `comments` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `proposal_id` int(10) unsigned DEFAULT NULL,
  `operation_type` char(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'general, crud, email, sms, cron, payment, status',
  PRIMARY KEY (`id`),
  KEY `proposals_history_deleted_at_index` (`deleted_at`),
  KEY `259415_5c500ae99af17proposal` (`proposal_id`),
  CONSTRAINT `fk_proposals_history_proposal_id` FOREIGN KEY (`proposal_id`) REFERENCES `acrm_proposals` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_proposals_history` */

/*Table structure for table `acrm_proposals_notes` */

DROP TABLE IF EXISTS `acrm_proposals_notes`;

CREATE TABLE `acrm_proposals_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` text COLLATE utf8mb4_unicode_ci,
  `date_contacted` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `proposal_id` int(10) unsigned DEFAULT NULL,
  `created_by_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `proposals_notes_deleted_at_index` (`deleted_at`),
  KEY `298254_5cc692936db0aproposal` (`proposal_id`),
  KEY `fk_acrm_proposals_notes_created_by_id` (`created_by_id`),
  CONSTRAINT `298254_5cc692936db0aproposal` FOREIGN KEY (`proposal_id`) REFERENCES `acrm_proposals` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_acrm_proposals_notes_created_by_id` FOREIGN KEY (`created_by_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_proposals_notes` */

/*Table structure for table `acrm_proposals_reminders` */

DROP TABLE IF EXISTS `acrm_proposals_reminders`;

CREATE TABLE `acrm_proposals_reminders` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` text COLLATE utf8mb4_unicode_ci,
  `date` date DEFAULT NULL,
  `isnotified` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notify_by_email` enum('no','yes') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `proposal_id` int(10) unsigned DEFAULT NULL,
  `reminder_to_id` int(10) unsigned DEFAULT NULL,
  `created_by_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `proposals_reminders_deleted_at_index` (`deleted_at`),
  KEY `298253_5cc691865346cproposal` (`proposal_id`),
  KEY `fk_acrm_contacts_proposals_reminders_to` (`reminder_to_id`),
  KEY `fk_acrm_proposals_reminders_created_by_id` (`created_by_id`),
  CONSTRAINT `298253_5cc691865346cproposal` FOREIGN KEY (`proposal_id`) REFERENCES `acrm_proposals` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_acrm_contacts_proposals_reminders_to` FOREIGN KEY (`reminder_to_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_acrm_proposals_reminders_created_by_id` FOREIGN KEY (`created_by_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_proposals_reminders` */

/*Table structure for table `acrm_purchase_order_products` */

DROP TABLE IF EXISTS `acrm_purchase_order_products`;

CREATE TABLE `acrm_purchase_order_products` (
  `purchase_order_id` int(10) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `product_name` varchar(191) DEFAULT NULL,
  `product_qty` int(11) DEFAULT NULL,
  `product_price` decimal(10,2) DEFAULT NULL,
  `product_tax` decimal(10,2) DEFAULT NULL COMMENT 'Tax Rate',
  `tax_type` varchar(10) DEFAULT NULL,
  `tax_value` decimal(10,2) DEFAULT NULL,
  `product_discount` decimal(10,2) DEFAULT NULL COMMENT 'Discount Rate',
  `discount_type` varchar(10) DEFAULT NULL,
  `discount_value` decimal(10,0) DEFAULT NULL,
  `product_subtotal` decimal(10,0) DEFAULT NULL,
  `product_amount` decimal(10,2) DEFAULT NULL,
  `pid` int(11) DEFAULT NULL,
  `unit` varchar(15) DEFAULT NULL,
  `hsn` varchar(45) DEFAULT NULL,
  `alert` int(11) DEFAULT NULL,
  `stock_quantity` int(11) DEFAULT NULL,
  `product_description` text,
  KEY `fk_purchase_order_id_purchase_order_products` (`purchase_order_id`),
  KEY `fk_product_id_purchase_order_products` (`purchase_order_id`),
  KEY `fk_product_id_purchase_order_products2` (`product_id`),
  CONSTRAINT `fk_product_id_purchase_order_products2` FOREIGN KEY (`product_id`) REFERENCES `acrm_products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_purchase_order_id_purchase_order_products` FOREIGN KEY (`purchase_order_id`) REFERENCES `acrm_purchase_orders` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `acrm_purchase_order_products` */

/*Table structure for table `acrm_purchase_orders` */

DROP TABLE IF EXISTS `acrm_purchase_orders`;

CREATE TABLE `acrm_purchase_orders` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `subject` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('Published','Draft') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `invoice_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_quantity_as` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_no` bigint(22) DEFAULT NULL,
  `reference` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_date` date DEFAULT NULL,
  `order_due_date` date DEFAULT NULL,
  `update_stock` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `customer_id` int(10) unsigned DEFAULT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `warehouse_id` int(10) unsigned DEFAULT NULL,
  `tax_id` int(10) unsigned DEFAULT NULL,
  `discount_id` int(10) unsigned DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `products` text COLLATE utf8mb4_unicode_ci,
  `paymentstatus` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT 'unpaid',
  `recurring_period_id` int(10) unsigned DEFAULT NULL,
  `delivery_address` text COLLATE utf8mb4_unicode_ci COMMENT 'Shipping address',
  `show_delivery_address` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `admin_notes` text COLLATE utf8mb4_unicode_ci,
  `sale_agent` int(10) unsigned DEFAULT NULL,
  `terms_conditions` text COLLATE utf8mb4_unicode_ci,
  `prevent_overdue_reminders` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `invoice_number_format` char(20) COLLATE utf8mb4_unicode_ci DEFAULT 'numberbased',
  `invoice_number_separator` char(5) COLLATE utf8mb4_unicode_ci DEFAULT '-',
  `invoice_number_length` int(10) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `purchase_orders_deleted_at_index` (`deleted_at`),
  KEY `259347_5c502e5c9dd65` (`customer_id`),
  KEY `259347_5c502e5cb2ac0` (`currency_id`),
  KEY `259347_5c502e5cc8928` (`warehouse_id`),
  KEY `259347_5c502e5ce08d5` (`tax_id`),
  KEY `259347_5c502e5d01a3a` (`discount_id`),
  KEY `fk_po_recurring_period_id` (`recurring_period_id`),
  KEY `fk_po_sale_agent` (`sale_agent`),
  CONSTRAINT `259347_5c502e5c9dd65` FOREIGN KEY (`customer_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `259347_5c502e5cb2ac0` FOREIGN KEY (`currency_id`) REFERENCES `acrm_currencies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `259347_5c502e5cc8928` FOREIGN KEY (`warehouse_id`) REFERENCES `acrm_warehouses` (`id`) ON DELETE CASCADE,
  CONSTRAINT `259347_5c502e5ce08d5` FOREIGN KEY (`tax_id`) REFERENCES `acrm_taxes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `259347_5c502e5d01a3a` FOREIGN KEY (`discount_id`) REFERENCES `acrm_discounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_po_recurring_period_id` FOREIGN KEY (`recurring_period_id`) REFERENCES `acrm_recurring_periods` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_po_sale_agent` FOREIGN KEY (`sale_agent`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_purchase_orders` */

/*Table structure for table `acrm_purchase_orders_history` */

DROP TABLE IF EXISTS `acrm_purchase_orders_history`;

CREATE TABLE `acrm_purchase_orders_history` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ip_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` text COLLATE utf8mb4_unicode_ci,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `browser` text COLLATE utf8mb4_unicode_ci,
  `comments` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `purchase_order_id` int(10) unsigned DEFAULT NULL,
  `operation_type` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoices_history_deleted_at_index` (`deleted_at`),
  KEY `259415_5c500ae99af17` (`purchase_order_id`),
  CONSTRAINT `fk_purchase_order_id` FOREIGN KEY (`purchase_order_id`) REFERENCES `acrm_purchase_orders` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_purchase_orders_history` */

/*Table structure for table `acrm_purchase_orders_payments` */

DROP TABLE IF EXISTS `acrm_purchase_orders_payments`;

CREATE TABLE `acrm_purchase_orders_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `account_id` int(10) unsigned DEFAULT NULL,
  `purchase_order_id` int(10) unsigned DEFAULT NULL,
  `paymentmethod` char(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `payment_status` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_data` text COLLATE utf8mb4_unicode_ci,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_payments_deleted_at_index` (`deleted_at`),
  KEY `263295_5c5d41a961b5c` (`account_id`),
  KEY `263295_5c5d41a961b9c` (`purchase_order_id`),
  CONSTRAINT `fk_payments_purchase_order_id` FOREIGN KEY (`purchase_order_id`) REFERENCES `acrm_purchase_orders` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_purchase_orders_payments` */

/*Table structure for table `acrm_quote_products` */

DROP TABLE IF EXISTS `acrm_quote_products`;

CREATE TABLE `acrm_quote_products` (
  `quote_id` int(10) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `product_name` varchar(191) DEFAULT NULL,
  `product_qty` int(11) DEFAULT NULL,
  `product_price` decimal(10,2) DEFAULT NULL,
  `product_tax` decimal(10,2) DEFAULT NULL COMMENT 'Tax Rate',
  `tax_type` varchar(10) DEFAULT NULL,
  `tax_value` decimal(10,2) DEFAULT NULL,
  `product_discount` decimal(10,2) DEFAULT NULL COMMENT 'Discount Rate',
  `discount_type` varchar(10) DEFAULT NULL,
  `discount_value` decimal(10,0) DEFAULT NULL,
  `product_subtotal` decimal(10,0) DEFAULT NULL,
  `product_amount` decimal(10,2) DEFAULT NULL,
  `pid` int(11) DEFAULT NULL,
  `unit` varchar(15) DEFAULT NULL,
  `hsn` varchar(45) DEFAULT NULL,
  `alert` int(11) DEFAULT NULL,
  `stock_quantity` int(11) DEFAULT NULL,
  `product_description` text,
  KEY `fk_quote_id_quotee_products` (`quote_id`),
  KEY `fk_product_id_quote_products` (`quote_id`),
  KEY `fk_product_id_quote_products2` (`product_id`),
  CONSTRAINT `fk_product_id_quote_products2` FOREIGN KEY (`product_id`) REFERENCES `acrm_products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_quote_id_quote_products` FOREIGN KEY (`quote_id`) REFERENCES `acrm_quotes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `acrm_quote_products` */

/*Table structure for table `acrm_quote_task_user` */

DROP TABLE IF EXISTS `acrm_quote_task_user`;

CREATE TABLE `acrm_quote_task_user` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `quote_task_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_invoice_task_id` (`quote_task_id`),
  KEY `fk_acrm_contacts_quote_task_user_id` (`user_id`),
  CONSTRAINT `fk_acrm_contacts_quote_task_user_id` FOREIGN KEY (`user_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_quote_task_id_quote_task_user` FOREIGN KEY (`quote_task_id`) REFERENCES `acrm_quote_tasks` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `acrm_quote_task_user` */

/*Table structure for table `acrm_quote_tasks` */

DROP TABLE IF EXISTS `acrm_quote_tasks`;

CREATE TABLE `acrm_quote_tasks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `priority_id` int(10) unsigned DEFAULT NULL,
  `startdate` date DEFAULT NULL,
  `duedate` date DEFAULT NULL,
  `datefinished` date DEFAULT NULL,
  `status_id` int(10) unsigned DEFAULT NULL,
  `recurring_type` enum('day','week','month','year') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `recurring_value` int(10) unsigned DEFAULT '0' COMMENT '''0'' means not recurring',
  `cycles` int(11) DEFAULT NULL,
  `total_cycles` int(10) unsigned DEFAULT NULL,
  `last_recurring_date` date DEFAULT NULL,
  `is_public` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'yes',
  `billable` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'yes',
  `billed` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `hourly_rate` double DEFAULT '0',
  `kanban_order` int(11) DEFAULT NULL,
  `milestone_order` int(11) DEFAULT NULL,
  `visible_to_client` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `deadline_notified` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `recurring_id` int(10) unsigned DEFAULT NULL,
  `quote_id` int(10) unsigned DEFAULT NULL,
  `created_by_id` int(10) unsigned DEFAULT NULL,
  `mile_stone_id` int(10) unsigned DEFAULT NULL,
  `is_recurring_from` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `quote_tasks_deleted_at_index` (`deleted_at`),
  KEY `298242_5cc68c34c3153` (`recurring_id`),
  KEY `298242_5cc68c34eed43` (`quote_id`),
  KEY `fk_is_recurring_from_quote_tasks` (`is_recurring_from`),
  KEY `fk_acrm_quote_tasks_created_by_id` (`created_by_id`),
  CONSTRAINT `298242_5cc68c34c3153` FOREIGN KEY (`recurring_id`) REFERENCES `acrm_recurring_periods` (`id`) ON DELETE CASCADE,
  CONSTRAINT `298242_5cc68c34eed43` FOREIGN KEY (`quote_id`) REFERENCES `acrm_quotes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_acrm_quote_tasks_created_by_id` FOREIGN KEY (`created_by_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_is_recurring_from_quote_tasks` FOREIGN KEY (`is_recurring_from`) REFERENCES `acrm_quote_tasks` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_quote_tasks` */

/*Table structure for table `acrm_quotes` */

DROP TABLE IF EXISTS `acrm_quotes`;

CREATE TABLE `acrm_quotes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `invoice_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_quantity_as` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_no` bigint(22) DEFAULT NULL,
  `status` enum('Published','Draft') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_date` date DEFAULT NULL,
  `invoice_due_date` date DEFAULT NULL,
  `invoice_notes` text COLLATE utf8mb4_unicode_ci COMMENT 'Client Notes',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `customer_id` int(10) unsigned DEFAULT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `tax_id` int(10) unsigned DEFAULT NULL,
  `discount_id` int(10) unsigned DEFAULT NULL,
  `recurring_period_id` int(10) unsigned DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `products` longtext COLLATE utf8mb4_unicode_ci,
  `paymentstatus` char(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_id` int(10) unsigned DEFAULT NULL,
  `created_by_id` int(10) unsigned DEFAULT NULL,
  `delivery_address` text COLLATE utf8mb4_unicode_ci COMMENT 'Shipping address',
  `show_delivery_address` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `admin_notes` text COLLATE utf8mb4_unicode_ci,
  `sale_agent` int(10) unsigned DEFAULT NULL,
  `terms_conditions` longtext COLLATE utf8mb4_unicode_ci,
  `prevent_overdue_reminders` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `is_expiry_notified` tinyint(1) DEFAULT '0',
  `invoice_number_format` char(20) COLLATE utf8mb4_unicode_ci DEFAULT 'numberbased',
  `invoice_number_separator` char(5) COLLATE utf8mb4_unicode_ci DEFAULT '-',
  `invoice_number_length` int(11) DEFAULT NULL,
  `proposal_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recurring_invoices_deleted_at_index` (`deleted_at`),
  KEY `259430_5c500cea0e179` (`customer_id`),
  KEY `259430_5c500cea382ac` (`currency_id`),
  KEY `259430_5c500cea57b0d` (`tax_id`),
  KEY `259430_5c500cea7d32d` (`discount_id`),
  KEY `259430_5c500ceaa1e4c` (`recurring_period_id`),
  KEY `fk_quotes_sale_agent` (`sale_agent`),
  KEY `fk_invoice_id_quotes` (`invoice_id`),
  KEY `fk_acrm_quotes_created_by_id` (`created_by_id`),
  KEY `fk_acrm_quotes_proposal_id_idx` (`proposal_id`),
  CONSTRAINT `fk_acrm_quotes_created_by_id` FOREIGN KEY (`created_by_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_acrm_quotes_proposal_id` FOREIGN KEY (`proposal_id`) REFERENCES `acrm_proposals` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_invoice_id_quotes` FOREIGN KEY (`invoice_id`) REFERENCES `acrm_invoices` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_quotes_currency_id` FOREIGN KEY (`currency_id`) REFERENCES `acrm_currencies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_quotes_customerid` FOREIGN KEY (`customer_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_quotes_discount_id` FOREIGN KEY (`discount_id`) REFERENCES `acrm_discounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_quotes_recurring_period_id` FOREIGN KEY (`recurring_period_id`) REFERENCES `acrm_recurring_periods` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_quotes_sale_agent` FOREIGN KEY (`sale_agent`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_quotes_tax_id` FOREIGN KEY (`tax_id`) REFERENCES `acrm_taxes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_quotes` */

/*Table structure for table `acrm_quotes_history` */

DROP TABLE IF EXISTS `acrm_quotes_history`;

CREATE TABLE `acrm_quotes_history` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ip_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` text COLLATE utf8mb4_unicode_ci,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `browser` text COLLATE utf8mb4_unicode_ci,
  `comments` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `quote_id` int(10) unsigned DEFAULT NULL,
  `operation_type` char(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'general, crud, email, sms, cron, payment, status',
  PRIMARY KEY (`id`),
  KEY `invoices_history_deleted_at_index` (`deleted_at`),
  KEY `259415_5c500ae99af17` (`quote_id`),
  CONSTRAINT `fk_quotes_history_quote_id` FOREIGN KEY (`quote_id`) REFERENCES `acrm_quotes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_quotes_history` */

/*Table structure for table `acrm_quotes_notes` */

DROP TABLE IF EXISTS `acrm_quotes_notes`;

CREATE TABLE `acrm_quotes_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` text COLLATE utf8mb4_unicode_ci,
  `date_contacted` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `quote_id` int(10) unsigned DEFAULT NULL,
  `created_by_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `quotes_notes_deleted_at_index` (`deleted_at`),
  KEY `298254_5cc692936db0a` (`quote_id`),
  KEY `fk_acrm_quotes_notes_created_by_id` (`created_by_id`),
  CONSTRAINT `298254_5cc692936db0a` FOREIGN KEY (`quote_id`) REFERENCES `acrm_quotes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_acrm_quotes_notes_created_by_id` FOREIGN KEY (`created_by_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_quotes_notes` */

/*Table structure for table `acrm_quotes_reminders` */

DROP TABLE IF EXISTS `acrm_quotes_reminders`;

CREATE TABLE `acrm_quotes_reminders` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` text COLLATE utf8mb4_unicode_ci,
  `date` date DEFAULT NULL,
  `isnotified` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notify_by_email` enum('no','yes') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `quote_id` int(10) unsigned DEFAULT NULL,
  `reminder_to_id` int(10) unsigned DEFAULT NULL,
  `created_by_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `quotes_reminders_deleted_at_index` (`deleted_at`),
  KEY `298253_5cc691865346c` (`quote_id`),
  KEY `fk_acrm_contacts_quotes_reminders_to` (`reminder_to_id`),
  KEY `fk_acrm_quotes_reminders_created_by_id` (`created_by_id`),
  CONSTRAINT `298253_5cc691865346c` FOREIGN KEY (`quote_id`) REFERENCES `acrm_quotes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_acrm_contacts_quotes_reminders_to` FOREIGN KEY (`reminder_to_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_acrm_quotes_reminders_created_by_id` FOREIGN KEY (`created_by_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_quotes_reminders` */

/*Table structure for table `acrm_recurring_periods` */

DROP TABLE IF EXISTS `acrm_recurring_periods`;

CREATE TABLE `acrm_recurring_periods` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` int(10) DEFAULT '1',
  `type` char(10) COLLATE utf8mb4_unicode_ci DEFAULT 'month' COMMENT 'Eg: day, week, month, year',
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recurring_periods_deleted_at_index` (`deleted_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_recurring_periods` */

/*Table structure for table `acrm_role_user` */

DROP TABLE IF EXISTS `acrm_role_user`;

CREATE TABLE `acrm_role_user` (
  `role_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  KEY `fk_p_259279_259280_user_r_5c4fd26c5adde` (`role_id`),
  KEY `fk_user_id_role_user_idx` (`user_id`),
  CONSTRAINT `fk_acrm_role_user_1` FOREIGN KEY (`user_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_role_id_role_user` FOREIGN KEY (`role_id`) REFERENCES `acrm_roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


/*Table structure for table `acrm_roles` */

DROP TABLE IF EXISTS `acrm_roles`;

CREATE TABLE `acrm_roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `color` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `type` enum('contact_type','role') COLLATE utf8mb4_unicode_ci DEFAULT 'contact_type',
  `status` enum('active','inactive') COLLATE utf8mb4_unicode_ci DEFAULT 'active',
  `priority` int(11) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_roles` */

insert  into `acrm_roles`(`id`,`title`,`name`,`slug`,`description`,`created_at`,`updated_at`,`color`,`deleted_at`,`type`,`status`,`priority`) values 
(1,'Administrator (can create other users)','Administrator (can create other users)','Admin',NULL,'2019-01-30 12:52:17','2019-04-04 09:56:35','#41cc57',NULL,'role','active',11),
(2,'Customer','Customer','Customer',NULL,'2019-01-30 12:52:17','2019-07-16 12:16:52','#80828a',NULL,'role','active',2),
(3,'Business Manager','Business Manager','BusinessManager','Test','2019-01-30 12:52:17','2019-07-29 05:48:12','#b2c920',NULL,'role','active',3),
(4,'Sales Manager','Sales Manager','SalesManager',NULL,'2019-01-30 12:52:17','2019-04-13 05:43:52','#3ebce6',NULL,'role','active',6),
(5,'Sale Agent','Sale Agent','SalesPerson',NULL,'2019-01-30 12:52:17','2019-07-16 05:11:20','#000000',NULL,'role','active',7),
(6,'Project Manager','Project Manager','ProjectManager',NULL,'2019-01-30 12:52:17','2019-07-16 12:05:06','#660505',NULL,'role','active',8),
(7,'Stock Manager','Stock Manager','StockManager',NULL,'2019-01-30 12:52:17','2019-07-16 12:04:21','#c94008',NULL,'role','active',9),
(8,'Supplier','Supplier','Supplier',NULL,'2019-01-30 12:52:17','2019-07-03 11:23:05','#4a7037',NULL,'role','active',10),
(10,'Client','Client','Client',NULL,'2019-03-18 09:06:56','2019-08-22 06:10:25','#221199',NULL,'role','active',4),
(11,'Lead','Lead','Leads',NULL,'2019-01-30 12:52:17','2019-08-17 05:11:26',NULL,NULL,'contact_type','active',1),
(12,'Employee','Employee','Employee',NULL,'2019-05-16 04:43:20','2019-08-29 03:37:57','#d93434',NULL,'role','active',5),
(14,'Executive','Executive',NULL,NULL,'2019-09-17 06:18:19','2019-09-17 06:18:19','#c2bc30',NULL,'role','active',1);

/*Table structure for table `acrm_send_sms` */

DROP TABLE IF EXISTS `acrm_send_sms`;

CREATE TABLE `acrm_send_sms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `send_to` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `message` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `gateway_id` int(10) unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gateway_response` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `send_sms_deleted_at_index` (`deleted_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_send_sms` */

/*Table structure for table `acrm_site_themes` */

DROP TABLE IF EXISTS `acrm_site_themes`;

CREATE TABLE `acrm_site_themes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `theme_title_key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `settings_data` text COLLATE utf8mb4_unicode_ci,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_active` char(2) COLLATE utf8mb4_unicode_ci DEFAULT '0',
  `theme_color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `site_themes_deleted_at_index` (`deleted_at`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_site_themes` */

insert  into `acrm_site_themes`(`id`,`title`,`slug`,`theme_title_key`,`settings_data`,`description`,`is_active`,`theme_color`,`created_at`,`updated_at`,`deleted_at`) values 
(1,'Default','default','default','{\"theme_color\":{\"value\":\"skin-blue\",\"type\":\"select\",\"extra\":{\"total_options\":\"12\",\"options\":{\"skin-blue\":\"Blue\",\"skin-black\":\"Black\",\"skin-red\":\"Red\",\"skin-yellow\":\"Yellow\",\"skin-purple\":\"Purple\",\"skin-green\":\"Green\",\"skin-blue-light\":\"Blue Light\",\"skin-black-light\":\"Black Light\",\"skin-red-light\":\"Red Light\",\"skin-yellow-light\":\"Yellow Light\",\"skin-purple-light\":\"Purple Light\",\"skin-green-light\":\"Green Light\"}},\"tool_tip\":\"Site Theme Color\"}}',NULL,'0',NULL,'2018-03-24 00:00:00','2019-09-28 10:34:34',NULL),
(3,'BSB','bsb','bsb','{\"skin\":{\"value\":\"Teal\",\"type\":\"select\",\"extra\":{\"total_options\":\"20\",\"options\":{\"Red\":\"Red\",\"Pink\":\"Pink\",\"Purple\":\"Purple\",\"Deep Purple\":\"Deep Purple\",\"Indigo\":\"Indigo\",\"Blue\":\"Blue\",\"Light Blue\":\"Light Blue\",\"Cyan\":\"Cyan\",\"Teal\":\"Teal\",\"Green\":\"Green\",\"Light Green\":\"Light Green\",\"Lime\":\"Lime\",\"Yellow\":\"Yellow\",\"Amber\":\"Amber\",\"Orange\":\"Orange\",\"Deep Orange\":\"Deep Orange\",\"Brown\":\"Brown\",\"Grey\":\"Grey\",\"Blue Grey\":\"Blue Grey\",\"Black\":\"Black\"}},\"tool_tip\":\"Skin\"},\"user-profile-placement\":{\"value\":\"Topbar\",\"type\":\"select\",\"extra\":{\"total_options\":\"2\",\"options\":{\"Topbar\":\"Topbar\",\"Sidebar\":\"Sidebar\"}},\"tool_tip\":\"User Profile Placement\"}}','Test Description','1',NULL,NULL,'2019-09-28 10:35:05',NULL);

/*Table structure for table `acrm_sms_gateways` */

DROP TABLE IF EXISTS `acrm_sms_gateways`;

CREATE TABLE `acrm_sms_gateways` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sms_gateways_deleted_at_index` (`deleted_at`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_sms_gateways` */

insert  into `acrm_sms_gateways`(`id`,`name`,`key`,`description`,`created_at`,`updated_at`,`deleted_at`) values 
(1,'Plivo','plivo','Plivo','2019-03-15 07:52:23','2019-03-15 07:52:23',NULL),
(2,'Nexmo','nexmo','Nexmo','2019-03-15 07:52:23','2019-03-15 07:52:23',NULL),
(3,'Twilio','twilio','Twilio','2019-03-15 07:52:23','2019-03-15 07:52:23',NULL);

/*Table structure for table `acrm_smstemplates` */

DROP TABLE IF EXISTS `acrm_smstemplates`;

CREATE TABLE `acrm_smstemplates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `smstemplates_key_unique` (`key`),
  KEY `smstemplates_deleted_at_index` (`deleted_at`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_smstemplates` */

insert  into `acrm_smstemplates`(`id`,`title`,`key`,`content`,`created_at`,`updated_at`,`deleted_at`) values 
(1,'Invoice Created','invoice-created','Dear {{$client_name}} \r\nYour Invoice#  {{$invoice_no}} is created. To view your invoice-{{$invoice_url}}\r\nRegards,\r\n{{$site_title}}','2019-02-14 13:42:39','2019-02-14 13:44:59',NULL),
(2,'Invoice Reminder','invoice-reminder','Dear {{$client_name}}, Please make payment of invoice  # {{$invoice_no}}. {{$invoice_url}} Regards {{$site_title}}','2019-02-14 13:44:38','2019-07-31 05:03:13',NULL),
(3,'Payment Received','payment-received','Dear {{$client_name}}, Payment received of invoice  # {{$invoice_no}} on {{$payment_date}}. {{$invoice_url}} Regards {{$site_title}}','2019-02-14 13:46:13','2019-07-31 05:03:26',NULL),
(4,'Payment Overdue','payment-overdue','Dear {{$client_name}}, Payment overdue of invoice  # {{$invoice_no}}. {{$invoice_url}} Regards {{$site_title}}','2019-02-14 13:47:15','2019-07-31 05:03:40',NULL),
(5,'Refund processed','refund-processed','Dear {{$client_name}}, Payment refund processed of invoice  # {{$invoice_no}}. {{$invoice_url}} Regards {{$site_title}}','2019-02-14 13:48:18','2019-09-17 06:05:42',NULL),
(6,'Quote Created','quote-created','Dear {{$client_name}} \r\nYour Quote#  {{$invoice_no}} is created. To view your quote-{{$invoice_url}}\r\nRegards,\r\n{{$site_title}}','2019-02-21 06:18:49','2019-02-21 06:18:49',NULL),
(7,'Quote Accepted','quote-accepted','Dear {{$client_name}} \r\n\r\nThanks for Accepting Quote - {{$invoice_no}}. You can view this Quote-{{$invoice_url}}\r\n\r\nRegards,\r\n{{$site_title}}','2019-02-21 06:20:55','2019-02-21 06:20:55',NULL),
(8,'Quote Cancelled','quote-cancelled','Dear {{$client_name}} \r\nQuote has been cancelled - {{$invoice_no}}. You can view this Quote- {{$invoice_url}}\r\nRegards,\r\n{{$site_title}}','2019-02-21 06:22:13','2019-02-21 06:22:13',NULL),
(9,'Order Created','order-created','Dear {{$client_name}} \r\nYour purchase order#  {{$invoice_no}} is created. To view your order-{{$invoice_url}}\r\nRegards,\r\n{{$site_title}}','2019-02-26 11:05:41','2019-02-26 11:05:41',NULL),
(10,'Order Accepted','order-accepted','Dear {{$client_name}} \r\nYour order#  {{$invoice_no}} is accepted. To view your order-{{$invoice_url}}\r\nRegards,\r\n{{$site_title}}','2019-02-26 11:08:29','2019-02-26 11:33:01',NULL),
(11,'Order Cancelled','order-cancelled','Dear {{$client_name}} \r\nYour order#  {{$invoice_no}} is cancelled. To view your order-{{$invoice_url}}\r\nRegards,\r\n{{$site_title}}','2019-02-26 11:09:04','2019-02-26 11:09:04',NULL),
(12,'Payment Reminder','payment-reminder','Dear {{$client_name}}, Payment of invoice  # {{$invoice_no}} is due on {{$payment_date}}. {{$invoice_url}} Regards {{$site_title}}','2019-09-16 04:59:13','2019-09-16 05:30:31',NULL),
(13,'Payment refund','payment-refund','Dear {{$client_name}}, Payment refund processed of invoice  # {{$invoice_no}}. {{$invoice_url}} Regards {{$site_title}}','2019-09-16 05:28:04','2019-09-16 05:34:23',NULL),
(14,'Proposal Created','proposal-created','Dear {{$client_name}} \r\nYour Invoice#  {{$invoice_no}} is created. To view your invoice-{{$invoice_url}}\r\nRegards,\r\n{{$site_title}}','2019-09-11 05:39:46','2019-09-11 05:39:46',NULL),
(15,'Proposal Accepted','proposal-accepted','Dear {{$client_name}} \r\n\r\nThanks for Accepting Proposal- {{$invoice_no}}. You can view this Proposal-{{$invoice_url}}\r\n\r\nRegards,\r\n{{$site_title}}','2019-09-11 05:46:42','2019-09-11 05:57:46',NULL),
(16,'Proposal Cancelled','Proposal-cancelled','Dear {{$client_name}} \r\nProposal has been cancelled - {{$invoice_no}}. You can view this Proposal- {{$invoice_url}}\r\nRegards,\r\n{{$site_title}}','2019-09-11 05:48:17','2019-09-11 05:48:17',NULL),
(17,'Contract Created','contract-created','Dear {{$client_name}} \r\nYour Contract#  {{$invoice_no}} is created. To view your contract-{{$invoice_url}}\r\nRegards,\r\n{{$site_title}}','2019-09-28 08:27:07','2019-09-28 08:27:07',NULL),
(18,'Contract Accepted','contract-accepted','Dear {{$client_name}} \r\n\r\nThanks for Accepting Contract - {{$invoice_no}}. You can view this Contract-{{$invoice_url}}\r\n\r\nRegards,\r\n{{$site_title}}','2019-09-28 08:30:36','2019-09-28 08:30:36',NULL),
(19,'Contract Cancelled','contract-cancelled','Dear {{$client_name}} \r\nContract has been cancelled - {{$invoice_no}}. You can view this Contract- {{$invoice_url}}\r\nRegards,\r\n{{$site_title}}','2019-09-28 08:33:30','2019-09-28 08:33:30',NULL);

/*Table structure for table `acrm_supports` */

DROP TABLE IF EXISTS `acrm_supports`;

CREATE TABLE `acrm_supports` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` enum('Low','Medium','High','Urgent') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `department_id` int(10) unsigned DEFAULT NULL,
  `created_by_id` int(10) unsigned DEFAULT NULL,
  `assigned_to_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `supports_deleted_at_index` (`deleted_at`),
  KEY `259533_5c50317ee7f26` (`department_id`),
  KEY `fk_acrm_supports_createdby_id` (`created_by_id`),
  KEY `fk_acrm_supports_assigned_to_id` (`assigned_to_id`),
  CONSTRAINT `259533_5c50317ee7f26` FOREIGN KEY (`department_id`) REFERENCES `acrm_departments` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_acrm_supports_assigned_to_id` FOREIGN KEY (`assigned_to_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_acrm_supports_createdby_id` FOREIGN KEY (`created_by_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_supports` */

/*Table structure for table `acrm_task_statuses` */

DROP TABLE IF EXISTS `acrm_task_statuses`;

CREATE TABLE `acrm_task_statuses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT 'panel-primary',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_task_statuses` */

insert  into `acrm_task_statuses`(`id`,`name`,`color`,`created_at`,`updated_at`) values 
(1,'Open','panel-warning',NULL,'2019-09-25 08:51:07'),
(2,'In progress','panel-primary',NULL,NULL),
(3,'Close','panel-info',NULL,'2019-09-25 08:50:57'),
(4,'Completed','panel-success',NULL,'2019-09-25 08:50:45'),
(5,'Deferred','panel-warning',NULL,'2019-09-25 08:50:32'),
(15,'Support','panel-default',NULL,'2019-09-25 08:50:03');

/*Table structure for table `acrm_task_tags` */

DROP TABLE IF EXISTS `acrm_task_tags`;

CREATE TABLE `acrm_task_tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_task_tags` */

/*Table structure for table `acrm_task_task_tag` */

DROP TABLE IF EXISTS `acrm_task_task_tag`;

CREATE TABLE `acrm_task_task_tag` (
  `task_id` int(10) unsigned DEFAULT NULL,
  `task_tag_id` int(10) unsigned DEFAULT NULL,
  KEY `fk_p_259298_259297_taskta_5c4fd7e7a5022` (`task_id`),
  KEY `fk_p_259297_259298_task_t_5c4fd7e7a50e3` (`task_tag_id`),
  CONSTRAINT `fk_p_259297_259298_task_t_5c4fd7e7a50e3` FOREIGN KEY (`task_tag_id`) REFERENCES `acrm_task_tags` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_p_259298_259297_taskta_5c4fd7e7a5022` FOREIGN KEY (`task_id`) REFERENCES `acrm_tasks` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_task_task_tag` */

/*Table structure for table `acrm_tasks` */

DROP TABLE IF EXISTS `acrm_tasks`;

CREATE TABLE `acrm_tasks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `attachment` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `due_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `259298_5c4fd7e568411` (`status_id`),
  KEY `fk_acrm_tasks_contacts_user_id_idx` (`user_id`),
  CONSTRAINT `259298_5c4fd7e568411` FOREIGN KEY (`status_id`) REFERENCES `acrm_task_statuses` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_acrm_tasks_contacts_user_id` FOREIGN KEY (`user_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_tasks` */

/*Table structure for table `acrm_taxes` */

DROP TABLE IF EXISTS `acrm_taxes`;

CREATE TABLE `acrm_taxes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rate` double(7,2) DEFAULT NULL,
  `rate_type` enum('value','percent') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `taxes_deleted_at_index` (`deleted_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_taxes` */

/*Table structure for table `acrm_templates` */

DROP TABLE IF EXISTS `acrm_templates`;

CREATE TABLE `acrm_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` enum('Content','Header','Footer') COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `from_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `from_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `status` char(10) COLLATE utf8mb4_unicode_ci DEFAULT 'active',
  PRIMARY KEY (`id`),
  UNIQUE KEY `templates_key_unique` (`key`),
  KEY `templates_deleted_at_index` (`deleted_at`)
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_templates` */

insert  into `acrm_templates`(`id`,`title`,`key`,`type`,`subject`,`from_email`,`from_name`,`content`,`created_at`,`updated_at`,`deleted_at`,`status`) values 
(1,'Header','header','Header','Header','info@laraoffice.com','LaraOffice','<!-- HEADER -->\r\n<table>\r\n  <tbody>\r\n   <tr>\r\n      <td>&nbsp;</td>\r\n     <td>\r\n      <table style=\"height:57px; width:753px\">\r\n        <tbody>\r\n         <tr>\r\n            <td><img alt=\"{{$site_title}}\" src=\"{{$logo}}\" style=\"height:39px; width:180px\" /></td>\r\n           <td>\r\n            <p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;  &nbsp; &nbsp; {{$date}}&nbsp; &nbsp; &nbsp;&nbsp;</p>\r\n           </td>\r\n         </tr>\r\n       </tbody>\r\n      </table>\r\n      </td>\r\n     <td>&nbsp;</td>\r\n   </tr>\r\n </tbody>\r\n</table>\r\n<!-- /HEADER -->','2019-02-12 06:34:13','2019-06-18 10:51:34',NULL,'active'),
(2,'Footer','footer','Footer','Footer','info@laraoffice.com','LaraOffice','<!-- FOOTER -->\r\n<table>\r\n  <tbody>\r\n   <tr>\r\n      <td>&nbsp;</td>\r\n     <td>\r\n      <table>\r\n       <tbody>\r\n         <tr>\r\n            <td colspan=\"2\">\r\n            <p>Post! Remember - this is not a marketing email. Since you have an Envato Account, we want to keep you informed about transactions, operational updates or changes to our websites</p>\r\n\r\n            <p>&nbsp;</p>\r\n           </td>\r\n         </tr>\r\n       </tbody>\r\n      </table>\r\n      </td>\r\n     <td>&nbsp;</td>\r\n   </tr>\r\n </tbody>\r\n</table>\r\n<!-- /FOOTER -->','2019-02-12 06:47:54','2019-04-13 10:16:58',NULL,'active'),
(3,'Invoice Created','invoice-created','Content','Invoice Created','info@laraoffice.com','LaraOffice','<div style=\"line-height:1.6;color:#222;text-align:left;width:1000px;font-size:10pt;margin:0px 10px;font-family:verdana,\'droid sans\',\'lucida sans\',sans-serif;padding:14px;border:3px solid #d8d8d8;border-top:3px solid #007bc3\">\r\n<div style=\"padding:5px;font-size:11pt;font-weight:bold\">Dear {{$client_name}},</div>\r\n\r\n<div style=\"padding:5px\">This email serves as your official invoice from <strong>{{$site_title}}</strong></div>\r\n\r\n<div style=\"padding:10px 5px\">View Invoice: Click <a href=\"{{$invoice_url}}\">here</a><br />\r\nInvoice No.: {{$invoice_no}}<br />\r\nInvoice Amount: {{$invoice_amount}}<br />\r\nInvoice Date: {{$invoice_date}} <br />Due Date: {{$invoice_due_date}}</div>\r\n\r\n<div style=\"padding:5px\"><span style=\"font-size:13.3333330154419px\">If you have any questions or need assistance, please don&#39;t hesitate to contact us.</span></div>\r\n\r\n<div style=\"padding:0px 5px\">Best Regards,<br />\r\n{{$site_title}}</div>\r\n\r\n<div style=\"padding:0px 5px\">{{$site_address}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Phone: {{$site_phone}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Email: {{$site_email}}</div>\r\n</div>','2019-02-12 06:59:36','2019-06-15 11:01:10',NULL,'active'),
(4,'Payment Reminder','payment-reminder','Content','Payment Reminder','info@laraoffice.com','LaraOffice','<p>Dear {{$client_name}},</p>\r\n\r\n<p>We are contacting you in regard to a payment reminder of invoice {{$invoice_no}} that has been created on your account on {{$date}}. You may find the invoice with below link. Please pay the balance of {{$amount_due}} due by {{$invoice_due_date}}.</p>\r\n\r\n<p><b>If already paid please Ignore.</b></p>\r\n\r\n<p>View Invoice: Click <a href=\"{{$invoice_url}}\">here</a><br />\r\nInvoice No.: {{$invoice_no}}<br />\r\nInvoice Amount: {{$invoice_amount}}<br />\r\nInvoice Date: {{$invoice_date}}</p>\r\n\r\n<p>Due Date: {{$invoice_due_date}}</p>\r\n\r\n<p><span style=\"font-size:1rem\">We look forward to conducting future business with you.&nbsp;</span>If you have any questions or need assistance, please don&#39;t hesitate to contact us.</p>\r\n\r\n<p><span style=\"font-size:1rem\">Kind Regards, </span></p>\r\n\r\n<p><span style=\"font-size:1rem\">Team </span></p>\r\n\r\n<p>{{$site_title}}</p>\r\n\r\n<p>{{$site_address}}</p>\r\n\r\n<p>Phone: {{$site_phone}}</p>\r\n\r\n<p>Email: {{$site_email}}</p>\r\n\r\n<h6>&nbsp;</h6>\r\n\r\n<p>&nbsp;</p>','2019-02-12 08:52:58','2019-07-15 10:37:03',NULL,'active'),
(5,'Payment Received','payment-received','Content','Payment Received','info@laraoffice.com','LaraOffice','<p>Dear <strong>{{$client_name}}</strong>,</p>\r\n\r\n<p>We are contacting you in regarding to a payment received of invoice # {{$invoice_no}} that has been created on your account on {{$invoice_date}}. You may find the invoice with below link. Please pay the balance of {{$amount_due}} due by {{$invoice_due_date}}.</p>\r\n\r\n<p><b>If already paid please ignore.</b></p>\r\n\r\n<p><strong>View Invoice: Click <a href=\"{{$invoice_url}}\">here</a><br />\r\n<strong>Invoice No.</strong>: {{$invoice_no}}<br />\r\n<strong>Invoice Amount</strong>: {{$invoice_amount}}</strong></p>\r\n\r\n<p><strong>Invoice Date:&nbsp;{{$invoice_date}}​<br />\r\n<strong>Due Date</strong>: {{$invoice_due_date}}</strong></p>\r\n\r\n<p><strong><span style=\"font-size:1rem\">We look forward to conducting future business with you.&nbsp;</span>If you have any questions or need assistance, please don&#39;t hesitate to contact us.</strong></p>\r\n\r\n<p><strong><span style=\"font-size:1rem\">Best Regards, </span></strong></p>\r\n\r\n<p><strong><span style=\"font-size:1rem\">{{$site_address}}</span></strong></p>\r\n\r\n<p><strong><span style=\"font-size:1rem\">Phone: {{$site_phone}}</span></strong></p>\r\n\r\n<p><strong><span style=\"font-size:1rem\">Email: {{$site_email}}</span></strong></p>','2019-02-12 09:30:39','2019-07-15 10:36:46',NULL,'active'),
(6,'Payment Overdue','payment-overdue','Content','Payment Overdue','info@laraoffice.com','LaraOffice','<p>Dear {{$client_name}},</p>\r\n\r\n<p>We are contacting you in regard to a payment overdue reminder of invoice # {{$invoice_no}} that has been created on your account on {{$date}}. You may find the invoice with below link. Please pay the balance of {{$amount_due}} due by {{$invoice_due_date}}.</p>\r\n\r\n<p><b>If already paid please ignore.</b></p>\r\n\r\n<p><strong>View Invoice: Click <a href=\"{{$invoice_url}}\">here</a></strong></p>\r\n\r\n<p><strong>Invoice ID: {{$invoice_no}}<br />\r\nInvoice Amount: {{$invoice_amount}}<br />\r\nDue Date: {{$invoice_due_date}}</strong></p>\r\n\r\n<p><strong><span style=\"font-size:1rem\">We look forward to conducting future business with you.&nbsp;</span>If you have any questions or need assistance, please don&#39;t hesitate to contact us.</strong></p>\r\n\r\n<p><strong><span style=\"font-size:1rem\">Best Regards, </span></strong></p>\r\n\r\n<p><strong>{{$site_address}}</strong></p>\r\n\r\n<p><strong>Phone: {{$site_phone}}</strong></p>\r\n\r\n<p><strong>Email: {{$site_email}}</strong></p>','2019-02-12 09:34:52','2019-07-15 10:35:58',NULL,'active'),
(7,'Refund Proceeded','refund-proceeded','Content','Refund Proceeded','info@laraoffice.com','LaraOffice','<p>Dear <strong>{{$client_name}}</strong>,</p>\r\n\r\n<p>We are contacting you in regard to a payment refund processed for Invoice no&nbsp; # {{$invoice_no}} that has been created on your account and sent you on {{$date}}. You may find the Invoice with below link.</p>\r\n\r\n<p><strong>View Invoice no​:Click <a href=\"{{$invoice_url}}\">here</a><br />\r\nInvoice no<strong>.</strong>: {{$invoice_no}}<br />\r\nInvoice<strong>&nbsp;Amount</strong>: {{$invoice_amount}}<br />\r\n<strong>Due Date</strong>: {{$invoice_due_date}}</strong></p>\r\n\r\n<p><strong>We look forward to conducting future business with you.&nbsp;If you have any questions or need assistance, please don&#39;t hesitate to contact us.</strong></p>\r\n\r\n<p><strong>Best Regards, </strong></p>\r\n\r\n<p><strong>{{$site_address}}</strong></p>\r\n\r\n<p><strong>Phone: {{$site_phone}}</strong></p>\r\n\r\n<p><strong>Email: {{$site_email}}</strong></p>','2019-02-12 09:41:23','2019-09-17 04:21:03',NULL,'active'),
(8,'Quote Created','quote-created','Content','Quote Created','info@laraoffice.com','LaraOffice','<p>Dear {{$client_name}},</p>\r\n\r\n<p>This email serves as your official quote from <strong>{{$site_title}}</strong></p>\r\n\r\n<p>View Quote: Click <a href=\"{{$invoice_url}}\">here</a><br />\r\nQuote No.: {{$invoice_no}}</p>\r\n\r\n<p>Quote Date.: {{$invoice_date}}<br />\r\nValid Till: {{$invoice_due_date}}</p>\r\n\r\n<p>If you have any questions or need assistance, please don&#39;t hesitate to contact us.&nbsp;We look forward to conducting future business with you.</p>\r\n\r\n<p>Best Regards,<br />\r\n{{$site_title}}</p>\r\n\r\n<p>{{$site_address}}</p>\r\n\r\n<p>Phone: {{$site_phone}}</p>\r\n\r\n<p>Email: {{$site_email}}</p>','2019-02-21 06:15:59','2019-09-14 07:08:49',NULL,'active'),
(9,'Order Created','order-created','Content','Order Created','info@laraoffice.com','LaraOffice','<div style=\"line-height:1.6;color:#222;text-align:left;width:1000px;font-size:10pt;margin:0px 10px;font-family:verdana,\'droid sans\',\'lucida sans\',sans-serif;padding:14px;border:3px solid #d8d8d8;border-top:3px solid #007bc3\">\r\n<div style=\"padding: 5px; font-size: 11pt; font-weight: bold;\">Dear {{$client_name}},</div>\r\n\r\n<div style=\"padding: 5px;\">This email serves as your official order from <strong>{{$site_title}}</strong></div>\r\n\r\n<div style=\"padding: 10px 5px;\">Thank you for your order! Below are order details:</div>\r\nCreated Date: {{$order_created_date}}\r\n\r\n<div style=\"padding: 10px 5px;\">Products:</div>\r\n\r\n<div style=\"padding: 10px 5px;\">{!!$products!!}</div>\r\n\r\n<div style=\"padding: 10px 5px;\">Outstanding Amount Payable on Delivery:&nbsp;<strong>{{$amount}}.</strong></div>\r\n\r\n<div style=\"padding: 5px;\">Delivery Address:</div>\r\n\r\n<div style=\"padding: 5px;\">{!!$delivery_address!!}</div>\r\n\r\n<div style=\"padding: 5px;\"><span style=\"font-size:13.3333330154419px\">If you have any questions or need assistance, please don&#39;t hesitate to contact us.&nbsp;</span>We look forward to conducting future business with you.</div>\r\n\r\n<div style=\"padding: 0px 5px;\">Best Regards,<br />\r\n{{$site_title}}</div>\r\n\r\n<div style=\"padding: 0px 5px;\">{{$site_address}}</div>\r\n\r\n<div style=\"padding: 0px 5px;\">Phone: {{$site_phone}}</div>\r\n\r\n<div style=\"padding: 0px 5px;\">Email: {{$site_email}}</div>\r\n</div>','2019-02-26 11:04:21','2019-06-19 09:14:54',NULL,'active'),
(10,'coupon','themeee','Content','wdsa','ravitejauiux@gmail.com','teja','<p>test description</p>','2019-03-16 08:32:22','2019-03-16 08:32:32','2019-03-16 08:32:32','active'),
(11,'Expense Created','expense-created','Content','Expense Created','info@laraoffice.com','LaraOffice','<div style=\"line-height:1.6;color:#222;text-align:left;width:550px;font-size:10pt;margin:0px 10px;font-family:verdana,\'droid sans\',\'lucida sans\',sans-serif;padding:14px;border:3px solid #d8d8d8;border-top:3px solid #007bc3\">\r\n<div style=\"padding:5px;font-size:11pt;font-weight:bold\">Dear Admin,</div>\r\n\r\n<div style=\"padding:5px\">There was a expense recorded in your site. Please find details below:</div>\r\n\r\n<div style=\"padding:10px 5px\">Account: {{$account_id}}<br />\r\nExpense category : {{$expense_category_id}}<br />\r\nEntry date: {{$entry_date}}<br />\r\nAmount: {{$amount}}<br />\r\nDescription: {!!$description!!}<br />\r\nPayee: {{$payee_id}}<br />\r\nPayment method: {{$payment_method_id}}<br />\r\nRef.: {{$ref_no}}<br />\r\nCreated at: {{$created_at}}</div>\r\n\r\n<div style=\"padding:5px\"><span style=\"font-size:13.3333330154419px\">If you have any questions or need assistance, please don&#39;t hesitate to contact us.</span></div>\r\n\r\n<div style=\"padding:0px 5px\">Best Regards,<br />\r\n{{$site_title}}</div>\r\n\r\n<div style=\"padding:0px 5px\">{{$site_address}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Phone: {{$site_phone}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Email: {{$site_email}}</div>\r\n</div>','2019-03-28 14:36:02','2019-06-10 12:52:48',NULL,'active'),
(12,'User Created','user-created','Content','Your account has been created','info@laraoffice.com','LaraOffice','<p>Dear <strong>{{$name}}</strong>,</p>\r\n\r\n<p><strong>Welcome to {{$site_title}}!</strong></p>\r\n\r\n<p>Your account &#39;{{$user_name}}&#39; has been successfully created at at&nbsp;<a href=\"{{$site_url}}\" target=\"_blank\">{{$site_url}}</a>.</p>\r\n\r\n<p>Here are a couple of tips to help you get started:</p>\r\n\r\n<ul>\r\n  <li><strong>Use link below</strong>&nbsp;to <a href=\"{{$activation_link}}\">activate</a>&nbsp;your account at <strong>{{$site_title}}</strong>.</li>\r\n</ul>\r\n\r\n<p>Once you activate the account use the following details to login:</p>\r\n\r\n<p><strong>Username:&nbsp;</strong>{{$user_name}}</p>\r\n\r\n<p><strong>Password:&nbsp;</strong>{{$password}}</p>\r\n\r\n<p>Should you ever encounter problems with your account or forget your password we will contact you at this address.</p>\r\n\r\n<p>Enjoy!</p>\r\n\r\n<p>The <strong>{{$site_title}}</strong> Team</p>','2019-03-29 04:35:35','2019-04-13 10:13:38',NULL,'active'),
(13,'Recurring Invoice Created','recurring-invoice-created','Content','Recurring Invoice Created','info@laraoffice.com','LaraOffice','<div style=\"line-height:1.6;color:#222;text-align:left;width:1000px;font-size:10pt;margin:0px 10px;font-family:verdana,\'droid sans\',\'lucida sans\',sans-serif;padding:14px;border:3px solid #d8d8d8;border-top:3px solid #007bc3\">\r\n<div style=\"padding:5px;font-size:11pt;font-weight:bold\">Dear {{$client_name}},</div>\r\n\r\n<div style=\"padding:10px\">This email serves as your official invoice from <strong>{{$site_title}}</strong></div>\r\n\r\n<div style=\"padding:10px 5px\">View Invoice: Click <a href=\"{{$invoice_url}}\">here</a><br />\r\nInvoice No.: {{$invoice_no}}<br />\r\nInvoice Amount: {{$invoice_amount}}<br />\r\nInvoice Date: {{$invoice_date}}<br />\r\nDue Date: {{$invoice_due_date}}\r\n<div style=\"padding:5px\"><span style=\"font-size:13.3333330154419px\">If you have any questions or need assistance, please don&#39;t hesitate to contact us.</span></div>\r\n<br />\r\n<div style=\"padding:0px 5px\">Best Regards,<br />\r\n{{$site_title}}</div>\r\n\r\n<div style=\"padding:0px 5px\">{{$site_address}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Phone: {{$site_phone}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Email: {{$site_email}}</div>\r\n</div>\r\n</div>','2019-03-29 08:06:17','2019-06-18 04:45:21',NULL,'active'),
(14,'Invoice Created','invoice-created(duplicate)(duplicate)','Content','Invoice Created','adiyya@gmail.com','KnowingGod','<div style=\"line-height:1.6;color:#222;text-align:left;width:550px;font-size:10pt;margin:0px 10px;font-family:verdana,\'droid sans\',\'lucida sans\',sans-serif;padding:14px;border:3px solid #d8d8d8;border-top:3px solid #007bc3\">\r\n<div style=\"padding:5px;font-size:11pt;font-weight:bold\">Dear {{$client_name}},</div>\r\n\r\n<div style=\"padding:5px\">This email serves as your official invoice from <strong>{{$site_title}}</strong></div>\r\n\r\n<div style=\"padding:10px 5px\">View Invoice: {{$invoice_url}}<br />\r\nInvoice No.: {{$invoice_no}}<br />\r\nInvoice Amount: {{$invoice_amount}}<br />\r\nDue Date: {{$invoice_due_date}}</div>\r\n\r\n<div style=\"padding:5px\"><span style=\"font-size:13.3333330154419px\">If you have any questions or need assistance, please don&#39;t hesitate to contact us.</span></div>\r\n\r\n<div style=\"padding:0px 5px\">Best Regards,<br />\r\n{{$site_title}}</div>\r\n\r\n<div style=\"padding:0px 5px\">{{$site_address}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Phone: {{$site_phone}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Email: {{$site_email}}</div>\r\n</div>','2019-03-29 08:08:03','2019-03-29 08:08:54','2019-03-29 08:08:54','active'),
(15,'Task Assigned','task-assigned','Content','Task Assigned','info@laraoffice.com','LaraOffice','<div style=\"line-height:1.6;color:#222;text-align:left;width:550px;font-size:10pt;margin:0px 10px;font-family:verdana,\'droid sans\',\'lucida sans\',sans-serif;padding:14px;border:3px solid #d8d8d8;border-top:3px solid #007bc3\">\r\n<div style=\"padding:5px;font-size:11pt;font-weight:bold\">Dear {{$client_name}},</div>\r\n\r\n<div style=\"padding:5px\">Following are task assignment for you:</div>\r\n\r\n<div style=\"padding:5px\">Name: {{$name}}</div>\r\n\r\n<div style=\"padding:5px\">Description: {!!$description!!}</div>\r\n\r\n<div style=\"padding:5px\">Status: {{$status_id}}</div>\r\n\r\n<div style=\"padding:5px\">Start date: {{$start_date}}</div>\r\n\r\n<div style=\"padding:5px\">Due date: {{$due_date}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Best Regards,<br />\r\n{{$site_title}}</div>\r\n\r\n<div style=\"padding:0px 5px\">{{$site_address}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Phone: {{$site_phone}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Email: {{$site_email}}</div>\r\n</div>','2019-03-29 10:21:38','2019-04-13 10:12:48',NULL,'active'),
(16,'Order Payment Success','order-payment-success','Content','Order Payment Success','info@laraoffice.com','LaraOffice','<div style=\"line-height:1.6; color:#222; text-align:left; width:1000px; font-size:10pt; margin:0px 10px; font-family:verdana,\'droid sans\',\'lucida sans\',sans-serif;padding:14px;border:3px solid #d8d8d8;border-top:3px solid #007bc3\">\r\n<div style=\"padding:5px;font-size:11pt;font-weight:bold\">Dear {{$client_name}},</div>\r\n\r\n<div style=\"padding:5px\">This email serves as your official order from <strong>{{$site_title}}</strong></div>\r\n\r\n<div style=\"padding:10px 5px\">Thank you for your order! Below are order details:</div>\r\n\r\n<div style=\"padding:10px 5px\">Products:</div>\r\n\r\n<div style=\"padding:10px 5px\">{!!$products!!}</div>\r\n\r\n<div style=\"padding:10px 5px\">Outstanding Amount Payable on Delivery: <strong>{{$amount}}.</strong></div>\r\n\r\n<div style=\"padding:5px\">{{$track_link}}</div>\r\n\r\n<div style=\"padding:5px\">Delivery Address:</div>\r\n\r\n<div style=\"padding:5px\">{!! $delivery_address !!}</div>\r\n\r\n<div style=\"padding:5px\"><span style=\"font-size:13.3333330154419px\">If you have any questions or need assistance, please don&#39;t hesitate to contact us.&nbsp;</span>We look forward to conducting future business with you.</div>\r\n\r\n<div style=\"padding:0px 5px\">Best Regards,<br />\r\n{{$site_title}}</div>\r\n\r\n<div style=\"padding:0px 5px\">{{$site_address}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Phone: {{$site_phone}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Email: {{$site_email}}</div>\r\n</div>','2019-03-29 11:06:52','2019-06-27 06:18:37',NULL,'active'),
(17,'Payment Acknowledgment','payment-acknowledgment','Content','Payment Acknowledgment','info@laraoffice.com','LaraOffice - Ultimate CRM, Project Management, Accounting and Invoicing System','<div style=\"line-height:1.6;color:#222;text-align:left;width:550px;font-size:10pt;margin:0px 10px;font-family:verdana,\'droid sans\',\'lucida sans\',sans-serif;padding:14px;border:3px solid #d8d8d8;border-top:3px solid #007bc3\">\r\n<div style=\"padding:5px;font-size:11pt;font-weight:bold\">Dear {{$client_name}},</div>\r\n\r\n<div style=\"padding:5px\">This email serves as your official receipt from <strong>{{$site_title}}</strong></div>\r\n\r\n<div style=\"padding:10px 5px\">As per your request we are sending receipt here. Please find attachment in PDF format.</div>\r\n\r\n<div style=\"padding:5px\"><span style=\"font-size:13.3333330154419px\">If you have any questions or need assistance, please don&#39;t hesitate to contact us.&nbsp;</span>We look forward to conducting future business with you.</div>\r\n\r\n<div style=\"padding:0px 5px\">Best Regards,<br />\r\n{{$site_title}}</div>\r\n\r\n<div style=\"padding:0px 5px\">{{$site_address}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Phone: {{$site_phone}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Email: {{$site_email}}</div>\r\n</div>','2019-03-29 13:07:03','2019-05-13 12:28:10',NULL,'active'),
(18,'Amount Transfered','amount-transfered','Content','Amount Transfered','info@laraoffice.com','LaraOffice','<div style=\"line-height:1.6;color:#222;text-align:left;width:550px;font-size:10pt;margin:0px 10px;font-family:verdana,\'droid sans\',\'lucida sans\',sans-serif;padding:14px;border:3px solid #d8d8d8;border-top:3px solid #007bc3\">\r\n<div style=\"padding:5px;font-size:11pt;font-weight:bold\">Hi,</div>\r\n\r\n<div style=\"padding:5px\">There was a amount transfered on&nbsp;<strong>{{$site_title}} </strong>details are given below:</div>\r\n\r\n<div style=\"padding:10px 5px\">Account From: {{$from_id}}<br />\r\nAccount To: {{$to_id}}<br />\r\nAmount: {{$amount}}<br />\r\nDate: {{$date}}</div>\r\n\r\n<div style=\"padding:10px 5px\">Ref. #: {{$ref_no}}</div>\r\n\r\n<div style=\"padding:10px 5px\">Description : {{$description}}</div>\r\n\r\n<div style=\"padding:10px 5px\">Payment Method: {{$payment_method_id}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Best Regards,<br />\r\n{{$site_title}}</div>\r\n\r\n<div style=\"padding:0px 5px\">{{$site_address}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Phone: {{$site_phone}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Email: {{$site_email}}</div>\r\n</div>','2019-04-01 10:22:15','2019-04-13 10:09:25',NULL,'active'),
(19,'Account Suspended','account-suspended','Content','Your account has been suspended','info@laraoffice.com','LaraOffice','<p>Dear <strong>{{$name}}</strong>,</p>\r\n\r\n<p>Your account &#39;{{$user_name}}&#39; has been suspended&nbsp;at&nbsp;<a href=\"{{$site_url}}\" target=\"_blank\">{{$site_url}}</a>.</p>\r\n\r\n<p>Please contact administrator with following details:</p>\r\n\r\n<p><strong>Username:&nbsp;</strong>{{$user_name}}</p>\r\n\r\n<p>The <strong>{{$site_title}}</strong> Team</p>','2019-04-01 13:00:51','2019-04-13 10:11:30',NULL,'active'),
(20,'Accounted Activated','account-activated','Content','Your account has been activated','info@laraoffice.com','LaraOffice','<p>Dear <strong>{{$name}}</strong>,</p>\r\n\r\n<p><strong>Welcome to {{$site_title}}!</strong></p>\r\n\r\n<p>Your account &#39;{{$user_name}}&#39; has been successfully created at at&nbsp;<a href=\"{{$site_url}}\" target=\"_blank\">{{$site_url}}</a>.</p>\r\n\r\n<p>Please login with following details at&nbsp;<a href=\"{{$login_link}}\">{{$login_link}}</a></p>\r\n\r\n<p><strong>Username:&nbsp;</strong>{{$user_name}}</p>\r\n\r\n<p><strong>Password:&nbsp;</strong><em>Your Password</em></p>\r\n\r\n<p>Should you ever encounter problems with your account or forget your password we will contact you at this address.</p>\r\n\r\n<p>Enjoy!</p>\r\n\r\n<p>The <strong>{{$site_title}}</strong> Team</p>','2019-04-01 13:03:50','2019-04-13 10:11:08',NULL,'active'),
(21,'Test Template','Test Key','Content','Test Subject','noelcstpl18@gmail.com','Noel','<p>Test Content.</p>','2019-04-03 06:29:42','2019-04-03 06:47:45','2019-04-03 06:47:45','active'),
(22,'Test Template','Test Key(duplicate)','Content','Test Subject','noelcstpl18@gmail.com','Noel','<p>Test Content.</p>','2019-04-03 06:46:24','2019-04-03 06:47:45','2019-04-03 06:47:45','active'),
(23,'Quote expiry reminder','quote-expiry-reminder','Content','Quote Expiration Reminder','info@laraoffice.com','LaraOffice','<p>Dear {{$client_name}},</p>\r\n\r\n<p>This email serves as your official quote from <strong>{{$site_title}}</strong></p>\r\n\r\n<p>The quote with<strong>&nbsp;#{{$invoice_no}}&nbsp;</strong>will expire on {{$invoice_due_date}}&nbsp;You can view the quote on the following link:</p>\r\n\r\n<p>View Quote: Click <a href=\"{{$invoice_url}}\">here</a><br />\r\nQuote No.: {{$invoice_no}}<br />\r\nValid Till: {{$invoice_due_date}}</p>\r\n\r\n<p>If you have any questions or need assistance, please don&#39;t hesitate to contact us.&nbsp;We look forward to conducting future business with you.</p>\r\n\r\n<p>Best Regards,<br />\r\n{{$site_title}}</p>\r\n\r\n<p>{{$site_address}}</p>\r\n\r\n<p>Phone: {{$site_phone}}</p>\r\n\r\n<p>Email: {{$site_email}}</p>','2019-04-26 06:03:04','2019-09-14 09:19:28',NULL,'active'),
(24,'Invoice overdue notice','invoice-overdue-notice','Content','Invoice Overdue Notice','info@laraoffice.com','LaraOffice','<div style=\"line-height:1.6;color:#222;text-align:left;width:550px;font-size:10pt;margin:0px 10px;font-family:verdana,\'droid sans\',\'lucida sans\',sans-serif;padding:14px;border:3px solid #d8d8d8;border-top:3px solid #007bc3\">\r\n<div style=\"padding:5px;font-size:11pt;font-weight:bold\">Dear {{$client_name}},</div>\r\n\r\n<div style=\"padding:5px\">This email serves as your official invoice from <strong>{{$site_title}}</strong></div>\r\n\r\n<div style=\"padding:5px\">This is an overdue notice for invoice<strong>&nbsp;#{{$invoice_no}}&nbsp;</strong>This invoice was due: {{$invoice_due_date}}&nbsp;You can view the quote on the following link:</div>\r\n\r\n<div style=\"padding:10px 5px\">View Invoice: Click <a href=\"{{$invoice_url}}\">here</a><br />\r\nInvoice No.: {{$invoice_no}}</div>\r\n\r\n<div style=\"padding:10px 5px\">Invoice No.: {{$invoice_date}}<br />\r\nValid Till: {{$invoice_due_date}}</div>\r\n\r\n<div style=\"padding:5px\"><span style=\"font-size:13.3333330154419px\">If you have any questions or need assistance, please don&#39;t hesitate to contact us.&nbsp;</span>We look forward to conducting future business with you.</div>\r\n\r\n<div style=\"padding:0px 5px\">Best Regards,<br />\r\n{{$site_title}}</div>\r\n\r\n<div style=\"padding:0px 5px\">{{$site_address}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Phone: {{$site_phone}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Email: {{$site_email}}</div>\r\n</div>','2019-04-26 09:44:33','2019-06-12 11:48:21',NULL,'active'),
(25,'Task Deadline Reminder','task-deadline-reminder','Content','Task Deadline Reminder','info@laraoffice.com','LaraOffice','<div style=\"line-height:1.6;color:#222;text-align:left;width:1000px;font-size:10pt;margin:0px 10px;font-family:verdana,\'droid sans\',\'lucida sans\',sans-serif;padding:14px;border:3px solid #d8d8d8;border-top:3px solid #007bc3\">\r\n<div style=\"padding:5px;font-size:11pt;font-weight:bold\">Dear {{$client_name}},</div>\r\n\r\n<div style=\"padding:5px\">This email serves as your official invoice from <strong>{{$site_title}}</strong></div>\r\n\r\n<div style=\"padding:5px\">The task <strong>{{$task_name}}</strong> deadline is on <strong>{{$task_duedate}}</strong>.<br />\r\nThis task is still not finished.<br />\r\n<br />\r\nYou can view the task on the following link: <a href=\"{{$task_link}}\">{{$task_name}}</a></div>\r\n\r\n<div style=\"padding:5px\"><span style=\"font-size:13.3333330154419px\">If you have any questions or need assistance, please don&#39;t hesitate to contact us.&nbsp;</span>We look forward to conducting future business with you.</div>\r\n\r\n<div style=\"padding:0px 5px\">Best Regards,<br />\r\n{{$site_title}}</div>\r\n\r\n<div style=\"padding:0px 5px\">{{$site_address}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Phone: {{$site_phone}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Email: {{$site_email}}</div>\r\n</div>','2019-04-30 14:38:42','2019-06-14 10:28:02',NULL,'active'),
(26,'Invoice Reminder','invoice-reminder','Content','Invoice Reminder','info@laraoffice.com','LaraOffice','<div style=\"line-height:1.6;color:#222;text-align:left;width:550px;font-size:10pt;margin:0px 10px;font-family:verdana,\'droid sans\',\'lucida sans\',sans-serif;padding:14px;border:3px solid #d8d8d8;border-top:3px solid #007bc3\">\r\n<div style=\"padding:5px;font-size:11pt;font-weight:bold\">Dear {{$client_name}},</div>\r\n\r\n<div style=\"padding:5px\">This email serves as your official invoice from <strong>{{$site_title}}</strong></div>\r\n\r\n<div style=\"padding:5px\">You have new reminder linked to invoice</div>\r\n\r\n<div style=\"padding:5px\">Description : {{$description}}.</div>\r\n\r\n<div style=\"padding:5px\">Click <a href=\"{{$reminder_link}}\">here</a> to view<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"padding:5px\"><span style=\"font-size:13.3333330154419px\">If you have any questions or need assistance, please don&#39;t hesitate to contact us on following address.</span></div>\r\n\r\n<div style=\"padding:0px 5px\">Best Regards,<br />\r\n{{$site_title}}</div>\r\n\r\n<div style=\"padding:0px 5px\">{{$site_address}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Phone: {{$site_phone}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Email: {{$site_email}}</div>\r\n</div>','2019-05-01 06:11:09','2019-05-01 06:48:33',NULL,'active'),
(27,'Quote Reminder','quote-reminder','Content','Quote Reminder','info@laraoffice.com','LaraOffice','<p>Dear {{$client_name}},</p>\r\n\r\n<p>This email serves as your official quote from <strong>{{$site_title}}</strong></p>\r\n\r\n<p>You have new reminder linked to quote</p>\r\n\r\n<p>Description : {{$description}}.</p>\r\n\r\n<p>Click <a href=\"{{$reminder_link}}\">here</a> to view<br />\r\n&nbsp;</p>\r\n\r\n<p>If you have any questions or need assistance, please don&#39;t hesitate to contact us on the following address.</p>\r\n\r\n<p>Best Regards,<br />\r\n{{$site_title}}</p>\r\n\r\n<p>{{$site_address}}</p>\r\n\r\n<p>Phone: {{$site_phone}}</p>\r\n\r\n<p>Email: {{$site_email}}</p>','2019-05-01 08:56:47','2019-09-14 09:19:09',NULL,'active'),
(28,'Auto Close Ticket','auto-close-ticket','Content','Ticket Auto Closed','info@laraoffice.com','LaraOffice','<div style=\"line-height:1.6;color:#222;text-align:left;width:1000px;font-size:10pt;margin:0px 10px;font-family:verdana,\'droid sans\',\'lucida sans\',sans-serif;padding:14px;border:3px solid #d8d8d8;border-top:3px solid #007bc3\">\r\n<div style=\"padding:5px;font-size:11pt;font-weight:bold\">Dear {{$client_name}},</div>\r\n\r\n<div style=\"padding:5px\">This email serves as your official invoice from <strong>{{$site_title}}</strong></div>\r\n\r\n<div style=\"padding:5px\">Ticket <strong>{{$ticket_subject}}</strong> has been auto close due to inactivity.</div>\r\n\r\n<div style=\"padding:5px\">Ticket # <a href=\"{{$ticket_url}}\">{{$ticket_id}}</a></div>\r\n\r\n<div style=\"padding:5px\">Category:{{$category}}</div>\r\n\r\n<div style=\"padding:5px\">Priority: {{$priority}}</div>\r\n\r\n<div style=\"padding:5px\">Created: {{$ticket_created_at}}</div>\r\n\r\n<div style=\"padding:5px\"><span style=\"font-size:13.3333330154419px\">If you have any questions or need assistance, please don&#39;t hesitate to contact us on following address.</span></div>\r\n\r\n<div style=\"padding:0px 5px\">Best Regards,<br />\r\n{{$site_title}}</div>\r\n\r\n<div style=\"padding:0px 5px\">{{$site_address}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Phone: {{$site_phone}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Email: {{$site_email}}</div>\r\n</div>','2019-05-01 09:51:19','2019-06-14 04:39:13',NULL,'active'),
(29,'User Created Welcome','user-created-welcome','Content','Your account has been created','info@laraoffice.com','LaraOffice','<p>Dear <strong>{{$name}}</strong>,</p>\r\n\r\n<p><strong>Welcome to {{$site_title}}!</strong></p>\r\n\r\n<p>Your account &#39;{{$user_name}}&#39; has been successfully created at at&nbsp;<a href=\"{{$site_url}}\" target=\"_blank\">{{$site_url}}</a>.</p>\r\n\r\n<p>Here are a couple of tips to help you get started:</p>\r\n\r\n<ul>\r\n  <li><strong>Use link below</strong>&nbsp;to <a href=\"{{$login_link}}\">login</a>&nbsp;to your account at <strong>{{$site_title}}</strong> with following details.</li>\r\n</ul>\r\n\r\n<p><strong>Username:&nbsp;</strong>{{$user_name}}</p>\r\n\r\n<p><strong>Password:&nbsp;</strong>{{$password}}</p>\r\n\r\n<p>Should you ever encounter problems with your account or forget your password we will contact you at this address.</p>\r\n\r\n<p>Enjoy!</p>\r\n\r\n<p>The <strong>{{$site_title}}</strong> Team</p>','2019-05-15 05:01:41','2019-05-15 05:04:53',NULL,'active'),
(30,'Purchase Order Created','purchase-order-created','Content','Purchase Order Created','info@laraoffice.com','LaraOffice','<div style=\"line-height:1.6;color:#222;text-align:left;width:1200px;font-size:10pt;margin:0px 10px;font-family:verdana,\'droid sans\',\'lucida sans\',sans-serif;padding:14px;border:3px solid #d8d8d8;border-top:3px solid #007bc3\">\r\n<div style=\"padding: 5px; font-size: 11pt; font-weight: bold;\">Dear {{$client_name}},</div>\r\n\r\n<div style=\"padding: 5px;\">This email serves as your official order from <strong>{{$site_title}}</strong></div>\r\n\r\n<div style=\"padding: 10px 5px;\">Thank you for your order! Below are order details:</div>\r\n\r\n<p>Purchase Order No:&nbsp; {{$invoice_no}}</p>\r\n\r\n<p>Order date: {{$order_date}}</p>\r\n\r\n<p>Order Due Date :&nbsp;{{$order_due_date}}</p>\r\n\r\n<div style=\"padding: 10px 5px; text-decoration: underline;\">Products:</div>\r\n&nbsp;\r\n\r\n<div style=\"border: 1px solid lightgray;\">{!!$products!!}</div>\r\n\r\n<div style=\"padding: 10px 5px;\">Outstanding Amount Payable on Delivery:&nbsp;<strong>{{$amount}}.</strong></div>\r\n\r\n<div style=\"padding: 5px; text-decoration: underline;\">Address:</div>\r\n\r\n<div style=\"padding: 5px; \">{{$address}}</div>\r\n\r\n<div style=\"padding: 5px;\"><span style=\"font-size:13.3333330154419px\">If you have any questions or need assistance, please don&#39;t hesitate to contact us.&nbsp;</span>We look forward to conducting future business with you.</div>\r\n\r\n<div style=\"padding: 0px 5px; \">Best Regards,<br />\r\n{{$site_title}}</div>\r\n\r\n<div style=\"padding: 0px 5px;\">{{$site_address}}</div>\r\n\r\n<div style=\"padding: 0px 5px;\">Phone: {{$site_phone}}</div>\r\n\r\n<div style=\"padding: 0px 5px;\">Email: {{$site_email}}</div>\r\n</div>','2019-06-15 10:12:41','2019-07-26 09:51:57',NULL,'active'),
(31,'Reminder','invoice-reminder-employee','Content','Employee Reminder','info@laraoffice.com','LaraOffice','<div style=\"line-height:1.6;color:#222;text-align:left;width:550px;font-size:10pt;margin:0px 10px;font-family:verdana,\'droid sans\',\'lucida sans\',sans-serif;padding:14px;border:3px solid #d8d8d8;border-top:3px solid #007bc3\">\r\n<div style=\"padding:5px;font-size:11pt;font-weight:bold\">Dear {{$reminder_to}},</div>\r\n\r\n<div style=\"padding:5px\">This email serves as your official invoice from <strong>{{$site_title}}</strong></div>\r\n\r\n<div style=\"padding:5px\">You have new reminder linked to invoice-reminder.</div>\r\n\r\n<div style=\"padding:5px\">Date : {{$date}}</div>\r\n\r\n<div style=\"padding:5px\">Description : {{$description}}.</div>\r\n\r\n<div style=\"padding:5px\"><strong><strong>&nbsp;</strong></strong></div>\r\n\r\n<div style=\"padding:5px\"><strong><strong><span style=\"font-size:13.3333330154419px\">If you have any questions or need assistance, please don&#39;t hesitate to contact us on following address.</span></strong></strong></div>\r\n\r\n<div style=\"padding:0px 5px\"><strong><strong>Best Regards,<br />\r\n{{$site_title}}</strong></strong></div>\r\n\r\n<div style=\"padding:0px 5px\"><strong><strong>{{$site_address}}</strong></strong></div>\r\n\r\n<div style=\"padding:0px 5px\"><strong><strong>Phone: {{$site_phone}}</strong></strong></div>\r\n\r\n<div style=\"padding:0px 5px\"><strong><strong>Email: {{$site_email}}</strong></strong></div>\r\n</div>','2019-06-28 18:44:56','2019-06-29 05:12:44',NULL,'active'),
(32,'Reminder','quote-reminder-employee','Content','Employee Reminder','info@laraoffice.com','LaraOffice','<p>Dear {{$reminder_to}},</p>\r\n\r\n<p>This email serves as your official quote from <strong>{{$site_title}}</strong></p>\r\n\r\n<p>You have new reminder linked to quote-reminder.</p>\r\n\r\n<p>Date : {{$date}}</p>\r\n\r\n<p>Description : {{$description}}.</p>\r\n\r\n<p><strong><strong>&nbsp;</strong></strong></p>\r\n\r\n<p><strong><strong>If you have any questions or need assistance, please don&#39;t hesitate to contact us on following address.</strong></strong></p>\r\n\r\n<p><strong><strong>Best Regards,<br />\r\n{{$site_title}}</strong></strong></p>\r\n\r\n<p><strong><strong>{{$site_address}}</strong></strong></p>\r\n\r\n<p><strong><strong>Phone: {{$site_phone}}</strong></strong></p>\r\n\r\n<p><strong><strong>Email: {{$site_email}}</strong></strong></p>','2019-06-29 05:15:41','2019-09-14 07:10:49',NULL,'active'),
(33,'General contact email','contact-email','Content','We are so great by having you with us','info@laraoffice.com','LaraOffice','<p>Dear <strong>{{$name}}</strong>,</p>\r\n\r\n<p><strong>Welcome to {{$site_title}}!</strong></p>\r\n\r\n<p>We hope you&#39;re enjoying our brand-new product.</p>\r\n\r\n<p>If you&#39;re interested, I&#39;d love to hear more about how you feel the product. Let me know some pros and cons and if there&#39;s any way I can be of assistance to guide you through this process. I&#39;m here for whatever you may need and look forward to hearing from you soon.</p>\r\n\r\n<p>Cheers,</p>\r\n\r\n<p>The <strong>{{$site_title}}</strong> Team</p>','2019-07-06 04:26:39','2019-07-06 04:31:50',NULL,'active'),
(34,'Credit Note Created','credit-note-created','Content','Credit Note Created','info@laraoffice.com','LaraOffice','<p>Dear {{$client_name}},</p>\r\n\r\n<p>This email serves as your official Credit Note from <strong>{{$site_title}}</strong></p>\r\n\r\n<p>View Credit Note: Click <a href=\"{{$invoice_url}}\">here</a><br />\r\nCredit Note No.: {{$invoice_no}}<br />\r\nCredit Note Amount: {{$invoice_amount}}</p>\r\n\r\n<p>Credit Note&nbsp;Date: {{$invoice_date}}</p>\r\n\r\n<p>If you have any questions or need assistance, please don&#39;t hesitate to contact us.</p>\r\n\r\n<p>Best Regards,<br />\r\n{{$site_title}}</p>\r\n\r\n<p>{{$site_address}}</p>\r\n\r\n<p>Phone: {{$site_phone}}</p>\r\n\r\n<p>Email: {{$site_email}}</p>','2019-07-07 18:32:27','2019-09-25 12:02:05',NULL,'active'),
(35,'Mailchimp Email Template','mailchimp-contact-email','Content','We are so great by having you with us','info@laraoffice.com','LaraOffice','<p>Hi,</p>\r\n\r\n<p><strong>Welcome to {{$site_title}}!</strong></p>\r\n\r\n<p>We hope you&#39;re enjoying our brand-new product.</p>\r\n\r\n<p>If you&#39;re interested, I&#39;d love to hear more about how you feel the product. Let me know some pros and cons and if there&#39;s any way I can be of assistance to guide you through this process. I&#39;m here for whatever you may need and look forward to hearing from you soon.</p>\r\n\r\n<p>Cheers,</p>\r\n\r\n<p>The <strong>{{$site_title}}</strong> Team</p>','2019-07-08 07:23:55','2019-07-08 08:12:03',NULL,'active'),
(36,'Bulk Email Template','bulk-contact-email','Content','We are so great by having you with us','info@laraoffice.com','LaraOffice','<p>Hi,</p>\r\n\r\n<p><strong>Welcome to {{$site_title}}!</strong></p>\r\n\r\n<p>We hope you&#39;re enjoying our brand-new product.</p>\r\n\r\n<p>If you&#39;re interested, I&#39;d love to hear more about how you feel the product. Let me know some pros and cons and if there&#39;s any way I can be of assistance to guide you through this process. I&#39;m here for whatever you may need and look forward to hearing from you soon.</p>\r\n\r\n<p>Cheers,</p>\r\n\r\n<p>The <strong>{{$site_title}}</strong> Team</p>','2019-07-10 05:51:34','2019-07-10 05:52:02',NULL,'active'),
(37,'Cart Order overdue notice','order-overdue-notice','Content','Cart Order Overdue Notice','info@laraoffice.com','LaraOffice','<div style=\"line-height:1.6;color:#222;text-align:left;width:550px;font-size:10pt;margin:0px 10px;font-family:verdana,\'droid sans\',\'lucida sans\',sans-serif;padding:14px;border:3px solid #d8d8d8;border-top:3px solid #007bc3\">\r\n<div style=\"padding:5px;font-size:11pt;font-weight:bold\">Dear {{$client_name}},</div>\r\n\r\n<div style=\"padding:5px\">This email serves as your official invoice from <strong>{{$site_title}}</strong></div>\r\n\r\n<div style=\"padding:5px\">This is an overdue notice for order<strong>&nbsp;#{{$invoice_no}}&nbsp;</strong>This invoice was due: {{$invoice_due_date}}&nbsp;You can view the order on the following link:</div>\r\n\r\n<div style=\"padding:10px 5px\">View Invoice: Click <a href=\"{{$invoice_url}}\">here</a><br />\r\nOrder No.: {{$invoice_no}}</div>\r\n\r\n<div style=\"padding:10px 5px\">Order Date: {{$invoice_date}}<br />\r\nDue Date: {{$invoice_due_date}}</div>\r\n\r\n<div style=\"padding:5px\"><span style=\"font-size:13.3333330154419px\">If you have any questions or need assistance, please don&#39;t hesitate to contact us.&nbsp;</span>We look forward to conducting future business with you.</div>\r\n\r\n<div style=\"padding:0px 5px\">Best Regards,<br />\r\n{{$site_title}}</div>\r\n\r\n<div style=\"padding:0px 5px\">{{$site_address}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Phone: {{$site_phone}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Email: {{$site_email}}</div>\r\n</div>','2019-07-23 10:53:12','2019-07-23 10:57:48',NULL,'active'),
(38,'Cart Order overdue notice','order-overdue-notice(duplicate)','Content','Cart Order Overdue Notice','info@laraoffice.com','LaraOffice','<div style=\"line-height:1.6;color:#222;text-align:left;width:550px;font-size:10pt;margin:0px 10px;font-family:verdana,\'droid sans\',\'lucida sans\',sans-serif;padding:14px;border:3px solid #d8d8d8;border-top:3px solid #007bc3\">\r\n<div style=\"padding:5px;font-size:11pt;font-weight:bold\">Dear {{$client_name}},</div>\r\n\r\n<div style=\"padding:5px\">This email serves as your official invoice from <strong>{{$site_title}}</strong></div>\r\n\r\n<div style=\"padding:5px\">This is an overdue notice for order<strong>&nbsp;#{{$invoice_no}}&nbsp;</strong>This invoice was due: {{$invoice_due_date}}&nbsp;You can view the order on the following link:</div>\r\n\r\n<div style=\"padding:10px 5px\">View Invoice: Click <a href=\"{{$invoice_url}}\">here</a><br />\r\nOrder No.: {{$invoice_no}}</div>\r\n\r\n<div style=\"padding:10px 5px\">Order Date: {{$invoice_date}}<br />\r\nDue Date: {{$invoice_due_date}}</div>\r\n\r\n<div style=\"padding:5px\"><span style=\"font-size:13.3333330154419px\">If you have any questions or need assistance, please don&#39;t hesitate to contact us.&nbsp;</span>We look forward to conducting future business with you.</div>\r\n\r\n<div style=\"padding:0px 5px\">Best Regards,<br />\r\n{{$site_title}}</div>\r\n\r\n<div style=\"padding:0px 5px\">{{$site_address}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Phone: {{$site_phone}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Email: {{$site_email}}</div>\r\n</div>','2019-08-26 09:24:20','2019-08-26 09:24:37','2019-08-26 09:24:37','active'),
(39,'Credit note refund proceeded','credit-note-refund-proceeded','Content','Refund Proceeded','info@laraoffice.com','LaraOffice','<p>Dear <strong>{{$client_name}}</strong>,</p>\r\n\r\n<p>We are contacting you in regard to a payment refund processed for&nbsp;Credit Note # {{$invoice_no}} that has been created on your account and sent you on {{$date}}. You may find the Credit Note with below link.</p>\r\n\r\n<p><strong>View Credit Note​:Click <a href=\"{{$invoice_url}}\">here</a><br />\r\nCredit Note<strong> No.</strong>: {{$invoice_no}}<br />\r\nCredit Note<strong> Amount</strong>: {{$invoice_amount}}</strong></p>\r\n\r\n<p><strong>We look forward to conducting future business with you.&nbsp;If you have any questions or need assistance, please don&#39;t hesitate to contact us.</strong></p>\r\n\r\n<p><strong>Best Regards, </strong></p>\r\n\r\n<p><strong>{{$site_address}}</strong></p>\r\n\r\n<p><strong>Phone: {{$site_phone}}</strong></p>\r\n\r\n<p><strong>Email: {{$site_email}}</strong></p>','2019-09-17 04:11:52','2019-09-25 12:01:55',NULL,'active'),
(40,'Credit note refund proceeded','credit-note-refund-proceeded(duplicate)','Content','Refund Proceeded','info@laraoffice.com','LaraOffice','<p>Dear <strong>{{$client_name}}</strong>,</p>\r\n\r\n<p>We are contacting you in regard to a payment refund processed for&nbsp;Credit Note # {{$invoice_no}} that has been created on your account and sent you on {{$date}}. You may find the Credit Note with below link.</p>\r\n\r\n<p><strong>View Credit Note​:Click <a href=\"{{$invoice_url}}\">here</a><br />\r\nCredit Note<strong> No.</strong>: {{$invoice_no}}<br />\r\nCredit Note<strong> Amount</strong>: {{$invoice_amount}}<br />\r\n<strong>Due Date</strong>: {{$invoice_due_date}}</strong></p>\r\n\r\n<p><strong>We look forward to conducting future business with you.&nbsp;If you have any questions or need assistance, please don&#39;t hesitate to contact us.</strong></p>\r\n\r\n<p><strong>Best Regards, </strong></p>\r\n\r\n<p><strong>{{$site_address}}</strong></p>\r\n\r\n<p><strong>Phone: {{$site_phone}}</strong></p>\r\n\r\n<p><strong>Email: {{$site_email}}</strong></p>','2019-09-17 08:56:24','2019-09-17 08:56:34','2019-09-17 08:56:34','active'),
(41,'Proposal Created','proposal-created','Content','proposal Created','info@laraoffice.com','LaraOffice','<p>Dear {{$client_name}},</p>\r\n\r\n<p>This email serves as your official invoice from <strong>{{$site_title}}</strong></p>\r\n\r\n<p>View Proposal : Click <a href=\"{{$invoice_url}}\">here</a><br />\r\nProposal No.: {{$invoice_no}}</p>\r\n\r\n<p>Proposal Date.: {{$invoice_date}}<br />\r\nValid Till: {{$invoice_due_date}}</p>\r\n\r\n<p>If you have any questions or need assistance, please don&#39;t hesitate to contact us.&nbsp;We look forward to conducting future business with you.</p>\r\n\r\n<p>Best Regards,<br />\r\n{{$site_title}}</p>\r\n\r\n<p>{{$site_address}}</p>\r\n\r\n<p>Phone: {{$site_phone}}</p>\r\n\r\n<p>Email: {{$site_email}}</p>','2019-09-11 05:20:40','2019-09-11 05:23:09',NULL,'active'),
(42,'Reminder','proposal-reminder-employee','Content','Employee Reminder','info@laraoffice.com','LaraOffice','<p>Dear {{$reminder_to}},</p>\r\n\r\n<p>This email serves as your official invoice from <strong>{{$site_title}}</strong></p>\r\n\r\n<p>You have new reminder linked to proposal-reminder.</p>\r\n\r\n<p>Date : {{$date}}</p>\r\n\r\n<p>Description : {{$description}}.</p>\r\n\r\n<p><strong><strong>&nbsp;</strong></strong></p>\r\n\r\n<p><strong><strong>If you have any questions or need assistance, please don&#39;t hesitate to contact us on following address.</strong></strong></p>\r\n\r\n<p><strong><strong>Best Regards,<br />\r\n{{$site_title}}</strong></strong></p>\r\n\r\n<p><strong><strong>{{$site_address}}</strong></strong></p>\r\n\r\n<p><strong><strong>Phone: {{$site_phone}}</strong></strong></p>\r\n\r\n<p><strong><strong>Email: {{$site_email}}</strong></strong></p>','2019-09-14 03:34:22','2019-09-14 03:35:21',NULL,'active'),
(43,'Proposal expiry reminder','proposal-expiry-reminder','Content','Proposal Expiration Reminder','info@laraoffice.com','LaraOffice','<p>Dear {{$client_name}},</p>\r\n\r\n<p>This email serves as your official invoice from <strong>{{$site_title}}</strong></p>\r\n\r\n<p>The proposal with<strong>&nbsp;#{{$invoice_no}}&nbsp;</strong>will expire on {{$invoice_due_date}}&nbsp;You can view the quote on the following link:</p>\r\n\r\n<p>View Proposal: Click <a href=\"{{$invoice_url}}\">here</a><br />\r\nProposalNo.: {{$invoice_no}}<br />\r\nValid Till: {{$invoice_due_date}}</p>\r\n\r\n<p>If you have any questions or need assistance, please don&#39;t hesitate to contact us.&nbsp;We look forward to conducting future business with you.</p>\r\n\r\n<p>Best Regards,<br />\r\n{{$site_title}}</p>\r\n\r\n<p>{{$site_address}}</p>\r\n\r\n<p>Phone: {{$site_phone}}</p>\r\n\r\n<p>Email: {{$site_email}}</p>','2019-09-14 03:36:25','2019-09-14 03:39:01',NULL,'active'),
(44,'Proposal expiry reminder','quote-expiry-reminder(duplicate)(duplicate)','Content','Quote Expiration Reminder','info@laraoffice.com','LaraOffice','<div style=\"line-height:1.6;color:#222;text-align:left;width:550px;font-size:10pt;margin:0px 10px;font-family:verdana,\'droid sans\',\'lucida sans\',sans-serif;padding:14px;border:3px solid #d8d8d8;border-top:3px solid #007bc3\">\r\n<div style=\"padding:5px;font-size:11pt;font-weight:bold\">Dear {{$client_name}},</div>\r\n\r\n<div style=\"padding:5px\">This email serves as your official invoice from <strong>{{$site_title}}</strong></div>\r\n\r\n<div style=\"padding:5px\">The quote with<strong>&nbsp;#{{$invoice_no}}&nbsp;</strong>will expire on {{$invoice_due_date}}&nbsp;You can view the quote on the following link:</div>\r\n\r\n<div style=\"padding:10px 5px\">View Quote: Click <a href=\"{{$invoice_url}}\">here</a><br />\r\nQuote No.: {{$invoice_no}}<br />\r\nValid Till: {{$invoice_due_date}}</div>\r\n\r\n<div style=\"padding:5px\"><span style=\"font-size:13.3333330154419px\">If you have any questions or need assistance, please don&#39;t hesitate to contact us.&nbsp;</span>We look forward to conducting future business with you.</div>\r\n\r\n<div style=\"padding:0px 5px\">Best Regards,<br />\r\n{{$site_title}}</div>\r\n\r\n<div style=\"padding:0px 5px\">{{$site_address}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Phone: {{$site_phone}}</div>\r\n\r\n<div style=\"padding:0px 5px\">Email: {{$site_email}}</div>\r\n</div>','2019-09-14 03:36:44','2019-09-14 03:37:09','2019-09-14 03:37:09','active'),
(45,'Reminder','contract-reminder-employee','Content','Employee Reminder','info@laraoffice.com','LaraOffice','<p>Dear {{$reminder_to}},</p>\r\n\r\n<p>This email serves as your official contract from <strong>{{$site_title}}</strong></p>\r\n\r\n<p>You have new reminder linked to contract-reminder.</p>\r\n\r\n<p>Date : {{$date}}</p>\r\n\r\n<p>Description : {{$description}}.</p>','2019-09-28 08:16:44','2019-09-28 08:16:44',NULL,'active'),
(46,'Contract Reminder','contract-reminder','Content','Contract Reminder','info@laraoffice.com','LaraOffice','<p>Dear {{$client_name}},</p>\r\n\r\n<p>This email serves as your official contract from <strong>{{$site_title}}</strong></p>\r\n\r\n<p>You have new reminder linked to contract</p>\r\n\r\n<p>Description : {{$description}}.</p>\r\n\r\n<p>Click <a href=\"{{$reminder_link}}\">here</a> to view</p>','2019-09-28 08:18:10','2019-09-28 08:18:10',NULL,'active'),
(47,'Contract expiry reminder','contract-expiry-reminder','Content','Contract Expiration Reminder','info@laraoffice.com','LaraOffice','<p>Dear {{$client_name}},</p>\r\n\r\n<p>This email serves as your official contract from <strong>{{$site_title}}</strong></p>\r\n\r\n<p>The contract with<strong>&nbsp;#{{$invoice_no}}&nbsp;</strong>will expire on {{$invoice_due_date}}&nbsp;You can view the contract on the following link:</p>\r\n\r\n<p>View contract : Click <a href=\"{{$invoice_url}}\">here</a><br />\r\ncontract No.: {{$invoice_no}}<br />\r\nValid Till: {{$invoice_due_date}}</p>\r\n\r\n<p>If you have any questions or need assistance, please don&#39;t hesitate to contact us.&nbsp;We look forward to conducting future business with you.</p>\r\n\r\n<p>Best Regards,<br />\r\n{{$site_title}}</p>\r\n\r\n<p>{{$site_address}}</p>\r\n\r\n<p>Phone: {{$site_phone}}</p>\r\n\r\n<p>Email: {{$site_email}}</p>','2019-09-28 08:20:30','2019-09-28 08:20:30',NULL,'active'),
(48,'Contract Created','contract-created','Content','Contract Created','info@laraoffice.com','LaraOffice','<p>Dear {{$client_name}},</p>\r\n\r\n<p>This email serves as your official contract from <strong>{{$site_title}}</strong></p>\r\n\r\n<p>View Contract : Click <a href=\"{{$invoice_url}}\">here</a><br />\r\nContract No.: {{$invoice_no}}</p>\r\n\r\n<p>Contract Date.: {{$invoice_date}}<br />\r\nValid Till: {{$invoice_due_date}}</p>\r\n\r\n<p>If you have any questions or need assistance, please don&#39;t hesitate to contact us.&nbsp;We look forward to conducting future business with you.</p>\r\n\r\n<p>Best Regards,<br />\r\n{{$site_title}}</p>\r\n\r\n<p>{{$site_address}}</p>\r\n\r\n<p>Phone: {{$site_phone}}</p>\r\n\r\n<p>Email: {{$site_email}}</p>','2019-09-28 08:21:57','2019-09-28 08:21:57',NULL,'active');

/*Table structure for table `acrm_themes_delete` */

DROP TABLE IF EXISTS `acrm_themes_delete`;

CREATE TABLE `acrm_themes_delete` (
  `id` bigint(20) unsigned NOT NULL,
  `title` varchar(250) DEFAULT NULL,
  `slug` varchar(250) NOT NULL,
  `theme_title_key` varchar(250) NOT NULL,
  `settings_data` text NOT NULL,
  `description` text,
  `is_active` tinyint(4) NOT NULL DEFAULT '0',
  `theme_color` varchar(50) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `acrm_themes_delete` */

/*Table structure for table `acrm_ticketit` */

DROP TABLE IF EXISTS `acrm_ticketit`;

CREATE TABLE `acrm_ticketit` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `subject` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `html` longtext COLLATE utf8mb4_unicode_ci,
  `status_id` int(10) unsigned NOT NULL,
  `priority_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `agent_id` int(10) unsigned NOT NULL,
  `category_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `completed_at` timestamp NULL DEFAULT NULL,
  `project_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ticketit_subject_index` (`subject`),
  KEY `ticketit_status_id_index` (`status_id`),
  KEY `ticketit_priority_id_index` (`priority_id`),
  KEY `ticketit_user_id_index` (`user_id`),
  KEY `ticketit_agent_id_index` (`agent_id`),
  KEY `ticketit_category_id_index` (`category_id`),
  KEY `ticketit_completed_at_index` (`completed_at`),
  KEY `fk_project_id_ticketit` (`project_id`),
  CONSTRAINT `fk_project_id_ticketit` FOREIGN KEY (`project_id`) REFERENCES `acrm_client_projects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_ticketit` */

/*Table structure for table `acrm_ticketit_audits` */

DROP TABLE IF EXISTS `acrm_ticketit_audits`;

CREATE TABLE `acrm_ticketit_audits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `operation` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `ticket_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_ticketit_audits` */

/*Table structure for table `acrm_ticketit_categories` */

DROP TABLE IF EXISTS `acrm_ticketit_categories`;

CREATE TABLE `acrm_ticketit_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_ticketit_categories` */

/*Table structure for table `acrm_ticketit_categories_users` */

DROP TABLE IF EXISTS `acrm_ticketit_categories_users`;

CREATE TABLE `acrm_ticketit_categories_users` (
  `category_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_ticketit_categories_users` */

/*Table structure for table `acrm_ticketit_comments` */

DROP TABLE IF EXISTS `acrm_ticketit_comments`;

CREATE TABLE `acrm_ticketit_comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `html` longtext COLLATE utf8mb4_unicode_ci,
  `user_id` int(10) unsigned NOT NULL,
  `ticket_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ticketit_comments_user_id_index` (`user_id`),
  KEY `ticketit_comments_ticket_id_index` (`ticket_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_ticketit_comments` */

/*Table structure for table `acrm_ticketit_priorities` */

DROP TABLE IF EXISTS `acrm_ticketit_priorities`;

CREATE TABLE `acrm_ticketit_priorities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_ticketit_priorities` */

/*Table structure for table `acrm_ticketit_settings` */

DROP TABLE IF EXISTS `acrm_ticketit_settings`;

CREATE TABLE `acrm_ticketit_settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lang` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `default` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ticketit_settings_slug_unique` (`slug`),
  UNIQUE KEY `ticketit_settings_lang_unique` (`lang`),
  KEY `ticketit_settings_lang_index` (`lang`),
  KEY `ticketit_settings_slug_index` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_ticketit_settings` */

insert  into `acrm_ticketit_settings`(`id`,`lang`,`slug`,`value`,`default`,`created_at`,`updated_at`) values 
(1,NULL,'main_route','tickets','tickets','2019-03-06 08:02:39','2019-05-27 09:53:53'),
(2,'EN','main_route_path','tickets','tickets','2019-03-06 08:02:39','2019-05-27 09:54:06'),
(3,NULL,'admin_route','tickets-admin','tickets-admin','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(4,NULL,'admin_route_path','tickets-admin','tickets-admin','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(5,NULL,'master_template','layouts.app','layouts.app','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(6,NULL,'bootstrap_version','3','4','2019-03-06 08:02:39','2019-04-02 08:38:43'),
(7,NULL,'email.template','ticketit::emails.templates.ticketit','ticketit::emails.templates.ticketit','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(8,NULL,'email.header','Ticket Update','Ticket Update','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(9,NULL,'email.signoff','Thank you for your patience!','Thank you for your patience!','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(10,NULL,'email.signature','Your friends','Your friends','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(11,NULL,'email.dashboard','My Dashboard','My Dashboard','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(12,NULL,'email.google_plus_link','#','#','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(13,NULL,'email.facebook_link','#','#','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(14,NULL,'email.twitter_link','#','#','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(15,NULL,'email.footer','Powered by Ticketit','Powered by Ticketit','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(16,NULL,'email.footer_link','https://github.com/thekordy/ticketit','https://github.com/thekordy/ticketit','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(17,NULL,'email.color_body_bg','#FFFFFF','#FFFFFF','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(18,NULL,'email.color_header_bg','#44B7B7','#44B7B7','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(19,NULL,'email.color_content_bg','#F46B45','#F46B45','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(20,NULL,'email.color_footer_bg','#414141','#414141','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(21,NULL,'email.color_button_bg','#AC4D2F','#AC4D2F','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(22,NULL,'default_status_id','11','11','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(23,NULL,'default_close_status_id','10','0','2019-03-06 08:02:39','2019-08-17 05:56:23'),
(24,NULL,'default_reopen_status_id','11','0','2019-03-06 08:02:39','2019-08-17 05:58:24'),
(25,NULL,'paginate_items','10','10','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(26,NULL,'length_menu','a:2:{i:0;a:3:{i:0;i:10;i:1;i:50;i:2;i:100;}i:1;a:3:{i:0;i:10;i:1;i:50;i:2;i:100;}}','a:2:{i:0;a:3:{i:0;i:10;i:1;i:50;i:2;i:100;}i:1;a:3:{i:0;i:10;i:1;i:50;i:2;i:100;}}','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(27,NULL,'status_notification','1','1','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(28,NULL,'comment_notification','1','1','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(29,NULL,'queue_emails','0','0','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(30,NULL,'assigned_notification','1','1','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(31,NULL,'agent_restrict','0','0','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(32,NULL,'close_ticket_perm','a:3:{s:5:\"owner\";b:1;s:5:\"agent\";b:1;s:5:\"admin\";b:1;}','a:3:{s:5:\"owner\";b:1;s:5:\"agent\";b:1;s:5:\"admin\";b:1;}','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(33,NULL,'reopen_ticket_perm','a:3:{s:5:\"owner\";b:1;s:5:\"agent\";b:1;s:5:\"admin\";b:1;}','a:3:{s:5:\"owner\";b:1;s:5:\"agent\";b:1;s:5:\"admin\";b:1;}','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(34,NULL,'delete_modal_type','builtin','builtin','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(35,NULL,'editor_enabled','1','1','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(36,NULL,'include_font_awesome','1','1','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(37,NULL,'summernote_locale','en','en','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(38,NULL,'editor_html_highlighter','1','1','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(39,NULL,'codemirror_theme','monokai','monokai','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(40,NULL,'summernote_options_json_file','vendor/kordy/ticketit/src/JSON/summernote_init.json','vendor/kordy/ticketit/src/JSON/summernote_init.json','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(41,NULL,'purifier_config','a:3:{s:15:\"HTML.SafeIframe\";s:4:\"true\";s:20:\"URI.SafeIframeRegexp\";s:72:\"%^(http://|https://|//)(www.youtube.com/embed/|player.vimeo.com/video/)%\";s:18:\"URI.AllowedSchemes\";a:5:{s:4:\"data\";b:1;s:4:\"http\";b:1;s:5:\"https\";b:1;s:6:\"mailto\";b:1;s:3:\"ftp\";b:1;}}','a:3:{s:15:\"HTML.SafeIframe\";s:4:\"true\";s:20:\"URI.SafeIframeRegexp\";s:72:\"%^(http://|https://|//)(www.youtube.com/embed/|player.vimeo.com/video/)%\";s:18:\"URI.AllowedSchemes\";a:5:{s:4:\"data\";b:1;s:4:\"http\";b:1;s:5:\"https\";b:1;s:6:\"mailto\";b:1;s:3:\"ftp\";b:1;}}','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(42,NULL,'routes','/home/127013.cloudwaysapps.com/xuqvxspmpb/public_html/vendor/kordy/ticketit/src/routes.php','/home/127013.cloudwaysapps.com/xuqvxspmpb/public_html/vendor/kordy/ticketit/src/routes.php','2019-03-06 08:02:39','2019-03-06 08:02:39'),
(43,NULL,'test_global_setting','1','0','2019-04-02 09:19:15','2019-04-02 09:19:15'),
(44,NULL,'default_slug','slug_1','slug','2019-04-30 05:54:58','2019-04-30 05:54:58'),
(45,'7889','manual testing','tool','....','2019-04-30 07:01:16','2019-04-30 07:01:16'),
(46,'!@','0-1*9','dfg','rrt','2019-04-30 12:09:11','2019-04-30 12:09:11'),
(47,NULL,'autoclose_tickets_after','48','48','2019-05-01 09:19:52','2019-05-01 09:20:21');

/*Table structure for table `acrm_ticketit_statuses` */

DROP TABLE IF EXISTS `acrm_ticketit_statuses`;

CREATE TABLE `acrm_ticketit_statuses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_ticketit_statuses` */

insert  into `acrm_ticketit_statuses`(`id`,`name`,`color`) values 
(2,'In Progress','#80ff00'),
(3,'Answered','#800040'),
(4,'On Hold','#ff8000'),
(10,'Closed','#0000ff'),
(11,'Open','#a6ee11');

/*Table structure for table `acrm_time_entries` */

DROP TABLE IF EXISTS `acrm_time_entries`;

CREATE TABLE `acrm_time_entries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `project_id` int(10) unsigned DEFAULT NULL,
  `task_id` int(10) unsigned DEFAULT NULL,
  `completed_by_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `hourly_rate` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `time_entries_deleted_at_index` (`deleted_at`),
  KEY `259360_5c4ffba07819c` (`project_id`),
  KEY `fk_task_id_time_entries` (`task_id`),
  KEY `fk_acrm_time_entries_completed_by_id` (`completed_by_id`),
  KEY `fk_acrm_time_entries_user_id` (`user_id`),
  CONSTRAINT `259360_5c4ffba07819c` FOREIGN KEY (`project_id`) REFERENCES `acrm_client_projects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_acrm_time_entries_completed_by_id` FOREIGN KEY (`completed_by_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_acrm_time_entries_user_id` FOREIGN KEY (`user_id`) REFERENCES `acrm_contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_task_id_time_entries` FOREIGN KEY (`task_id`) REFERENCES `acrm_project_tasks` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_time_entries` */

/*Table structure for table `acrm_transfers` */

DROP TABLE IF EXISTS `acrm_transfers`;

CREATE TABLE `acrm_transfers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `amount` double DEFAULT NULL,
  `ref_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `from_id` int(10) unsigned DEFAULT NULL,
  `to_id` int(10) unsigned DEFAULT NULL,
  `payment_method_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transfers_deleted_at_index` (`deleted_at`),
  KEY `259554_5c5034b6e9c61` (`from_id`),
  KEY `259554_5c5034b7307c2` (`to_id`),
  KEY `259554_5c5034b7623aa` (`payment_method_id`),
  CONSTRAINT `259554_5c5034b6e9c61` FOREIGN KEY (`from_id`) REFERENCES `acrm_accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `259554_5c5034b7307c2` FOREIGN KEY (`to_id`) REFERENCES `acrm_accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `259554_5c5034b7623aa` FOREIGN KEY (`payment_method_id`) REFERENCES `acrm_payment_gateways` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_transfers` */

/*Table structure for table `acrm_user_actions` */

DROP TABLE IF EXISTS `acrm_user_actions`;

CREATE TABLE `acrm_user_actions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_model` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `record_original` text COLLATE utf8mb4_unicode_ci,
  `record_update` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `259281_5c4fd29b38b49` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


/*Table structure for table `acrm_warehouses` */

DROP TABLE IF EXISTS `acrm_warehouses`;

CREATE TABLE `acrm_warehouses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `warehouses_deleted_at_index` (`deleted_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `acrm_warehouses` */

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
