<?php $request = app('Illuminate\Http\Request'); ?>


<?php $__env->startSection('content'); ?>
    <h3 class="page-title"><?php echo app('translator')->getFromJson('global.contacts.mailchimp-lists'); ?></h3>    

    <div class="panel panel-default">
        <div class="panel-heading">
            <?php echo app('translator')->getFromJson('global.app_list'); ?>
        </div>

        <div class="panel-body table-responsive">
            <table class="table table-bordered table-striped ajaxTable">
                <thead>
                    <tr>
                        <?php if( empty( $list_id ) ): ?>
                        <th><?php echo app('translator')->getFromJson('global.contacts.fields.name'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.contacts.member-count'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.contacts.is-schedule'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.contacts.last-run'); ?></th>
                        <?php else: ?>
                        <th><?php echo app('translator')->getFromJson('global.contacts.fields.email'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.contacts.member-status'); ?></th>
                        <?php endif; ?>
                        <?php if( empty( $list_id ) ): ?>
                        <th>&nbsp;</th>
                        <?php endif; ?>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
    <?php echo $__env->make('admin.contacts.mail.modal-loading', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?> 
    <script>
        $(document).ready(function () {
            <?php if( ! empty( $list_id ) ): ?>
            window.dtDefaultOptionsNew.ajax.url = '<?php echo route('admin.contacts.mailchimp-email-campaigns', $list_id); ?>';
            <?php else: ?>
            window.dtDefaultOptionsNew.ajax.url = '<?php echo route('admin.contacts.mailchimp-email-campaigns'); ?>';
            <?php endif; ?>
            window.dtDefaultOptionsNew.columns = [
                <?php if( ! empty( $list_id ) ): ?>
                {data: 'email_address', name: 'email_address'},
                {data: 'status', name: 'status', sortable: false},

                <?php else: ?>
                {data: 'name', name: 'name'},
                {data: 'member_count', name: 'member_count', sortable: false},
                {data: 'is_schedule', name: 'is_schedule', sortable: false},
                {data: 'last_run', name: 'last_run', sortable: false},
                <?php endif; ?>
                <?php if( empty( $list_id ) ): ?>
                {data: 'actions', name: 'actions', searchable: false, sortable: false}
                <?php endif; ?>
            ];
            processAjaxTablesNew();
        });
    </script>
   <script src="<?php echo e(url('adminlte/plugins/ckeditor/ckeditor.js')); ?>"></script>
    <?php echo $__env->make('admin.contacts.mail.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>