<?php
$controller = getController('controller');
$method = getController('method');
?>

<div class="row white-bg page-heading">

    <div class="col-lg-12">
        
        <div class="title-action">

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_edit')): ?>
            <a href="<?php echo e(route('admin.proposals.edit', $invoice->id)); ?>" class="btn btn-primary"><i class="fa fa-pencil-square-o"></i><?php echo e(trans('proposals::custom.proposals.edit')); ?></a>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_email_access')): ?>
             <?php if( ! in_array( $controller, array( 'ProposalTasksController', 'ProposalsRemindersController', 'ProposalsNotesController' ) ) ): ?>
            <div class="btn-group">
              <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <i class="fa fa-envelope" aria-hidden="true"></i>&nbsp;<?php echo e(trans('custom.invoices.email')); ?>&nbsp;<span class="caret"></span>
              </button>
              <ul class="dropdown-menu">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_email_created')): ?>
                <?php
                $is_sent = $invoice->history()->where('comments', 'proposal-created')->where('operation_type', 'email')->first();
                ?>
                <li><a href="#loadingModal" data-toggle="modal" data-remote="false" class="dropdown-item sendBill" data-action="proposal-created-ema" data-invoice_id="<?php echo e($invoice->id); ?>"><?php echo e(trans('custom.proposals.proposal-created')); ?><?php if( $is_sent ): ?> (<?php echo app('translator')->getFromJson('custom.messages.sent'); ?>) <?php endif; ?></a></li>
                <?php endif; ?>
              </ul>
            </div>
            <?php endif; ?>
            <?php endif; ?>

            
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_sms_access')): ?>
             <?php if( ! in_array( $controller, array( 'ProposalTasksController', 'ProposalsRemindersController', 'ProposalsNotesController' ) ) ): ?>
            <!-- SMS -->
            <div class="btn-group">
                <button type="button" class="btn btn-warning dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <i class="fa fa-comments-o" aria-hidden="true"></i>&nbsp;<?php echo e(trans('custom.common.sms')); ?>&nbsp;<span class="caret"></span>
                </button>
                <div class="dropdown-menu">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_sms_created')): ?>
                    <?php
                    $is_sent = $invoice->history()->where('comments', 'proposal-created')->where('operation_type', 'sms')->first();
                    ?>
                    <li><a href="#loadingModal" data-toggle="modal" data-remote="false" class="dropdown-item sendBill" data-action="proposal-created-sms" data-invoice_id="<?php echo e($invoice->id); ?>"><?php echo e(trans('proposals::custom.proposals.send-proposal')); ?></a></li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_sms_accepted')): ?>
                    <li><a href="#loadingModal" data-toggle="modal" data-remote="false" class="dropdown-item sendBill" data-action="proposal-accepted-sms" data-invoice_id="<?php echo e($invoice->id); ?>"><?php echo e(trans('proposals::custom.proposals.proposal-accepted')); ?></a></li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_sms_cancelled')): ?>
                    <li><a href="#loadingModal" data-toggle="modal" data-remote="false" class="dropdown-item sendBill" data-action="proposal-cancelled-sms" data-invoice_id="<?php echo e($invoice->id); ?>"><?php echo e(trans('proposals::custom.proposals.proposal-cancelled')); ?></a></li>
                    <?php endif; ?>
                </div>

            </div>
            <?php endif; ?>
            <?php endif; ?>            
            
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_changestatus_access')): ?>
            <div class="btn-group ">
                <button type="button" class="btn btn-success mb-1 btn-min-width dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">                                    
                    <i class="fa fa-arrows-v" aria-hidden="true"></i>&nbsp;<?php echo e(trans('custom.common.mark-as')); ?>&nbsp;<span class="caret"></span>
                </button>
                <div class="dropdown-menu">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_changestatus_delivered')): ?>
                    <li><a class="dropdown-item markas" href="<?php echo e(route('admin.proposals.changestatus', [ 'id' => $invoice->id, 'status' => 'delivered'])); ?>"><?php echo e(trans('proposals::custom.proposals.delivered')); ?></a></li>
                    <?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_changestatus_onhold')): ?>
                    <li><a class="dropdown-item markas" href="<?php echo e(route('admin.proposals.changestatus', [ 'id' => $invoice->id, 'status' => 'on-hold'])); ?>"><?php echo e(trans('proposals::custom.proposals.on-hold')); ?></a></li>
                    <?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_changestatus_accepted')): ?>
                    <li><a class="dropdown-item markas" href="<?php echo e(route('admin.proposals.changestatus', [ 'id' => $invoice->id, 'status' => 'accepted'])); ?>"><?php echo e(trans('proposals::custom.proposals.accepted')); ?></a></li>
                    <?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_changestatus_rejected')): ?>
                    <li><a class="dropdown-item markas" href="<?php echo e(route('admin.proposals.changestatus', [ 'id' => $invoice->id, 'status' => 'rejected'])); ?>"><?php echo e(trans('proposals::custom.proposals.rejected')); ?></a></li>
                    <?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_changestatus_lost')): ?>
                    <li><a class="dropdown-item markas" href="<?php echo e(route('admin.proposals.changestatus', [ 'id' => $invoice->id, 'status' => 'lost'])); ?>"><?php echo e(trans('proposals::custom.proposals.lost')); ?></a></li>
                    <?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_changestatus_dead')): ?>
                    <li><a class="dropdown-item markas" href="<?php echo e(route('admin.proposals.changestatus', [ 'id' => $invoice->id, 'status' => 'dead'])); ?>"><?php echo e(trans('proposals::custom.proposals.dead')); ?></a></li>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>
    <?php if( empty( $invoice->quote_id ) || empty( $invoice->invoice_id ) ): ?>
      <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_convertinvoice')): ?>
         <?php if( ! in_array( $controller, array( 'ProposalTasksController', 'ProposalsRemindersController', 'ProposalsNotesController' ) ) ): ?>
            <div class="btn-group ">
                <button type="button" class="btn btn-success mb-1 btn-min-width dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> 
                <i class="fa fa-cloud-upload" aria-hidden="true"></i>&nbsp;<?php echo e(trans('proposals::custom.proposals.convert-to')); ?>&nbsp;<span class="caret"></span>
                </button> 
                <div class="dropdown-menu">
                <?php if( empty( $invoice->invoice_id ) ): ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_convertinvoice')): ?>
                        <?php
                        $invoice_url = '';
                        if ( ! empty( $invoice->invoice_id ) ) {
                        $invoice_url = route('admin.invoices.show', [$invoice->invoice_id]);
                        }
                        ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_convertinvoice')): ?>
                        <li><a href="javascript:void(0);" data-url="<?php echo e(route('admin.proposals.convertinvoice', ['slug' => $invoice->slug, 'type' => 'convertsavedraft'])); ?>" class="dropdown-item markas convertProposal" title="<?php echo e(trans('proposals::custom.proposals.convert-to-invoice')); ?>" data-proposal_id="<?php echo e($invoice->id); ?>" data-slug="<?php echo e($invoice->slug); ?>" data-invoice_id="<?php echo e($invoice->invoice_id); ?>" data-invoice_url="<?php echo e($invoice_url); ?>"><?php echo e(trans('proposals::custom.proposals.convert-to-invoice-save-draft')); ?></a></li>
                        <?php endif; ?>
                        
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_convertinvoice')): ?>
                        <li><a href="javascript:void(0);" data-url="<?php echo e(route('admin.proposals.convertinvoice', ['slug' => $invoice->slug, 'type' => 'convert'])); ?>" class="dropdown-item markas convertProposal" title="<?php echo e(trans('proposals::custom.proposals.convert-to-invoice')); ?>" data-proposal_id="<?php echo e($invoice->id); ?>" data-slug="<?php echo e($invoice->slug); ?>" data-invoice_id="<?php echo e($invoice->invoice_id); ?>" data-invoice_url="<?php echo e($invoice_url); ?>"><?php echo e(trans('proposals::custom.proposals.convert-invoice')); ?></a></li>
                         <li role="separator" class="divider"></li>
                        <?php endif; ?>
                    <?php endif; ?>
                <?php endif; ?>
                

                <?php if( empty( $invoice->quote_id ) && empty( $invoice->invoice_id ) ): ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_convertquote')): ?>
                        <?php
                        $quote_url = '';
                        if ( ! empty( $quote->quote_id ) ) {
                        $quote_url = route('Quotes::admin.quotes.show', [$quote->quote_id]);
                        }
                        ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_convertquote')): ?>
                        <li><a href="javascript:void(0);" data-url="<?php echo e(route('admin.proposals.convertquote', ['slug' => $invoice->slug, 'type' => 'convertsavedraft'])); ?>" class="dropdown-item markas convertQuote" title="<?php echo e(trans('proposals::custom.proposals.convert-to-quote')); ?>" data-proposal_id="<?php echo e($invoice->id); ?>" data-slug="<?php echo e($invoice->slug); ?>" data-quinvoiceote_id="<?php echo e($invoice->quote_id); ?>" data-quote_url="<?php echo e($quote_url); ?>"><?php echo e(trans('proposals::custom.proposals.convert-to-quote-save-draft')); ?></a></li>
                        <?php endif; ?>
                        
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_convertquote')): ?>
                        <li><a href="javascript:void(0);" data-url="<?php echo e(route('admin.proposals.convertquote', ['slug' => $invoice->slug, 'type' => 'convert'])); ?>" class="dropdown-item markas convertQuote" title="<?php echo e(trans('proposals::custom.proposals.convert-to-quote')); ?>" data-proposal_id="<?php echo e($invoice->id); ?>" data-slug="<?php echo e($invoice->slug); ?>" data-quote_id="<?php echo e($invoice->quote_id); ?>" data-quote_url="<?php echo e($quote_url); ?>"><?php echo e(trans('proposals::custom.proposals.convert-quote')); ?></a></li>
                        <?php endif; ?>
                    <?php endif; ?>
                <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
        <?php endif; ?>
    <?php endif; ?>



        
 
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_more_options')): ?>
            <div class="btn-group ">
                <button type="button" class="btn btn-success mb-1 btn-min-width dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">                                    
                    <i class="fa fa-microchip" aria-hidden="true"></i>&nbsp;<?php echo e(trans('custom.invoices.more')); ?>&nbsp;<span class="caret"></span>
                </button>
                <div class="dropdown-menu">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_task_access')): ?>
                    <?php
                    $count = Modules\Proposals\Entities\ProposalTask::where('proposal_id', '=',$invoice->id )->count();
                    ?>
                    <li>
                        <a href="<?php echo e(route('admin.proposal_tasks.index', $invoice->id)); ?>"  class="dropdown-item">
                        <?php echo e(trans('custom.invoices.tasks')); ?>&nbsp;<span class="badge"><?php echo e($count); ?></span>
                        </a></li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_reminder_access')): ?>
                    <?php
                    $count = Modules\Proposals\Entities\ProposalsReminder::where('proposal_id', '=',$invoice->id )->count();
                    ?>
                    <li><a href="<?php echo e(route('admin.proposal_reminders.index', $invoice->id)); ?>"  class="dropdown-item"><?php echo e(trans('custom.invoices.reminders')); ?>&nbsp;<span class="badge"><?php echo e($count); ?></span></a></li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposals_note_access')): ?>
                    <?php
                    $count = Modules\Proposals\Entities\ProposalsNote::where('proposal_id', '=',$invoice->id )->count();
                    ?>
                    <li><a href="<?php echo e(route('admin.proposals_notes.index', $invoice->id)); ?>"  class="dropdown-item"><?php echo e(trans('custom.invoices.notes')); ?>&nbsp;<span class="badge"><?php echo e($count); ?></span></a></li>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>
                    
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_preview')): ?>
            <a href="<?php echo e(route( 'admin.proposals.preview', [ 'slug' => $invoice->slug ] )); ?>" class="btn btn-info" target="_blank"><i class="fa fa-street-view"></i><?php echo e(trans('custom.common.preview')); ?></a>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_duplicate')): ?>
            <a href="<?php echo e(route( 'admin.proposals.duplicate', [ 'slug' => $invoice->slug ] )); ?>" class="btn btn-info" onclick="return confirm(window.are_you_sure_duplicate)"><i class="fa fa-clone"></i> <?php echo e(trans('custom.common.duplicate')); ?></a>
            <?php endif; ?>


            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_upload')): ?>
            <a href="<?php echo e(route( 'admin.proposals.upload', [ 'slug' => $invoice->slug ] )); ?>" class="btn btn-success" title="<?php echo e(trans('custom.invoices.upload-documents')); ?>">                                
                <i class="fa fa-upload" aria-hidden="true"></i>&nbsp;<?php echo e(trans('custom.invoices.upload-documents')); ?>

            </a>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_pdf_access')): ?>
            <div class="btn-group ">
                <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">                                    
                    <i class="fa fa-file-pdf-o" aria-hidden="true"></i>&nbsp;<?php echo e(trans('custom.common.pdf')); ?>&nbsp;<span class="caret"></span>
                </button>
                <div class="dropdown-menu">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_pdf_view')): ?>
                    <li><a class="dropdown-item" href="<?php echo e(route('admin.proposals.invoicepdf', ['slug' => $invoice->slug, 'operation' => 'view'] )); ?>" target="_blank"><?php echo e(trans('custom.common.view-pdf')); ?></a></li>
                    <?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_pdf_download')): ?>
                    <li><a class="dropdown-item" href="<?php echo e(route('admin.proposals.invoicepdf', $invoice->slug)); ?>"><?php echo e(trans('custom.common.download-pdf')); ?></a></li>
                    <?php endif; ?>

                </div>
            </div>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_print')): ?>
            <a href="<?php echo e(route('admin.proposals.invoicepdf', ['slug' => $invoice->slug, 'operation' => 'print'] )); ?>" class="btn btn-large btn-primary buttons-print ml-sm" title="<?php echo e(trans('custom.common.print')); ?>" target="_blank"><i class="fa fa-print" aria-hidden="true"></i> <?php echo app('translator')->getFromJson('custom.common.print'); ?></a>
            <?php endif; ?>
            </div>
        </div>
</div>