<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.client_projects.operations.menu', array( 'client_project' => $project_task->project), \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <h3 class="page-title"><?php echo app('translator')->getFromJson('global.project-tasks.title'); ?></h3>

    <div class="panel panel-default">
        <div class="panel-heading">
            <?php echo app('translator')->getFromJson('global.app_view'); ?>
        </div>

        <div class="panel-body table-responsive">

            <div class="row">
                <div class="col-md-6">
                    <table class="table table-bordered table-striped">
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.name'); ?></th>
                            <td field-key='name'><?php echo e($project_task->name); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.description'); ?></th>
                            <td field-key='description'><?php echo clean($project_task->description); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.priority'); ?></th>
                            <td field-key='priority'><?php echo e($project_task->task_priority->title); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.startdate'); ?></th>
                            <td field-key='startdate'><?php echo e($project_task->startdate ? digiDate( $project_task->startdate ) : ''); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.duedate'); ?></th>
                            <td field-key='duedate'><?php echo e($project_task->duedate ? digiDate( $project_task->duedate ) : ''); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.datefinished'); ?></th>
                            <td field-key='datefinished'><?php echo e($project_task->datefinished ? digiDate( $project_task->datefinished ) : ''); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.status'); ?></th>
                            <td field-key='status'><?php echo e($project_task->task_status->title); ?></td>
                        </tr>
                      

                        <?php if( ! empty( $project_task->recurring_value ) ): ?>

                         <tr>
                            <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.recurring-value'); ?></th>
                            <td field-key='recurring_value'><?php echo e($project_task->recurring_value); ?></td>
                        </tr>

                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.recurring-type'); ?></th>
                            <td field-key='recurring_type'><?php echo e($project_task->recurring_type); ?></td>
                        </tr>
                       
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.cycles'); ?></th>
                            <td field-key='cycles'><?php echo e($project_task->cycles); ?></td>
                        </tr>
                        <?php endif; ?>

                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.total-cycles'); ?></th>
                            <td field-key='total_cycles'><?php echo e($project_task->total_cycles); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.last-recurring-date'); ?></th>
                            <td field-key='last_recurring_date'><?php echo e($project_task->last_recurring_date); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.is-public'); ?></th>
                            <td field-key='is_public'><?php echo e($project_task->is_public); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.billable'); ?></th>
                            <td field-key='billable'><?php echo e($project_task->billable); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.billed'); ?></th>
                            <td field-key='billed'><?php echo e($project_task->billed); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.project'); ?></th>
                            <td field-key='project'><?php echo e($project_task->project->title ?? ''); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.hourly-rate'); ?></th>
                            <td field-key='hourly_rate'><?php echo e(digiCurrency($project_task->hourly_rate)); ?></td>
                        </tr>
                        
                    <tr>
                     <th><?php echo app('translator')->getFromJson('global.client-projects.fields.assigned-to'); ?></th>
                     <td field-key='assigned_to'>
                     <?php $__currentLoopData = $project_task->assigned_to; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $singleAssignedTo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                     <span class="label label-info label-many"><?php echo e($singleAssignedTo->name); ?></span>
                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                     </td>
                    </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.visible-to-client'); ?></th>
                            <td field-key='visible_to_client'><?php echo e($project_task->visible_to_client); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.deadline-notified'); ?></th>
                            <td field-key='deadline_notified'><?php echo e($project_task->deadline_notified); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.mile-stone'); ?></th>
                            <td field-key='mile_stone'><?php echo e($project_task->mile_stone->name ?? ''); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.attachments'); ?></th>
                            <td field-key='attachments's> <?php $__currentLoopData = $project_task->getMedia('attachments'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $media): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <p class="form-group">
                                    <a href="<?php echo e(route('admin.home.media-download', $media->id)); ?>"><?php echo e($media->name); ?> (<?php echo e($media->size); ?> KB)</a>
                                </p>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.created-by'); ?></th>
                            <td field-key='created_by'><?php echo e($project_task->created_by->name ?? ''); ?></td>
                        </tr>
                    </table>
                </div>
            </div>

            <p>&nbsp;</p>

            <a href="<?php echo e(route('admin.project_tasks.index', $project_task->project_id)); ?>" class="btn btn-default"><?php echo app('translator')->getFromJson('global.app_back_to_list'); ?></a>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    ##parent-placeholder-b6e13ad53d8ec41b034c49f131c64e99cf25207a##
    
   <?php echo $__env->make('admin.common.standard-ckeditor', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <script src="<?php echo e(url('adminlte/plugins/datetimepicker/moment-with-locales.min.js')); ?>"></script>
    <script src="<?php echo e(url('adminlte/plugins/datetimepicker/bootstrap-datetimepicker.min.js')); ?>"></script>
    <script>
        $(function(){
            moment.updateLocale('<?php echo e(App::getLocale()); ?>', {
                week: { dow: 1 } // Monday is the first day of the week
            });
            
            $('.date').datetimepicker({
                format: "<?php echo e(config('app.date_format_moment')); ?>",
                locale: "<?php echo e(App::getLocale()); ?>",
            });
            
        });
    </script>
            
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>