<header class="main-header">
    <!-- Logo -->
    <a href="<?php echo e(url('/admin/dashboard')); ?>" class="logo"
       style="font-size: 16px;">
        <!-- mini logo for sidebar mini 50x50 pixels -->
        <?php
        $site_title = getSetting('site_title','site_settings', 'LaraOffice');
        $site_logo = getSetting('site_logo','site_settings');        
        $destinationPath      = getSettingsPath();
        ?>
        <?php if( ! empty( $site_logo ) && file_exists($destinationPath.$site_logo)): ?>
        <img src="<?php echo e(IMAGE_PATH_SETTINGS.$site_logo); ?>" class="logo-main" alt="<?php echo e($site_title); ?>" title="<?php echo e($site_title); ?>">
        <?php else: ?>
        <img src="<?php echo e(asset('images/logo3.png')); ?>" class="logo-main" alt="<?php echo e($site_title); ?>" title="<?php echo e($site_title); ?>">
        <?php endif; ?>
        <!-- logo for regular state and mobile devices -->        


        <span class="logo-mini"><?php echo e($site_title); ?></span>
        <!-- logo for regular state and mobile devices -->
        <span class="logo-lg"><?php echo e($site_title); ?></span>
    </a>
    <!-- Header Navbar: style can be found in header.less -->

    <nav class="navbar navbar-static-top">
        <!-- Sidebar toggle button-->
        <a href="#" class="sidebar-toggle" data-toggle="offcanvas" role="button">
        <!-- logo for regular state and mobile devices -->        
            <span class="sr-only">Toggle navigation</span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
        </a>

        
        <div class="navbar-custom-menu">
            <ul class="nav navbar-nav">

                <li class="dropdown notifications-menu">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
                        <i class="fa fa-bell-o"></i>
                        <?php ($notificationCount = \Auth::user()->internalNotifications()->where('read_at', null)->count()); ?>
                        <?php if($notificationCount > 0): ?>
                            <span class="label label-warning">
                            <?php echo e($notificationCount); ?>

                        </span>
                        <?php endif; ?>
                    </a>
                    <ul class="dropdown-menu">
                        <li>
                            <div class="slimScrollDiv"
                                 style="position: relative;">
                                <ul class="menu notification-menu">
                                    <?php if(count($notifications = \Auth::user()->internalNotifications()->get()) > 0): ?>
                                        <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li class="notification-link <?php echo e($notification->pivot->read_at === null ? "unread" : false); ?>">
                                                <a href="<?php echo e($notification->link ? $notification->link : "#"); ?>"
                                                   class="<?php echo e($notification->link ? 'is-link' : false); ?>">
                                                    <?php echo e($notification->text); ?>

                                                </a>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <li class="notification-link" style="text-align:center;">
                                            <?php echo app('translator')->getFromJson('custom.topbar.no-notifications'); ?>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </li>
                    </ul>
                </li>

                <?php
                $user = Auth::user();
                $name = $user->name;
                $image = '';
                if ($user->thumbnail && file_exists(public_path().'/thumb/' . $user->thumbnail)) {
                    $image = asset(env('UPLOAD_PATH').'/thumb/'.$user->thumbnail);
                }
                ?>
                <li class="dropdown user user-menu">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
                      <?php if( ! empty( $image ) ): ?>
                      <img src="<?php echo e($image); ?>" class="user-image" alt="<?php echo e($name); ?>">
                      <?php endif; ?>
                      <span class="hidden-xs"><?php echo e($name); ?></span>
                    </a>
                    <ul class="dropdown-menu">
                      <!-- User image -->
                      <li class="user-header">
                        <?php if( ! empty( $image ) ): ?>
                        <img src="<?php echo e($image); ?>" class="img-circle" alt="<?php echo e($name); ?>">
                        <?php endif; ?>

                        <p><?php echo e($name); ?>

                          <small><?php echo app('translator')->getFromJson('custom.topbar.last-login'); ?><?php echo e(digiDate( Auth::user()->updated_at, true )); ?> 
                            <?php if( ! empty( Auth::user()->last_login_from ) ): ?> <br> <?php echo app('translator')->getFromJson('custom.topbar.login-from'); ?><?php echo e(Auth::user()->last_login_from); ?> <?php endif; ?></small>
                        </p>
                      </li>
        
                      <!-- Menu Footer-->
                      <li class="user-footer">
                        <div class="pull-left">
                          <a href="<?php echo e(route('admin.contacts.profile.edit')); ?>" class="btn btn-success btn-flat"><?php echo app('translator')->getFromJson('custom.topbar.profile'); ?></a>
                        </div>
                        <div class="pull-right">                          
                          <a href="#logout" onclick="$('#logout').submit();" class="btn btn-warning btn-flat">
                            <i class="fa fa-arrow-left"></i>
                            <span class="title"><?php echo app('translator')->getFromJson('global.app_logout'); ?></span>
                        </a>
                        </div>
                      </li>
                    </ul>
                  </li>

            </ul>
        </div>
        <?php
        $languages = getLanguages();
        $languages_arr = array();
        ?>
        <div class="navbar-custom-menu">
            <ul class="nav navbar-nav">
                <li class="dropdown languages-menu">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
                        <?php echo e(strtoupper(\App::getLocale())); ?>

                    </a>
                    <ul class="dropdown-menu">
                        <li class="header"></li>
                        <ul class="menu language-menu">
                            <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php                            
                            $languages_arr[ $language->code ] = $language->language;
                            ?>
                                <li class="language-link">
                                    <a href="<?php echo e(route('admin.language', $language->code)); ?>">
                                        <?php echo e($language->language); ?> (<?php echo e(strtoupper($language->code)); ?>)
                                    </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php
                            config('app.languages', $languages_arr);
                            ?>
                        </ul>
                        <li class="footer"></li>
                    </ul>
                </li>
            </ul>
        </div>
    </nav>
</header>


    </nav>
</header>