<div class="row">
<div class="col-xs-6">
<div class="form-group">
    <?php echo Form::label('title', trans('global.client-projects.fields.title').'*', ['class' => 'control-label form-label']); ?>


    <div class="form-line">
    <?php echo Form::text('title', old('title'), ['class' => 'form-control', 'placeholder' => 'Title', 'required' => '']); ?>

    <p class="help-block"></p>
    <?php if($errors->has('title')): ?>
        <p class="help-block">
            <?php echo e($errors->first('title')); ?>

        </p>
    <?php endif; ?>
</div>
</div>
</div>

<div class="col-xs-6">
<div class="form-group">
    <?php echo Form::label('client_id', trans('global.client-projects.fields.client').'*', ['class' => 'control-label']); ?>

    <?php if( Gate::allows('contact_create')): ?>
        <?php if( 'button' === $addnew_type ): ?>
        &nbsp;<button type="button" class="btn btn-danger modalForm" data-id="0" data-selectedid="client_id" data-action="createclient" data-redirect="<?php echo e(route('admin.client_projects.create')); ?>" data-toggle="tooltip" data-placement="bottom" data-original-title="<?php echo e(trans('global.add_new_title', ['title' => strtolower( trans('global.client-projects.fields.client') )])); ?>"><?php echo e(trans('global.app_add_new')); ?></button>
        <?php else: ?>        
        &nbsp;<a class="modalForm" data-action="createclient" data-selectedid="client_id" data-toggle="tooltip" data-placement="bottom" data-original-title="<?php echo e(trans('global.add_new_title', ['title' => strtolower( trans('global.client-projects.fields.client') )])); ?>"><i class="fa fa-plus-square"></i></a>
        <?php endif; ?>
    <?php endif; ?>
    <?php echo Form::select('client_id', $clients, old('client_id'), ['class' => 'form-control select2', 'required' => '', 'id' => 'client_id']); ?>

    <p class="help-block"></p>
    <?php if($errors->has('client_id')): ?>
        <p class="help-block">
            <?php echo e($errors->first('client_id')); ?>

        </p>
    <?php endif; ?>
</div>
</div>
</div>

<div class="row">

<div class="col-xs-<?php echo e(COLUMNS); ?>">
<div class="form-group">
    <?php echo Form::label('priority', trans('global.client-projects.fields.priority').'*', ['class' => 'control-label']); ?>

    <?php echo Form::select('priority', $enum_priority, old('priority'), ['class' => 'form-control select2', 'required' => '']); ?>

    <p class="help-block"></p>
    <?php if($errors->has('priority')): ?>
        <p class="help-block">
            <?php echo e($errors->first('priority')); ?>

        </p>
    <?php endif; ?>
</div>
</div>



<div class="col-xs-<?php echo e(COLUMNS); ?>">
<div class="form-group">
    <?php echo Form::label('billing_type_id', trans('global.client-projects.fields.billing-type').'*', ['class' => 'control-label']); ?>

    <?php
    $disable = '';
    $budget_div = 'display: none;';
    $project_rate_per_hour_div = 'display: none;';
    $hourly_rate_div = 'display: none;';
    if ( ! empty( $client_project ) ) {
        $billed_tasks = \App\ProjectTask::where('project_id', $client_project->id)->where('billable', 'yes')->where('billed', 'yes')->first();
        $billed_expenses = \App\Expense::where('project_id', $client_project->id)->where('billable', 'yes')->where('billed', 'yes')->first();

        if ( $billed_tasks || $billed_expenses ) {
            $disable = ' disabled';
        }

        if ( $client_project->billing_type_id == PROJECT_BILLING_TYPE_FIXED_PRICE ) {
            $budget_div = '';
        }
        if ( $client_project->billing_type_id == PROJECT_BILLING_TYPE_PROJECT_HOURS ) {
            $project_rate_per_hour_div = '';
        }
        if ( $client_project->billing_type_id == PROJECT_BILLING_TYPE_TASK_HOURS ) {
            $hourly_rate_div = '';
        }
    }

    $billing_type_id_old = old('billing_type_id');
    if ( ! empty( $billing_type_id_old ) ) {
        if ( $billing_type_id_old == PROJECT_BILLING_TYPE_FIXED_PRICE ) {
            $budget_div = '';
        }
        if ( $billing_type_id_old == PROJECT_BILLING_TYPE_PROJECT_HOURS ) {
            $project_rate_per_hour_div = '';
        }
        if ( $billing_type_id_old == PROJECT_BILLING_TYPE_TASK_HOURS ) {
            $hourly_rate_div = '';
        }
    }
    ?>
    <?php echo Form::select('billing_type_id', $billing_types, old('billing_type_id'), ['class' => 'form-control select2', 'required' => '','id'=>'billing_type_id', $disable]); ?>

    <?php if( ! empty( $disable ) && ! empty( $client_project ) ): ?>
    <input type="hidden" name="billing_type_id" value="<?php echo e($client_project->billing_type_id); ?>">
    <?php endif; ?>
    <p class="help-block"></p>
    <?php if($errors->has('billing_type_id')): ?>
        <p class="help-block">
            <?php echo e($errors->first('billing_type_id')); ?>

        </p>
    <?php endif; ?>

</div>
</div>

<div class="col-xs-<?php echo e(COLUMNS); ?>" id="budget_div" style="<?php echo e($budget_div); ?>">
<div class="form-group">
    <?php echo Form::label('budget', trans('global.client-projects.fields.budget').' ' . getDefaultCurrency(), ['class' => 'control-label form-label']); ?>

    <div class="form-line">
    <?php echo Form::number('budget', old('budget'), ['class' => 'form-control','min'=>'0','step'=>'.01','placeholder' => trans('global.client-projects.fields.budget') . ' ' . getDefaultCurrency()]); ?>

    <p class="help-block"></p>
    <?php if($errors->has('budget')): ?>
        <p class="help-block">
            <?php echo e($errors->first('budget')); ?>

        </p>
    <?php endif; ?>
</div>
</div>
</div>

<div class="col-xs-<?php echo e(COLUMNS); ?>" id="hourly_rate_div" style="<?php echo e($hourly_rate_div); ?>">
<div class="form-group">
    <?php echo Form::label('hourly_rate', trans('global.client-projects.fields.hourly_rate').' ' . getDefaultCurrency(), ['class' => 'control-label form-label']); ?>

    <div class="form-line">
    <?php echo Form::number('hourly_rate', old('hourly_rate'), ['class' => 'form-control','min'=>'0','step'=>'.01' , 'placeholder' => trans('global.client-projects.fields.hourly_rate') . ' ' . getDefaultCurrency()]); ?>

    <p class="help-block"></p>
    <?php if($errors->has('hourly_rate')): ?>
        <p class="help-block">
            <?php echo e($errors->first('hourly_rate')); ?>

        </p>
    <?php endif; ?>
</div>
</div>
</div>

<div class="col-xs-<?php echo e(COLUMNS); ?>" id="project_rate_per_hour_div" style="<?php echo e($project_rate_per_hour_div); ?>">
<div class="form-group">
    <?php echo Form::label('project_rate_per_hour', trans('global.client-projects.fields.project_rate_per_hour').' ' . getDefaultCurrency(), ['class' => 'control-label form-label']); ?>

    <div class="form-line">
    <?php echo Form::number('project_rate_per_hour', old('project_rate_per_hour'), ['class' => 'form-control','min'=>'0', 'step'=>'.01' ,'placeholder' => trans('global.client-projects.fields.project_rate_per_hour') . ' ' . getDefaultCurrency()]); ?>

    <p class="help-block"></p>
    <?php if($errors->has('project_rate_per_hour')): ?>
        <p class="help-block">
            <?php echo e($errors->first('project_rate_per_hour')); ?>

        </p>
    <?php endif; ?>
</div>
</div>
</div>

<div class="col-xs-<?php echo e(COLUMNS); ?>" id="estimated_hours">
<div class="form-group">
    <?php echo Form::label('estimated_hours', trans('global.client-projects.fields.estimated_hours').'', ['class' => 'control-label form-label']); ?>

    <div class="form-line">
    <?php echo Form::number('estimated_hours', old('estimated_hours'), ['class' => 'form-control amount','min'=>'0', 'placeholder' => '','min'=>'1']); ?>

    <p class="help-block"></p>
    <?php if($errors->has('estimated_hours')): ?>
        <p class="help-block">
            <?php echo e($errors->first('estimated_hours')); ?>

        </p>
    <?php endif; ?>
</div>
</div>
</div>
</div>

<div class="row">

<div class="col-xs-<?php echo e(COLUMNS); ?>">
<div class="form-group">
    <?php echo Form::label('phase', trans('global.client-projects.fields.phase').'', ['class' => 'control-label form-label']); ?>

    <div class="form-line">
    <?php echo Form::number('phase', old('phase'), ['class' => 'form-control amount','min'=>'0','step'=>'.01' , 'placeholder' => 'Eg: 1, 2 etc.']); ?>

    <p class="help-block"></p>
    <?php if($errors->has('phase')): ?>
        <p class="help-block">
            <?php echo e($errors->first('phase')); ?>

        </p>
    <?php endif; ?>
</div>
</div>
</div>

<div class="col-xs-<?php echo e(COLUMNS); ?>">
<div class="form-group">
    <?php echo Form::label('progress_from_tasks', trans('global.client-projects.fields.progress_from_tasks').'*', ['class' => 'control-label']); ?>

    <?php echo Form::select('progress_from_tasks', yesnooptions(), old('progress_from_tasks'), ['class' => 'form-control select2', 'required' => '']); ?>

    <p class="help-block"></p>
    <?php if($errors->has('progress_from_tasks')): ?>
        <p class="help-block">
            <?php echo e($errors->first('progress_from_tasks')); ?>

        </p>
    <?php endif; ?>
</div>
</div>




<div class="col-xs-<?php echo e(COLUMNS); ?>">
<div class="form-group">

    <?php echo Form::label('start_date', trans('global.client-projects.fields.start-date').'', ['class' => 'control-label form-label']); ?>

    <div class="form-line">
    <?php
    $start_date = digiTodayDateAdd();
    if ( ! empty( $client_project->start_date ) ) {
        $start_date = digiDate( $client_project->start_date );
    }
    ?>
    <?php echo Form::text('start_date', old('start_date', $start_date), ['class' => 'form-control date', 'placeholder' => 'Start Date']); ?>

    <p class="help-block"></p>
    <?php if($errors->has('start_date')): ?>
        <p class="help-block">
            <?php echo e($errors->first('start_date')); ?>

        </p>
    <?php endif; ?>
</div>
</div>
</div>

<div class="col-xs-<?php echo e(COLUMNS); ?>">
<div class="form-group">
 
    <?php echo Form::label('due_date', trans('global.client-projects.fields.due-date').'', ['class' => 'control-label form-label']); ?>

    <div class="form-line">
    <?php
    $due_date = digiTodayDateAdd(2);
    if ( ! empty( $client_project->due_date ) ) {
        $due_date = digiDate( $client_project->due_date );
    }
    ?>
    <?php echo Form::text('due_date', old('due_date', $due_date), ['class' => 'form-control date', 'placeholder' => 'Due Date']); ?>

    <p class="help-block"></p>
    <?php if($errors->has('due_date')): ?>
        <p class="help-block">
            <?php echo e($errors->first('due_date')); ?>

        </p>
    <?php endif; ?>
</div>
</div>
</div>

</div>

<div class="row">

<div class="col-xs-<?php echo e(COLUMNS); ?>">
<div class="form-group">
    <?php echo Form::label('status_id', trans('global.client-projects.fields.status').'*', ['class' => 'control-label']); ?>

    <?php echo Form::select('status_id', $statuses, old('status_id'), ['class' => 'form-control select2', 'required' => '']); ?>

    <p class="help-block"></p>
    <?php if($errors->has('status_id')): ?>
        <p class="help-block">
            <?php echo e($errors->first('status_id')); ?>

        </p>
    <?php endif; ?>
</div>
</div>

<div class="col-xs-<?php echo e(COLUMNS); ?>">
<div class="form-group">
    <?php echo Form::label('demo_url', trans('global.client-projects.fields.demo-url').'', ['class' => 'control-label form-label']); ?>

    <div class="form-line">
    <?php echo Form::text('demo_url', old('demo_url'), ['class' => 'form-control', 'placeholder' => 'Demo url']); ?>

    <p class="help-block"></p>
    <?php if($errors->has('demo_url')): ?>
        <p class="help-block">
            <?php echo e($errors->first('demo_url')); ?>

        </p>
    <?php endif; ?>
</div>
</div>
</div>
</div>



<div class="row">
<div class="col-xs-6">
<div class="form-group">
    <?php echo Form::label('assigned_to', trans('global.client-projects.fields.assigned-to').'', ['class' => 'control-label']); ?>

    <button type="button" class="btn btn-primary btn-xs" id="selectbtn-assigned_to">
        <?php echo e(trans('global.app_select_all')); ?>

    </button>
    <button type="button" class="btn btn-primary btn-xs" id="deselectbtn-assigned_to">
        <?php echo e(trans('global.app_deselect_all')); ?>

    </button>
     <?php
        $assigned_to = array();
        if ( ! empty( $client_project ) ) {
            $assigned_to = $client_project->assigned_to->pluck('id')->toArray();
        }
        ?>
    <?php echo Form::select('assigned_to[]', $assigned_tos, old('assigned_to'), ['class' => 'form-control select2', 'multiple' => 'multiple', 'id' => 'selectall-assigned_to' ]); ?>

    <p class="help-block"></p>
    <?php if($errors->has('assigned_to')): ?>
        <p class="help-block">
            <?php echo e($errors->first('assigned_to')); ?>

        </p>
    <?php endif; ?>
</div>
</div>


<div class="col-xs-6">
<div class="form-group">
    <?php echo Form::label('project_tabs', trans('global.client-projects.fields.project-tabs').'', ['class' => 'control-label']); ?>

    <button type="button" class="btn btn-primary btn-xs" id="selectbtn-project_tabs">
        <?php echo e(trans('global.app_select_all')); ?>

    </button>
    <button type="button" class="btn btn-primary btn-xs" id="deselectbtn-project_tabs">
        <?php echo e(trans('global.app_deselect_all')); ?>

    </button>
    <?php echo Form::select('project_tabs[]', $project_tabs, old('project_tabs'), ['class' => 'form-control select2', 'multiple' => 'multiple', 'id' => 'selectall-project_tabs' ]); ?>

    <p class="help-block"></p>
    <?php if($errors->has('project_tabs')): ?>
        <p class="help-block">
            <?php echo e($errors->first('project_tabs')); ?>

        </p>
    <?php endif; ?>
</div>
</div>

</div>
<div class="row">
<div class="col-xs-12">
<div class="form-group">
    <?php echo Form::label('description', trans('global.client-projects.fields.description').'', ['class' => 'control-label']); ?>

    <?php echo Form::textarea('description', old('description'), ['class' => 'form-control editor', 'placeholder' => 'Description']); ?>

    <p class="help-block"></p>
    <?php if($errors->has('description')): ?>
        <p class="help-block">
            <?php echo e($errors->first('description')); ?>

        </p>
    <?php endif; ?>
</div>
</div>


</div>

 



