<h3 class="page-title"><?php echo app('translator')->getFromJson('global.accounts.title'); ?></h3>
<?php echo Form::open(['method' => 'POST', 'route' => ['admin.accounts.store'],'class'=>'formvalidation', 'id' => 'frmAccount']); ?>


<div class="panel panel-default">
    <div class="panel-heading">
        <?php echo app('translator')->getFromJson('global.app_create'); ?>
    </div>

    <div class="alert" style="display:none" id="message_bag">
        <ul></ul>
    </div>
    
    <div class="panel-body">
        <div class="row">
            <div class="col-xs-6">
            <div class="form-group">
                <?php echo Form::label('name', trans('global.accounts.fields.name').'*', ['class' => 'control-label form-label']); ?>

                <div class="form-line">
                <?php echo Form::text('name', old('name'), ['class' => 'form-control', 'placeholder' => 'Name', 'required' => '']); ?>

                <p class="help-block"></p>
                <?php if($errors->has('name')): ?>
                    <p class="help-block">
                        <?php echo e($errors->first('name')); ?>

                    </p>
                <?php endif; ?>
            </div>
            </div>
            </div>

            <div class="col-xs-6">
            <div class="form-group">
                <?php echo Form::label('url', trans('global.accounts.fields.url').'', ['class' => 'control-label form-label']); ?>

                <div class="form-line">
                <?php echo Form::text('url', old('url'), ['class' => 'form-control', 'placeholder' => 'URL']); ?>

                <p class="help-block"></p>
                <?php if($errors->has('url')): ?>
                    <p class="help-block">
                        <?php echo e($errors->first('url')); ?>

                    </p>
                <?php endif; ?>
            </div>
            </div>
            </div>
        
            
       
            <div class="col-xs-<?php echo e(COLUMNS); ?>">
            <div class="form-group">
                <?php echo Form::label('initial_balance', trans('global.accounts.fields.initial-balance').'', ['class' => 'control-label form-label']); ?>

                <div class="form-line">
                <?php echo Form::text('initial_balance', old('initial_balance'), ['class' => 'form-control amount', 'placeholder' => 'Initial Balance']); ?>

                <p class="help-block"></p>
                <?php if($errors->has('initial_balance')): ?>
                    <p class="help-block">
                        <?php echo e($errors->first('initial_balance')); ?>

                    </p>
                <?php endif; ?>
            </div>
            </div>
            </div>
      
            <div class="col-xs-<?php echo e(COLUMNS); ?>">
            <div class="form-group">
                <?php echo Form::label('account_number', trans('global.accounts.fields.account-number').'', ['class' => 'control-label form-label']); ?>

                <div class="form-line">
                <?php echo Form::text('account_number', old('account_number'), ['class' => 'form-control', 'placeholder' => 'Account Number']); ?>

                <p class="help-block"></p>
                <?php if($errors->has('account_number')): ?>
                    <p class="help-block">
                        <?php echo e($errors->first('account_number')); ?>

                    </p>
                <?php endif; ?>
            </div>
            </div>
            </div>
      
            <div class="col-xs-<?php echo e(COLUMNS); ?>">
            <div class="form-group">
                <?php echo Form::label('contact_person', trans('global.accounts.fields.contact-person').'', ['class' => 'control-label form-label']); ?>

                <div class="form-line">
                <?php echo Form::text('contact_person', old('contact_person'), ['class' => 'form-control', 'placeholder' => 'Contact Person']); ?>

                <p class="help-block"></p>
                <?php if($errors->has('contact_person')): ?>
                    <p class="help-block">
                        <?php echo e($errors->first('contact_person')); ?>

                    </p>
                <?php endif; ?>
            </div>
            </div>
            </div>
       
            <div class="col-xs-<?php echo e(COLUMNS); ?>">
            <div class="form-group">
                <?php echo Form::label('phone', trans('global.accounts.fields.phone').'', ['class' => 'control-label form-label']); ?>

                <div class="form-line">
                <?php echo Form::text('phone', old('phone'), ['class' => 'form-control number', 'placeholder' => 'Phone']); ?>

                <p class="help-block"></p>
                <?php if($errors->has('phone')): ?>
                    <p class="help-block">
                        <?php echo e($errors->first('phone')); ?>

                    </p>
                <?php endif; ?>
            </div>
            </div>
            </div>


            <div class="col-xs-8">
            <div class="form-group">
                <?php echo Form::label('description', trans('global.accounts.fields.description').'', ['class' => 'control-label']); ?>

                <?php echo Form::textarea('description', old('description'), ['class' => 'form-control ', 'placeholder' => 'Description','rows'=>'4']); ?>

                <p class="help-block"></p>
                <?php if($errors->has('description')): ?>
                    <p class="help-block">
                        <?php echo e($errors->first('description')); ?>

                    </p>
                <?php endif; ?>
            </div>
            </div>
      
            
        </div>
        
    </div>
</div>
<?php
if ( empty( $is_ajax ) ) {
    $is_ajax = 'no';
}
?>
<input type="hidden" name="is_ajax" value="<?php echo e($is_ajax); ?>">
<?php
if ( empty( $selectedid ) ) {
    $selectedid = 'account_id';
}
?>
<input type="hidden" name="selectedid" value="<?php echo e($selectedid); ?>">
<?php echo Form::submit(trans('global.app_save'), ['class' => 'btn btn-danger wave-effect saveAccount']); ?>

<?php echo Form::close(); ?>


<?php if( 'yes' === $is_ajax ): ?>
<script type="text/javascript">
  $(".saveAccount").click(function(e){
            e.preventDefault();

            $.ajax({
                url: "<?php echo e(route('admin.accounts.store')); ?>",
                type:'POST',
                data: $( '#frmAccount' ).serializeArray(),
                success: function(data) {
                    if($.isEmptyObject(data.error)){
                        notifyMe('success', data.success);
                        $('#loadingModal').modal('hide');

                        var value = data.record.id;
                        var title = data.record.name;
                        $('#' + data.record.selectedid).append('<option value="'+value+'" selected="selected">'+title+'</option>');                        
                    }else{
                        printErrorMsg(data.error);
                    }
                }
            });
  });

  function printErrorMsg (msg) {
      $("#message_bag").find("ul").html('');
      $("#message_bag").css('display','block');
      $("#message_bag").addClass('alert-danger');
      $.each( msg, function( key, value ) {
          $("#message_bag").find("ul").append('<li>'+value+'</li>');
      });
  }
</script>
<?php endif; ?>