<div class="row">
    <div class="col-xs-<?php echo e(COLUMNS); ?>">
        <?php echo Form::label('name', trans('global.mile-stones.fields.name').'*', ['class' => 'control-label']); ?>

        <?php echo Form::text('name', old('name'), ['class' => 'form-control', 'placeholder' => '', 'required' => '']); ?>

        <p class="help-block"></p>
        <?php if($errors->has('name')): ?>
            <p class="help-block">
                <?php echo e($errors->first('name')); ?>

            </p>
        <?php endif; ?>
    </div>

    

    <div class="col-xs-<?php echo e(COLUMNS); ?>">
        <?php echo Form::label('description_visible_to_customer', trans('global.mile-stones.fields.description-visible-to-customer').'', ['class' => 'control-label']); ?>

        <?php echo Form::select('description_visible_to_customer', $enum_description_visible_to_customer, old('description_visible_to_customer'), ['class' => 'form-control select2']); ?>

        <p class="help-block"></p>
        <?php if($errors->has('description_visible_to_customer')): ?>
            <p class="help-block">
                <?php echo e($errors->first('description_visible_to_customer')); ?>

            </p>
        <?php endif; ?>
    </div>

    <div class="col-xs-<?php echo e(COLUMNS); ?>">
        <?php echo Form::label('due_date', trans('global.mile-stones.fields.due-date').'', ['class' => 'control-label']); ?>

        <?php echo Form::text('due_date', old('due_date'), ['class' => 'form-control date', 'placeholder' => '','required'=>'']); ?>

        <p class="help-block"></p>
        <?php if($errors->has('due_date')): ?>
            <p class="help-block">
                <?php echo e($errors->first('due_date')); ?>

            </p>
        <?php endif; ?>
    </div>

    
    <input type="hidden" name="project_id" value="<?php echo e($project->id); ?>">



    <div class="col-xs-<?php echo e(COLUMNS); ?>">
        <?php echo Form::label('milestone_order', trans('global.mile-stones.fields.milestone-order').'', ['class' => 'control-label']); ?>

        <?php echo Form::number('milestone_order', old('milestone_order'), ['class' => 'form-control', 'placeholder' => '','min'=>'0','required'=>'']); ?>

        <p class="help-block"></p>
        <?php if($errors->has('milestone_order')): ?>
            <p class="help-block">
                <?php echo e($errors->first('milestone_order')); ?>

            </p>
        <?php endif; ?>
    </div>

    <div class="col-xs-12">
        <?php echo Form::label('description', trans('global.mile-stones.fields.description').'', ['class' => 'control-label']); ?>

        <?php echo Form::textarea('description', old('description'), ['class' => 'form-control editor', 'placeholder' => '']); ?>

        <p class="help-block"></p>
        <?php if($errors->has('description')): ?>
            <p class="help-block">
                <?php echo e($errors->first('description')); ?>

            </p>
        <?php endif; ?>
    </div>
</div>