<?php $__env->startSection('content'); ?>
       <h3 class="page-title"><?php echo e($task->name); ?>

        
    </h3>

    <div class="panel panel-default">
        <?php if( 'yes' === $show_page_heading ): ?>
        <div class="panel-heading">
            <?php echo app('translator')->getFromJson('global.app_view'); ?>
        </div>
        <?php endif; ?>
   
        <div class="panel-body table-responsive">
            <?php if( Gate::allows('task_edit') || Gate::allows('task_delete')): ?>
            <div class="pull-right">   
                <?php if( Gate::allows('task_edit') ): ?>
                    <a href="<?php echo e(route('admin.tasks.edit', $task->id)); ?>" class="btn btn-xs btn-info"><i class="fa fa-pencil-square-o"></i><?php echo e(trans('global.app_edit')); ?></a>
                <?php endif; ?>
                <?php if( Gate::allows('task_delete')): ?>
                    <?php echo $__env->make('admin.common.delete-link', ['record' => $task, 'routeName' => 'admin.tasks.destroy', 'redirect_url' => url()->previous()] , \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                <?php endif; ?>
            </div>
            <?php endif; ?>
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-bordered table-striped">
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.tasks.fields.name'); ?></th>
                            <td field-key='name'><?php echo e($task->name); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.tasks.fields.description'); ?></th>
                            <td field-key='description'><?php echo clean($task->description); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.tasks.fields.status'); ?></th>
                            <td field-key='status'><?php echo e($task->status->name ?? ''); ?></td>
                        </tr>
                     
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.tasks.fields.attachment'); ?></th>
                            <td field-key='attachment'><?php if($task->attachment): ?><a href="<?php echo e(route('admin.home.media-file-download', ['model' => 'Task', 'field' => 'attachment', 'record_id' => $task->id])); ?>"><?php echo app('translator')->getFromJson('others.download-file'); ?></a><?php endif; ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.tasks.fields.start-date'); ?></th>
                            <td field-key='due_date'><?php echo e($task->start_date ? digiDate($task->start_date) : ''); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.tasks.fields.due-date'); ?></th>
                            <td field-key='due_date'><?php echo e($task->due_date ? digiDate($task->due_date) : ''); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.tasks.fields.user'); ?></th>
                            <td field-key='user'><?php echo e($task->user->name ?? ''); ?></td>
                        </tr>
                    </table>
                </div>
            </div>

            <p>&nbsp;</p>

            <a href="<?php echo e(route('admin.tasks.index')); ?>" class="btn btn-default"><?php echo app('translator')->getFromJson('global.app_back_to_list'); ?></a>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    ##parent-placeholder-b6e13ad53d8ec41b034c49f131c64e99cf25207a##

    <script src="<?php echo e(url('adminlte/plugins/datetimepicker/moment-with-locales.min.js')); ?>"></script>
    <script src="<?php echo e(url('adminlte/plugins/datetimepicker/bootstrap-datetimepicker.min.js')); ?>"></script>
    <script>
        $(function(){
            moment.updateLocale('<?php echo e(App::getLocale()); ?>', {
                week: { dow: 1 } // Monday is the first day of the week
            });
            
            $('.date').datetimepicker({
                format: "<?php echo e(config('app.date_format_moment')); ?>",
                locale: "<?php echo e(App::getLocale()); ?>",
            });
            
        });
    </script>
            
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>