<?php
$controller = getController('controller');
$method = getController('method');
?>

<div class="row white-bg page-heading">

    <div class="col-lg-12">
        
        <div class="title-action">

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_edit')): ?>
            <a href="<?php echo e(route('admin.quotes.edit', $invoice->id)); ?>" class="btn btn-info"><i class="fa fa-pencil-square-o"></i><?php echo e(trans('quotes::custom.quotes.edit')); ?></a>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_email_access')): ?>
             <?php if( ! in_array( $controller, array( 'QuoteTasksController', 'QuotesRemindersController', 'QuotesNotesController' ) ) ): ?>
            <div class="btn-group">
              <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <i class="fa fa-envelope" aria-hidden="true"></i>&nbsp;<?php echo e(trans('custom.invoices.email')); ?>&nbsp;<span class="caret"></span>
              </button>
              <ul class="dropdown-menu">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_email_created')): ?>
                <?php
                $is_sent = $invoice->history()->where('comments', 'quote-created')->where('operation_type', 'email')->first();
                ?>
                <li><a href="#loadingModal" data-toggle="modal" data-remote="false" class="dropdown-item sendBill" data-action="quote-created-ema" data-invoice_id="<?php echo e($invoice->id); ?>"><?php echo e(trans('quotes::custom.quotes.quote-created')); ?><?php if( $is_sent ): ?> (<?php echo app('translator')->getFromJson('custom.messages.sent'); ?>) <?php endif; ?></a></li>
                <?php endif; ?>
              </ul>
            </div>
            <?php endif; ?>
            <?php endif; ?>

            
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_sms_access')): ?>
             <?php if( ! in_array( $controller, array( 'QuoteTasksController', 'QuotesRemindersController', 'QuotesNotesController' ) ) ): ?>
            <!-- SMS -->
            <div class="btn-group">
                <button type="button" class="btn btn-warning dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <i class="fa fa-comments-o" aria-hidden="true"></i>&nbsp;<?php echo e(trans('custom.common.sms')); ?>&nbsp;<span class="caret"></span>
                </button>
                <div class="dropdown-menu">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_sms_created')): ?>
                    <?php
                    $is_sent = $invoice->history()->where('comments', 'quote-created')->where('operation_type', 'sms')->first();
                    ?>
                    <li><a href="#loadingModal" data-toggle="modal" data-remote="false" class="dropdown-item sendBill" data-action="quote-created-sms" data-invoice_id="<?php echo e($invoice->id); ?>"><?php echo e(trans('quotes::custom.quotes.send-quote')); ?></a></li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_sms_accepted')): ?>
                    <li><a href="#loadingModal" data-toggle="modal" data-remote="false" class="dropdown-item sendBill" data-action="quote-accepted-sms" data-invoice_id="<?php echo e($invoice->id); ?>"><?php echo e(trans('quotes::custom.quotes.quote-accepted')); ?></a></li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_sms_cancelled')): ?>
                    <li><a href="#loadingModal" data-toggle="modal" data-remote="false" class="dropdown-item sendBill" data-action="quote-cancelled-sms" data-invoice_id="<?php echo e($invoice->id); ?>"><?php echo e(trans('quotes::custom.quotes.quote-cancelled')); ?></a></li>
                    <?php endif; ?>
                </div>

            </div>
            <?php endif; ?>
            <?php endif; ?>            
            
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_changestatus_access')): ?>
            <div class="btn-group ">
                <button type="button" class="btn btn-success mb-1 btn-min-width dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">                                    
                    <i class="fa fa-arrows-v" aria-hidden="true"></i>&nbsp;<?php echo e(trans('custom.common.mark-as')); ?>&nbsp;<span class="caret"></span>
                </button>
                <div class="dropdown-menu">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_changestatus_delivered')): ?>
                    <li><a class="dropdown-item markas" href="<?php echo e(route('admin.quotes.changestatus', [ 'id' => $invoice->id, 'status' => 'delivered'])); ?>"><?php echo e(trans('quotes::custom.quotes.delivered')); ?></a></li>
                    <?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_changestatus_onhold')): ?>
                    <li><a class="dropdown-item markas" href="<?php echo e(route('admin.quotes.changestatus', [ 'id' => $invoice->id, 'status' => 'on-hold'])); ?>"><?php echo e(trans('quotes::custom.quotes.on-hold')); ?></a></li>
                    <?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_changestatus_accepted')): ?>
                    <li><a class="dropdown-item markas" href="<?php echo e(route('admin.quotes.changestatus', [ 'id' => $invoice->id, 'status' => 'accepted'])); ?>"><?php echo e(trans('quotes::custom.quotes.accepted')); ?></a></li>
                    <?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_changestatus_rejected')): ?>
                    <li><a class="dropdown-item markas" href="<?php echo e(route('admin.quotes.changestatus', [ 'id' => $invoice->id, 'status' => 'rejected'])); ?>"><?php echo e(trans('quotes::custom.quotes.rejected')); ?></a></li>
                    <?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_changestatus_lost')): ?>
                    <li><a class="dropdown-item markas" href="<?php echo e(route('admin.quotes.changestatus', [ 'id' => $invoice->id, 'status' => 'lost'])); ?>"><?php echo e(trans('quotes::custom.quotes.lost')); ?></a></li>
                    <?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_changestatus_dead')): ?>
                    <li><a class="dropdown-item markas" href="<?php echo e(route('admin.quotes.changestatus', [ 'id' => $invoice->id, 'status' => 'dead'])); ?>"><?php echo e(trans('quotes::custom.quotes.dead')); ?></a></li>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>

            <?php if( empty( $invoice->invoice_id ) ): ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_convertinvoice')): ?>
                 <?php if( ! in_array( $controller, array( 'QuoteTasksController', 'QuotesRemindersController', 'QuotesNotesController' ) ) ): ?>
                <div class="btn-group ">
                    <?php if( isPluginActive('invoice') ): ?>
                    <button type="button" class="btn btn-success mb-1 btn-min-width dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">                                    
                        <i class="fa fa-cloud-upload" aria-hidden="true"></i>&nbsp;<?php echo e(trans('quotes::custom.quotes.convert-to-invoice')); ?>&nbsp;<span class="caret"></span>
                    </button>
                    <?php endif; ?>
                    <div class="dropdown-menu">
                        <?php
                        $invoice_url = '';
                        if ( ! empty( $invoice->invoice_id ) ) {
                            $invoice_url = route('admin.invoices.show', [$invoice->invoice_id]);
                        }
                        ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_convertinvoice')): ?>
                        <li><a href="javascript:void(0);" data-url="<?php echo e(route('admin.quotes.convertinvoice', ['slug' => $invoice->slug, 'type' => 'convertsavedraft'])); ?>" class="dropdown-item markas convertQuote" title="<?php echo e(trans('quotes::custom.quotes.convert-to-invoice')); ?>" data-quote_id="<?php echo e($invoice->id); ?>" data-slug="<?php echo e($invoice->slug); ?>" data-invoice_id="<?php echo e($invoice->invoice_id); ?>" data-invoice_url="<?php echo e($invoice_url); ?>"><?php echo e(trans('quotes::custom.quotes.convert-to-invoice-save-draft')); ?></a></li>
                        <?php endif; ?>
                        
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_convertinvoice')): ?>
                        <li><a href="javascript:void(0);" data-url="<?php echo e(route('admin.quotes.convertinvoice', ['slug' => $invoice->slug, 'type' => 'convert'])); ?>" class="dropdown-item markas convertQuote" title="<?php echo e(trans('quotes::custom.quotes.convert-to-invoice')); ?>" data-quote_id="<?php echo e($invoice->id); ?>" data-slug="<?php echo e($invoice->slug); ?>" data-invoice_id="<?php echo e($invoice->invoice_id); ?>" data-invoice_url="<?php echo e($invoice_url); ?>"><?php echo e(trans('quotes::custom.quotes.convert')); ?></a></li>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endif; ?>
                <?php endif; ?>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_more_options')): ?>
            <div class="btn-group ">
                <button type="button" class="btn btn-success mb-1 btn-min-width dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">                                    
                    <i class="fa fa-microchip" aria-hidden="true"></i>&nbsp;<?php echo e(trans('custom.invoices.more')); ?>&nbsp;<span class="caret"></span>
                </button>
                <div class="dropdown-menu">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_task_access')): ?>
                    <?php
                    $count = Modules\Quotes\Entities\QuoteTask::where('quote_id', '=',$invoice->id )->count();
                    ?>
                    <li>
                        <a href="<?php echo e(route('admin.quote_tasks.index', $invoice->id)); ?>"  class="dropdown-item">
                        <?php echo e(trans('custom.invoices.tasks')); ?>&nbsp;<span class="badge"><?php echo e($count); ?></span>
                        </a></li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_reminder_access')): ?>
                    <?php
                    $count = Modules\Quotes\Entities\QuotesReminder::where('quote_id', '=',$invoice->id )->count();
                    ?>
                    <li><a href="<?php echo e(route('admin.quote_reminders.index', $invoice->id)); ?>"  class="dropdown-item"><?php echo e(trans('custom.invoices.reminders')); ?>&nbsp;<span class="badge"><?php echo e($count); ?></span></a></li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quotes_note_access')): ?>
                    <?php
                    $count = Modules\Quotes\Entities\QuotesNote::where('quote_id', '=',$invoice->id )->count();
                    ?>
                    <li><a href="<?php echo e(route('admin.quotes_notes.index', $invoice->id)); ?>"  class="dropdown-item"><?php echo e(trans('custom.invoices.notes')); ?>&nbsp;<span class="badge"><?php echo e($count); ?></span></a></li>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>
                    
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_preview')): ?>
            <a href="<?php echo e(route( 'admin.quotes.preview', [ 'slug' => $invoice->slug ] )); ?>" class="btn btn-info" target="_blank"><i class="fa fa-street-view"></i><?php echo e(trans('custom.common.preview')); ?></a>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_duplicate')): ?>
            <a href="<?php echo e(route( 'admin.quotes.duplicate', [ 'slug' => $invoice->slug ] )); ?>" class="btn btn-info" onclick="return confirm(window.are_you_sure_duplicate)"><i class="fa fa-clone"></i> <?php echo e(trans('custom.common.duplicate')); ?></a>
            <?php endif; ?>


            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_upload')): ?>
            <a href="<?php echo e(route( 'admin.quotes.upload', [ 'slug' => $invoice->slug ] )); ?>" class="btn btn-success" title="<?php echo e(trans('custom.invoices.upload-documents')); ?>">                                
                <i class="fa fa-upload" aria-hidden="true"></i>&nbsp;<?php echo e(trans('custom.invoices.upload-documents')); ?>

            </a>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_pdf_access')): ?>
            <div class="btn-group ">
                <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">                                    
                    <i class="fa fa-file-pdf-o" aria-hidden="true"></i>&nbsp;<?php echo e(trans('custom.common.pdf')); ?>&nbsp;<span class="caret"></span>
                </button>
                <div class="dropdown-menu">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_pdf_view')): ?>
                    <li><a class="dropdown-item" href="<?php echo e(route('admin.quotes.invoicepdf', ['slug' => $invoice->slug, 'operation' => 'view'] )); ?>" target="_blank"><?php echo e(trans('custom.common.view-pdf')); ?></a></li>
                    <?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_pdf_download')): ?>
                    <li><a class="dropdown-item" href="<?php echo e(route('admin.quotes.invoicepdf', $invoice->slug)); ?>"><?php echo e(trans('custom.common.download-pdf')); ?></a></li>
                    <?php endif; ?>

                </div>
            </div>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_print')): ?>
            <a href="<?php echo e(route('admin.quotes.invoicepdf', ['slug' => $invoice->slug, 'operation' => 'print'] )); ?>" class="btn btn-large btn-primary buttons-print ml-sm" title="<?php echo e(trans('custom.common.print')); ?>" target="_blank"><i class="fa fa-print" aria-hidden="true"></i> <?php echo app('translator')->getFromJson('custom.common.print'); ?></a>
            <?php endif; ?>
            </div>
        </div>
</div>