<?php
$currency_id = $invoice->currency_id;
$transactions = $invoice->transactions();

if ( $transactions->count() > 0 ) {

?>
<div id="invoice-template" class="row">
    <div class="col-lg-12">
<h3><?php echo app('translator')->getFromJson('custom.invoices.related-transactions'); ?></h3>
    <table class="table table-bordered sys_table">
        <tbody>
            <tr class="text-view">
                <th><?php echo app('translator')->getFromJson('custom.invoices.date'); ?></th>
                
                <?php if( ! isCustomer() && ! isSalesPerson() ): ?>
                <th>
                <?php echo app('translator')->getFromJson('custom.invoices.account'); ?>                
                </th>
                <?php endif; ?>
                <th class="text-right"><?php echo app('translator')->getFromJson('custom.invoices.amount'); ?></th>
                <th><?php echo app('translator')->getFromJson('custom.invoices.description'); ?></th>
				<th><?php echo app('translator')->getFromJson('global.app_status'); ?></th>
               
            </tr>
            <?php $__currentLoopData = $transactions->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
            $account = $transaction->account()->where('id', '=', $transaction->account_id)->first();
            $account_name = ! empty( $account ) ? $account->name : '';

            ?>
            <tr class="info">
                <td><?php echo e(digiDate( $transaction->created_at, true )); ?></td>
                <?php if( ! isCustomer() && ! isSalesPerson() ): ?>
                <td><?php echo e($account_name); ?></td>
                <?php endif; ?>
                <td class="text-right"><?php echo e(digiCurrency( $transaction->amount, $currency_id )); ?>

                    <p><span class="label label-info label-many">
                        <?php
                        $paymentmethod = $transaction->paymentmethod;
                        if ( is_numeric( $paymentmethod ) ) {
                            $paymentmethod = \App\PaymentGateway::find($paymentmethod)->name;
                        }
                        ?>
                        <?php echo e($paymentmethod); ?></span></p>
                </td>
                <td><?php echo e($transaction->description); ?></td>
				<td><?php echo e($transaction->payment_status ?? $transaction->payment_status); ?></td>
                
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    </tbody>

</table>
</div>
</div>
<?php } ?>