<?php $__env->startSection('content'); ?>
    <h3 class="page-title"><?php echo e($warehouse->name); ?>

        <?php echo $__env->make('admin.common.drop-down-menu', [
        'links' => [
            [
                'route' => 'admin.warehouses.edit', 
                'title' => trans('global.app_edit'), 
                'type' => 'edit',
                'icon' => '<i class="fa fa-pencil-square-o" style="margin-right: 15px;"></i>',
                'permission_key' => 'warehouse_edit',
            ], 
            [
                'route' => 'admin.warehouses.destroy', 
                'title' => trans('global.app_delete'), 
                'type' => 'delete',
                'icon' => '<i class="fa fa-trash-o" style="margin-right: 5px;color:#ff0000;padding-left: 20px;"></i>',
                'redirect_url' => url()->previous(),
                'permission_key' => 'warehouse_delete',
            ],
        ],
        'record' => $warehouse,
        ] , \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    </h3>

    <div class="panel panel-default">
        <?php if( 'yes' === $show_page_heading ): ?>
        <div class="panel-heading">
            <?php echo app('translator')->getFromJson('global.app_view'); ?>
        </div>
        <?php endif; ?>

        <?php
        $tabs = [
            'details_active' => 'active',
            'products_active' => '',
            'purchase_orders_active'=>'',

        ];
        
        if ( ! empty( $list ) ) {
            foreach ($tabs as $key => $value) {
                $tabs[ $key ] = '';
                if ( substr( $key, 0, -7) == $list ) {
                    $tabs[ $key ] = 'active';
                }
            }
        }
        ?>

        <div class="panel-body table-responsive">
            <!-- Nav tabs -->
<ul class="nav nav-tabs" role="tablist">
 
<li role="presentation" class="<?php echo e($tabs['details_active']); ?>"><a href="#details" aria-controls="details" role="tab" data-toggle="tab"><?php echo app('translator')->getFromJson('others.canvas.details'); ?></a></li>  
<?php if( isPluginActive('product') ): ?> 
<li role="presentation" class="<?php echo e($tabs['products_active']); ?>"><a href="<?php echo e(route('admin.warehouses.show', [ 'warehouse_id' => $warehouse->id, 'list' => 'products' ])); ?>" title= "<?php echo app('translator')->getFromJson('others.canvas.products'); ?>"><?php echo app('translator')->getFromJson('others.canvas.products'); ?></a></li>
<?php endif; ?>
<?php if( isPluginActive('purchase_order') ): ?>
<li role="presentation" class="<?php echo e($tabs['purchase_orders_active']); ?>"><a href="<?php echo e(route('admin.warehouses.show', [ 'warehouse_id' => $warehouse->id, 'list' => 'purchase_orders' ])); ?>"><?php echo app('translator')->getFromJson('global.purchase-orders.title'); ?></a></li>
<?php endif; ?>

</ul>

<!-- Tab panes -->
<div class="tab-content">

  <div role="tabpanel" class="tab-pane <?php echo e($tabs['details_active']); ?>" id="details">

         <div class="pull-right">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse_edit')): ?>
                <a href="<?php echo e(route('admin.warehouses.edit',[$warehouse->id])); ?>" class="btn btn-xs btn-info"><i class="fa fa-pencil-square-o"></i><?php echo app('translator')->getFromJson('global.app_edit'); ?></a>
            <?php endif; ?>
          </div>   

        <table class="table table-bordered table-striped">
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.warehouses.fields.name'); ?></th>
                            <td field-key='name'><?php echo e($warehouse->name); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.warehouses.fields.address'); ?></th>
                            <td field-key='address'><?php echo clean($warehouse->address); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.warehouses.fields.description'); ?></th>
                            <td field-key='description'><?php echo clean($warehouse->description); ?></td>
                        </tr>
                    </table>

    </div>    

    <?php if( 'active' === $tabs['products_active'] ): ?>
    <div role="tabpanel" class="tab-pane <?php echo e($tabs['products_active']); ?>" id="products">
        <?php echo $__env->make('admin.products.records-display', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    </div>
    <?php endif; ?>
    </div>
    <?php if( 'active' === $tabs['purchase_orders_active'] ): ?>
    <div role="tabpanel" class="tab-pane <?php echo e($tabs['purchase_orders_active']); ?>" id="purchase_orders">
        <?php echo $__env->make('admin.purchase_orders.records-display', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    </div>
    <?php endif; ?>
</div>

            <p>&nbsp;</p>

            <a href="<?php echo e(route('admin.warehouses.index')); ?>" class="btn btn-default"><?php echo app('translator')->getFromJson('global.app_back_to_list'); ?></a>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?> 
    <?php if( 'active' === $tabs['products_active'] ): ?>
        <?php echo $__env->make('admin.products.records-display-scripts', [ 'type' => 'ware_house', 'type_id' => $warehouse->id ], \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
     <?php endif; ?>
    <?php if( 'active' === $tabs['purchase_orders_active'] ): ?>
        <?php echo $__env->make('admin.purchase_orders.records-display-scripts', [ 'type' => 'warehouse', 'type_id' => $warehouse->id ], \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
     <?php endif; ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>