<?php $__env->startSection('content'); ?>

    <h3 class="page-title"><?php echo app('translator')->getFromJson('global.contact-notes.title'); ?></h3>
    <div class="panel panel-default">
        <div class="panel-heading">
            <?php echo e($contact_note->title); ?>

        </div>

        <div class="panel-body table-responsive">
             <?php if( Gate::allows('contact_note_edit') || Gate::allows('contact_note_delete')): ?>
            <div class="pull-right">   
                <?php if( Gate::allows('contact_note_edit') ): ?>
                    <a href="<?php echo e(route('admin.contact_notes.edit', $contact_note->id)); ?>" class="btn btn-xs btn-info"><i class="fa fa-pencil-square-o"></i><?php echo e(trans('global.app_edit')); ?></a>
                <?php endif; ?>
                <?php if( Gate::allows('contact_note_delete')): ?>
                    <?php echo $__env->make('admin.common.delete-link', ['record' => $contact_note, 'routeName' => 'admin.contact_notes.destroy', 'redirect_url' => url()->previous()] , \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                <?php endif; ?>
            </div>
            <?php endif; ?>
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-bordered table-striped">
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.contact-notes.fields.title'); ?></th>
                            <td field-key='title'><?php echo e($contact_note->title); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.contact-notes.fields.contact'); ?></th>
                            <td field-key='contact'><?php echo e($contact_note->contact->name ?? ''); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.contact-notes.fields.notes'); ?></th>
                            <td field-key='notes'style="padding: 0px;"><?php echo clean($contact_note->notes); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.contact-notes.fields.attachment'); ?></th>
                            <td field-key='attachment'> <?php $__currentLoopData = $contact_note->getMedia('attachment'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $media): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <p class="form-group">
                                    <a href="<?php echo e(route('admin.home.media-download', $media->id)); ?>" ><?php echo e($media->name); ?> (<?php echo e($media->size); ?> KB)</a>
                                </p>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></td>
                        </tr>
                    </table>
                </div>
            </div>

            <p>&nbsp;</p>

            <a href="<?php echo e(route('admin.contact_notes.index')); ?>" class="btn btn-default"><?php echo app('translator')->getFromJson('global.app_back_to_list'); ?></a>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    ##parent-placeholder-b6e13ad53d8ec41b034c49f131c64e99cf25207a##
    
    <?php echo $__env->make('admin.common.standard-ckeditor', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>