<?php $request = app('Illuminate\Http\Request'); ?>


<?php $__env->startSection('content'); ?>
    <h3 class="page-title"><?php echo app('translator')->getFromJson('orders::global.orders.title'); ?></h3>
    <p>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('order_create')): ?>
        <a href="<?php echo e(route('admin.orders.create')); ?>" class="btn btn-success"><i class="fa fa-plus"></i>&nbsp;<?php echo app('translator')->getFromJson('global.app_add_new'); ?></a>
    <?php endif; ?>

    <?php echo $__env->make('orders::admin.orders.canvas.canvas', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    
        
    </p>

    <?php echo $__env->make('orders::admin.orders.filters', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <p>
        <ul class="list-inline">
            <li><a href="<?php echo e(route('admin.orders.index')); ?>" style="<?php echo e(request('show_deleted') == 1 ? '' : 'font-weight: 700'); ?>"><?php echo app('translator')->getFromJson('global.app_all'); ?>
                <span class="badge"> 
            <?php if( isCustomer() ): ?>
                <?php echo e(\Modules\Orders\Entities\Order::where( 'customer_id', '=', getContactId())->count()); ?>

            <?php else: ?>
                <?php echo e(\Modules\Orders\Entities\Order::count()); ?>

            <?php endif; ?>
        </span>
            </a></li>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('order_delete')): ?>
            <?php if( ! isCustomer() ): ?>
             | <li><a href="<?php echo e(route('admin.orders.index')); ?>?show_deleted=1" style="<?php echo e(request('show_deleted') == 1 ? 'font-weight: 700' : ''); ?>">
                 
                    <?php echo app('translator')->getFromJson('global.app_trash'); ?>
                    <span class="badge">
                        <?php echo e(\Modules\Orders\Entities\Order::onlyTrashed()->count()); ?>

                </span> 
                </a></li>
            <?php endif; ?>
            <?php endif; ?>
        </ul>
    </p>
    

    <div class="panel panel-default">
        <div class="panel-heading">
            <?php echo app('translator')->getFromJson('global.app_list'); ?>
        </div>

        <div class="panel-body table-responsive">
            <table class="table table-bordered table-striped ajaxTable <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('order_delete_multi')): ?> <?php if( request('show_deleted') != 1 ): ?> dt-select <?php endif; ?> <?php endif; ?>">
                <thead>
                    <tr>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('order_delete_multi')): ?>
                            <?php if( request('show_deleted') != 1 ): ?><th style="text-align:center;"><input type="checkbox" id="select-all" /></th><?php endif; ?>
                        <?php endif; ?>
                        <th><?php echo app('translator')->getFromJson('orders::global.orders.fields.id'); ?></th>
                        <th><?php echo app('translator')->getFromJson('orders::global.orders.fields.customer'); ?></th>
                        <th><?php echo app('translator')->getFromJson('orders::global.orders.fields.status'); ?></th>
                        <th><?php echo app('translator')->getFromJson('orders::global.orders.fields.price'); ?></th>
                        <th><?php echo app('translator')->getFromJson('orders::global.orders.fields.billing-cycle'); ?></th>
                        <?php if( request('show_deleted') == 1 ): ?>
                        <th>&nbsp;</th>
                        <?php else: ?>
                        <th>&nbsp;</th>
                        <?php endif; ?>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?> 
    <script>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('order_delete_multi')): ?>
            <?php if( request('show_deleted') != 1 ): ?> window.route_mass_crud_entries_destroy = '<?php echo e(route('admin.orders.mass_destroy')); ?>'; <?php endif; ?>
        <?php endif; ?>
        $(document).ready(function () {
            window.dtDefaultOptionsNew.ajax.url = '<?php echo route('admin.orders.index'); ?>?show_deleted=<?php echo e(request('show_deleted')); ?>';
            window.dtDefaultOptionsNew.columns = [<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('order_delete_multi')): ?>
                <?php if( request('show_deleted') != 1 ): ?>
                    {data: 'massDelete', name: 'id', searchable: false, sortable: false},
                <?php endif; ?>
                <?php endif; ?>
                {data: 'id', name: 'id'},
                {data: 'customer.first_name', name: 'customer.first_name'},
                {data: 'status', name: 'status'},
                {data: 'price', name: 'price'},
                {data: 'billing_cycle.title', name: 'billing_cycle.title'},
                
                {data: 'actions', name: 'actions', searchable: false, sortable: false}
            ];
            processAjaxTablesNew();
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>