<?php $request = app('Illuminate\Http\Request'); ?>


<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('proposals::admin.proposals.invoice.invoice-menu', ['invoice' => $proposal], \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    
    <h3 class="page-title"><?php echo app('translator')->getFromJson('global.proposals-notes.title'); ?></h3>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposals_note_create')): ?>
    <p>
        <a href="<?php echo e(route('admin.proposals_notes.create', $proposal->id)); ?>" class="btn btn-success"><?php echo app('translator')->getFromJson('global.app_add_new'); ?></a>
        
    </p>
    <?php endif; ?>

    <p>
        <ul class="list-inline">
            <?php
             $count = Modules\Proposals\Entities\ProposalsNote::where('proposal_id', '=',$proposal->id )->count();
            ?>
            <li><a href="<?php echo e(route('admin.proposals_notes.index', $proposal->id)); ?>" style="<?php echo e(request('show_deleted') == 1 ? '' : 'font-weight: 700'); ?>"><?php echo app('translator')->getFromJson('global.app_all'); ?><span class="badge"><?php echo e($count); ?></span></a></li><?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposals_note_delete')): ?> |
                <?php
                 $trash_count = Modules\Proposals\Entities\ProposalsNote::where('proposal_id', '=',$proposal->id )->onlyTrashed()->count();
                ?> 
            <li><a href="<?php echo e(route('admin.proposals_notes.index', $proposal->id)); ?>?show_deleted=1" style="<?php echo e(request('show_deleted') == 1 ? 'font-weight: 700' : ''); ?>"><?php echo app('translator')->getFromJson('global.app_trash'); ?><span class="badge"><?php echo e($trash_count); ?></span></a></li>
            <?php endif; ?>
        </ul>
    </p>
    

    <div class="panel panel-default">
        <div class="panel-heading">
            <?php echo app('translator')->getFromJson('global.app_list'); ?>
        </div>

        <div class="panel-body table-responsive">
            <table class="table table-bordered table-striped ajaxTable <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposals_note_delete')): ?> <?php if( request('show_deleted') != 1 ): ?> dt-select <?php endif; ?> <?php endif; ?>">
                <thead>
                    <tr>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposals_note_delete')): ?>
                            <?php if( request('show_deleted') != 1 ): ?><th style="text-align:center;"><input type="checkbox" id="select-all" /></th><?php endif; ?>
                        <?php endif; ?>

                        <th><?php echo app('translator')->getFromJson('global.proposals-notes.fields.description'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.invoice-notes.fields.created-by'); ?></th>
                        <?php if( request('show_deleted') == 1 ): ?>
                        <th>&nbsp;</th>
                        <?php else: ?>
                        <th>&nbsp;</th>
                        <?php endif; ?>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?> 
    <script>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposals_note_delete')): ?>
            <?php if( request('show_deleted') != 1 ): ?> window.route_mass_crud_entries_destroy = '<?php echo e(route('admin.proposals_notes.mass_destroy', $proposal->id)); ?>'; <?php endif; ?>
        <?php endif; ?>
        $(document).ready(function () {
            window.dtDefaultOptionsNew.ajax.url = '<?php echo route('admin.proposals_notes.index', $proposal->id); ?>?show_deleted=<?php echo e(request('show_deleted')); ?>';
            window.dtDefaultOptionsNew.columns = [<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposals_note_delete')): ?>
                <?php if( request('show_deleted') != 1 ): ?>
                    {data: 'massDelete', name: 'id', searchable: false, sortable: false},
                <?php endif; ?>
                <?php endif; ?>{data: 'description', name: 'description'},
                {data: 'created_by.name', name: 'created_by.name'},
                
                {data: 'actions', name: 'actions', searchable: false, sortable: false}
            ];
            processAjaxTablesNew();
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>