<?php $request = app('Illuminate\Http\Request'); ?>


<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('quotes::admin.quotes.invoice.invoice-menu', ['invoice' => $quote], \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <h3 class="page-title"><?php echo app('translator')->getFromJson('global.quote-tasks.title'); ?></h3>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_task_create')): ?>
    <p>
        <a href="<?php echo e(route('admin.quote_tasks.create', $quote->id)); ?>" class="btn btn-success"><?php echo app('translator')->getFromJson('global.app_add_new'); ?></a>
        
        <?php if(!is_null(Auth::getUser()->role_id) && config('global.can_see_all_records_role_id') == Auth::getUser()->role_id): ?>
            <?php if(Session::get('QuoteTask.filter', 'all') == 'my'): ?>
                <a href="?filter=all" class="btn btn-default">Show all records</a>
            <?php else: ?>
                <a href="?filter=my" class="btn btn-default">Filter my records</a>
            <?php endif; ?>
        <?php endif; ?>
    </p>
    <?php endif; ?>

    <p>
        <ul class="list-inline">
              <?php
                    $count = Modules\Quotes\Entities\QuoteTask::where('quote_id', '=',$quote->id )->count();
                    ?>
            <li><a href="<?php echo e(route('admin.quote_tasks.index', $quote->id)); ?>" style="<?php echo e(request('show_deleted') == 1 ? '' : 'font-weight: 700'); ?>"><?php echo app('translator')->getFromJson('global.app_all'); ?><span class="badge"><?php echo e($count); ?></span></a></li>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_task_delete')): ?> |
             <?php
                    $trash_count = Modules\Quotes\Entities\QuoteTask::where('quote_id', '=',$quote->id )->onlyTrashed()->count();
                    ?> 
            <li><a href="<?php echo e(route('admin.quote_tasks.index', $quote->id)); ?>?show_deleted=1" style="<?php echo e(request('show_deleted') == 1 ? 'font-weight: 700' : ''); ?>"><?php echo app('translator')->getFromJson('global.app_trash'); ?>
            <span class="badge"><?php echo e($trash_count); ?></span></a></li>
            <?php endif; ?>
        </ul>
    </p>
    

    <div class="panel panel-default">
        <div class="panel-heading">
            <?php echo app('translator')->getFromJson('global.app_list'); ?>
        </div>

        <div class="panel-body table-responsive">
            <table class="table table-bordered table-striped ajaxTable <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_task_delete_multi')): ?> <?php if( request('show_deleted') != 1 ): ?> dt-select <?php endif; ?> <?php endif; ?>">
                <thead>
                    <tr>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_task_delete_multi')): ?>
                            <?php if( request('show_deleted') != 1 ): ?><th style="text-align:center;"><input type="checkbox" id="select-all" /></th><?php endif; ?>
                        <?php endif; ?>

                        <th><?php echo app('translator')->getFromJson('global.quote-tasks.fields.name'); ?></th>
                       
                        <th><?php echo app('translator')->getFromJson('global.quote-tasks.fields.startdate'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.quote-tasks.fields.duedate'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.quote-tasks.fields.status'); ?></th>
                       
                        <?php if( request('show_deleted') == 1 ): ?>
                        <th>&nbsp;</th>
                        <?php else: ?>
                        <th>&nbsp;</th>
                        <?php endif; ?>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?> 
    <script>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_task_delete_multi')): ?>
            <?php if( request('show_deleted') != 1 ): ?> window.route_mass_crud_entries_destroy = '<?php echo e(route('admin.quote_tasks.mass_destroy')); ?>'; <?php endif; ?>
        <?php endif; ?>
        $(document).ready(function () {
            window.dtDefaultOptionsNew.ajax.url = '<?php echo route('admin.quote_tasks.index', $quote->id); ?>?show_deleted=<?php echo e(request('show_deleted')); ?>';
            window.dtDefaultOptionsNew.columns = [<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_task_delete_multi')): ?>
                <?php if( request('show_deleted') != 1 ): ?>
                    {data: 'massDelete', name: 'id', searchable: false, sortable: false},
                <?php endif; ?>
                <?php endif; ?>{data: 'name', name: 'name'},
           
                {data: 'startdate', name: 'startdate'},
                {data: 'duedate', name: 'duedate'},
                {data: 'status_id', name: 'status_id'},
               
                {data: 'actions', name: 'actions', searchable: false, sortable: false}
            ];
            processAjaxTablesNew();
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>