<h3 class="page-title"><?php echo app('translator')->getFromJson('global.recurring-periods.title'); ?></h3>
<?php echo Form::open(['method' => 'POST', 'route' => ['admin.recurring_periods.store'], 'id' => 'frmRecurringPeriods']); ?>


<div class="panel panel-default">
    <div class="panel-heading">
        <?php echo app('translator')->getFromJson('global.app_create'); ?>
    </div>

    <div class="alert message_bag" style="display:none">
        <ul></ul>
    </div>
    
    <div class="panel-body">
        <?php echo $__env->make('recurringperiods::admin.recurring_periods.form-fields', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>            
    </div>
</div>
<?php
if ( empty( $is_ajax ) ) {
  $is_ajax = 'no';
}
?>
<input type="hidden" name="is_ajax" value="<?php echo e($is_ajax); ?>">
<?php
if ( empty( $selectedid ) ) {
  $selectedid = 'recurring_period_id';
}
?>
<input type="hidden" name="selectedid" value="<?php echo e($selectedid); ?>">
<?php
if ( empty( $fetchaddress ) ) {
  $fetchaddress = 'no';
}
?>
<input type="hidden" name="fetchaddress" value="<?php echo e($fetchaddress); ?>">
<?php echo Form::submit(trans('global.app_save'), ['class' => 'btn btn-danger saveButtonRecurringPeriods']); ?>

<?php echo Form::close(); ?>


<?php if( ! empty( $is_ajax ) && 'yes' === $is_ajax ): ?>
<script type="text/javascript">
  $(".saveButtonRecurringPeriods").click(function(e){
            e.preventDefault();

            $.ajax({
                url: "<?php echo e(route('admin.recurring_periods.store')); ?>",
                type:'POST',
                data: $( '#frmRecurringPeriods' ).serializeArray(),
                success: function(data) {
                    if($.isEmptyObject(data.error)){
                        notifyMe('success', data.success);
                        $('#loadingModal').modal('hide');

                        var value = data.record.id;
                        var title = data.record.title;
                        $('#' + data.record.selectedid).append('<option value="'+value+'" selected="selected">'+title+'</option>');
                        if ( data.record.fetchaddress == 'yes' ) {
                          $('#' + data.record.selectedid).trigger('change');
                        }

                    }else{
                        printErrorMsg(data.error);
                    }
                }
            });
  });

  function printErrorMsg (msg) {
      $(".message_bag").find("ul").html('');
      $(".message_bag").css('display','block');
      $(".message_bag").addClass('alert-danger');
      $.each( msg, function( key, value ) {
          $(".message_bag").find("ul").append('<li>'+value+'</li>');
      });
  }
</script>
<?php endif; ?>