<?php $__env->startSection('content'); ?>
    <h3 class="page-title"><?php echo app('translator')->getFromJson('global.income.title'); ?></h3>
    <?php echo Form::open(['method' => 'POST', 'route' => ['admin.incomes.store'], 'files' => true,'class'=>'formvalidation']); ?>


    <div class="panel panel-default">
        <div class="panel-heading">
            <?php echo app('translator')->getFromJson('global.app_create'); ?>
        </div>
        
        <div class="panel-body">
            <div class="row">
                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                <div class="form-group">
                    <?php echo Form::label('account_id', trans('global.income.fields.account').'*', ['class' => 'control-label']); ?>

                    <?php if( Gate::allows('account_create')): ?>
                        <?php if( 'button' === $addnew_type ): ?>
                        &nbsp;<button type="button" class="btn btn-danger modalForm" data-action="createaccount" data-selectedid="account_id" data-redirect="<?php echo e(route('admin.incomes.create')); ?>" data-toggle="tooltip" data-placement="bottom" data-original-title="<?php echo e(trans('global.add_new_title', ['title' => strtolower( trans('global.income.fields.account') )])); ?>"><?php echo e(trans('global.app_add_new')); ?></button>
                        <?php else: ?>        
                        &nbsp;<a class="modalForm" data-action="createaccount" data-selectedid="account_id" data-toggle="tooltip" data-placement="bottom" data-original-title="<?php echo e(trans('global.add_new_title', ['title' => strtolower( trans('global.income.fields.account') )])); ?>"><i class="fa fa-plus-square"></i></a>
                        <?php endif; ?>
                    <?php endif; ?>
                    <?php echo Form::select('account_id', $accounts, old('account_id'), ['class' => 'form-control select2', 'required' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('account_id')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('account_id')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
            
            
                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                <div class="form-group">
                    <?php echo Form::label('income_category_id', trans('global.income.fields.income-category').'*', ['class' => 'control-label']); ?>

                    <?php if( Gate::allows('income_create')): ?>
                        <?php if( 'button' === $addnew_type ): ?>
                        &nbsp;<button type="button" class="btn btn-danger modalForm" data-action="createincomecategory" data-selectedid="income_category_id" data-redirect="<?php echo e(route('admin.incomes.create')); ?>" data-toggle="tooltip" data-placement="bottom" data-original-title="<?php echo e(trans('global.add_new_title', ['title' => strtolower( trans('global.income.fields.income-category') )])); ?>"><?php echo e(trans('global.app_add_new')); ?></button>
                        <?php else: ?>        
                        &nbsp;<a class="modalForm" data-action="createincomecategory" data-selectedid="income_category_id" data-toggle="tooltip" data-placement="bottom" data-original-title="<?php echo e(trans('global.add_new_title', ['title' => strtolower( trans('global.income.fields.income-category') )])); ?>"><i class="fa fa-plus-square"></i></a>
                        <?php endif; ?>
                    <?php endif; ?>

                    <?php echo Form::select('income_category_id', $income_categories, old('income_category_id'), ['class' => 'form-control select2', 'required' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('income_category_id')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('income_category_id')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
            
                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                <div class="form-group">
                    
                    <?php echo Form::label('entry_date', trans('global.income.fields.entry-date').'*', ['class' => 'control-label form-label']); ?>

                    <div class="form-line">
                    <?php echo Form::text('entry_date', old('entry_date'), ['class' => 'form-control date', 'placeholder' => 'Entry date', 'required' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('entry_date')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('entry_date')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
                </div>
            
                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                <div class="form-group">
                    
                    <?php echo Form::label('amount', trans('global.income.fields.amount').'*', ['class' => 'control-label form-label']); ?>

                    <div class="form-line">
                    <?php echo Form::number('amount', old('amount'), ['class' => 'form-control amount','min'=>'0','step'=>'.01', 'placeholder' => 'Amount', 'required' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('amount')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('amount')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
                </div>
            
                <div class="col-xs-12">
                <div class="form-group">
                    <?php echo Form::label('description', trans('global.income.fields.description').'', ['class' => 'control-label']); ?>

                    <?php echo Form::textarea('description', old('description'), ['class' => 'form-control editor', 'placeholder' => 'Description']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('description')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('description')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
            
          
            
                <div class="col-xs-4">
                <div class="form-group">
                    <?php echo Form::label('payer_id', trans('global.income.fields.payer').'*', ['class' => 'control-label']); ?>

                    <?php if( Gate::allows('contact_create')): ?>
                        <?php if( 'button' === $addnew_type ): ?>
                        &nbsp;<button type="button" class="btn btn-danger modalForm" data-action="createcustomer" data-selectedid="payer_id" data-redirect="<?php echo e(route('admin.incomes.create')); ?>" data-toggle="tooltip" data-placement="bottom" data-original-title="<?php echo e(trans('global.add_new_title', ['title' => strtolower( trans('global.income.fields.payer') )])); ?>"><?php echo e(trans('global.app_add_new')); ?></button>
                        <?php else: ?>        
                        &nbsp;<a class="modalForm" data-action="createcustomer" data-selectedid="payer_id" data-toggle="tooltip" data-placement="bottom" data-original-title="<?php echo e(trans('global.add_new_title', ['title' => strtolower( trans('global.income.fields.payer') )])); ?>"><i class="fa fa-plus-square"></i></a>
                        <?php endif; ?>
                    <?php endif; ?>
                    <?php echo Form::select('payer_id', $payers, old('payer_id'), ['class' => 'form-control select2', 'required' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('payer_id')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('payer_id')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
            
                <div class="col-xs-4">
                <div class="form-group">
                    <?php echo Form::label('pay_method_id', trans('global.income.fields.pay-method').'*', ['class' => 'control-label']); ?>

                    <?php echo Form::select('pay_method_id', $pay_methods, old('pay_method_id'), ['class' => 'form-control select2', 'required' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('pay_method_id')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('pay_method_id')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
           
                <div class="col-xs-4">
                <div class="form-group">
                    
                    <?php echo Form::label('ref_no', trans('global.income.fields.ref-no').'', ['class' => 'control-label form-label']); ?>

                    <div class="form-line">
                    <?php echo Form::text('ref_no', old('ref_no'), ['class' => 'form-control', 'placeholder' => 'Reference no / Transaction id']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('ref_no')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('ref_no')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
                </div>

                      <div class="col-xs-6">
                <div class="form-group">
                    <?php echo Form::label('description_file', trans('global.income.fields.description-file').'', ['class' => 'control-label']); ?>

                    <?php echo Form::file('description_file[]', [
                        'multiple',
                        'class' => 'form-control file-upload',
                        'data-url' => route('admin.media.upload'),
                        'data-bucket' => 'description_file',
                        'data-filekey' => 'description_file',
                        'data-accept' => FILE_TYPES_GENERAL,
                        ]); ?>

                    <p class="help-block"><?php echo e(trans('others.global_file_types_general')); ?></p>
                    <div class="photo-block">
                        <div class="form-group">
                        <div class="progress-bar">&nbsp;</div>
                    </div>
                        <div class="files-list"></div>
                    </div>
                    <?php if($errors->has('description_file')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('description_file')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>

            </div>
            
        </div>
    </div>

    <?php echo Form::submit(trans('global.app_save'), ['class' => 'btn btn-danger wave-effect']); ?>

    <?php echo Form::close(); ?>


    <?php echo $__env->make('admin.common.modal-loading-submit', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    ##parent-placeholder-b6e13ad53d8ec41b034c49f131c64e99cf25207a##
    
    <?php echo $__env->make('admin.common.standard-ckeditor', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <script src="<?php echo e(url('adminlte/plugins/datetimepicker/moment-with-locales.min.js')); ?>"></script>
    <script src="<?php echo e(url('adminlte/plugins/datetimepicker/bootstrap-datetimepicker.min.js')); ?>"></script>
    <script>
        $(function(){
            moment.updateLocale('<?php echo e(App::getLocale()); ?>', {
                week: { dow: 1 } // Monday is the first day of the week
            });
            
            $('.date').datetimepicker({
                format: "<?php echo e(config('app.date_format_moment')); ?>",
                locale: "<?php echo e(App::getLocale()); ?>",
            });
            
        });
    </script>
            
    <script src="<?php echo e(asset('adminlte/plugins/fileUpload/js/jquery.iframe-transport.js')); ?>"></script>
    <script src="<?php echo e(asset('adminlte/plugins/fileUpload/js/jquery.fileupload.js')); ?>"></script>
    <script>
        $(function () {
            $('.file-upload').each(function () {
                var $this = $(this);
                var $parent = $(this).parent();
                

                $(this).fileupload({
                    dataType: 'json',
                    formData: {
                        model_name: 'Income',
                        bucket: $this.data('bucket'),
                        file_key: $this.data('filekey'),
                        accept: $this.data('accept'),
                        _token: '<?php echo e(csrf_token()); ?>'
                    },
                    add: function (e, data) {
                        data.submit();
                    },
                    done: function (e, data) {
                        $.each(data.result.files, function (index, file) {
                            
                            if ( file.size > 0 ) {
                                var $line = $($('<p/>', {class: "form-group"}).html(file.name + ' (' + file.size + ' bytes)').appendTo($parent.find('.files-list')));
                                $line.append('<a href="#" class="btn btn-xs btn-danger remove-file">Remove</a>');
                                $line.append('<input type="hidden" name="' + $this.data('bucket') + '_id[]" value="' + file.id + '"/>');
                                if ($parent.find('.' + $this.data('bucket') + '-ids').val() != '') {
                                    $parent.find('.' + $this.data('bucket') + '-ids').val($parent.find('.' + $this.data('bucket') + '-ids').val() + ',');
                                }
                                $parent.find('.' + $this.data('bucket') + '-ids').val($parent.find('.' + $this.data('bucket') + '-ids').val() + file.id);
                            } else {
                                var $line = $($('<p/>', {class: "form-group"}).html(file.name).appendTo($parent.find('.files-list')));
                                $line.append('<a href="#" class="btn btn-xs btn-danger remove-file">Not accepted</a>');
                            }
                        });
                        $parent.find('.progress-bar').hide().css(
                            'width',
                            '0%'
                        );
                    }
                }).on('fileuploadprogressall', function (e, data) {
                    var progress = parseInt(data.loaded / data.total * 100, 10);
                    $parent.find('.progress-bar').show().css(
                        'width',
                        progress + '%'
                    );
                });
            });
            $(document).on('click', '.remove-file', function () {
                var $parent = $(this).parent();
                $parent.remove();
                return false;
            });
        });
    </script>
    <?php echo $__env->make('admin.common.modal-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>