<?php $__env->startSection('content'); ?>
    <h3 class="page-title"> <?php echo e(digiCurrency($income->amount,$income->currency_id)); ?> - <?php echo e(' ('.$income->entry_date.')'); ?>

        
    </h3>

    <div class="panel panel-default">
        <?php if( 'yes' === $show_page_heading ): ?>
            <div class="panel-heading">
                <?php echo app('translator')->getFromJson('global.app_view'); ?>
            </div>
        <?php endif; ?>

        <div class="panel-body table-responsive">
            <?php if( Gate::allows('income_edit') || Gate::allows('income_delete')): ?>
            <div class="pull-right">   
                <?php if( Gate::allows('income_edit') ): ?>
                    <a href="<?php echo e(route('admin.incomes.edit', $income->id)); ?>" class="btn btn-xs btn-info"><i class="fa fa-pencil-square-o"></i><?php echo e(trans('global.app_edit')); ?></a>
                <?php endif; ?>
                <?php if( Gate::allows('income_delete')): ?>
                    <?php echo $__env->make('admin.common.delete-link', ['record' => $income, 'routeName' => 'admin.incomes.destroy', 'redirect_url' => url()->previous()] , \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                <?php endif; ?>
            </div>
            <?php endif; ?>
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-bordered table-striped">
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.income.fields.account'); ?></th>
                            <td field-key='account'><?php echo e($income->account->name ?? ''); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.income.fields.income-category'); ?></th>
                            <td field-key='income_category'><?php echo e($income->income_category->name ?? ''); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.income.fields.entry-date'); ?></th>
                            <td field-key='entry_date'><?php echo e($income->entry_date); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.income.fields.amount'); ?></th>
                            <td field-key='amount'><?php echo e(digiCurrency($income->amount,$income->currency_id)); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.income.fields.description'); ?></th>
                            <td field-key='description'><?php echo clean($income->description); ?></td>
                        </tr>
                       
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.income.fields.description-file'); ?></th>
                            <td field-key='description_file's> <?php $__currentLoopData = $income->getMedia('description_file'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $media): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <p class="form-group">
                                    <a href="<?php echo e(route('admin.home.media-download', $media->id)); ?>" ><?php echo e($media->name); ?> (<?php echo e($media->size); ?> KB)</a>
                                </p>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.income.fields.payer'); ?></th>
                            <td field-key='payer'><?php echo e($income->payer->first_name ?? $income->payer_name); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.income.fields.pay-method'); ?></th>
                            <td field-key='pay_method'><?php echo e($income->pay_method->name ?? ''); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.income.fields.ref-no'); ?></th>
                            <td field-key='ref_no'><?php echo e($income->ref_no); ?></td>
                        </tr>
                    </table>
                </div>
            </div>

            <p>&nbsp;</p>

            <a href="<?php echo e(route('admin.incomes.index')); ?>" class="btn btn-default"><?php echo app('translator')->getFromJson('global.app_back_to_list'); ?></a>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    ##parent-placeholder-b6e13ad53d8ec41b034c49f131c64e99cf25207a##
    <?php echo $__env->make('admin.common.standard-ckeditor', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>


    <script src="<?php echo e(url('adminlte/plugins/datetimepicker/moment-with-locales.min.js')); ?>"></script>
    <script src="<?php echo e(url('adminlte/plugins/datetimepicker/bootstrap-datetimepicker.min.js')); ?>"></script>
    <script>
        $(function(){
            moment.updateLocale('<?php echo e(App::getLocale()); ?>', {
                week: { dow: 1 } // Monday is the first day of the week
            });
            
            $('.date').datetimepicker({
                format: "<?php echo e(config('app.date_format_moment')); ?>",
                locale: "<?php echo e(App::getLocale()); ?>",
            });
            
        });
    </script>
            
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>