<?php $__env->startSection('content'); ?>
    <h3 class="page-title"><?php echo app('translator')->getFromJson('global.internal-notifications.title'); ?></h3>
    <?php echo Form::open(['method' => 'POST', 'route' => ['admin.internal_notifications.store'],'class'=>'formvalidation']); ?>


    <div class="panel panel-default">
        <div class="panel-heading">
            <?php echo app('translator')->getFromJson('global.app_create'); ?>
        </div>
        
        <div class="panel-body">
            <div class="row">
                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                <div class="form-group">
                    <?php echo Form::label('text', trans('global.internal-notifications.fields.text').'*', ['class' => 'control-label form-label']); ?>

                    <div class="form-line">
                    <?php echo Form::text('text', old('text'), ['class' => 'form-control', 'placeholder' => '', 'required' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('text')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('text')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
                </div>
        
                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                <div class="form-group">
                    <?php echo Form::label('link', trans('global.internal-notifications.fields.link').'', ['class' => 'control-label form-label']); ?>

                    <div class="form-line">
                    <?php echo Form::text('link', old('link'), ['class' => 'form-control', 'placeholder' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('link')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('link')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
                </div>
            
                <div class="col-xs-6">
                <div class="form-group">
                    <?php echo Form::label('users', trans('global.internal-notifications.fields.users').'*', ['class' => 'control-label']); ?>

                    <button type="button" class="btn btn-primary btn-xs" id="selectbtn-users">
                        <?php echo e(trans('global.app_select_all')); ?>

                    </button>
                    <button type="button" class="btn btn-primary btn-xs" id="deselectbtn-users">
                        <?php echo e(trans('global.app_deselect_all')); ?>

                    </button>
                    <?php echo Form::select('users[]', $users, old('users'), ['class' => 'form-control select2', 'multiple' => 'multiple', 'id' => 'selectall-users' , 'required' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('users')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('users')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
            </div>
            
        </div>
    </div>

    <?php echo Form::submit(trans('global.app_save'), ['class' => 'btn btn-danger wave-effect']); ?>

    <?php echo Form::close(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    ##parent-placeholder-b6e13ad53d8ec41b034c49f131c64e99cf25207a##

    <script>
        $("#selectbtn-users").click(function(){
            $("#selectall-users > option").prop("selected","selected");
            $("#selectall-users").trigger("change");
        });
        $("#deselectbtn-users").click(function(){
            $("#selectall-users > option").prop("selected","");
            $("#selectall-users").trigger("change");
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>