<?php
namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class StoreTaxesRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [
            'name' => 'required|unique:taxes,name,'.$this->route('tax'),
            'rate' => 'numeric|required',
        ];
        if ( 'percent' === request()->rate_type ) {
            $rules['rate'] = 'required|numeric|max:100';
        }
        return $rules;
    }
}
