<?php

$factory->define(App\ClientProject::class, function (Faker\Generator $faker) {
    
    $data = [
        'title' => $faker->word,
        'budget' => $faker->randomFloat(2,1),
        'phase' => '"'.$faker->$domainWord.'"',
        'start_date' => $faker->dateTimeBetween('now', '+16 years'),
        'due_date' => $faker->dateTimeBetween('now', '+16 years'),
        'description' => $faker->text(200),
        'demo_url' =>$faker->url,
        'client_id' =>function () {
                    return App\Contact::inRandomOrder()->whereHas("contact_type",
                    function ($query) {
                    $query->where('id', CONTACT_CLIENT_TYPE);
                    })->first()->id;
        },
        'billing_type_id' => function () {
            return \App\RecurringPeriod::inRandomOrder()->first()->id;
        },
        'status_id' => function () {
            return \App\ProjectStatus::inRandomOrder()->first()->id;
        },
        'date_finished' => dateTimeBetween('now', '+16 years'),
        'progress' => $faker->randomDigit,
        'project_rate_per_hour' => $faker->randomFloat(2,1,24).'hrs',
        'estimated_hours' =>$faker->randomFloat(2,1,24).'hrs',
        'hourly_rate' => $faker->randomFloat(2,1,24).'hrs',
        'currency_id' =>function () {
            return App\Currency::inRandomOrder()->first()->id;
        },   
    ];
    return $data;
});
