<?php

$factory->define(App\Income::class, function (Faker\Generator $faker) {
    $data = [
        'slug' => $faker->slug,
        'entry_date' => $faker->date('Y-m-d'),
        'amount' => $faker->randomFloat(2, 1),
        'original_amount' => $faker->randomFloat(2, 1),
        'original_currency_id' => function () {
            return App\Currency::where('status', '=', 'Active')->inRandomOrder()->first()->id;
        },
        'income_category_id' => function () {
                  return App\IncomeCategory::inRandomOrder()->first()->id;
        },
        'description' => $faker->text(200),
        'ref_no' =>$faker->slug(3),
        'account_id' => function () {
            return App\Account::inRandomOrder()->first()->id;
        },
        'payer_id' => function () {
                    return App\Contact::inRandomOrder()->whereHas("contact_type",
                    function ($query) {
                    $query->where('id', CUSTOMERS_TYPE);
                    })->first()->id;
        },
        'pay_method_id' =>function () {
            return App\PaymentGateway::inRandomOrder()->first()->id;
        },
    ];
    return $data;
});