<?php

$factory->define(\Modules\Orders\Entities\Order::class, function (Faker\Generator $faker) {
    
    $data = [
        'price' => $faker->randomFloat(2,1),
        'customer_id' => function () {
                    return App\Contact::inRandomOrder()->whereHas("contact_type",
                    function ($query) {
                    $query->where('id', CUSTOMERS_TYPE);
                    })->first()->id;
        },
        'currency_id' => function () {
            return App\Currency::where('status', '=', 'Active')->inRandomOrder()->first()->id;
        },
        'billing_cycle_id' => function () {
            return \App\RecurringPeriod::inRandomOrder()->first()->id;
        },
        'products' => $faker->text(200),
        'slug' => $faker->slug,
        'total_cycles' =>$faker->randomDigit,
        'cycles' => $faker->randomDigit,
        
        'last_recurring_date' => $faker->date('Y-m-d'),
        'invoice_date' => $faker->date('Y-m-d'),
        'invoice_due_date' =>$faker->date('Y-m-d'),
        'delivery_address' => $faker->address,
        
    ];
    return $data;
});
