<?php

$factory->define(App\PurchaseOrder::class, function (Faker\Generator $faker) {
    
    $data = [
        'subject' => $faker->word,
        'address' => $faker->address,
        'invoice_prefix' => $faker->iban('INV'),
        'show_quantity_as' => $faker->randomFloat(2,1),
        'invoice_no' => $faker->numberBetween(1,10000 ),
        'status' => $faker->randomElement(['Published', 'Draft']),
        'reference' => $faker->word,
        'order_date' => $faker->date('Y-m-d'),
        'order_due_date' =>$faker->date('Y-m-d', strtotime(date('Y-m-d') . "+20 days")),
        //'invoice_notes' =>$faker->text(200),
        'amount' => $faker->randomFloat(2,1),
        'customer_id' => function () {
                    return App\Contact::inRandomOrder()->whereHas("contact_type",
                    function ($query) {
                    $query->where('id', SUPPLIERS_TYPE);
                    })->first()->id;
        },
        'currency_id' => function () {
            return App\Currency::where('status', '=', 'Active')->inRandomOrder()->first()->id;
        },
        'tax_id' => function () {
                  return App\Tax::inRandomOrder()->first()->id;
        },
        'discount_id' => function () {
            return App\Discount::inRandomOrder()->first()->id;
        },
        //'products' => $faker->name,
        'slug' => $faker->slug,
        'delivery_address' => $faker->address,
        'admin_notes' => $faker->text(200),
        'sale_agent' => function () {
                    return App\Contact::inRandomOrder()->whereHas("contact_type",
                    function ($query) {
                    $query->where('id', CONTACT_SALE_AGENT);
                    })->first()->id;
        },
        'terms_conditions' => $faker->text(200),
        // 'project_id' => function () {
        //     return App\ClientProject::inRandomOrder()->first()->id;
        // },
        // 'quote_id' => function () {
        //     return \Modules\Quotes\Entities\Quote::inRandomOrder()->first()->id;
        // },
        // 'order_id' => function () {
        //     return \Modules\Orders\Entities\Order::inRandomOrder()->first()->id;
        // },
        // 'created_by_id' => function () {
        //     return App\User::inRandomOrder()->first()->id;
        // },
    ];
    return $data;
});
