<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class Create1556515888QuoteTasksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(! Schema::hasTable('quote_tasks')) {
            Schema::create('quote_tasks', function (Blueprint $table) {
                $table->increments('id');
                $table->string('name')->nullable();
                $table->text('description')->nullable();
                $table->integer('priority')->nullable()->unsigned();
                $table->date('startdate')->nullable();
                $table->date('duedate')->nullable();
                $table->date('datefinished')->nullable();
                $table->integer('status')->nullable();
                $table->enum('recurring_type', array('day', 'week', 'month', 'year'))->nullable();
                $table->integer('recurring_value')->nullable()->unsigned();
                $table->integer('cycles')->nullable();
                $table->integer('total_cycles')->nullable()->unsigned();
                $table->date('last_recurring_date')->nullable();
                $table->enum('is_public', array('yes', 'no'))->nullable();
                $table->enum('billable', array('yes', 'no'))->nullable();
                $table->enum('billed', array('yes', 'no'))->nullable();
                $table->decimal('hourly_rate', 15, 2)->nullable();
                $table->integer('milestone')->nullable();
                $table->integer('kanban_order')->nullable();
                $table->integer('milestone_order')->nullable();
                $table->enum('visible_to_client', array('yes', 'no'))->nullable();
                $table->enum('deadline_notified', array('yes', 'no'))->nullable();
                
                $table->timestamps();
                $table->softDeletes();

                $table->index(['deleted_at']);
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('quote_tasks');
    }
}
