<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class Add5cc6918a06bceRelationshipsToQuotesReminderTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('quotes_reminders', function(Blueprint $table) {
            if (!Schema::hasColumn('quotes_reminders', 'quote_id')) {
                $table->integer('quote_id')->unsigned()->nullable();
                $table->foreign('quote_id', '298253_5cc691865346c')->references('id')->on('quotes')->onDelete('cascade');
                }
                if (!Schema::hasColumn('quotes_reminders', 'reminder_to_id')) {
                $table->integer('reminder_to_id')->unsigned()->nullable();
                $table->foreign('reminder_to_id', '298253_5cc6918677a05')->references('id')->on('contacts')->onDelete('cascade');
                }
                if (!Schema::hasColumn('quotes_reminders', 'created_by_id')) {
                $table->integer('created_by_id')->unsigned()->nullable();
                $table->foreign('created_by_id', '298253_5cc691869c9a9')->references('id')->on('users')->onDelete('cascade');
                }
                
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('quotes_reminders', function(Blueprint $table) {
            
        });
    }
}
