<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class Add5cc69ae12afd4RelationshipsToQuoteTaskTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('quote_tasks', function(Blueprint $table) {
            if (!Schema::hasColumn('quote_tasks', 'recurring_id')) {
                $table->integer('recurring_id')->unsigned()->nullable();
                $table->foreign('recurring_id', '298242_5cc68c34c3153')->references('id')->on('recurring_periods')->onDelete('cascade');
                }
                if (!Schema::hasColumn('quote_tasks', 'invoice_id')) {
                $table->integer('invoice_id')->unsigned()->nullable();
                $table->foreign('invoice_id', '298242_5cc68c34eed43')->references('id')->on('quotes')->onDelete('cascade');
                }
                if (!Schema::hasColumn('quote_tasks', 'created_by_id')) {
                $table->integer('created_by_id')->unsigned()->nullable();
                $table->foreign('created_by_id', '298242_5cc68c3527a57')->references('id')->on('users')->onDelete('cascade');
                }
                if (!Schema::hasColumn('quote_tasks', 'mile_stone_id')) {
                $table->integer('mile_stone_id')->unsigned()->nullable();
                $table->foreign('mile_stone_id', '298242_5cc68f948e526')->references('id')->on('mile_stones')->onDelete('cascade');
                }
                
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('quote_tasks', function(Blueprint $table) {
            
        });
    }
}
