<?php

use Illuminate\Database\Seeder;

class UserSeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $items = [            
            // Admin Role
            [
                'id' => DEFAULT_ADMIN_ID, 
                'name' => 'Admin',
                'first_name' => 'First',
                'last_name' => 'Admin',
                'email' => 'admin@admin.com', 
                'password' => '$2y$10$AfzEdLcBxq4MyYGMY5hdCOo6iUhv21Zz9ekwygGNFC7L8C0U8RaJi', // password
                'remember_token' => '', 
                'is_user' => 'yes',
            ],

            // Executive
            [
                'id' => DEFAULT_EXECUTIVE_ID, 
                'name' => 'Executive',
                'first_name' => 'Executive',
                'last_name' => '',
                'email' => 'sam@gmail.com', 
                'password' => '$2y$10$AfzEdLcBxq4MyYGMY5hdCOo6iUhv21Zz9ekwygGNFC7L8C0U8RaJi', // password
                'remember_token' => '', 
                'is_user' => 'yes',
            ],

            // Customer
            [
                'id' => DEFAULT_CUSTOMER_ID, 
                'name' => 'Customer',
                'first_name' => 'Customer',
                'last_name' => '',
                'email' => 'domenic@gmail.com', 
                'password' => '$2y$10$AfzEdLcBxq4MyYGMY5hdCOo6iUhv21Zz9ekwygGNFC7L8C0U8RaJi', // password
                'remember_token' => '', 
                'is_user' => 'yes',
            ],

            // Sale Agent
            [
                'id' => DEFAULT_SALEAGENT_ID, 
                'name' => 'Sale Agent',
                'first_name' => 'Sale',
                'last_name' => 'Agent',
                'email' => 'cieo@gmail.com', 
                'password' => '$2y$10$AfzEdLcBxq4MyYGMY5hdCOo6iUhv21Zz9ekwygGNFC7L8C0U8RaJi', // password
                'remember_token' => '', 
                'is_user' => 'yes',
            ],

            // Supplier
            [
                'id' => DEFAULT_SUPPLIER_ID, 
                'name' => 'Supplier',
                'first_name' => 'Supplier',
                'last_name' => '',
                'email' => 'brent@gmail.com', 
                'password' => '$2y$10$AfzEdLcBxq4MyYGMY5hdCOo6iUhv21Zz9ekwygGNFC7L8C0U8RaJi', // password
                'remember_token' => '', 
                'is_user' => 'yes',
            ],

            // Sales Manager
            [
                'id' => DEFAULT_SALEMANAGER_ID, 
                'name' => 'Sales Manager',
                'first_name' => 'Sales',
                'last_name' => 'Manager',
                'email' => 'lavinia@gmail.com', 
                'password' => '$2y$10$AfzEdLcBxq4MyYGMY5hdCOo6iUhv21Zz9ekwygGNFC7L8C0U8RaJi', // password
                'remember_token' => '', 
                'is_user' => 'yes',
            ],

            // Employee
            [
                'id' => DEFAULT_EMPLOYEE_ID, 
                'name' => 'Employee',
                'first_name' => 'Employee',
                'last_name' => '',
                'email' => 'himla@gmail.com', 
                'password' => '$2y$10$AfzEdLcBxq4MyYGMY5hdCOo6iUhv21Zz9ekwygGNFC7L8C0U8RaJi', // password
                'remember_token' => '', 
                'is_user' => 'yes',
            ],

            // Client
            [
                'id' => DEFAULT_CLIENT_ID, 
                'name' => 'Client',
                'first_name' => 'Client',
                'last_name' => '',
                'email' => 'merle@gmail.com', 
                'password' => '$2y$10$AfzEdLcBxq4MyYGMY5hdCOo6iUhv21Zz9ekwygGNFC7L8C0U8RaJi', // password
                'remember_token' => '', 
                'is_user' => 'yes',
            ],

            // Project Manager
            [
                'id' => DEFAULT_PROJECTMANAGER_ID, 
                'name' => 'Project Manager',
                'first_name' => 'Project',
                'last_name' => 'Manager',
                'email' => 'joanie@gmail.com', 
                'password' => '$2y$10$AfzEdLcBxq4MyYGMY5hdCOo6iUhv21Zz9ekwygGNFC7L8C0U8RaJi', // password
                'remember_token' => '', 
                'is_user' => 'yes',
            ],

            // Business Manager
            [
                'id' => DEFAULT_BUSINESSMANAGER_ID, 
                'name' => 'Business Manager',
                'first_name' => 'Business',
                'last_name' => 'Manager',
                'email' => 'robert@gmail.com', 
                'password' => '$2y$10$AfzEdLcBxq4MyYGMY5hdCOo6iUhv21Zz9ekwygGNFC7L8C0U8RaJi', // password
                'remember_token' => '', 
                'is_user' => 'yes',
            ],

            // Stock Manager
            [
                'id' => DEFAULT_STOCKMANAGER_ID, 
                'name' => 'Stock Manager',
                'first_name' => 'Stock',
                'last_name' => 'Manager',
                'email' => 'donald@example.com', 
                'password' => '$2y$10$AfzEdLcBxq4MyYGMY5hdCOo6iUhv21Zz9ekwygGNFC7L8C0U8RaJi', // password
                'remember_token' => '', 
                'is_user' => 'yes',
            ],

        ];
        foreach ($items as $item) {
            \App\Contact::create($item);
        }
    }
}
