<?php
$controllers = array(
    'ContactCompaniesController' => array(
        'main_title' => trans( 'global.contact-companies.title' ),
        'main_url' => route('admin.contact_companies.index'),
    ),
    'ContactsController' => array(
        'main_title' => trans( 'global.contacts.title' ),
        'main_url' => route('admin.contacts.index'),
        'actions' => array(
            'profileEdit' => trans( 'global.contacts.edit-profile' ),
        ),
    ),
    'ContactGroupsController' => array(
        'main_title' => trans( 'global.contact-groups.title' ),
        'main_url' => route('admin.contact_groups.index'),
    ),
    'ContactTypesController' => array(
        'main_title' => trans( 'global.contact-types.title' ),
        'main_url' => route('admin.contact_types.index'),
    ),
    'ContactNotesController' => array(
        'main_title' => trans( 'global.contact-notes.title' ),
        'main_url' => route('admin.contact_notes.index'),
    ),
    'ContactDocumentsController' => array(
        'main_title' => trans( 'global.contact-documents.title' ),
        'main_url' => route('admin.contact_documents.index'),
    ),
    'IncomesController' => array(
        'main_title' => trans( 'global.income.title' ),
        'main_url' => route('admin.incomes.index'),
    ),
    'ExpensesController' => array(
        'main_title' => trans( 'global.expense.title' ),
        'main_url' => route('admin.expenses.index'),
    ),
    'ExpenseCategoriesController' => array(
        'main_title' => trans( 'global.expense-category.title' ),
        'main_url' => route('admin.expense_categories.index'),
    ),
    'IncomeCategoriesController' => array(
        'main_title' => trans( 'global.income-category.title' ),
        'main_url' => route('admin.income_categories.index'),
    ),
    'MonthlyReportsController' => array(
        'main_title' => trans( 'global.monthly-report.title' ),
        'main_url' => route('admin.monthly_reports.index'),
    ),
    'TransfersController' => array(
        'main_title' => trans( 'global.transfers.title' ),
        'main_url' => route('admin.transfers.index'),
    ),
    'AccountsController' => array(
        'main_title' => trans( 'global.accounts.title' ),
        'main_url' => route('admin.accounts.index'),
    ),
    'PurchaseOrdersController' => array(
        'main_title' => trans( 'global.purchase-orders.title' ),
        'main_url' => route('admin.purchase_orders.index'),
    ),
    'HomeController' => array(
        'main_title' => trans( 'global.app_dashboard' ),
        'main_url' => route('admin.home.dashboard'),
    ),
    'ArticlesController' => array(
        'main_title' => trans( 'global.articles.title' ),
        'main_url' => route('admin.articles.index'),
    ),
    'ContentCategoriesController' => array(
        'main_title' => trans( 'global.content-categories.title' ),
        'main_url' => route('admin.content_categories.index'),
    ),
   
    
    'ClientProjectsController' => array(
        'main_title' => trans( 'global.client-projects.title' ),
        'main_url' => route('admin.client_projects.index'),
    ),
	'ProductCategoriesController' => array(
        'main_title' => trans( 'global.product-categories.title' ),
        'main_url' => route('admin.product_categories.index'),
    ),
    'ProductsTransfersController' => array(
        'main_title' => trans( 'global.products.title' ),
        'main_url' => route('admin.products.index'),
    ),
    'MasterSettingsController' => array(
        'main_title' => trans( 'global.master-settings.title' ),
        'main_url' => route('admin.master_settings.index'),
    ),
    'GeneralSettingsController' => array(
        'main_title' => trans( 'global.master-settings.title' ),
        'main_url' => route('admin.master_settings.index'),
    ),
    
    'InvoicesController' => array(
        'main_title' => trans( 'global.invoices.title' ),
        'main_url' => route('admin.invoices.index'),
    ),
    
    'ProductsController' => array(
        'main_title' => trans( 'global.products.title' ),
        'main_url' => route('admin.products.index'),
    ),
    'BrandsController' => array(
        'main_title' => trans( 'global.brands.title' ),
        'main_url' => route('admin.brands.index'),
    ),
    'MeasurementUnitsController' => array(
        'main_title' => trans( 'global.measurement-units.title' ),
        'main_url' => route('admin.measurement_units.index'),
    ),
    'WarehousesController' => array(
        'main_title' => trans( 'global.warehouses.title' ),
        'main_url' => route('admin.warehouses.index'),
    ),

    'ProductsReturnsController' => array(
        'main_title' => trans( 'global.products-return.title' ),
        'main_url' => route('admin.products_returns.index'),
    ),

    'CustomersController' => array(
        'main_title' => trans( 'global.app_customers' ),
        'main_url' => route('admin.customers.index'),
    ),
    'SuppliersController' => array(
        'main_title' => trans( 'global.contacts.title_suppliers' ),
        'main_url' => route('admin.suppliers.index'),
    ),

    'RolesController' => array(
        'main_title' => trans( 'global.roles.title' ),
        'main_url' => url('admin/roles'),
    ),
    'UsersController' => array(
        'main_title' => trans( 'global.users.title' ),
        'main_url' => route('admin.users.index'),
    ),
    'OrdersController' => array(
        'main_title' => trans( 'orders::global.orders.title' ),
        'main_url' => route('admin.orders.index'),
    ),

    'InternalNotificationsController' => array(
        'main_title' => trans( 'global.internal-notifications.title' ),
        'main_url' => route('admin.internal_notifications.index'),
    ),
    'FaqQuestionsController' => array(
        'main_title' => trans('global.faq-management.faq'),
        'main_url' => route('admin.faq_questions.index'),
    ),
    'FaqCategoriesController' => array(
        'main_title' => trans( 'global.faq-categories.title' ),
        'main_url' => route('admin.faq_categories.index'),
    ),
    'ContentTagsController' => array(
        'main_title' => trans( 'global.content-tags.title' ),
        'main_url' => route('admin.content_tags.index'),
    ),
    'ContentPagesController' => array(
        'main_title' => trans( 'global.content-pages.title' ),
        'main_url' => route('admin.content_pages.index'),
    ),

    'TasksController' => array(
        'main_title' => trans( 'global.tasks.title' ),
        'main_url' => route('admin.tasks.index'),
    ),
    'TaskStatusesController' => array(
        'main_title' => trans( 'global.task-statuses.title' ),
        'main_url' => route('admin.task_statuses.index'),
    ),
    'TaskTagsController' => array(
        'main_title' => trans( 'global.task-tags.title' ),
        'main_url' => route('admin.task_tags.index'),
    ),
    'TaskCalendarsController' => array(
        'main_title' => trans( 'global.task-calendar.title' ),
        'main_url' => route('admin.task_calendars.index'),
    ),
    'TaskCalendarsController' => array(
        'main_title' => trans( 'global.task-calendar.title' ),
        'main_url' => route('admin.task_calendars.index'),
    ),

    'AssetsController' => array(
        'main_title' => trans( 'global.assets.title' ),
        'main_url' => route('admin.assets.index'),
    ),
    'AssetsCategoriesController' => array(
        'main_title' => trans( 'global.assets-categories.title' ),
        'main_url' => route('admin.assets_categories.index'),
    ),
    'AssetsLocationsController' => array(
        'main_title' => trans( 'global.assets-locations.title' ),
        'main_url' => route('admin.assets_locations.index'),
    ),

    'AssetsStatusesController' => array(
        'main_title' => trans( 'global.assets-statuses.title' ),
        'main_url' => route('admin.assets_statuses.index'),
    ),

    'CurrenciesController' => array(
        'main_title' => trans( 'global.currencies.title' ),
        'main_url' => route('admin.currencies.index'),
    ),
    'TemplatesController' => array(
        'main_title' => trans( 'templates::global.templates.title' ),
        'main_url' => route('admin.templates.index'),
    ),
    'SmstemplatesController' => array(
        'main_title' => trans( 'smstemplates::global.smstemplates.title' ),
        'main_url' => route('admin.smstemplates.index'),
    ),
    'PaymentGatewaysController' => array(
        'main_title' => trans( 'global.payment-gateways.title' ),
        'main_url' => route('admin.payment_gateways.index'),
    ),
    'TaxesController' => array(
        'main_title' => trans( 'global.taxes.title' ),
        'main_url' => route('admin.taxes.index'),
    ),
    'DiscountsController' => array(
        'main_title' => trans( 'global.discounts.title' ),
        'main_url' => route('admin.discounts.index'),
    ),
    'RecurringPeriodsController' => array(
        'main_title' => trans( 'global.recurring-periods.title' ),
        'main_url' => route('admin.recurring_periods.index'),
    ),
    'Controller' => array(
        'main_title' => trans( 'custom.translations.title' ),
        'main_url' => url('admin/translations'),
    ),
    'LanguagesController' => array(
        'main_title' => trans( 'global.languages.title' ),
        'main_url' => route('admin.languages.index'),
    ),

    'CountriesController' => array(
        'main_title' => trans( 'global.countries.title' ),
        'main_url' => route('admin.countries.index'),
    ),
	'TimeEntriesController' => array(
        'main_title' => trans( 'global.time-entries.title' ),
        'main_url' => route('admin.time_entries.index'),
    ),
	'ProjectStatusesController' => array(
        'main_title' => trans( 'global.project-statuses.title' ),
        'main_url' => route('admin.project_statuses.index'),
    ),
	'ProjectBillingTypesController' => array(
        'main_title' => trans( 'global.project-billing-types.title' ),
        'main_url' => route('admin.project_billing_types.index'),
    ),
	
	'CreditNotesController' => array(
        'main_title' => trans( 'global.credit_notes.title' ),
        'main_url' => route('admin.credit_notes.index'),
    ),
    'PermissionsController' => array(
        'main_title' => trans( 'global.permissions.title' ),
        'main_url' => route('admin.permissions.index'),
    ),
);

if( File::exists(config('modules.paths.modules') . '/Quotes') && Module::find('quotes')->active && isPluginActive('quotes') ) {
    $controllers['QuotesController'] = array(
        'main_title' => trans( 'global.quotes.title' ),
        'main_url' => route('admin.quotes.index'),
    );
}
if( File::exists(config('modules.paths.modules') . '/Sendsms') && Module::find('sendsms')->active && isPluginActive('sendsms') ) {
    $controllers['SendSmsController'] = array(
        'main_title' => trans( 'sendsms::global.send-sms.title' ),
        'main_url' => route('admin.send_sms.index'),
    );
}
if( File::exists(config('modules.paths.modules') . '/RecurringInvoices') && Module::find('recurringinvoices')->active && isPluginActive('recurring_invoice') ) {
    $controllers['RecurringInvoicesController'] = array(
        'main_title' => trans( 'global.recurring-invoices.title' ),
        'main_url' => route('admin.recurring_invoices.index'),
    );
}
if( File::exists(config('modules.paths.modules') . '/DatabaseBackup
') && Module::find('databasebackup
')->active && isPluginActive('databasebackup
') ) {
    $controllers['DatabaseBackupsController'] = array(
        'main_title' => trans( 'databasebackup::global.database-backup.title' ),
        'main_url' => route('admin.database_backups.index'),
    );
}
if( File::exists(config('modules.paths.modules') . '/SiteThemes

') && Module::find('sitethemes

')->active && isPluginActive('sitethemes') ) {
    $controllers['SiteThemesController'] = array(
        'main_title' => trans( 'databasebackup::global.site-themes.title' ),
        'main_url' => route('admin.site_themes.index'),
    );
}
if( File::exists(config('modules.paths.modules') . '/DynamicOptions') && Module::find('dynamicoptions')->active && isPluginActive('dynamicoptions
') ) {
    $controllers['DynamicOptionsController'] = array(
        'main_title' => trans( 'databasebackup::global.dynamic_options.title' ),
        'main_url' => route('admin.dynamic_options.index'),
    );
}

if( File::exists(config('modules.paths.modules') . '/Proposals') && Module::find('proposals')->active && isPluginActive('proposals') ) {
    $controllers['ProposalsController'] = array(
        'main_title' => trans( 'proposals::global.proposals.title' ),
        'main_url' => route('admin.proposals.index'),
    );
}

if( File::exists(config('modules.paths.modules') . '/Contracts') && Module::find('contracts')->active && isPluginActive('contracts') ) {
    $controllers['ContractsController'] = array(
        'main_title' => trans( 'contracts::global.contracts.title' ),
        'main_url' => route('admin.contracts.index'),
    );
}

$current_controller = getController( 'controller' );
$current_action = getController( 'action' );
if ( in_array($current_controller, array( 'ContactsController' ) ) && in_array($current_action, [ 'create' , 'edit', 'index']) ) {
    $title = trans( 'global.contacts.title' );
    $type = \Request::segment(4);
    if ( empty( $type ) ) {
        $type = \Request::segment(3);
    }
    $route = route( 'admin.contacts.index' );
    if ( ! empty( $type ) ) {
        $details = \App\ContactType::find( $type );
        if ( $details ) {
            $title = $details->title;
            $route = route('admin.list_contacts.index', [ 'type' => 'contact_type', 'type_id' => $type ] );
        }
    }
    $controllers[ $current_controller ] = array(
        'main_title' => $title,
        'main_url' => $route,
    );
}
if ( in_array($current_controller, array( 'QuoteTasksController', 'QuotesRemindersController', 'QuotesNotesController' ) )) {
    $title = trans( 'global.quote-tasks.title' );
    $route = route('admin.quote_tasks.index', \Request::segment(3));
    if ( 'QuotesRemindersController' === $current_controller ) {
        $title = trans( 'global.quotes-reminders.title' );
        $route = route('admin.quote_reminders.index', \Request::segment(3));
    }
    if ( 'QuotesNotesController' === $current_controller ) {
        $title = trans( 'global.quotes-notes.title' );
        $route = route('admin.quotes_notes.index', \Request::segment(3));
    }
    $controllers[ $current_controller ] = array(
        'main_title' => $title,
        'main_url' => $route,
    );
}

if ( in_array($current_controller, array( 'InvoiceTasksController', 'InvoiceRemindersController', 'InvoiceNotesController' ) )) {
    $title = trans( 'global.invoice-tasks.title' );
    $route = route('admin.invoice_tasks.index', \Request::segment(3));
    if ( 'InvoiceRemindersController' === $current_controller ) {
        $title = trans( 'global.invoice-reminders.title' );
        $route = route('admin.invoice_reminders.index', \Request::segment(3));
    }
    if ( 'InvoiceNotesController' === $current_controller ) {
        $title = trans( 'global.invoice-notes.title' );
        $route = route('admin.invoice_notes.index', \Request::segment(3));
    }
    $controllers[ $current_controller ] = array(
        'main_title' => $title,
        'main_url' => $route,
    );
}

if ( in_array($current_controller, array( 'ProposalTasksController', 'ProposalsRemindersController', 'ProposalsNotesController' ) )) {
    $title = trans( 'global.proposal-tasks.title' );
    $route = route('admin.proposal_tasks.index', \Request::segment(3));
    if ( 'ProposalsRemindersController' === $current_controller ) {
        $title = trans( 'global.proposal-reminders.title' );
        $route = route('admin.proposal_reminders.index', \Request::segment(3));
    }
    if ( 'ProposalsNotesController' === $current_controller ) {
        $title = trans( 'global.proposal-notes.title' );
        $route = route('admin.proposals_notes.index', \Request::segment(3));
    }
    $controllers[ $current_controller ] = array(
        'main_title' => $title,
        'main_url' => $route,
    );
}

if ( in_array($current_controller, array( 'ContractTasksController', 'ContractsRemindersController', 'ContractsNotesController' ) )) {
    $title = trans( 'global.contract-tasks.title' );
    $route = route('admin.contract_tasks.index', \Request::segment(3));
    if ( 'ContractsRemindersController' === $current_controller ) {
        $title = trans( 'global.contracts-reminders.title' );
        $route = route('admin.contract_reminders.index', \Request::segment(3));
    }
    if ( 'ContractsNotesController' === $current_controller ) {
        $title = trans( 'global.contract-notes.title' );
        $route = route('admin.contracts_notes.index', \Request::segment(3));
    }
    $controllers[ $current_controller ] = array(
        'main_title' => $title,
        'main_url' => $route,
    );
}

// Project
if ( in_array($current_controller, array( 'ProjectTasksController', 'TimeEntriesController', 'MileStonesController', 'ProjectDiscussionController','ProjectTicketsController' ) )) {
    $title = trans( 'global.project-tasks.title' );
    $route = route('admin.project_tasks.index', \Request::segment(3));
    if ( 'TimeEntriesController' === $current_controller ) {
        $title = trans( 'global.time-entries.title' );
        $route = route('admin.time_entries.index', \Request::segment(3));
    }
	if ( 'MileStonesController' === $current_controller ) {
        $title = trans( 'global.mile-stones.title' );
        $route = route('admin.mile_stones.index', \Request::segment(3));
    }
	if ( 'ProjectDiscussionController' === $current_controller ) {
        $title = trans( 'global.project-discussions.title' );
        $route = route('admin.project_discussions.index', \Request::segment(3));
    }
    if ( 'ProjectTicketsController' === $current_controller ) {
        $title = trans( 'global.client-projects.title-tickets' );
        $route = route('admin.project_tickets.index', \Request::segment(3));
    }
	 
    $controllers[ $current_controller ] = array(
        'main_title' => $title,
        'main_url' => $route,
    );
}

if ( 'HomeController' === $current_controller && in_array( $current_action, ['dashboardWidgets', 'dashboardWidgetsAssign', 'dashboardWidgetsChangeorder']) ) {
    $controllers['HomeController']['main_title'] = trans('global.dashboard-widgets.title');
    $controllers['HomeController']['main_url'] = route('admin.home.dashboard-widgets');
}


$actions = array(
    'index' => trans( 'global.app_list' ),
    'create' => trans( 'global.app_create' ),
    'edit' => trans( 'global.app_edit' ),
    'show' => trans( 'global.app_view' ),
    'viewSettings' => trans( 'global.app_edit' ),
    'addSubSettings' => trans( 'global.app_edit' ),
    'csv_parse' => trans('global.app_csvImport'),
    'tasksStatus' => trans('custom.tasks.statuswise-tasks'),
    'getIndex' => trans( 'global.app_list' ),
	'receiptPDF' => trans('custom.incomes.receipt'),
	'checkOut' => trans('orders::global.orders.checkout'),
	'tickets' => trans( 'global.client-projects.title-tickets' ),
	'projectDiscussionComments' => trans( 'global.project-discussions.comments' ),
	'invoices' => trans( 'global.app_list' ),
    'invoiceProject' => trans( 'global.app_create' ),
	'expenses' => trans( 'global.app_list' ),
	'mailchimpEmailCampaigns' => trans( 'global.contacts.mailchimp-email-campaigns' ),
    'dashboardWidgetsAssign' => trans( 'global.dashboard-widgets.assign-widgets' ),
    'dashboardWidgets' => trans( 'global.dashboard-widgets.title' ),
    'dashboardWidgetsChangeorder' => trans( 'global.app_change_order' ),
    'upload' => trans( 'custom.common.upload' ),
);

foreach ($controllers as $controller => $controller_args) {
    if ( ! empty( $controller_args['actions'] ) ) {
        $actions = $actions + $controller_args['actions'];
    }
    foreach ($actions as $action => $action_title) {
        Breadcrumbs::for( $controller . '.' . $action, function ($trail) use( $controller, $controller_args, $action_title, $action, $controllers, $current_controller, $current_action ) {
            
			if ( 'ContactsController.profileEdit' === $controller . '.' . $action ) {
                $controller_args['main_title'] = trans('global.app_dashboard');
                $controller_args['main_url'] = route('admin.home.dashboard');
            }
			
            if( File::exists(config('modules.paths.modules') . '/Quotes') && Module::find('quotes')->active && isPluginActive('quote') ) {
                if ( in_array($controller, array( 'QuoteTasksController', 'QuotesRemindersController', 'QuotesNotesController' ) )) {
    				$trail->push( $controllers['QuotesController']['main_title'], $controllers['QuotesController']['main_url']);
    			}
            }
            if ( in_array($controller, array( 'InvoiceTasksController', 'InvoiceRemindersController', 'InvoiceNotesController' ) )) {
                $trail->push( $controllers['InvoicesController']['main_title'], $controllers['InvoicesController']['main_url']);
            }
			
			if ( in_array($controller, array( 'ProjectTasksController', 'TimeEntriesController', 'MileStonesController', 'ProjectDiscussionController','ProjectTicketsController') )) {
                $trail->push( $controllers['ClientProjectsController']['main_title'], $controllers['ClientProjectsController']['main_url']);
            }
			
			if ( 'ClientProjectsController' === $current_controller && 'tickets' === $current_action ) {
				$trail->push( $controllers['ClientProjectsController']['main_title'], $controllers['ClientProjectsController']['main_url']);
				
				$trail->push( trans('global.client-projects.title-tickets'), route('admin.client_projects.tickets', \Request::segment(4)));
				$trail->push( $action_title );
                
			} elseif ( 'ClientProjectsController' === $current_controller && 'invoices' === $current_action ) {
				$trail->push( $controllers['ClientProjectsController']['main_title'], $controllers['ClientProjectsController']['main_url']);
				
				$trail->push( trans('global.client-projects.invoices'), route('admin.client_projects.invoices', \Request::segment(4)));
				$trail->push( $action_title );
			} elseif ( 'ClientProjectsController' === $current_controller && 'invoiceProject' === $current_action ) {
                $trail->push( $controllers['ClientProjectsController']['main_title'], $controllers['ClientProjectsController']['main_url']);
                
                $trail->push( trans('global.client-projects.invoices'), route('admin.client_projects.invoices', \Request::segment(4)));
                $trail->push( $action_title );
            } elseif ( 'ClientProjectsController' === $current_controller && 'expenses' === $current_action ) {
                $trail->push( $controllers['ClientProjectsController']['main_title'], $controllers['ClientProjectsController']['main_url']);
                
                $trail->push( trans('global.client-projects.expenses'), route('admin.client_projects.expenses', \Request::segment(4)));
                $trail->push( $action_title );
            } else {
				$trail->push( $controller_args['main_title'], $controller_args['main_url']);
				$trail->push( $action_title );
			}
        });
    }
}
