<div class="pull-right">
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('client_project_edit')): ?>
    <a href="<?php echo e(route('admin.client_projects.edit',[$client_project->id])); ?>" class="btn btn-xs btn-info"><i class="fa fa-pencil-square-o"></i><?php echo app('translator')->getFromJson('global.app_edit'); ?></a>
<?php endif; ?>
</div> 
<?php
$currency_id = getDefaultCurrency('id');
if ( ! empty( $client_project->currency_id ) ) {
    $currency_id = $client_project->currency_id;
} elseif ( ! empty( $client_project->client->currency_id ) ) {
    $currency_id = $client_project->client->currency_id;
}
?>
 <table class="table table-bordered table-striped">
    <tr>
        <th><?php echo app('translator')->getFromJson('global.client-projects.fields.title'); ?></th>
        <td field-key='title' class="trash"><?php echo e($client_project->title); ?></td>
    </tr>
    <tr>
        <th><?php echo app('translator')->getFromJson('global.client-projects.fields.client'); ?></th>
        <td field-key='client'><?php echo e($client_project->client->name ?? ''); ?></td>
    </tr>
    <tr>
        <th><?php echo app('translator')->getFromJson('global.client-projects.fields.priority'); ?></th>
        <td field-key='priority'><?php echo e($client_project->priority); ?></td>
    </tr>
    <tr>
        <th><?php echo app('translator')->getFromJson('global.client-projects.fields.billing-type'); ?></th>
        <td field-key='billing_type'><?php echo e($client_project->billing_type->title ?? ''); ?></td>
    </tr>
    <?php if( $client_project->billing_type_id == PROJECT_BILLING_TYPE_FIXED_PRICE): ?>
    <tr>
        <th><?php echo app('translator')->getFromJson('global.client-projects.fields.budget'); ?></th>
        <td field-key='budget'><?php echo e(digiCurrency($client_project->budget, $currency_id)); ?></td>
    </tr>
    <?php endif; ?>
    <?php if( $client_project->billing_type_id == PROJECT_BILLING_TYPE_PROJECT_HOURS): ?>
    <tr>
        <th><?php echo app('translator')->getFromJson('global.client-projects.fields.project_rate_per_hour'); ?></th>
        <td field-key='budget'><?php echo e(digiCurrency( $client_project->project_rate_per_hour, $currency_id )); ?></td>
    </tr>
    <?php endif; ?>
    <?php if( $client_project->billing_type_id == PROJECT_BILLING_TYPE_TASK_HOURS): ?>
    <tr>
        <th><?php echo app('translator')->getFromJson('global.client-projects.fields.hourly_rate'); ?></th>
        <td field-key='budget'><?php echo e(digiCurrency( $client_project->hourly_rate, $currency_id )); ?></td>
    </tr>
    <?php endif; ?>
    
    <tr>
        <th><?php echo app('translator')->getFromJson('global.client-projects.fields.phase'); ?></th>
        <td field-key='phase'><?php echo e($client_project->phase); ?></td>
    </tr>
    <tr>
        <th><?php echo app('translator')->getFromJson('global.client-projects.fields.progress_from_tasks'); ?></th>
        <td field-key='phase'><?php echo e(ucfirst( $client_project->progress_from_tasks )); ?></td>
    </tr>
    <tr>
        <th><?php echo app('translator')->getFromJson('global.client-projects.fields.start-date'); ?></th>
        <td field-key='start_date'><?php echo e(digiDate( $client_project->start_date )); ?></td>
    </tr>
    <tr>
        <th><?php echo app('translator')->getFromJson('global.client-projects.fields.due-date'); ?></th>
        <td field-key='due_date'><?php echo e(digiDate( $client_project->due_date )); ?></td>
    </tr>
    <tr>
        <th><?php echo app('translator')->getFromJson('global.client-projects.fields.status'); ?></th>
        <td field-key='status'><?php echo e($client_project->status->name ?? ''); ?></td>
    </tr>
    <?php if( ! empty( $client_project->demo_url ) ): ?>
    <tr>
        <th><?php echo app('translator')->getFromJson('global.client-projects.fields.demo-url'); ?></th>
        <td field-key='demo_url'><a href="<?php echo e($client_project->demo_url); ?>" target="_blank"><?php echo e($client_project->demo_url); ?></td>
    </tr>
    <?php endif; ?>
    <tr>
        <th><?php echo app('translator')->getFromJson('global.client-projects.fields.assigned-to'); ?></th>
        <td field-key='assigned_to'>
            <?php $__currentLoopData = $client_project->assigned_to; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $singleAssignedTo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <span class="label label-info label-many"><?php echo e($singleAssignedTo->name); ?></span>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </td>
    </tr>
    <tr>
        <th><?php echo app('translator')->getFromJson('global.client-projects.fields.project-tabs'); ?></th>
        <td field-key='assigned_to'>
            <?php $__currentLoopData = $client_project->project_tabs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $singleTab): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <span class="label label-info label-many"><?php echo e($singleTab->title); ?></span>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </td>
    </tr>    
    
    <tr>
        <th><?php echo app('translator')->getFromJson('global.client-projects.fields.description'); ?></th>
        <td field-key='description'><?php echo clean($client_project->description); ?></td>
    </tr>
    
</table>  

