<?php

$factory->define(App\Contact::class, function (Faker\Generator $faker) {
    $x = rand(1, 3);
    $first_name = $faker->firstName;
    $last_name = $faker->lastName;
    switch( $x ) {
        case 1:
            $first_name = $faker->firstNameMale;
            break;
        case 2:
            $first_name = $faker->firstNameFemale;
            break;
        default:
            $first_name = $faker->firstNameMale;
            break;
    }

    $image_type = array_rand(['jpg', 'png'], 1);
    $onezero = array_rand( [ '1', '0' ], 1);
    $name = $first_name;
    if ( ! empty( $last_name ) ) {
        $name .= ' ' . $last_name;
    }
    $yesno = array_rand(['yes', 'no'], 1);
    $row = [
        'first_name' => $first_name,
        'last_name' => $last_name,
        //'thumbnail' => $faker->image(public_path().'/thumb/', 50, 50),
        'phone1_code' => function () {
            return App\Country::inRandomOrder()->first()->dialcode;
        },
        'phone1' => $faker->numberBetween(1000000000, 2147483647),
        'phone2_code' => function () {
            return App\Country::inRandomOrder()->first()->dialcode;
        },
        'phone2' => $faker->numberBetween(1000000000, 2147483647),
        'email' => $faker->unique()->safeEmail,
        'skype' => $faker->word,
        
        'address' => $faker->address,
        //'company_id' => factory('App\ContactCompany')->create()->id,
        'company_id' => function () {
            return App\ContactCompany::inRandomOrder()->first()->id;
        },
        'city' => $faker->city,
        'state_region' => $faker->state,
        'zip_postal_code' => $faker->postcode,
        'tax_id' => $faker->text(10),
        'group_id' => function () {
            return App\ContactGroup::inRandomOrder()->first()->id;
        },
        'country_id' => function () {
            return App\Country::inRandomOrder()->first()->id;
        },
        'delivery_address' => $faker->address,
        'currency_id' => function () {
            return App\Currency::where('status', 'Active')->inRandomOrder()->first()->id;
        },
        'language_id' => function () {
            return App\Language::inRandomOrder()->first()->id;
        },
        'ticket_emails' => $onezero,
        'name' => $name,
        'fulladdress' => $faker->address,
    ];

    $status = array_rand(['Registered', 'Supended', 'Active', 'Deleted'], 1);
    $theme = array_rand(['default', 'bsb'], 1);
    $confirmation_code = ( 'Active' != $status ) ? $faker->password : null;
    
    if ( 'yes' === $yesno ) {
        $password = '123456789';
        $row['is_user'] = 'yes';
        $row['email_verified_at'] = $faker->dateTime;
        $row['password'] = '$2y$10$TKh8H1.PfQx37YgCzwiKb.KjNyWgaHb9cbcoQgdIVFlYg7B77UdFm'; // secret
        $row['department_id'] = function () {
            return App\Department::inRandomOrder()->first()->id;
        };
        $row['ticketit_admin'] = $onezero;
        $row['ticketit_agent'] = 'yes';
        $row['status'] = $status;
        $row['theme'] = $theme;
        $row['portal_language'] = function () {
            return App\Language::inRandomOrder()->first()->code;
        };
        $row['confirmation_code'] = $confirmation_code;
        $row['hourly_rate'] = $faker->randomFloat(2, 15);
        if ( 'default' === $theme ) {
            $themes = [
                'default' => trans( 'global.users.default' ),
                'darkgray theme.css' => trans( 'global.users.darkgray-theme' ),
                'gradient blue theme.css' => trans( 'global.users.gradient-blue-theme' ),
                'light blue theme.css' => trans( 'global.users.light-blue-theme' ),
                'darkgray theme.css' => trans( 'global.users.white' ),
            ];
            $row['color_theme'] = array_rand(array_keys($themes), 1);

            $skins = [
                'skin-blue' => trans( 'global.users.default' ),
                'skin-blue-light' => trans( 'global.users.skin-blue-light' ),
                'skin-yellow' => trans( 'global.users.skin-yellow' ),
                'skin-yellow-light' => trans( 'global.users.skin-yellow-light' ),
                'skin-green' => trans( 'global.users.skin-green' ),

                'skin-green-light' => trans( 'global.users.skin-green-light' ),
                'skin-purple' => trans( 'global.users.skin-purple' ),
                'skin-purple-light' => trans( 'global.users.skin-purple-light' ),
                'skin-red' => trans( 'global.users.skin-red' ),
                'skin-red-light' => trans( 'global.users.skin-red-light' ),

                'skin-black' => trans( 'global.users.skin-black' ),
                'skin-black-light' => trans( 'global.users.skin-black-light' ),
            ];
            $row['color_skin'] = array_rand(array_keys($skins), 1);
        }
    }

    return $row;
});
