<?php

$factory->define(App\Expense::class, function (Faker\Generator $faker) {
    $yesno = $faker->randomElement(['yes', 'no']);
    $data = [
        'name' => $faker->word,
        'slug' => $faker->slug,
        'entry_date' => $faker->date('Y-m-d'),
        'amount' => $faker->randomFloat(2, 1, 99999),        
        'expense_category_id' => function () {
                  return App\ExpenseCategory::inRandomOrder()->first()->id;
        },
        'description' => $faker->text(200),
        'ref_no' =>$faker->slug(3),
        'account_id' => function () {
            return App\Account::inRandomOrder()->first()->id;
        },
        'payee_id' => function () {
                    return App\Contact::inRandomOrder()->whereHas("contact_type",
                    function ($query) {
                    $query->where('id', CUSTOMERS_TYPE);
                    })->first()->id;
        },
        'payment_method_id' =>function () {
            return App\PaymentGateway::inRandomOrder()->first()->id;
        },
        'is_recurring' => $yesno,
    ];
    if ( 'yes' == $yesno ) {
        $data['recurring_value'] = $faker->numberBetween(1,50);
        $data['recurring_type'] = $faker->randomElement(['day', 'week', 'month', 'year']);
    }
    return $data;
});