<?php

$factory->define(InvoiceProducts::class, function (Faker\Generator $faker) {
     // /$data = $factory->raw(InvoiceProducts::class);
    // $yesno = array_rand(['yes', 'no'], 1);  
    $product = App\Product::inRandomOrder()->first();
    $product_name = $faker->name;
    $product_qty = $faker->randomDigitNotNull;
    $product_price = $faker->randomFloat(2,1);
    $product_tax = $faker->randomFloat(1,0,100);
    $tax_type = $faker->randomElement(['percent', 'value']);
    $tax_value = $faker->randomFloat(1,0,100);
    $product_discount = $faker->randomFloat(1,0,100);
    $discount_type = $faker->randomElement(['percent', 'value']);
    if ( 'percent' === $discount_type ) {
        $discount_value = $faker->randomFloat(1,0,100);
    } else {
        $discount_value = $faker->randomFloat(1,0,$product_price);
    }
    
    //$product_subtotal => $faker->randomFloat(1,0,100),
    //$product_amount => $faker->randomFloat(1,0,100),
            
    $product_amount = $product_qty * $product_price;

    if ( 'percent' === $tax_type && $product_tax > 0 && $product_amount > 0 ) {
        $tax_value = ( $product_amount * $product_tax) / 100;
    } else {
        $tax_value = $product_tax;
    }

    $total_tax += $tax_value;

    if ( 'percent' === $discount_type && $product_discount > 0 && $product_amount > 0 ) {
        $discount_value = ( $product_amount * $product_discount) / 100;
    } else {
        $discount_value = $product_discount;
    }
          
    $product_subtotal = $product_amount;
    $amount = ($product_qty * $product_price) + $tax_value - $discount_value;
            

    $data = [
        'invoice_id' => function () {
            return App\Invoice::inRandomOrder()->first()->id;
        },
        'product_id' => $product->id,
        'product_name' => $product_name,
        'product_qty' =>  $product_qty,
        'product_price' => $product_price,
        'product_tax' => $product_tax,
        'tax_type' => $tax_type,
        'tax_value' =>$tax_value,
        'product_discount' => $product_discount,
        'discount_type' => $discount_type,
        'discount_value' =>$discount_value,
        'product_subtotal' => $amount,
        'product_amount' =>  $amount,
        'pid' => $faker->unique()->randomDigitNotNull,
        'unit' => $faker->randomLetter,
        'hsn' =>$faker->randomAscii,
        'alert' => '5',
        'stock_quantity' => $faker->randomNumber(2),
        'product_description' => $faker->text(200),
        ];
    return $data;
    // return array_merge($data, ['completed' => true]);
});
