<?php

$factory->define(App\Product::class, function (Faker\Generator $faker) {
	$image_type = array_rand(['jpg', 'png'], 1);
    // $status = array_rand(['Active','Inactive','Damaged','Fixed asset'],1);
    $actual_price = $faker->randomFloat(2, 1, 99999);
    $sale_price = $faker->randomFloat(2, 1, $actual_price);

    $data = [
        'name' => $faker->text(50),
        'product_code' => $faker->postcode,
        'actual_price' => $actual_price,
        'sale_price' => $sale_price,
        'description' => $faker->text(200),
        'stock_quantity' => $faker->randomDigit,
        'alert_quantity' => $faker->randomNumber(2),
        //'thumbnail' => $faker->image(public_path().'/thumb/', 50, 50),
        'hsn_sac_code' => $faker->postcode,
        'product_size' => $faker->randomNumber(2).'x'.$faker->randomNumber(2),
        'product_weight' =>$faker->randomFloat(2,1),
        'ware_house_id' => function () {
            return App\Warehouse::inRandomOrder()->first()->id;
        },
        'brand_id' =>  function () {
            return App\Brand::inRandomOrder()->first()->id;
        },
        'tax_id' => function () {
            return App\Tax::inRandomOrder()->first()->id;
        },
        'discount_id' => function () {
            return App\Discount::inRandomOrder()->first()->id;
        },
        'measurement_unit' =>function () {
            return App\MeasurementUnit::inRandomOrder()->first()->id;
        },
        'excerpt' => $faker->slug,
        /*'prices' => $faker->randomFloat(2,1),
        'prices_available'=> function () {
            return App\Currency::inRandomOrder()->first()->code;
        },
        */
    ];
    return $data;
});