<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class Create1556517250QuotesRemindersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(! Schema::hasTable('quotes_reminders')) {
            Schema::create('quotes_reminders', function (Blueprint $table) {
                $table->increments('id');
                $table->text('description')->nullable();
                $table->date('date')->nullable();
                $table->enum('isnotified', array('yes', 'no'))->nullable();
                $table->enum('notify_by_email', array('no', 'yes'))->nullable();
                
                $table->timestamps();
                $table->softDeletes();

                $table->index(['deleted_at']);
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('quotes_reminders');
    }
}
