<?php
$direction = 'ltr';
if (\Cookie::get('direction')) {
    $direction = \Cookie::get('direction');
}

$lang = 'en';
if (\Cookie::get('language')) { 
    $lang = \Cookie::get('language');
}

$theme = 'default';
if (\Cookie::get('theme')) { 
    $theme = \Cookie::get('theme');
}
$color_theme = 'skin-blue';
if (\Cookie::get('color_skin')) { // If user has his own skin we need get it.
    $color_theme = \Cookie::get('color_skin');
}
?>
<!DOCTYPE html>
<html lang="<?php echo e($lang); ?>" dir="<?php echo e($direction); ?>">

<head>
    <?php echo $__env->make('partials.head', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
</head>

<body class="hold-transition <?php echo e($color_theme); ?> sidebar-mini" ng-app="academia">

<span id="hdata"
      data-df="<?php echo e(config('app.date_format_moment')); ?>"
      data-curr="<?php echo e(getDefaultCurrency()); ?>" data-currency_id="<?php echo e(getDefaultCurrency('id')); ?>"></span>

<div id="wrapper">

<?php if( empty( $topbar ) ): ?>
    <?php echo $__env->make('partials.topbar', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
<?php elseif( 'yes' === $topbar ): ?>
    <?php echo $__env->make('partials.topbar', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
<?php endif; ?>

<?php
$style = '';
$columns = 6;
?>
<?php if( empty( $sidebar ) ): ?>
    <?php echo $__env->make('partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
<?php elseif( 'yes' === $sidebar ): ?>
    <?php echo $__env->make('partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
<?php else: ?>
<?php $style = ' style="margin-left:0px;"'; ?>
<?php endif; ?>

<!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper" <?php echo $style; ?>>
        <!-- Main content -->
        <section class="content">
            <?php if(isset($siteTitle)): ?>
                <h3 class="page-title">
                    <?php echo e($siteTitle); ?>

                </h3>
            <?php endif; ?>

            <div class="row">
                <div class="col-md-12">
                    <?php
                    $parts = getController();
                    if( env('APP_DEV') ) {
                        echo $parts['controller'] . '@' . $parts['action'] . ' ' . date('d-m-Y H:i:s');
                    }
                    ?>
                    <?php echo e(Breadcrumbs::render($parts['controller'] . '.' . $parts['action'])); ?>

                    <?php if(env('DEMO_MODE')): ?>
                    <div class="alert alert-info demo-alert col-md-12">
                    &nbsp;&nbsp;&nbsp;<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                        <strong><?php echo app('translator')->getFromJson('global.info'); ?>!</strong> CRUD <?php echo app('translator')->getFromJson('global.operations_disabled'); ?>
                    </div>
                    <?php endif; ?>

                    <?php if(Session::has('message')): ?>
                        <?php
                        $message_type = getSetting('message_type', 'site_settings', 'onpage');
                        if ( 'onpage' === $message_type ) {
                        ?>
                        <div class="alert alert-<?php echo e(Session::get('status', 'info')); ?>">
                            &nbsp;&nbsp;&nbsp;<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                            <?php echo e(Session::get('message')); ?>

                        </div>
                    <?php } ?>
                    <?php endif; ?>
                    <?php if($errors->count() > 0 && ! in_array($parts['controller'], array( 'TicketsController', 'StatusesController', 'PrioritiesController', 'AgentsController', 'ConfigurationsController', 'CategoriesController', 'AdministratorsController' ) )): ?>
                        <div class="alert alert-danger">
                            <ul class="list-unstyled">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <?php echo $__env->yieldContent('content'); ?>

                </div>
            </div>
        </section>
    </div>
</div>

<?php echo Form::open(['route' => 'auth.logout', 'style' => 'display:none;', 'id' => 'logout']); ?>

<button type="submit">Logout</button>
<?php echo Form::close(); ?>


<?php echo $__env->make('partials.javascripts', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>

<?php echo getSetting('google_analytics', 'seo_settings'); ?>

</body>
</html>