<?php $request = app('Illuminate\Http\Request'); ?>


<?php $__env->startSection('content'); ?>
    <h3 class="page-title"><?php echo app('translator')->getFromJson('global.product-categories.title'); ?></h3>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_category_create')): ?>
    <p>
        <a href="<?php echo e(route('admin.product_categories.create')); ?>" class="btn btn-success"><i class="fa fa-plus"></i>&nbsp;<?php echo app('translator')->getFromJson('global.app_add_new'); ?></a>
        
    </p>
    <?php endif; ?>

    

    <div class="panel panel-default">
        <div class="panel-heading">
            <?php echo app('translator')->getFromJson('global.app_list'); ?>
        </div>

        <div class="panel-body table-responsive">
            <table class="table table-bordered table-striped <?php echo e(count($product_categories) > 0 ? 'datatable' : ''); ?> <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_category_delete_multi')): ?> dt-select <?php endif; ?>">
                <thead>
                    <tr>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_category_delete_multi')): ?>
                            <th style="text-align:center;"><input type="checkbox" id="select-all" /></th>
                        <?php endif; ?>

                        <th><?php echo app('translator')->getFromJson('global.product-categories.fields.name'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.product-categories.fields.photo'); ?></th>
                                                <th>&nbsp;</th>

                    </tr>
                </thead>
                
                <tbody>
                    <?php if(count($product_categories) > 0): ?>
                        <?php $__currentLoopData = $product_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr data-entry-id="<?php echo e($product_category->id); ?>">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_category_delete_multi')): ?>
                                    <td></td>
                                <?php endif; ?>

                                <td field-key='name'><?php echo e($product_category->name); ?></td>
                                <td field-key='photo'>
                                    <?php if( $product_category->photo && file_exists(public_path() . '/thumb/' . $product_category->photo)): ?> 
                                    <a href="<?php echo e(route('admin.home.media-file-download', [ 'model' => 'ProductCategory', 'field' => 'photo', 'record_id' => $product_category->id ])); ?>" ><img src="<?php echo e(asset(env('UPLOAD_PATH').'/thumb/' . $product_category->photo)); ?>"/></a>
                                    <?php else: ?>
                                     <img src="<?php echo e(asset ('images/product-50x50.jpg')); ?>" width="50" height="50"/> 
                                <?php endif; ?>
                                </td>
                                  <td>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_category_view')): ?>
                                    <a href="<?php echo e(route('admin.product_categories.show',[$product_category->id])); ?>" class="btn btn-xs btn-primary"><?php echo app('translator')->getFromJson('global.app_view'); ?></a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_category_edit')): ?>
                                    <a href="<?php echo e(route('admin.product_categories.edit',[$product_category->id])); ?>" class="btn btn-xs btn-info"><?php echo app('translator')->getFromJson('global.app_edit'); ?></a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_category_delete_multi')): ?>
                        <?php echo Form::open(array(
                                        'style' => 'display: inline-block;',
                                        'method' => 'DELETE',
                                        'onsubmit' => "return confirm('".trans("global.app_are_you_sure")."');",
                                        'route' => ['admin.product_categories.destroy', $product_category->id])); ?>

                                    <?php echo Form::submit(trans('global.app_delete'), array('class' => 'btn btn-xs btn-danger')); ?>

                                    <?php echo Form::close(); ?>

                                    <?php endif; ?>
                                </td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="8"><?php echo app('translator')->getFromJson('global.app_no_entries_in_table'); ?></td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?> 
    <script>
        
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_category_delete_multi')): ?>
            window.route_mass_crud_entries_destroy = '<?php echo e(route('admin.product_categories.mass_destroy')); ?>';
        <?php endif; ?>

    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>