<?php
$direction = 'ltr';
if (\Cookie::get('direction')) {
    // die(\Cookie::get('direction'));
    $direction = \Cookie::get('direction');
}

$lang = 'en';
if (\Cookie::get('language')) { 
    $lang = \Cookie::get('language');
}
?>
<!DOCTYPE html>
<html lang="<?php echo e($lang); ?>" dir="<?php echo e($direction); ?>">

<head>
    <?php echo $__env->make('partials.head', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
</head>
<?php
$themecolor = strtolower( str_replace( ' ', '-', getActiveTheme('skin', 'red') ) );
//$themecolor = 'red';
?>
<body class="theme-<?php echo e($themecolor); ?>" ng-app="academia">

    <span id="hdata"
      data-df="<?php echo e(config('app.date_format_moment')); ?>"
      data-curr="<?php echo e(getDefaultCurrency()); ?>"></span>
    <!-- Page Loader -->
    <div class="page-loader-wrapper">
        <div class="loader">
            <div class="preloader">
                <div class="spinner-layer pl-red">
                    <div class="circle-clipper left">
                        <div class="circle"></div>
                    </div>
                    <div class="circle-clipper right">
                        <div class="circle"></div>
                    </div>
                </div>
            </div>
            <p>Please wait...</p>
        </div>
    </div>
    <!-- #END# Page Loader -->
    <!-- Overlay For Sidebars -->
    <div class="overlay"></div>
    <!-- #END# Overlay For Sidebars -->
    <!-- Search Bar -->
    <div class="search-bar">
        <div class="search-icon">
            <i class="material-icons">search</i>
        </div>
        <input type="text" placeholder="START TYPING..." class="searchable-field">
        <div class="close-search">
            <i class="material-icons">close</i>
        </div>
    </div>
    <!-- #END# Search Bar -->
    <?php if( empty( $topbar ) ): ?>
        <?php echo $__env->make('partials.topbar', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php elseif( 'yes' === $topbar ): ?>
        <?php echo $__env->make('partials.topbar', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php endif; ?>

    <?php
    $style = '';
    $columns = 6;
    ?>
    <?php if( empty( $sidebar ) ): ?>
        <?php echo $__env->make('partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php elseif( 'yes' === $sidebar ): ?>
        <?php echo $__env->make('partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php else: ?>
    <?php $style = ' style="margin-left:0px;"'; ?>
    <?php endif; ?>

    <section class="content" <?php echo $style; ?>>
        <?php
        $parts = getController();
        // echo $parts['controller'] . '@' . $parts['action'];
        ?>
        <div class="col-md-12"><?php echo e(Breadcrumbs::render($parts['controller'] . '.' . $parts['action'])); ?></div>
        <div class="container-fluid">
            

            <?php if(env('DEMO_MODE')): ?>  
            <div class="col-md-12">
                <div class="alert alert-info demo-alert">
                &nbsp;&nbsp;&nbsp;<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                    <strong><?php echo app('translator')->getFromJson('global.info'); ?>!</strong> CRUD <?php echo app('translator')->getFromJson('global.operations_disabled'); ?>
                </div>
            </div>
            <?php endif; ?>

            <?php if($errors->count() > 0 && ! in_array($parts['controller'], array( 'TicketsController', 'StatusesController', 'PrioritiesController', 'AgentsController', 'ConfigurationsController', 'CategoriesController', 'AdministratorsController' ) )): ?>
            <div class="col-md-12">
                <div class="alert alert-danger">
                    <ul class="list-unstyled">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
            <?php endif; ?>

            <?php if(Session::has('message')): ?>
                <?php
                $message_type = getSetting('message_type', 'site_settings', 'onpage');
                if ( 'onpage' === $message_type ) {
                ?>
                <div class="col-md-12">
                    <div class="alert alert-<?php echo e(Session::get('status', 'info')); ?>">
                        &nbsp;&nbsp;&nbsp;<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                        <?php echo e(Session::get('message')); ?>

                    </div>
                </div>
            <?php } ?>
            <?php endif; ?>

            <?php echo $__env->yieldContent('content'); ?>
        </div>
    </section>

    <?php echo Form::open(['route' => 'logout', 'style' => 'display:none;', 'id' => 'logout']); ?>

<button type="submit">Logout</button>
<?php echo Form::close(); ?>


    <?php echo $__env->make('partials.javascripts', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <?php echo getSetting('google_analytics', 'seo_settings'); ?>


</body>

</html>
