<?php $request = app('Illuminate\Http\Request'); ?>
<section>
    <!-- Left Sidebar -->
    <aside id="leftsidebar" class="sidebar">
        <?php
        $userprofileplacement = getActiveTheme('user-profile-placement', 'Topbar');
        if ( 'Sidebar' === $userprofileplacement ) {
        ?>
        <!-- User Info -->
        <?php
        $contact = \App\Contact::where( 'id', '=', getContactId() )->first();
        if ( $contact ) {
            $name = $contact->first_name . ' ' . $contact->last_name;
            $image = '';
            $email = $contact->email;
            if ($contact->thumbnail && file_exists(public_path().'/thumb/' . $contact->thumbnail) ) {
                $image = asset(env('UPLOAD_PATH').'/thumb/'.$contact->thumbnail);
            }
        } else {                    
            $name = Auth::user()->name;
            $image = '';
            $email = Auth::user()->email;
        }
        ?>
        <div class="user-info">
            <?php if( ! empty( $image ) ): ?>
            <div class="image">
                <img src="<?php echo e($image); ?>" width="48" height="48" alt="<?php echo e($name); ?>" />
            </div>
            <?php endif; ?>
            <div class="info-container">
                <div class="name" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><?php echo e($name); ?></div>
                <div class="email"><?php echo e($email); ?></div>
                <div class="btn-group user-helper-dropdown">
                    <i class="material-icons" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">keyboard_arrow_down</i>
                    <ul class="dropdown-menu pull-right">
                        <li><a href="<?php echo e(route('admin.contacts.profile.edit')); ?>"><i class="material-icons">person</i>Profile</a></li>
                        <li role="separator" class="divider"></li>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoice_access')): ?>
                        <li>
                            <a href="<?php echo e(route('admin.invoices.index')); ?>">
                                <i class="fa fa-credit-card"></i>
                                <span><?php echo app('translator')->getFromJson('global.invoices.title'); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_access')): ?>
                        <li>
                            <a href="<?php echo e(route('admin.products.index')); ?>">
                                <i class="material-icons">shopping_cart</i>
                                <span><?php echo app('translator')->getFromJson('global.products.title'); ?></span>
                            </a>
                        </li><?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('order_access')): ?>
                        <li>
                            <a href="<?php echo e(route('admin.orders.index')); ?>">
                                <i class="fa fa-server"></i>
                                <span><?php echo app('translator')->getFromJson('orders::global.orders.list'); ?></span>
                            </a>
                        </li><?php endif; ?>
                        
                        <li role="separator" class="divider"></li>
                        <li>
                        <a href="#logout" onclick="$('#logout').submit();">
                            <i class="material-icons">input</i>
                            <?php echo app('translator')->getFromJson('global.app_logout'); ?>
                        </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- #User Info -->
        <?php } ?>
        <!-- Menu -->

        <div class="menu">
            <ul class="list">

            <?php
            $parts = getController();
            $controller = $parts['controller'];
            $action = $parts['action'];
           
            ?>
            <?php
            $use_dynamic_menu = getSetting('use-dynamic-menu', 'site_settings', 'No');
            if ( ! isAdmin() && 'Yes' === $use_dynamic_menu ) {
                $role = auth()->user()->role->first()->slug;
                
                if ( ! empty( $role ) ) {
                    $public_menu = \Harimayco\Menu\Models\Menus::byName( $role );
                    $theme = \Cookie::get('theme');
                    if ( empty( $theme ) ) {
                        $theme = 'bsb';
                    }

                    if ( $public_menu ) {
                        $public_menu = Menu::getByName( $role );
                        $parent_start = false;
                        foreach ($public_menu as $menu) {
                            if ( ! empty( $menu['theme'] ) && $theme != $menu['theme'] ) {
                                continue;
                            }                            

                            $query_string = str_replace($menu['link'], '',$request->fullUrl());

                            if ( 'heading' === $menu['link'] ) {
                                echo '<li class="header">'.$menu['label'].'</li>';
                                $parent_start = false;
                            } elseif ( ! empty( $menu['child'] ) ) {                               
                                
                                $isactive = false;
                                if ( (strpos($query_string, $menu['link'] ) ) !== false ) {
                                    $isactive = true;
                                }
                                foreach( $menu['child'] as $child ) {
                                    $query_string = str_replace($child['link'], '',$request->fullUrl());
                                    if ( (strpos($query_string, $child['link'] ) ) !== false ) {
                                        $isactive = true;
                                    }
                                }
                                ?>

                                <li class="<?php echo e(( $isactive ) ? 'active' : ''); ?>">
                                    <a href="#" class="menu-toggle">
                                        <?php if( ! empty( $menu['icon_html'] ) ): ?>
                                            <?php echo clean($menu['icon_html']); ?>

                                        <?php endif; ?>
                                        <span><?php echo e($menu['label']); ?>-<?php echo e($query_string); ?></span>                                        
                                    </a>
                                    <?php $__currentLoopData = $menu['child']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <ul class="ml-menu">                                       
                                        <li class="<?php echo e(( (strpos($query_string, $child['link'] ) ) !== false ) ? 'active' : ''); ?>">
                                            <a href="<?php echo e(url( $child['link'] )); ?>">
                                                <?php if( ! empty( $child['icon_html'] ) ): ?>
                                                    <?php echo clean($child['icon_html']); ?>

                                                <?php endif; ?>
                                                <span><?php echo e($child['label']); ?></span>
                                            </a>
                                        </li>
                                    </ul>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </li>                                
                                <?php
                            } else {
                                ?>
                                <li class="<?php echo e(( (strpos($query_string, $menu['link'] ) ) !== false ) ? 'active' : ''); ?>">
                                    <a href="<?php echo e(url( $menu['link'] )); ?>">
                                        <?php if( ! empty( $menu['icon_html'] ) ): ?>
                                            <?php echo clean($menu['icon_html']); ?>

                                        <?php endif; ?>
                                        <span><?php echo e($menu['label']); ?></span>
                                    </a>
                                </li>
                                <?php
                            }                           
                            ?>                            
                            <?php
                        }
                    }
                }
            }
            ?>

            <?php if( isAdmin() || 'No' === $use_dynamic_menu ): ?>
                <li class="<?php echo e($controller == 'HomeController' ? 'active' : ''); ?>">
                    <a href="<?php echo e(url('admin/dashboard')); ?>">
                        <i class="material-icons">dashboard</i>
                        <span class="title"><?php echo app('translator')->getFromJson('global.app_dashboard'); ?></span>
                    </a>
                </li>

                <?php if( isPluginActive( ['invoice', 'credit_note', 'quotes'] ) ): ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sale_access')): ?>
                    <li class="header"><?php echo app('translator')->getFromJson('custom.menu.sales'); ?></li>
                    <li class="<?php echo e(( in_array($controller, array('InvoicesController', 'QuotesController') ) && in_array($action, array('index', 'create', 'edit', 'show', 'destroy', 'uploadDocuments') ) ) ? 'active' : ''); ?>">
                        <a href="#" class="menu-toggle">
                            <i class="material-icons">view_list</i><span><?php echo app('translator')->getFromJson('global.sales.title'); ?></span>
                            
                        </a>
                        <ul class="ml-menu">
                            <?php if( isPluginActive('invoice') ): ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoice_access')): ?>
                                <li class="<?php echo e(( in_array($controller, array('InvoicesController') ) && in_array($action, array('index', 'edit', 'show', 'destroy', 'uploadDocuments') ) ) ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.invoices.index')); ?>">
                                        <i class="material-icons">event_note</i><span><?php echo app('translator')->getFromJson('global.invoices.title'); ?></span>
                                    </a>
                                </li>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoice_create')): ?>
                                <li class="<?php echo e(( in_array($controller, array('InvoicesController') ) && in_array($action, array('create') ) ) ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.invoices.create')); ?>">
                                        <i class="material-icons">add_box</i><span><?php echo app('translator')->getFromJson('custom.menu.create-invoice'); ?></span>
                                    </a>
                                </li>
                                <?php endif; ?>
                            <?php endif; ?>


                            <?php if( isPluginActive('credit_note') ): ?>
                                  <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('credit_note_access')): ?>
                                <li>
                                    <a href="<?php echo e(route('admin.credit_notes.index')); ?>">
                                        <i class="material-icons">file_copy</i>
                                        <span>Credit notes</span>
                                    </a>
                                </li>
                                <?php endif; ?>

                                   <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('credit_note_create')): ?>
                                <li>
                                    <a href="<?php echo e(route('admin.credit_notes.create')); ?>">
                                        <i class="material-icons">add_box</i>
                                        <span>New credit note</span>
                                    </a>
                                </li>
                                <?php endif; ?>
                            <?php endif; ?>


                            <?php if( File::exists(config('modules.paths.modules') . '/Quotes') && Module::find('quotes')->active && isPluginActive('quotes')): ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_access')): ?>
                                <li class="<?php echo e(( in_array($controller, array('QuotesController') ) && in_array($action, array('index', 'edit', 'show', 'destroy', 'uploadDocuments') ) ) ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.quotes.index')); ?>">
                                        <i class="material-icons">format_quote</i>
                                        <span><?php echo app('translator')->getFromJson('global.quotes.title'); ?></span>
                                    </a>
                                </li>
                                <?php endif; ?>
                            

                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quote_create')): ?>
                                <li class="<?php echo e(( in_array($controller, array('QuotesController') ) && in_array($action, array('create') ) ) ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.quotes.create')); ?>">
                                        <i class="material-icons">add_circle</i>
                                        <span><?php echo app('translator')->getFromJson('custom.menu.create-quote'); ?></span>
                                    </a>
                                </li>
                                <?php endif; ?>  
                            <?php endif; ?> 

                            <?php if( File::exists(config('modules.paths.modules') . '/Proposals') && Module::find('proposals')->active && isPluginActive('proposals')): ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_access')): ?>
                                <li>
                                    <a href="<?php echo e(route('admin.proposals.index')); ?>">
                                        <i class="material-icons">note</i>
                                        <span><?php echo app('translator')->getFromJson('proposals::custom.proposals.title'); ?></span>
                                    </a>
                                </li>
                                <?php endif; ?> 

                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('proposal_create')): ?>
                                <li>
                                    <a href="<?php echo e(route('admin.proposals.create')); ?>">
                                        <i class="material-icons">add_circle</i>
                                        <span><?php echo app('translator')->getFromJson('custom.menu.create-proposal'); ?></span>
                                    </a>
                                </li>
                                <?php endif; ?>
                            <?php endif; ?>

                            <?php if( File::exists(config('modules.paths.modules') . '/Contracts') && Module::find('contracts')->active && isPluginActive('contracts')): ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('contract_access')): ?>
                                <li>
                                    <a href="<?php echo e(route('admin.contracts.index')); ?>">
                                         <i class="material-icons">book</i>
                                        <span><?php echo app('translator')->getFromJson('contracts::global.contracts.title'); ?></span>
                                    </a>
                                </li>
                                <?php endif; ?> 

                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('contract_create')): ?>
                                <li>
                                    <a href="<?php echo e(route('admin.contracts.create')); ?>">
                                        <i class="material-icons">add_circle</i>
                                        <span><?php echo app('translator')->getFromJson('custom.menu.create-contract'); ?></span>
                                    </a>
                                </li>
                                <?php endif; ?>
                                
                            <?php endif; ?>                 
                           
                            
                        </ul>
                    </li>
                    <?php endif; ?>
                <?php endif; ?>

                <?php if( File::exists(config('modules.paths.modules') . '/RecurringInvoices') && Module::find('recurringinvoices')->active && isPluginActive('recurringinvoices')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('recurring_invoice_access')): ?>
            <li class="<?php echo e(( in_array($controller, array('RecurringInvoicesController', 'RecurringPeriodsController') ) && in_array($action, array('index', 'create', 'edit', 'show', 'destroy', 'uploadDocuments') ) ) ? 'active' : ''); ?>">
                <a href="#" class="menu-toggle">
                    <i class="material-icons">autorenew</i>
                    <span><?php echo app('translator')->getFromJson('global.recurring-invoices.title'); ?></span>
                   
                </a>
                <ul class="ml-menu">                
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('recurring_invoice_access')): ?>
                    <li class="<?php echo e(( in_array($controller, array('RecurringInvoicesController') ) && in_array($action, array('index', 'edit', 'show', 'destroy', 'uploadDocuments') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.recurring_invoices.index')); ?>">
                            <i class="material-icons">autorenew</i>
                            <span><?php echo app('translator')->getFromJson('global.recurring-invoices.title'); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('recurring_invoice_create')): ?>
                    <li class="<?php echo e(( in_array($controller, array('RecurringInvoicesController') ) && in_array($action, array('create') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.recurring_invoices.create')); ?>">
                            <i class="material-icons">add_circle</i>
                            <span><?php echo app('translator')->getFromJson('global.app_create'); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('recurring_period_access')): ?>
                    <li class="<?php echo e(( in_array($controller, array('RecurringPeriodsController') ) && in_array($action, array('index', 'create', 'edit', 'show', 'destroy') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.recurring_periods.index')); ?>">
                            <i class="material-icons">autorenew</i>
                            <span><?php echo app('translator')->getFromJson('global.recurring-periods.title'); ?></span>
                        </a>
                    </li><?php endif; ?>
                    
                </ul>
            </li><?php endif; ?>
            <?php endif; ?>

            <?php if( isPluginActive('product') ): ?>   
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_management_access')): ?>
                <li class="header"><?php echo app('translator')->getFromJson('custom.menu.stock'); ?></li>
                <li class="<?php echo e(( in_array( $request->segment(2), array( 'products', 'product_categories', 'product-tags', 'products_transfers', 'brands' ) ) || in_array( $controller, array('BrandsController', 'MeasurementUnitsController', 'WarehousesController') ) ) ? 'active' : ''); ?>">
                    <a href="#" class="menu-toggle">
                        <i class="material-icons">store</i>
                        <span><?php echo app('translator')->getFromJson('global.product-management.title'); ?></span>
                        
                    </a>
                    <ul class="ml-menu">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_access')): ?>
                        <li class="<?php echo e(( in_array($controller, array('ProductsController') ) && in_array($action, array('index', 'edit', 'show', 'destroy') ) ) ? 'active' : ''); ?>">
                            <a href="<?php echo e(route('admin.products.index')); ?>">
                                <i class="material-icons">shopping_cart</i>
                                <span><?php echo app('translator')->getFromJson('global.products.title'); ?></span>
                            </a>
                        </li><?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_category_access')): ?>
                        <li class="<?php echo e(( $request->segment(2) == 'product_categories' ) ? 'active' : ''); ?>">
                            <a href="<?php echo e(url('admin/product_categories')); ?>">
                                <i class="material-icons">category</i>
                                <span><?php echo app('translator')->getFromJson('global.product-categories.title'); ?></span>
                            </a>
                        </li><?php endif; ?>
                        
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products_transfer_access')): ?>
                        <li class="<?php echo e(( $request->segment(2) == 'products_transfers' ) ? 'active' : ''); ?>">
                            <a href="<?php echo e(route('admin.products_transfers.index')); ?>">
                                <i class="material-icons">transfer_within_a_station</i>
                                <span><?php echo app('translator')->getFromJson('global.products-transfer.title'); ?></span>
                            </a>
                        </li><?php endif; ?>
                        
                        
                        
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('brand_access')): ?>
                        <li class="<?php echo e(( in_array($controller, array('BrandsController') ) && in_array($action, array('index', 'edit', 'show', 'destroy') ) ) ? 'active' : ''); ?>">
                            <a href="<?php echo e(route('admin.brands.index')); ?>">
                                <i class="material-icons">branding_watermark</i>
                                <span><?php echo app('translator')->getFromJson('global.brands.title'); ?></span>
                            </a>
                        </li><?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('measurement_unit_access')): ?>
                        <li class="<?php echo e(( in_array($controller, array('MeasurementUnitsController') ) && in_array($action, array('index', 'create', 'edit', 'show', 'destroy') ) ) ? 'active' : ''); ?>">
                            <a href="<?php echo e(route('admin.measurement_units.index')); ?>">
                                <i class="material-icons">adjust</i>
                                <span><?php echo app('translator')->getFromJson('global.measurement-units.title'); ?></span>
                            </a>
                        </li><?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse_access')): ?>
                        <li class="<?php echo e(( in_array($controller, array('WarehousesController') ) && in_array($action, array('index', 'edit', 'show', 'destroy') ) ) ? 'active' : ''); ?>">
                            <a href="<?php echo e(route('admin.warehouses.index')); ?>">
                                <i class="material-icons">language</i>
                                <span><?php echo app('translator')->getFromJson('global.warehouses.title'); ?></span>
                            </a>
                        </li><?php endif; ?>
                        
                    </ul>
                </li><?php endif; ?>
               <?php endif; ?>

               <?php if( isPluginActive('purchase_order') ): ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase_order_access')): ?>
                <li class="<?php echo e(( $request->segment(2) == 'purchase_orders' ) ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('admin.purchase_orders.index')); ?>">
                        <i class="material-icons">add_shopping_cart</i>
                        <span><?php echo app('translator')->getFromJson('global.purchase-orders.title'); ?></span>
                    </a>
                </li><?php endif; ?>
            <?php endif; ?>

            <?php if( Gate::allows('contact_access') 
        && Gate::allows('contact_create') 
        && Gate::allows('contact_company_access') 
        && Gate::allows('country_access') 
        && Gate::allows('contact_group_access') 
        && Gate::allows('contact_type_access') 
        && Gate::allows('contact_note_access') 
        && Gate::allows('contact_document_access') 
        && Gate::allows('contact_mailchimp_email_campaigns') 
        ): ?> 
            <!-- start contact management -->
            <!-- contacts -->
            <li class="header"><?php echo app('translator')->getFromJson('custom.menu.crm'); ?></li>
               <li class="<?php echo e(( in_array($controller, array('ContactsController', 'ContactCompaniesController', 'ContactGroupsController', 'ContactTypesController', 'ContactNotesController', 'ContactDocumentsController', 'CountriesController') ) && in_array($action, array('index', 'create', 'edit', 'show', 'destroy') ) ) ? 'active' : ''); ?>">
                <a href="#" class="menu-toggle">
                    <i class="material-icons">contact_phone</i>
                    <span><?php echo app('translator')->getFromJson('global.contact-management.title'); ?></span>
                    
                </a>

                
                <ul class="ml-menu">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('contact_access')): ?>
                    <li class="<?php echo e(( in_array($controller, array('ContactsController') ) && in_array($action, array('index', 'edit', 'show', 'destroy') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.contacts.index')); ?>">
                            <i class="material-icons">add_circle</i>
                            <span><?php echo app('translator')->getFromJson('global.contacts.title'); ?></span>
                        </a>
                    </li>
                     <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('contact_create')): ?>
                    <li class="<?php echo e(( in_array($controller, array('ContactsController') ) && in_array($action, array('create') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.contacts.create')); ?>">
                            <i class="material-icons">add_box</i>
                            <span><?php echo app('translator')->getFromJson('custom.menu.create-contact'); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('contact_company_access')): ?>
                    <li class="<?php echo e(( in_array($controller, array('ContactCompaniesController') ) && in_array($action, array('index', 'create', 'edit', 'show', 'destroy') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.contact_companies.index')); ?>">
                            <i class="material-icons">view_comfy</i>
                            <span><?php echo app('translator')->getFromJson('global.contact-companies.title'); ?></span>
                        </a>
                    </li><?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('country_access')): ?>
                    <li class="<?php echo e(( in_array($controller, array('CountriesController') ) && in_array($action, array('index', 'create', 'edit', 'show', 'destroy') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.countries.index')); ?>">
                            <i class="material-icons">language</i>
                            <span><?php echo app('translator')->getFromJson('global.countries.title'); ?></span>
                        </a>
                    </li><?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('contact_group_access')): ?>
                    <li class="<?php echo e(( $request->segment(2) == 'contact_groups' ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.contact_groups.index')); ?>">
                            <i class="material-icons">contacts</i>
                            <span><?php echo app('translator')->getFromJson('global.contact-groups.title'); ?></span>
                        </a>
                    </li><?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('contact_type_access')): ?>
                    <li class="<?php echo e(( $request->segment(2) == 'contact_types' ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.contact_types.index')); ?>">
                            <i class="material-icons">perm_contact_calendar</i>
                            <span><?php echo app('translator')->getFromJson('global.contact-types.title'); ?></span>
                        </a>
                    </li><?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('contact_note_access')): ?>
                    <li class="<?php echo e(( $request->segment(2) == 'contact_notes') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.contact_notes.index')); ?>">
                            <i class="material-icons">import_contacts</i>
                            <span><?php echo app('translator')->getFromJson('global.contact-notes.title'); ?></span>
                        </a>
                    </li><?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('contact_document_access')): ?>
                    <li class="<?php echo e(( $request->segment(2) == 'contact_documents' ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.contact_documents.index')); ?>">
                            <i class="material-icons">file_copy</i>
                            <span><?php echo app('translator')->getFromJson('global.contact-documents.title'); ?></span>
                        </a>
                    </li><?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('contact_mailchimp_email_campaigns')): ?>
                    <li>
                        <a href="<?php echo e(route('admin.contacts.mailchimp-email-campaigns')); ?>">
                            <i class="material-icons">email</i>
                            <span><?php echo app('translator')->getFromJson('global.contacts.mailchimp-email-campaigns'); ?></span>
                        </a>
                    </li><?php endif; ?>
                </ul>
            </li>
           <?php endif; ?> 

           <?php if( isPluginActive('user') ): ?>
          <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user_management_access')): ?>
            <li class="<?php echo e(( in_array( $request->segment(2), array( 'permissions', 'roles', 'users', 'user_actions', 'departments' ) ) ) ? 'active' : ''); ?>">
                <a href="#" class="menu-toggle">
                    <i class="material-icons">supervisor_account</i>
                    <span><?php echo app('translator')->getFromJson('global.user-management.title'); ?></span>
                    
                </a>
                <ul class="ml-menu">
                    <?php if( isEnable('debug') ): ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('permission_access')): ?>
                            <li class="<?php echo e(( $request->segment(2) == 'permissions' ) ? 'active' : ''); ?>">
                                <a href="<?php echo e(url('admin/permissions')); ?>">
                                    <i class="material-icons">business_center</i>
                                    <span><?php echo app('translator')->getFromJson('global.permissions.title'); ?></span>
                                </a>
                            </li><?php endif; ?>
                    <?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('role_access')): ?>
                    <li class="<?php echo e(( $request->segment(2) == 'roles' ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(url('admin/roles')); ?>">
                            <i class="material-icons">security</i>
                            <span><?php echo app('translator')->getFromJson('global.roles.title'); ?></span>
                        </a>
                    </li><?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user_access')): ?>
                    <li class="<?php echo e(( $request->segment(2) == 'users' ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.users.index')); ?>">
                            <i class="material-icons">people</i>
                            <span><?php echo app('translator')->getFromJson('global.users.title'); ?></span>
                        </a>
                    </li><?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user_action_access')): ?>
                    <li class="<?php echo e(( $request->segment(2) == 'user_actions' ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.user_actions.index')); ?>">
                            <i class="material-icons">accessible_forward</i>
                            <span><?php echo app('translator')->getFromJson('global.user-actions.title'); ?></span>
                        </a>
                    </li><?php endif; ?>

           

                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('department_access')): ?>
                    <li class="<?php echo e(( $request->segment(2) == 'departments' ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.departments.index')); ?>">
                            <i class="material-icons">domain</i>
                            <span><?php echo app('translator')->getFromJson('global.departments.title'); ?></span>
                        </a>
                    </li><?php endif; ?>
                    
                    
                </ul>
            </li><?php endif; ?>
            <?php endif; ?>

            <?php if( isPluginActive('lead') ): ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('contact_access')): ?>
                <li class="<?php echo e(( $request->segment(2) == 'user_actions' ) ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('admin.list_contacts.index', [ 'type' => 'contact_type', 'type_id' => LEADS_TYPE ])); ?>">
                        <i class="material-icons">accessibility</i>
                        <span><?php echo app('translator')->getFromJson('global.contacts.title_leads'); ?></span>
                    </a>
                </li>
                <?php endif; ?>
            <?php endif; ?>

            <!-- client projects -->
        <?php if( isPluginActive('client_project') ): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('project_access')): ?>
            <li class="header"><?php echo app('translator')->getFromJson('custom.menu.project'); ?></li>
            <li class="<?php echo e(( in_array( $request->segment(2), array( 'client_projects', 'project_billing_types', 'project_statuses' ) ) ) ? 'active' : ''); ?>">
                <a href="#" class="menu-toggle">
                    <i class="material-icons">assignment</i>
                    <span><?php echo app('translator')->getFromJson('global.projects.title'); ?></span>
                    
                </a>
                <ul class="ml-menu">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('client_project_access')): ?>
                    <li class="<?php echo e(( $request->segment(2) == 'client_projects' ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.client_projects.index')); ?>">
                            <i class="material-icons">assessment</i>
                            <span><?php echo app('translator')->getFromJson('global.client-projects.title'); ?></span>
                        </a>
                    </li><?php endif; ?>


                       <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('project_status_access')): ?>
                    <li class="<?php echo e(( $request->segment(2) == 'project_statuses' ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.project_statuses.index')); ?>">
                            <i class="material-icons">trending_up</i>
                            <span><?php echo app('translator')->getFromJson('global.project-statuses.title'); ?></span>
                        </a>
                    </li><?php endif; ?>

                   <?php if( isEnable('debug') ): ?>    
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('project_billing_type_access')): ?>
                        <li class="<?php echo e(( $request->segment(2) == 'project_billing_types' ) ? 'active' : ''); ?>">
                            <a href="<?php echo e(route('admin.project_billing_types.index')); ?>">
                                <i class="material-icons">money</i>
                                <span><?php echo app('translator')->getFromJson('global.project-billing-types.title'); ?></span>
                            </a>
                        </li><?php endif; ?>
                    <?php endif; ?>

                    <?php if( isEnable('debug') ): ?>    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('project_tab_access')): ?>
                    <li class="<?php echo e(( $request->segment(2) == 'project_statuses' ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.project_tabs.index')); ?>">
                            <i class="material-icons">tab</i>
                            <span><?php echo app('translator')->getFromJson('global.project-tabs.title'); ?></span>
                        </a>
                    </li><?php endif; ?>
                    <?php endif; ?>




                    
                </ul>
            </li><?php endif; ?>
        <?php endif; ?>
            <!-- end client projects -->

         <?php if( isPluginActive('account') ): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('expense_management_access')): ?>
            <li class="header"><?php echo app('translator')->getFromJson('custom.menu.balance'); ?></li>
            <li class="<?php echo e(( in_array( $request->segment(2), array( 'incomes', 'expenses', 'expense_categories', 'income_categories', 'monthly_reports', 'transfers', 'accounts' ) ) ) ? 'active' : ''); ?>">
                <a href="#" class="menu-toggle">
                    <i class="material-icons">credit_card</i>
                    <span><?php echo app('translator')->getFromJson('global.expense-management.title'); ?></span>
                    
                </a>
                <ul class="ml-menu">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('income_access')): ?>
                    <li class="<?php echo e(( $request->segment(2) == 'incomes' ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.incomes.index')); ?>">
                            <i class="material-icons">arrow_forward</i>
                            <span><?php echo app('translator')->getFromJson('global.income.title-incomes'); ?></span>
                        </a>
                    </li><?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('expense_access')): ?>
                    <li class="<?php echo e(( $request->segment(2) == 'expenses' ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.expenses.index')); ?>">
                            <i class="material-icons">arrow_back</i>
                            <span><?php echo app('translator')->getFromJson('global.expense.title'); ?></span>
                        </a>
                    </li><?php endif; ?>

                     <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('income_category_access')): ?>
                    <li class="<?php echo e(( $request->segment(2) == 'income_categories' ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.income_categories.index')); ?>">
                            <i class="material-icons">input</i>
                            <span><?php echo app('translator')->getFromJson('global.income-category.title'); ?></span>
                        </a>
                    </li><?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('expense_category_access')): ?>
                    <li class="<?php echo e(( $request->segment(2) == 'expense_categories' ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.expense_categories.index')); ?>">
                            <i class="material-icons">account_balance_wallet</i>
                            <span><?php echo app('translator')->getFromJson('global.expense-category.title'); ?></span>
                        </a>
                    </li><?php endif; ?>
                    
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('monthly_report_access')): ?>
                    <li class="<?php echo e(( $request->segment(2) == 'monthly_reports' ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.monthly_reports.index')); ?>">
                            <i class="material-icons">pie_chart</i>
                            <span><?php echo app('translator')->getFromJson('global.monthly-report.title'); ?></span>
                        </a>
                    </li><?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('transfer_access')): ?>
                    <li class="<?php echo e(( $request->segment(2) == 'transfers' ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.transfers.index')); ?>">
                            <i class="material-icons">account_balance</i>
                            <span><?php echo app('translator')->getFromJson('global.transfers.title'); ?></span>
                        </a>
                    </li><?php endif; ?>                   
                    

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('account_access')): ?>
                    <li class="<?php echo e(( $request->segment(2) == 'accounts' ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.accounts.index')); ?>">
                            <i class="material-icons">business_center</i>
                            <span><?php echo app('translator')->getFromJson('global.accounts.title'); ?></span>
                        </a>
                    </li><?php endif; ?>
                    
                </ul>
            </li><?php endif; ?> 
        <?php endif; ?>

        <?php if( isPluginActive('order') ): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('order_access')): ?>
            <li class="<?php echo e(( in_array( $request->segment(2), array( 'orders' ) ) ) ? 'active' : ''); ?>">
                <a href="#" class="menu-toggle">
                    <i class="material-icons">add_shopping_cart</i>
                    <span><?php echo app('translator')->getFromJson('orders::global.orders.title'); ?></span>
                    
                </a>
                <ul class="ml-menu">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('order_access')): ?>
                    <li class="<?php echo e(( $request->segment(2) == 'orders' && empty( $request->segment(3) ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.orders.index')); ?>">
                            <i class="material-icons">view_list</i>
                            <span><?php echo app('translator')->getFromJson('orders::global.orders.list'); ?></span>
                        </a>
                    </li><?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('order_create')): ?>
                    <li class="<?php echo e(( $request->segment(2) == 'orders' && $request->segment(3) == 'create' ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.orders.create')); ?>">
                            <i class="material-icons">create_new_folder</i>
                            <span><?php echo app('translator')->getFromJson('orders::global.orders.place-new-order'); ?></span>
                        </a>
                    </li><?php endif; ?>
                </ul>
            </li>            
            <?php endif; ?>   
        <?php endif; ?> 

        <li class="header"><?php echo app('translator')->getFromJson('custom.menu.miscellaneous'); ?></li>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('task_management_access')): ?>
            <li class="<?php echo e(( in_array( $request->segment(2), array( 'tasks', 'task_statuses', 'task_tags', 'task_calendars', 'calendartasks' ) ) ) ? 'active' : ''); ?>">
                <a href="#" class="menu-toggle">
                    <i class="material-icons">chrome_reader_mode</i>
                    <span><?php echo app('translator')->getFromJson('global.task-management.title'); ?></span>
                    
                </a>
                <ul class="ml-menu">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('task_access')): ?>
                    <li class="<?php echo e(( $request->segment(2) == 'tasks' ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.tasks.index')); ?>">
                            <i class="material-icons">list</i>
                            <span><?php echo app('translator')->getFromJson('global.tasks.title'); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('task_status_access')): ?>
                    <li class="<?php echo e(( $request->segment(2) == 'task_statuses') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.task_statuses.index')); ?>">
                            <i class="material-icons">hourglass_full</i>
                            <span><?php echo app('translator')->getFromJson('global.task-statuses.title'); ?></span>
                        </a>
                    </li><?php endif; ?>
                    
                
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('task_calendar_access')): ?>
                    <li class="<?php echo e(( $request->segment(2) == 'task_calendars' ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.task_calendars.index')); ?>">
                            <i class="material-icons">calendar_today</i>
                            <span><?php echo app('translator')->getFromJson('global.task-calendar.title'); ?></span>
                        </a>
                    </li><?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('task_calendar_access')): ?>
                    <li class="<?php echo e(( $request->segment(2) == 'calendartasks' && $request->segment(3) == 'tasksstatuses' ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.calendartasks.calendar.taskstatus')); ?>">
                            <i class="material-icons">vertical_split</i>
                            <span><?php echo app('translator')->getFromJson('global.task-calendar.status-wise'); ?></span>
                        </a>
                    </li><?php endif; ?>

                    
                    
                </ul>
            </li><?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('assets_management_access')): ?>
            <li class="<?php echo e(( in_array($controller, array('AssetsController', 'AssetsCategoriesController', 'AssetsLocationsController', 'AssetsStatusesController', 'AssetsHistoriesController') ) && in_array($action, array('index', 'create', 'edit', 'show', 'destroy', 'uploadDocuments') ) ) ? 'active' : ''); ?>">
                <a href="#" class="menu-toggle">
                    <i class="material-icons">assignment_turned_in</i>
                    <span><?php echo app('translator')->getFromJson('global.assets-management.title'); ?></span>
                    
                </a>
                <ul class="ml-menu">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('asset_access')): ?>
                    <li class="<?php echo e(( in_array($controller, array('AssetsController') ) && in_array($action, array('index', 'create', 'edit', 'show', 'destroy', 'uploadDocuments') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.assets.index')); ?>">
                            <i class="material-icons">assignment</i>
                            <span><?php echo app('translator')->getFromJson('global.assets.title'); ?></span>
                        </a>
                    </li><?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('assets_category_access')): ?>
                    <li class="<?php echo e(( in_array($controller, array('AssetsCategoriesController') ) && in_array($action, array('index', 'create', 'edit', 'show', 'destroy', 'uploadDocuments') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.assets_categories.index')); ?>">
                            <i class="material-icons">category</i>
                            <span><?php echo app('translator')->getFromJson('global.assets-categories.title'); ?></span>
                        </a>
                    </li><?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('assets_location_access')): ?>
                    <li class="<?php echo e(( in_array($controller, array('AssetsLocationsController') ) && in_array($action, array('index', 'create', 'edit', 'show', 'destroy', 'uploadDocuments') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.assets_locations.index')); ?>">
                            <i class="material-icons">location_on</i>
                            <span><?php echo app('translator')->getFromJson('global.assets-locations.title'); ?></span>
                        </a>
                    </li><?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('assets_status_access')): ?>
                    <li class="<?php echo e(( in_array($controller, array('AssetsStatusesController') ) && in_array($action, array('index', 'create', 'edit', 'show', 'destroy', 'uploadDocuments') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.assets_statuses.index')); ?>">
                            <i class="material-icons">hourglass_full</i>
                            <span><?php echo app('translator')->getFromJson('global.assets-statuses.title'); ?></span>
                        </a>
                    </li><?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('assets_history_access')): ?>
                    <li class="<?php echo e(( in_array($controller, array('AssetsHistoriesController') ) && in_array($action, array('index', 'create', 'edit', 'show', 'destroy', 'uploadDocuments') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.assets_histories.index')); ?>">
                            <i class="material-icons">history</i>
                            <span><?php echo app('translator')->getFromJson('global.assets-history.title'); ?></span>
                        </a>
                    </li><?php endif; ?>
                    
                </ul>
            </li>
            <?php endif; ?>



            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('internal_notification_access')): ?>
            
            <li class="<?php echo e(( in_array( $request->segment(1), array( 'internal_notifications' ) ) || ( in_array($controller, array('SendSmsController') ) && in_array($action, array('index', 'create', 'edit', 'show', 'destroy') ) ) ) ? 'active' : ''); ?>">
                <a href="#" class="menu-toggle">
                    <i class="material-icons">notifications</i><span><?php echo app('translator')->getFromJson('global.internal-notifications.title'); ?></span>
                    
                </a>
                <ul class="ml-menu">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('internal_notification_access')): ?>
                    <li class="<?php echo e(( $request->segment(2) == 'internal_notifications' ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.internal_notifications.index')); ?>">
                            <i class="material-icons">notifications</i><span><?php echo app('translator')->getFromJson('global.internal-notifications.title'); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>

                    <?php if( File::exists(config('modules.paths.modules') . '/Sendsms') && Module::find('sendsms')->active && isPluginActive('Sendsms')): ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('send_sm_access')): ?>
                        <li class="<?php echo e(( in_array($controller, array('SendSmsController') ) && in_array($action, array('index', 'create', 'edit', 'show', 'destroy') ) ) ? 'active' : ''); ?>">
                            <a href="<?php echo e(route('admin.send_sms.index')); ?>">
                                <i class="material-icons">sms</i><span><?php echo app('translator')->getFromJson('sendsms::global.send-sms.title'); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                    <?php endif; ?>
                    
                    
                </ul>
            </li><?php endif; ?>

         <!-- knowledgebase_access -->

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('knowledgebase_access')): ?>
            <li class="<?php echo e(( in_array( $request->segment(1), array( 'tickets' ) ) || in_array( $request->segment(2), array(  'articles', 'faq_questions', 'faq_categories' ) ) ) ? 'active' : ''); ?>">
                <a href="#" class="menu-toggle">
                    <i class="material-icons">battery_charging_full</i>
                    <span><?php echo app('translator')->getFromJson('global.knowledgebase.title'); ?></span>
                    
                </a>
                <ul class="ml-menu">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('support_access')): ?>
                    <li class="<?php echo e(( $request->segment(1) == 'tickets' ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('tickets.index')); ?>">
                            <i class="material-icons">phone_in_talk</i>
                            <span><?php echo app('translator')->getFromJson('global.support.title'); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>



                   
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('faq_management_access')): ?>
                    <li class="<?php echo e(( $request->segment(2) == 'faq_questions' ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.faq_questions.index')); ?>">
                            <i class="material-icons">contact_support</i>
                            <span><?php echo app('translator')->getFromJson('global.faq-management.faq'); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('faq_category_access')): ?>
                    <li class="<?php echo e(( $request->segment(2) == 'faq_categories' ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.faq_categories.index')); ?>">
                            <i class="material-icons">category</i>
                            <span><?php echo app('translator')->getFromJson('global.faq-categories.title'); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    
                </ul>
            </li><?php endif; ?>
             <!-- end knowledgebase_access  -->

                    <!-- content management -->
              <?php if( isPluginActive( ['content_management', 'article'] ) ): ?>      
                  <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('content_management_access')): ?>
            <li class="<?php echo e(( in_array( $request->segment(2), array( 'content_categories', 'content_tags', 'content_pages' ) ) ) ? 'active' : ''); ?>">
                <a href="#" class="menu-toggle">
                    <i class="material-icons">ballot</i>
                    <span><?php echo app('translator')->getFromJson('global.content-management.title'); ?></span>
                    
                </a>
                <ul class="ml-menu">
                   <?php if( isPluginActive( 'content_management' ) ): ?>  
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('content_category_access')): ?>

                    <li class="<?php echo e(( $request->segment(2) == 'content_categories' ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.content_categories.index')); ?>">
                            <i class="material-icons">view_stream</i>
                            <span><?php echo app('translator')->getFromJson('global.content-categories.title'); ?></span>
                        </a>
                    </li><?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('content_tag_access')): ?>
                    <li class="<?php echo e(( $request->segment(2) == 'content_tags' ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.content_tags.index')); ?>">
                            <i class="material-icons">label</i>
                            <span><?php echo app('translator')->getFromJson('global.content-tags.title'); ?></span>
                        </a>
                    </li><?php endif; ?>


                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('content_page_access')): ?>
                    <li class="<?php echo e(( $request->segment(2) == 'content_pages' ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.content_pages.index')); ?>">
                            <i class="material-icons">pages</i>
                            <span><?php echo app('translator')->getFromJson('global.content-pages.title'); ?></span>
                        </a>
                    </li><?php endif; ?>

                   <?php endif; ?> 
                      
                    <?php if( isPluginActive( 'article' ) ): ?>  
                       <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('article_access')): ?>
                    <li class="<?php echo e(( $request->segment(2) == 'articles' ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.articles.index')); ?>">
                            <i class="material-icons">view_array</i>
                            <span><?php echo app('translator')->getFromJson('global.articles.title'); ?></span>
                        </a>
                    </li><?php endif; ?>
                    <?php endif; ?>
                    
                </ul>
            </li>
            <?php endif; ?>
            <?php endif; ?>   

             <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('global_setting_access')): ?>
            <li class="<?php echo e(( in_array($controller, array('MasterSettingsController', 'GeneralSettingsController', 'CurrenciesController', 'TemplatesController', 'SmstemplatesController', 'CompaniesController', 'PaymentGatewaysController', 'TaxesController', 'DiscountsController', 'Controller', 'DatabaseBackupsController', 'NavigationMenuesController', 'SiteThemesController', 'LanguagesController') ) && in_array($action, array('index', 'create', 'edit', 'show', 'destroy', 'viewSettings', 'addSubSettings', 'getIndex') ) ) ? 'active' : ''); ?>">
                <a href="#" class="menu-toggle">
                    <i class="material-icons">perm_data_setting</i>
                    <span><?php echo app('translator')->getFromJson('global.global-settings.title'); ?></span>
                    
                </a>
                <ul class="ml-menu">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('master_setting_access')): ?>
                    <li class="<?php echo e(( in_array($controller, array('MasterSettingsController', 'GeneralSettingsController') ) && in_array($action, array('index', 'edit', 'show', 'destroy', 'viewSettings', 'addSubSettings') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.master_settings.index')); ?>">
                            <i class="material-icons">settings_applications</i>
                            <span><?php echo app('translator')->getFromJson('global.master-settings.title'); ?></span>
                        </a>
                    </li><?php endif; ?>

                     <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('dynamic_option_access')): ?>
                    <li class="<?php echo e(( in_array($controller, array('DynamicOptionsController') ) && in_array($action, array('index', 'create', 'edit', 'show', 'destroy') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.dynamic_options.index')); ?>">
                            <i class="material-icons">settings_overscan</i>
                            <span><?php echo app('translator')->getFromJson('global.dynamic-options.title'); ?></span>
                        </a>
                    </li><?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('currency_access')): ?>
                    <li class="<?php echo e(( in_array($controller, array('CurrenciesController') ) && in_array($action, array('index', 'create', 'edit', 'show', 'destroy') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.currencies.index')); ?>">
                            <i class="material-icons">attach_money</i>
                            <span><?php echo app('translator')->getFromJson('global.currencies.title'); ?></span>
                        </a>
                    </li><?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('template_access')): ?>
                    <li class="<?php echo e(( in_array($controller, array('TemplatesController') ) && in_array($action, array('index', 'create', 'edit', 'show', 'destroy') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.templates.index')); ?>">
                            <i class="material-icons">view_module</i>
                            <span><?php echo app('translator')->getFromJson('templates::global.templates.email-templates'); ?></span>
                        </a>
                    </li><?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('smstemplate_access')): ?>
                    <li class="<?php echo e(( in_array($controller, array('SmstemplatesController') ) && in_array($action, array('index', 'create', 'edit', 'show', 'destroy') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.smstemplates.index')); ?>">
                            <i class="material-icons">textsms</i>
                            <span><?php echo app('translator')->getFromJson('smstemplates::global.smstemplates.title'); ?></span>
                        </a>
                    </li><?php endif; ?>    
                    
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('payment_gateway_access')): ?>
                    <li class="<?php echo e(( in_array($controller, array('PaymentGatewaysController') ) && in_array($action, array('index', 'create', 'edit', 'show', 'destroy') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.payment_gateways.index')); ?>">
                            <i class="material-icons">payment</i>
                            <span><?php echo app('translator')->getFromJson('global.payment-gateways.title'); ?></span>
                        </a>
                    </li><?php endif; ?>
                    
                    
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('tax_access')): ?>
                    <li class="<?php echo e(( in_array($controller, array('TaxesController') ) && in_array($action, array('index', 'create', 'edit', 'show', 'destroy') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.taxes.index')); ?>">
                            <i class="material-icons">settings_overscan</i>
                            <span><?php echo app('translator')->getFromJson('global.taxes.title'); ?></span>
                        </a>
                    </li><?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('discount_access')): ?>
                    <li class="<?php echo e(( in_array($controller, array('DiscountsController') ) && in_array($action, array('index', 'create', 'edit', 'show', 'destroy') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.discounts.index')); ?>">
                            <i class="material-icons">attach_money</i>
                            <span><?php echo app('translator')->getFromJson('global.discounts.title'); ?></span>
                        </a>
                    </li><?php endif; ?>
                                       
                   
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('translation_manager')): ?>
                    <li class="<?php echo e(( in_array($controller, array('Controller') ) && in_array($action, array('getIndex', 'create', 'edit', 'show', 'destroy') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(URL_TRANSLATIONS); ?>">
                            <i class="material-icons">translate</i>
                            <span><?php echo app('translator')->getFromJson('custom.translations.title'); ?></span>
                        </a>
                    </li><?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('language_access')): ?>
                    <li class="<?php echo e(( in_array($controller, array('LanguagesController') ) && in_array($action, array('index', 'create', 'edit', 'show', 'destroy') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.languages.index')); ?>">
                            <i class="material-icons">language</i>
                            <span><?php echo app('translator')->getFromJson('global.languages.title'); ?></span>
                        </a>
                    </li><?php endif; ?>
                                        
                    

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('database_backup_access')): ?>
                    <li class="<?php echo e(( in_array($controller, array('DatabaseBackupsController') ) && in_array($action, array('index', 'create', 'create', 'edit', 'show', 'destroy') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.database_backups.index')); ?>">
                            <i class="material-icons">backup</i>
                            <span><?php echo app('translator')->getFromJson('global.database-backup.title'); ?></span>
                        </a>
                    </li><?php endif; ?>



                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('site_theme_access')): ?>
                    <li class="<?php echo e(( in_array($controller, array('SiteThemesController') ) && in_array($action, array('index', 'create', 'edit', 'show', 'destroy') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.site_themes.index')); ?>">
                            <i class="material-icons">color_lens</i>
                            <span><?php echo app('translator')->getFromJson('sitethemes::global.site-themes.title'); ?></span>
                        </a>
                    </li><?php endif; ?>

                    <?php
                    echo $value = Eventy::filter('global_settings.menu', '');
                    ?>

                       <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('widget_access')): ?>
                    <li class="<?php echo e(( in_array($controller, array('HomeController') ) && in_array($action, array('index', 'create', 'edit', 'show', 'destroy') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.home.dashboard-widgets')); ?>">
                            <i class="material-icons">widgets</i>
                            <span><?php echo app('translator')->getFromJson('global.dashboard-widgets.title'); ?></span>
                        </a>
                    </li><?php endif; ?>
                    
                </ul>
            </li><?php endif; ?>
            
            
            
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reports_access')): ?>
            <li class="<?php echo e(( in_array($controller, array('ReportsController') ) ) ? 'active' : ''); ?>">
                <a href="#" class="menu-toggle">
                    <i class="material-icons">report</i>
                    <span class="title"><?php echo app('translator')->getFromJson('custom.reports.generated-reports'); ?></span>
                    
                </a>
                <ul class="ml-menu">

                     <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reports_income_access')): ?>
                    <li class="<?php echo e(( in_array($controller, array('ReportsController') ) && in_array($action, array('incomeReport') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(url('/admin/reports/income-report')); ?>">
                            <i class="material-icons">show_chart</i>
                            <span class="title"><?php echo app('translator')->getFromJson('custom.reports.income-report'); ?></span>
                        </a>
                    </li>
                     <?php endif; ?>

                   <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reports_expense_access')): ?>
                   <li class="<?php echo e(( in_array($controller, array('ReportsController') ) && in_array($action, array('expenseReport') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(url('/admin/reports/expense-report')); ?>">
                            <i class="material-icons">bar_chart</i>
                            <span class="title"><?php echo app('translator')->getFromJson('custom.reports.expense-report'); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>                    
                   

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reports_users_access')): ?>
                    <li class="<?php echo e(( in_array($controller, array('ReportsController') ) && in_array($action, array('usersReport') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(url('/admin/reports/users-report')); ?>">
                            <i class="material-icons">table_chart</i>
                            <span class="title"><?php echo app('translator')->getFromJson('custom.reports.users-report'); ?></span>
                        </a>
                    </li>
                     <?php endif; ?>

                       <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reports_users_access')): ?>
                    <li class="<?php echo e(( in_array($controller, array('ReportsController') ) && in_array($action, array('rolesUsersReport') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(url('/admin/reports/roles-users-report')); ?>">
                            <i class="material-icons">graphic_eq</i>
                            <span class="title"><?php echo app('translator')->getFromJson('others.reports.users-roles-report'); ?></span>
                        </a>
                    </li>
                     <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reports_projects_access')): ?>
                    <li class="<?php echo e(( in_array($controller, array('ReportsController') ) && in_array($action, array('contactsProjectsReports') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(url('/admin/reports/contacts-projects-reports')); ?>">
                            <i class="material-icons">insert_chart</i>
                            <span class="title"><?php echo app('translator')->getFromJson('custom.reports.projects-report'); ?></span>
                        </a>
                    </li>
                     <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reports_tasks_access')): ?>
                    <li class="<?php echo e(( in_array($controller, array('ReportsController') ) && in_array($action, array('tasksReport') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(url('/admin/reports/tasks-report')); ?>">
                            <i class="material-icons">insert_chart_outlined</i>
                            <span class="title"><?php echo app('translator')->getFromJson('custom.reports.tasks-report'); ?></span>
                        </a>
                    </li>
                     <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reports_assets_access')): ?>
                    <li class="<?php echo e(( in_array($controller, array('ReportsController') ) && in_array($action, array('assetsReport') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(url('/admin/reports/assets-report')); ?>">
                            <i class="material-icons">pie_chart</i>
                            <span class="title"><?php echo app('translator')->getFromJson('custom.reports.assets-report'); ?></span>
                        </a>
                    </li>
                     <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reports_products_access')): ?>
                    <li class="<?php echo e(( in_array($controller, array('ReportsController') ) && in_array($action, array('productsReport') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(url('/admin/reports/products-report')); ?>">
                            <i class="material-icons">bubble_chart</i>
                            <span class="title"><?php echo app('translator')->getFromJson('custom.reports.products-report'); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reports_purchase_access')): ?>
                    <li class="<?php echo e(( in_array($controller, array('ReportsController') ) && in_array($action, array('purchaseOrdersReport') ) ) ? 'active' : ''); ?>">
                        <a href="<?php echo e(url('/admin/reports/purchase-orders-report')); ?>">
                            <i class="material-icons">bar_chart</i>
                            <span class="title"><?php echo app('translator')->getFromJson('custom.reports.purchase-order-report'); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
            </li>
            <?php endif; ?>


                 <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('modules_management_access')): ?>
            <li class="<?php echo e(( in_array($controller, array('ModulesManagementsController') ) && in_array($action, array('index', 'create', 'edit', 'show') ) ) ? 'active' : ''); ?>">
                <a href="<?php echo e(route('admin.modules_managements.index')); ?>">
                    <i class="material-icons">iso</i>
                    <span><?php echo app('translator')->getFromJson('modulesmanagement::global.modules-management.title'); ?></span>
                </a>
            </li>
            <?php endif; ?>

            <?php if($unread = App\MessengerTopic::countUnread()): ?>
            <li class="<?php echo e($request->segment(2) == 'messenger' ? 'active' : ''); ?> <?php echo e(($unread > 0 ? 'unread' : '')); ?>">
                <a href="<?php echo e(route('admin.messenger.index')); ?>">
                    <i class="material-icons">email</i>

                    <span><?php echo app('translator')->getFromJson('custom.app_messages'); ?></span>
                    <?php if($unread > 0): ?>
                        <?php echo e(($unread > 0 ? '('.$unread.')' : '')); ?>

                    <?php endif; ?>
                </a>
            </li>

            <?php endif; ?>

            <li class="<?php echo e($request->segment(1) == 'change_password' ? 'active' : ''); ?>">
                <a href="<?php echo e(route('auth.change_password')); ?>">
                    <i class="material-icons">vpn_key</i>
                    <span class="title"><?php echo app('translator')->getFromJson('global.app_change_password'); ?></span>
                </a>
            </li>

            <li>
                <a href="#logout" onclick="$('#logout').submit();">
                    <i class="material-icons">subdirectory_arrow_left</i>
                    <span class="title"><?php echo app('translator')->getFromJson('global.app_logout'); ?></span>
                </a>
            </li>


            <?php endif; ?>
        </ul>
    </div>

    <?php if( ! empty( getSetting('rights_reserved','site_settings') ) ): ?>
        <!-- Footer -->
        <div class="legal">
            
            <?php
            $copyrights = getSetting('rights_reserved','site_settings');
            ?>
            <div class="copyright"><?php echo e($copyrights); ?></div>
            
        </div>
        <!-- #Footer -->
        <?php endif; ?>
        </aside>
    </section>