<?php $request = app('Illuminate\Http\Request'); ?>


<?php $__env->startSection('content'); ?>
    <h3 class="page-title"><?php echo app('translator')->getFromJson('modulesmanagement::global.modules-management.title'); ?></h3>
    <?php if(Gate::check('modules_management_create') || Gate::check('modules_management_upload') ): ?>
    <p>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('modules_management_create')): ?>
        <a href="<?php echo e(route('admin.modules_managements.create')); ?>" class="btn btn-success"><i class="fa fa-plus"></i>&nbsp;<?php echo app('translator')->getFromJson('global.app_add_new'); ?></a>
        <?php endif; ?>
        <?php if( Gate::check('modules_management_upload') && isEnable('debug') ): ?>
        &nbsp;|&nbsp;<a href="<?php echo e(route('admin.plugins.upload')); ?>" class="btn btn-success"><i class="fa fa-upload"></i>&nbsp;<?php echo app('translator')->getFromJson('custom.common.upload'); ?></a>
        <?php endif; ?>
    </p>
    <?php endif; ?>

    <?php if( isEnable('debug') ): ?>
    <p>
        <ul class="list-inline">
            <li><a href="<?php echo e(route('admin.modules_managements.index')); ?>" style="<?php echo e(request('show_deleted') == 1 ? '' : 'font-weight: 700'); ?>"><?php echo app('translator')->getFromJson('global.app_all'); ?>
    <span class="badge"><?php echo e(\Modules\ModulesManagement\Entities\ModulesManagement::count()); ?></span>
            </a></li> 
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('modules_management_delete')): ?>|
            <li><a href="<?php echo e(route('admin.modules_managements.index')); ?>?show_deleted=1" style="<?php echo e(request('show_deleted') == 1 ? 'font-weight: 700' : ''); ?>"><?php echo app('translator')->getFromJson('global.app_trash'); ?>
                   <span class="badge"><?php echo e(\Modules\ModulesManagement\Entities\ModulesManagement::onlyTrashed()->count()); ?> </span>
            </a></li>
            <?php endif; ?>
        </ul>
    </p>
    <?php endif; ?>
    

    <div class="panel panel-default">
        <div class="panel-heading">
            <?php echo app('translator')->getFromJson('global.app_list'); ?>
        </div>

        <div class="panel-body table-responsive">
            <table class="table table-bordered table-striped ajaxTable <?php if( isEnable('debug') ): ?> <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('modules_management_delete_multi')): ?> <?php if( request('show_deleted') != 1 ): ?> dt-select <?php endif; ?> <?php endif; ?> <?php endif; ?>">
                <thead>
                    <tr>
                        <?php if( isEnable('debug') ): ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('modules_management_delete_multi')): ?>
                                <?php if( request('show_deleted') != 1 ): ?><th style="text-align:center;"><input type="checkbox" id="select-all" /></th><?php endif; ?>
                            <?php endif; ?>
                        <?php endif; ?>

                        <th><?php echo app('translator')->getFromJson('modulesmanagement::global.modules-management.fields.name'); ?></th>
                        <th><?php echo app('translator')->getFromJson('modulesmanagement::global.modules-management.fields.slug'); ?></th>
                        <th><?php echo app('translator')->getFromJson('modulesmanagement::global.modules-management.fields.type'); ?></th>
                        <th><?php echo app('translator')->getFromJson('modulesmanagement::global.modules-management.fields.enabled'); ?></th>
                        <?php if( request('show_deleted') == 1 ): ?>
                        <th>&nbsp;</th>
                        <?php else: ?>
                        <th>&nbsp;</th>
                        <?php endif; ?>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?> 
    <script>
        <?php if( isEnable('debug') ): ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('modules_management_delete_multi')): ?>
            <?php if( request('show_deleted') != 1 ): ?> window.route_mass_crud_entries_destroy = '<?php echo e(route('admin.modules_managements.mass_destroy')); ?>'; <?php endif; ?>
        <?php endif; ?>
        <?php endif; ?>
        $(document).ready(function () {
            window.dtDefaultOptions.buttons = [];

            window.dtDefaultOptions.ajax = '<?php echo route('admin.modules_managements.index'); ?>?show_deleted=<?php echo e(request('show_deleted')); ?>';
            window.dtDefaultOptions.columns = [<?php if( isEnable('debug') ): ?><?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('modules_management_delete_multi')): ?>
                <?php if( request('show_deleted') != 1 ): ?>
                    {data: 'massDelete', name: 'id', searchable: false, sortable: false},
                <?php endif; ?>
                <?php endif; ?>
                <?php endif; ?>
                {data: 'name', name: 'name'},
                {data: 'slug', name: 'slug'},
                {data: 'type', name: 'type'},
                {data: 'enabled', name: 'enabled'},
                
                {data: 'actions', name: 'actions', searchable: false, sortable: false}
            ];
            processAjaxTables();
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>