<?php $request = app('Illuminate\Http\Request'); ?>


<?php $__env->startSection('content'); ?>
    <h3 class="page-title"><?php echo app('translator')->getFromJson('sitethemes::global.site-themes.title'); ?></h3>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('site_theme_create')): ?>
    <p>
        <a href="<?php echo e(route('admin.site_themes.create')); ?>" class="btn btn-success"><i class="fa fa-plus"></i>&nbsp;<?php echo app('translator')->getFromJson('global.app_add_new'); ?></a>
        
    </p>
    <?php endif; ?>

    
    

    <div class="panel panel-default">
        <div class="panel-heading">
            <?php echo app('translator')->getFromJson('global.app_list'); ?>
        </div>

        <div class="panel-body">
            <table style="width:100%" class="table nowrap table-bordered table-striped ajaxTable">
                <thead>
                    <tr>
                        <th><?php echo app('translator')->getFromJson('sitethemes::global.site-themes.fields.title'); ?></th>
                        <th><?php echo app('translator')->getFromJson('sitethemes::global.site-themes.fields.theme-title-key'); ?></th>
                        <th><?php echo app('translator')->getFromJson('sitethemes::global.site-themes.fields.is-active'); ?></th>
                        <th><?php echo app('translator')->getFromJson('sitethemes::global.site-themes.fields.settings'); ?></th>
                        <?php if( request('show_deleted') == 1 ): ?>
                        <th>&nbsp;</th>
                        <?php else: ?>
                        <th>&nbsp;</th>
                        <?php endif; ?>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?> 
    <script>

        $(document).ready(function () {
            window.dtDefaultOptions.ajax = '<?php echo route('admin.site_themes.index'); ?>';
            window.dtDefaultOptions.buttons = [];
            window.dtDefaultOptions.columns = [
                {data: 'title', name: 'title'},
                {data: 'theme_title_key', name: 'theme_title_key'},
                {data: 'is_active', name: 'is_active'},
                {data: 'settings_data', name: 'settings_data'},
                
                {data: 'actions', name: 'actions', searchable: false, sortable: false}
            ];
            processAjaxTables();
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>