<div class="row">
    <div class="col-xs-<?php echo e(COLUMNS); ?>">
        <div class="form-group">
        <?php echo Form::label('name', trans('global.project-tasks.fields.name').'*', ['class' => 'control-label']); ?>

        <?php echo Form::text('name', old('name'), ['class' => 'form-control', 'placeholder' => '', 'required' => '']); ?>

        <p class="help-block"></p>
        <?php if($errors->has('name')): ?>
            <p class="help-block">
                <?php echo e($errors->first('name')); ?>

            </p>
        <?php endif; ?>
        </div>
    </div>


    <div class="col-xs-<?php echo e(COLUMNS); ?>">
        <?php echo Form::label('priority', trans('global.project-tasks.fields.priority').'*', ['class' => 'control-label']); ?>

       <?php echo Form::select('priority', $priorities ,old('priority'), ['class' => 'form-control select2', 'required' => '']); ?>

        <p class="help-block"></p>
        <?php if($errors->has('priority')): ?>
            <p class="help-block">
                <?php echo e($errors->first('priority')); ?>

            </p>
        <?php endif; ?>
    </div>

    <div class="col-xs-<?php echo e(COLUMNS); ?>">
        <?php echo Form::label('startdate', trans('global.project-tasks.fields.startdate').'*', ['class' => 'control-label']); ?>

        <?php
        $startdate = ! empty($project_task->startdate) ? digiDate( $project_task->startdate ) : '';
        ?>
        <?php echo Form::text('startdate', old('startdate', $startdate), ['class' => 'form-control date', 'placeholder' => '', 'required' => '']); ?>

        <p class="help-block"></p>
        <?php if($errors->has('startdate')): ?>
            <p class="help-block">
                <?php echo e($errors->first('startdate')); ?>

            </p>
        <?php endif; ?>
    </div>

    <div class="col-xs-<?php echo e(COLUMNS); ?>">
        <?php echo Form::label('duedate', trans('global.project-tasks.fields.duedate').'', ['class' => 'control-label']); ?>

        <?php
        $duedate = ! empty($project_task->duedate) ? digiDate( $project_task->duedate ) : '';
        ?>
        <?php echo Form::text('duedate', old('duedate', $duedate), ['class' => 'form-control date', 'placeholder' => '']); ?>

        <p class="help-block"></p>
        <?php if($errors->has('duedate')): ?>
            <p class="help-block">
                <?php echo e($errors->first('duedate')); ?>

            </p>
        <?php endif; ?>
    </div>

    <div class="col-xs-<?php echo e(COLUMNS); ?>">
         <?php
        $datefinished = ! empty($project_task->datefinished) ? digiDate( $project_task->datefinished ) : '';
        ?>
        <?php echo Form::label('datefinished', trans('global.project-tasks.fields.datefinished').'', ['class' => 'control-label']); ?>

        <?php echo Form::text('datefinished', old('datefinished',$datefinished), ['class' => 'form-control date', 'placeholder' => '']); ?>

        <p class="help-block"></p>
        <?php if($errors->has('datefinished')): ?>
            <p class="help-block">
                <?php echo e($errors->first('datefinished')); ?>

            </p>
        <?php endif; ?>
    </div>


    <div class="col-xs-<?php echo e(COLUMNS); ?>">
        <?php echo Form::label('status', trans('global.project-tasks.fields.status').'', ['class' => 'control-label']); ?>

        <?php echo Form::select('status', $statuses, old('status'), ['class' => 'form-control select2']); ?>

        <p class="help-block"></p>
        <?php if($errors->has('status')): ?>
            <p class="help-block">
                <?php echo e($errors->first('status')); ?>

            </p>
        <?php endif; ?>
    </div>

    

    <div class="col-xs-<?php echo e(COLUMNS); ?>">
        <?php echo Form::label('billable', trans('global.project-tasks.fields.billable').'', ['class' => 'control-label']); ?>

        <?php echo Form::select('billable', $enum_billable, old('billable'), ['class' => 'form-control select2']); ?>

        <p class="help-block"></p>
        <?php if($errors->has('billable')): ?>
            <p class="help-block">
                <?php echo e($errors->first('billable')); ?>

            </p>
        <?php endif; ?>
    </div>

    <div class="col-xs-<?php echo e(COLUMNS); ?>">
        <?php echo Form::label('recurring_id', trans('global.project-tasks.fields.recurring').'', ['class' => 'control-label']); ?>

        <?php echo Form::select('recurring_id', $recurrings, old('recurring_id'), ['class' => 'form-control select2', 'id' => 'recurring_period_id']); ?>

        <p class="help-block"></p>
        <?php if($errors->has('recurring_id')): ?>
            <p class="help-block">
                <?php echo e($errors->first('recurring_id')); ?>

            </p>
        <?php endif; ?>
    </div>

    <div class="col-xs-<?php echo e(COLUMNS); ?>">
        <?php echo Form::label('recurring_value', trans('global.project-tasks.fields.recurring-value').'', ['class' => 'control-label']); ?>

        <?php echo Form::number('recurring_value', old('recurring_value'), ['class' => 'form-control', 'placeholder' => '','min'=>'0']); ?>

        <p class="help-block"></p>
        <?php if($errors->has('recurring_value')): ?>
            <p class="help-block">
                <?php echo e($errors->first('recurring_value')); ?>

            </p>
        <?php endif; ?>
    </div>

    <div class="col-xs-<?php echo e(COLUMNS); ?>">
        <?php echo Form::label('recurring_type', trans('global.project-tasks.fields.recurring-type').'', ['class' => 'control-label']); ?>

        <?php echo Form::select('recurring_type', $enum_recurring_type, old('recurring_type'), ['class' => 'form-control select2']); ?>

        <p class="help-block"></p>
        <?php if($errors->has('recurring_type')): ?>
            <p class="help-block">
                <?php echo e($errors->first('recurring_type')); ?>

            </p>
        <?php endif; ?>
    </div>

    

    <div class="col-xs-<?php echo e(COLUMNS); ?>">
        <?php echo Form::label('cycles', trans('global.project-tasks.fields.cycles').'', ['class' => 'control-label']); ?>

        <?php echo Form::number('cycles', old('cycles'), ['class' => 'form-control', 'placeholder' => '','min'=>'0']); ?>

        <p class="help-block"></p>
        <?php if($errors->has('cycles')): ?>
            <p class="help-block">
                <?php echo e($errors->first('cycles')); ?>

            </p>
        <?php endif; ?>
    </div>
    

    <div class="col-xs-<?php echo e(COLUMNS); ?>">
        <?php echo Form::label('billed', trans('global.project-tasks.fields.billed').'', ['class' => 'control-label']); ?>

        <?php echo Form::select('billed', $enum_billed, old('billed'), ['class' => 'form-control select2']); ?>

        <p class="help-block"></p>
        <?php if($errors->has('billed')): ?>
            <p class="help-block">
                <?php echo e($errors->first('billed')); ?>

            </p>
        <?php endif; ?>
    </div>

    <div class="col-xs-<?php echo e(COLUMNS); ?>">
        <?php echo Form::label('hourly_rate', trans('global.project-tasks.fields.hourly-rate').'', ['class' => 'control-label']); ?>

        <?php echo Form::number('hourly_rate', old('hourly_rate'), ['class' => 'form-control', 'placeholder' => '','min'=>'0']); ?>

        <p class="help-block"></p>
        <?php if($errors->has('hourly_rate')): ?>
            <p class="help-block">
                <?php echo e($errors->first('hourly_rate')); ?>

            </p>
        <?php endif; ?>
    </div>

    <div class="col-xs-<?php echo e(COLUMNS); ?>">
        <?php echo Form::label('visible_to_client', trans('global.project-tasks.fields.visible-to-client').'', ['class' => 'control-label']); ?>

        <?php echo Form::select('visible_to_client', $enum_visible_to_client, old('visible_to_client'), ['class' => 'form-control select2']); ?>

        <p class="help-block"></p>
        <?php if($errors->has('visible_to_client')): ?>
            <p class="help-block">
                <?php echo e($errors->first('visible_to_client')); ?>

            </p>
        <?php endif; ?>
    </div>

    <div class="col-xs-<?php echo e(COLUMNS); ?>">
        <?php echo Form::label('milestone', trans('global.project-tasks.fields.milestone').'', ['class' => 'control-label']); ?>

        <?php echo Form::select('milestone', $mile_stones, old('milestone'), ['class' => 'form-control select2']); ?>

        <p class="help-block"></p>
        <?php if($errors->has('milestone')): ?>
            <p class="help-block">
                <?php echo e($errors->first('milestone')); ?>

            </p>
        <?php endif; ?>
    </div>
</div>
    <div class="row">
    <div class="col-xs-6">
    <div class="form-group">
        <?php echo Form::label('assigned_to', trans('global.client-projects.fields.assigned-to').'', ['class' => 'control-label']); ?>

        <button type="button" class="btn btn-primary btn-xs" id="selectbtn-assigned_to">
            <?php echo e(trans('global.app_select_all')); ?>

        </button>
        <button type="button" class="btn btn-primary btn-xs" id="deselectbtn-assigned_to">
            <?php echo e(trans('global.app_deselect_all')); ?>

        </button>
        <?php echo Form::select('assigned_to[]', $users, old('assigned_to'), ['class' => 'form-control select2', 'multiple' => 'multiple', 'id' => 'selectall-assigned_to' ]); ?>

        <p class="help-block"></p>
        <?php if($errors->has('assigned_to')): ?>
            <p class="help-block">
                <?php echo e($errors->first('assigned_to')); ?>

            </p>
        <?php endif; ?>
    </div>
    </div>

    <div class="col-xs-6">
        <?php echo Form::label('attachments', trans('global.project-tasks.fields.attachments').'', ['class' => 'control-label']); ?>

        <?php echo Form::file('attachments[]', [
            'multiple',
            'class' => 'form-control file-upload',
            'data-url' => route('admin.media.upload'),
            'data-bucket' => 'attachments',
            'data-filekey' => 'attachments',
            'data-accept' => FILE_TYPES_GENERAL,
            ]); ?>

        <p class="help-block"><?php echo e(trans('others.global_file_types_general')); ?></p>
        <div class="photo-block">
            <div class="progress-bar">&nbsp;</div>
            <div class="files-list">
                <?php if( ! empty($project_task) ): ?>
                    <?php $__currentLoopData = $project_task->getMedia('attachments'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $media): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <p class="form-group">
                            <a href="<?php echo e($media->getUrl()); ?>" target="_blank"><?php echo e($media->name); ?> (<?php echo e($media->size); ?> KB)</a>
                            <a href="#" class="btn btn-xs btn-danger remove-file">Remove</a>
                            <input type="hidden" name="attachments_id[]" value="<?php echo e($media->id); ?>">
                        </p>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>
        </div>
        <?php if($errors->has('attachments')): ?>
            <p class="help-block">
                <?php echo e($errors->first('attachments')); ?>

            </p>
        <?php endif; ?>
    </div>
</div>

    
 <div class="row">
    <div class="col-xs-12">
        <?php echo Form::label('description', trans('global.project-tasks.fields.description').'', ['class' => 'control-label']); ?>

        <?php echo Form::textarea('description', old('description'), ['class' => 'form-control editor', 'placeholder' => '']); ?>

        <p class="help-block"></p>
        <?php if($errors->has('description')): ?>
            <p class="help-block">
                <?php echo e($errors->first('description')); ?>

            </p>
        <?php endif; ?>
    </div>


</div>