<div class="ibox-content">
<div class="invoice" id="invoice_pdf">  
<?php echo $__env->make('admin.common.invoice-stylesheet', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
 <style>
.footer {
  position: absolute;
  left: 0;
  bottom: 0;
  width: 100%;
  color: #333;
    background-color: white;
  text-align: center;
}
.main-header .navbar .nav > li > a > .label{
        padding: 2px 3px 11px 2px !important;
   }
    </style>

        <header><br/>
            <h1><?php echo e(trans('proposals::custom.proposals.title-single')); ?></h1>
            <address>
                <h4 class="red"><strong><?php echo e(trans('proposals::custom.proposals.proposal_no') . $invoice->invoicenumberdisplay); ?></strong></h4>
                <?php if(! empty($invoice->reference) ): ?>
                <h4 class="red"><strong><?php echo e(trans('proposals::custom.proposals.reference') . $invoice->reference); ?></strong></h4>
                <?php endif; ?>

                   <?php
              
                $class = 'danger'; // Un-paid, due
                $paymentstatus = $invoice->paymentstatus;
                if ( empty( $paymentstatus ) ) {
                    $paymentstatus = 'due';
                }
                $title = trans('custom.invoices.' . $paymentstatus);
                if ( 'accepted' == $paymentstatus ) {
                    $class = 'success';
                }
                if ( 'rejected' == $paymentstatus ) {
                    $class = 'danger';
                }
                
                if ( 'delivered' == $paymentstatus ) {  
                    $class = 'info';
                }


                ?>
                <h3 class="alert alert-<?php echo e($class); ?> alert-bg-p"><?php echo e(strtoupper($title)); ?></h3>
            </address>
            <?php
                    $logo = getSetting('Proposal-Logo', 'proposal-settings');
                    if ( empty( $logo ) ) {
                        $logo = getSetting('site_logo', 'site_settings');
                    }
                    ?>
            <table class="meta">
            <tr><td class="beta2"><img alt="" src="<?php echo e(asset( 'uploads/settings/' . $logo )); ?>" height="56" width="180"></td></tr> 
                <tr><td class="beta3"></td></tr>
                <tr><td class="beta2"><strong><?php echo e(getSetting('Company_Name_On_Proposal', 'proposal-settings', trans('global.global_title'))); ?></strong></td></tr>
                <tr><td class="beta2"><?php echo e(getSetting('Company-Address', 'proposal-settings')); ?></td></tr>
            </table>
            <address>
                <p><strong><?php echo e(trans('proposals::custom.proposals.recipient')); ?></strong></p>
                 <?php
                     if ( ! empty( $invoice->customer->company->name )) {
                   ?>
                <p><?php echo e($invoice->customer->company->name); ?></p>

                <?php } ?>

                <p><strong><?php echo e(trans('custom.invoices.attn')); ?></strong>&nbsp;<?php echo e($invoice->customer->first_name . ' ' . $invoice->customer->last_name); ?></p>

                <p><?php echo e($invoice->address); ?></p>
                
                <p><strong><?php echo e(trans('custom.common.phone')); ?></strong> <?php echo e($invoice->customer->phone1); ?></p>

                <?php if(! empty( $invoice->customer->email ) ): ?>
                <p><strong><?php echo e(trans('custom.common.email')); ?></strong> <?php echo e($invoice->customer->email); ?></p>
                <?php endif; ?>
                <br/>

               <?php if( 'yes' === $invoice->show_delivery_address ): ?> 
                <p><strong><?php echo e(trans('custom.invoices.ship-to')); ?></strong></p>
                <p><?php echo clean($invoice->delivery_address); ?></p>
            </address>
            <?php endif; ?>
        </header>
        <article>
            <table class="balance">
                <tr>
                    <th><span><?php echo e(trans('proposals::custom.proposals.proposal-date')); ?></span></th>
                    <td><span><?php echo e($invoice->invoice_date ? digiDate($invoice->invoice_date) : ''); ?></span></td>
                </tr>
                <tr>
                    <th><span><?php echo e(trans('global.proposals.fields.proposal-expiry-date')); ?></span></th>
                    <td><span><?php echo e($invoice->invoice_due_date ? digiDate($invoice->invoice_due_date) : ''); ?></span></td>
                </tr>

                   <?php
                    $show_sale_agent_on_invoices = getSetting('show_sale_agent_on_proposal', 'proposal-settings');
                    if ( 'yes' == $show_sale_agent_on_invoices && $invoice->sale_agent ) {
                    ?>
                <tr>
                    <th><span><?php echo e(trans('custom.invoices.sale-agent')); ?></span></th>
                    <td><span><?php echo e($invoice->saleagent->name); ?></span></td>
                <?php } ?>
                </tr>

                <tr>
                    <th><span><?php echo e(trans('proposals::custom.proposals.total')); ?></span></th>
                    <td><span> <?php echo e(digiCurrency($invoice->amount, $invoice->currency_id)); ?></span></td>
                </tr>

                 
            </table>
             <?php if( isPluginActive('product') ): ?> 
            <table class="inventory invoice-items">
                <thead>
                    <tr>
                        <th><span><?php echo e(trans('custom.products.item_name')); ?></span></th>
                        <th>
                        <?php if( ! empty( $invoice->show_quantity_as ) ): ?>
                            <span><?php echo e($invoice->show_quantity_as); ?></span>
                        <?php else: ?>
                            <span><?php echo e(trans('custom.products.quantity')); ?></span>
                        <?php endif; ?> 

                        </th>
                        <th><span><?php echo e(trans('custom.products.rate')); ?></span></th>
                        <th><span><?php echo e(trans('custom.products.tax_percent')); ?></span></th>
                        <th><span><?php echo e(trans('custom.products.tax')); ?></span></th>
                        <th><span><?php echo e(trans('custom.products.discount_percent')); ?></span></th>
                        <th><span><?php echo e(trans('custom.products.discount')); ?></span></th>
                        <th><span><?php echo e(trans('custom.products.amount')); ?></span></th>
                    </tr>
                </thead>


                <?php
                $products = ! empty( $invoice->products ) ? json_decode( $invoice->products ) : array();
            
                if ( ! empty( $products ) ) {
                 
                    $product_names = ! empty( $products->product_name ) ? $products->product_name : [];
                    $total_tax = $products->total_tax;
                    $total_discount = $products->total_discount;
                    $products_amount = $products->products_amount;
                    $sub_total = $products->sub_total;
                    $grand_total = $products->grand_total;
                    
                    $product_qtys = $products->product_qty;
                    $product_prices = $products->product_price;

                    $product_taxs = $products->product_tax;
                    $tax_types = $products->tax_type;
                    $tax_values = $products->tax_value;

                    $product_discounts = $products->product_discount;
                    $discount_types = $products->discount_type;
                    $discount_values = $products->discount_value;

                    $product_subtotals = $products->product_subtotal;
                    $pids = $products->pid;
                    $units = $products->unit;
                    $hsns = $products->hsn;
                    $alerts = $products->alert;
                    $stock_quantitys = $products->stock_quantity;
                    $product_ids = $products->product_ids;
                    $product_descriptions = $products->product_description;
                    for( $i = 0; $i < count( $product_names ); $i++ ) {

                        $product_name = ! empty( $product_names[ $i ] ) ? $product_names[ $i ] : '';
                        if ( is_numeric( $product_name ) ) {
                            $product = \App\Product::where('id', '=', $product_name )->first();
                            if ( $product ) {
                                $product_name = $product->name;
                            }
                        }
                        $product_qty = ! empty( $product_qtys[ $i ] ) ? $product_qtys[ $i ] : '1';
                        $product_price = ! empty( $product_prices[ $i ] ) ? $product_prices[ $i ] : '0';
                        $product_amount = $product_qty * $product_price;

                        $product_tax = ! empty( $product_taxs[ $i ] ) ? $product_taxs[ $i ] : '0'; // Rate.
                        $product_tax_display = digiCurrency( $product_tax, $invoice->currency_id );

                        $tax_type = ! empty( $tax_types[ $i ] ) ? $tax_types[ $i ] : 'percent';
                      
                        if ( 'percent' === $tax_type ) {
                            $tax_value = ( $product_amount * $product_tax) / 100;
                            $product_tax_display = $product_tax . ' %';
                        } else {
                            $tax_value = $product_tax;
                        }


                        $product_discount = ! empty( $product_discounts[ $i ] ) ? $product_discounts[ $i ] : '0';
                        $product_discount_display = digiCurrency( $product_discount, $invoice->currency_id );
                        $discount_type = ! empty( $discount_types[ $i ] ) ? $discount_types[ $i ] : 'percent';
                     
                        if ( 'percent' === $discount_type ) {
                            $discount_value = ( $product_amount * $product_discount) / 100;
                            $product_discount_display = $product_discount . ' %';
                        } else {
                            $discount_value = $product_discount;
                        }



                        $amount = $product_amount + $tax_value - $discount_value;
                       
                        $product_subtotal = ! empty( $product_subtotals[ $i ] ) ? $product_subtotals[ $i ] : '0';
                        $pid = ! empty( $pids[ $i ] ) ? $pids[ $i ] : '';
                        $unit = ! empty( $units[ $i ] ) ? $units[ $i ] : '';
                        $hsn = ! empty( $hsns[ $i ] ) ? $hsns[ $i ] : '';
                        $alert = ! empty( $alerts[ $i ] ) ? $alerts[ $i ] : '';
                        $stock_quantity = ! empty( $stock_quantitys[ $i ] ) ? $stock_quantitys[ $i ] : '';
                        $product_id = ! empty( $product_ids[ $i ] ) ? $product_ids[ $i ] : '';
                        $product_description = ! empty( $product_descriptions[ $i ] ) ? $product_descriptions[ $i ] : '';
                    ?>

                <tbody>
                    <tr class="product_row" data-rowid="<?php echo e($i); ?>" data-product_id="<?php echo e($pid); ?>">
                        <td><span><?php echo e($product_name); ?></span></td>
                        <td><span><?php echo e($product_qty); ?></span></td>
                        <td><span><?php echo e(digiCurrency( $product_amount, $invoice->currency_id )); ?></span></td>
                        <td><span><?php echo e($product_tax_display); ?></span></td>
                        <td id="tax_value_display-<?php echo e($i); ?>"><span><?php echo e(digiCurrency($tax_value, $invoice->currency_id)); ?></span></td>
                        <td id="discount_value_display-<?php echo e($i); ?>"><span><?php echo e($product_discount_display); ?></span></td>
                        <td><span><?php echo e(digiCurrency($discount_value, $invoice->currency_id)); ?></span></td>
                        <td id="result-<?php echo e($i); ?>"><span><?php echo e(digiCurrency($amount, $invoice->currency_id)); ?></span></td>
                    </tr>
                        <?php
                    }
                }else {
                    $total_tax = 0;
                    $total_discount = 0;
                    $total_products_amount = 0;
                    $sub_total = 0;
                    $grand_total = 0;
                 }
                ?>
                </tbody>
            </table>
            <table class="balance">
                <tr>
                    <th><span><?php echo app('translator')->getFromJson('custom.products.total_tax'); ?></span></th>
                    <td><span class="amount"><?php echo e(digiCurrency($total_tax, $invoice->currency_id)); ?></span></td>
                </tr>
                <tr>
                    <th><span><?php echo app('translator')->getFromJson('custom.products.sub_total'); ?></span></th>
                    <td><span class="amount"><?php echo e(digiCurrency($sub_total, $invoice->currency_id)); ?></span></td>
                </tr>
                <tr>
                    <th><span><?php echo app('translator')->getFromJson('custom.products.total_discount'); ?></span></th>
                    <td><span class="amount"><?php echo e(digiCurrency($total_discount, $invoice->currency_id)); ?></span></td>
                </tr>
                <tr>
                    <th><span><?php echo app('translator')->getFromJson('custom.products.grand_total'); ?></span></th>
                    <td><span class="amount"><?php echo e(digiCurrency($grand_total, $invoice->currency_id)); ?></span></td>
                </tr>
                <?php
                    $additionals = false;
                    if ( ! empty( $products->cart_tax ) && $products->cart_tax > 0 ) {
                        $additionals = true;
                    ?>                <tr>
                    <th><span><?php echo app('translator')->getFromJson('custom.products.additional-tax'); ?></span></th>
                    <td><span><?php echo e(digiCurrency($products->cart_tax, $invoice->currency_id)); ?></span></td>
                </tr>
                <?php } ?>

                 <?php
                    if ( ! empty( $products->cart_discount ) && $products->cart_discount > 0 ) {
                        $additionals = true;
                    ?>
                <tr>
                    <th><span><?php echo app('translator')->getFromJson('custom.products.additional-discount'); ?></span></th>
                    <td><span><?php echo e(digiCurrency($products->cart_discount, $invoice->currency_id)); ?></span></td>
                </tr>
                <?php } ?>

                 <?php
                    if ( true === $additionals ) {
                    ?>
                <tr>
                    <th><span><?php echo app('translator')->getFromJson('custom.products.amount-payable'); ?></span></th>
                    <td><span><?php echo e(digiCurrency($products->amount_payable, $invoice->currency_id)); ?></span></td>
                </tr>

                <?php } ?>

                

            </table>
            <?php endif; ?>
        </article>
         <?php
    $enable_signature_part = getSetting('enable-signature-part', 'proposal-settings');
    ?>
    <?php if( 'Yes' === $enable_signature_part ): ?>
            <table class="meta">
            <?php
            $authorized_person = getSetting('Authorized-Person', 'proposal-settings');
            $authorized_sign = getSetting('Authorized-Person-Signature', 'proposal-settings');
            $authorized_designation = getSetting('Authorized-Person-Designation', 'proposal-settings');
            ?>
                <tr><td class="beta"><?php echo app('translator')->getFromJson('custom.invoices.authorized-person'); ?></td></tr>
            <?php if( ! empty( $authorized_sign ) ): ?>
                <tr><td class="beta"><img src="<?php echo e(asset( 'uploads/settings/' . $authorized_sign )); ?>" width="120" height="40" alt=""></td></tr>
                <?php endif; ?>

                <?php if( ! empty( $authorized_person ) ): ?>
                <tr><td class="beta">(<?php echo e($authorized_person); ?>)</td></tr>
                <?php endif; ?>

                <?php if( ! empty( $authorized_designation ) ): ?>
                <tr><td class="beta"><?php echo e($authorized_designation); ?></td></tr>
                <?php endif; ?>
            </table>
            <?php endif; ?>
       
             <article>
                <table class="beta4">
                 <?php if( $invoice->recurring_period_id ): ?>
                     <tr><td class="beta4"><b><?php echo app('translator')->getFromJson('proposals::custom.proposals.payment-terms'); ?> : </b></td></tr>
                     <tr><td><code><?php echo e($invoice->recurring_period->title); ?></code></td></tr>
                     <?php endif; ?>
                 </table>
                 <table class="beta4">
                    
                    <?php if(! empty( $invoice->invoice_notes ) ): ?>
                     <tr><td class="beta4"><b><?php echo app('translator')->getFromJson('global.invoices.fields.client-notes'); ?></b></td></tr>
                     <tr><td><code><?php echo clean($invoice->invoice_notes); ?></code></td></tr>
                     <?php endif; ?>

                        <?php if(! empty( $invoice->admin_notes ) ): ?>
                     <tr><td class="beta4"><b><?php echo app('translator')->getFromJson('global.invoices.fields.admin-notes'); ?></b></td></tr>
                     <tr><td><code><?php echo clean($invoice->admin_notes); ?></code></td></tr>
                     <?php endif; ?>

                     <?php if(! empty( $invoice->terms_conditions ) ): ?>
                     <tr><td class="beta4"><b><?php echo app('translator')->getFromJson('global.invoices.fields.terms-conditions'); ?></b></td></tr>
                     <tr><td><code><?php echo clean($invoice->terms_conditions); ?></code></td></tr>
                     <?php endif; ?>
                 </table>
           </article>
        
       <?php
          $invoice_footer_enable = getSetting('proposal-footer-enable', 'proposal-settings');
        ?>
        <?php if( 'Yes' === $invoice_footer_enable ): ?>
         <?php echo $__env->make('proposals::admin.proposals.invoice.invoice-content-footer', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        <?php endif; ?>


    </div>
</div>