<?php $request = app('Illuminate\Http\Request'); ?>


<?php $__env->startSection('content'); ?>
    <h3 class="page-title">
        <?php if( 'database' === $type ): ?>
            <?php echo app('translator')->getFromJson('databasebackup::global.database-backup.database-backup'); ?>
        <?php elseif( 'files' === $type ): ?>
            <?php echo app('translator')->getFromJson('databasebackup::global.database-backup.files-backup'); ?>
        <?php else: ?>
            <?php echo app('translator')->getFromJson('databasebackup::global.database-backup.database-files-backup'); ?>
        <?php endif; ?>
        </h3>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('database_backup_create')): ?>
    <p>
        <a href="<?php echo e(route('admin.database_backups.create')); ?>" class="btn btn-success"><i class="fa fa-plus"></i>&nbsp;<?php echo app('translator')->getFromJson('databasebackup::global.database-backup.take-backup'); ?></a>

        <a href="<?php echo e(route('admin.databasebackups.index', 'database')); ?>" class="btn <?php if( 'database' === $type ): ?> active <?php else: ?> btn-info <?php endif; ?>"><i class="fa fa-database"></i>&nbsp;<?php echo app('translator')->getFromJson('databasebackup::global.database-backup.database-backup'); ?></a>

        <a href="<?php echo e(route('admin.databasebackups.index', 'files')); ?>" class="btn <?php if( 'files' === $type ): ?> active <?php else: ?> btn-warning <?php endif; ?>"><i class="fa fa-files-o"></i>&nbsp;<?php echo app('translator')->getFromJson('databasebackup::global.database-backup.files-backup'); ?></a>

        <a href="<?php echo e(route('admin.database_backups.index')); ?>" class="btn <?php if( 'both' === $type ): ?> active <?php else: ?> btn-danger <?php endif; ?>"><i class="fa fa-database"></i>&nbsp;<i class="fa fa-files-o"></i>&nbsp;<?php echo app('translator')->getFromJson('databasebackup::global.database-backup.database-files-backup'); ?></a>
        
    </p>
    <?php endif; ?>

    

    <div class="panel panel-default">
        <div class="panel-heading">
            <?php echo app('translator')->getFromJson('global.app_list'); ?>
        </div>

        <div class="panel-body table-responsive">
            <table class="table table-bordered table-striped ajaxTable <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('database_backup_delete_multi')): ?> <?php if( request('show_deleted') != 1 ): ?> dt-select <?php endif; ?> <?php endif; ?>">
                <thead>
                    <tr>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('database_backup_delete_multi')): ?>
                            <?php if( request('show_deleted') != 1 ): ?><th style="text-align:center;"><input type="checkbox" id="select-all" /></th><?php endif; ?>
                        <?php endif; ?>

                        <th><?php echo app('translator')->getFromJson('databasebackup::global.database-backup.fields.name'); ?></th>
                        <th><?php echo app('translator')->getFromJson('databasebackup::global.database-backup.fields.storage-location'); ?></th>
                        <th><?php echo app('translator')->getFromJson('databasebackup::global.database-backup.fields.size'); ?></th>
                        <th><?php echo app('translator')->getFromJson('databasebackup::global.database-backup.fields.created'); ?></th>
                        <?php if( request('show_deleted') == 1 ): ?>
                        <th>&nbsp;</th>
                        <?php else: ?>
                        <th>&nbsp;</th>
                        <?php endif; ?>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?> 
    <script>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('database_backup_delete_multi')): ?>
            <?php if( request('show_deleted') != 1 ): ?> window.route_mass_crud_entries_destroy = '<?php echo e(route('admin.database_backups.mass_destroy')); ?>'; <?php endif; ?>
        <?php endif; ?>
        $(document).ready(function () {
            window.dtDefaultOptions.buttons = [];
            window.dtDefaultOptions.ajax = '<?php echo route('admin.database_backups.index'); ?>?show_deleted=<?php echo e(request('show_deleted')); ?>&type=<?php echo e($type); ?>';
            window.dtDefaultOptions.columns = [<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('database_backup_delete_multi')): ?>
                <?php if( request('show_deleted') != 1 ): ?>
                    {data: 'massDelete', name: 'id', searchable: false, sortable: false},
                <?php endif; ?>
                <?php endif; ?>{data: 'file_name', name: 'name'},
                {data: 'file_path', name: 'storage_location'},
                {data: 'file_size', name: 'size'},
                {data: 'last_modified', name: 'created'},
                
                {data: 'actions', name: 'actions', searchable: false, sortable: false}
            ];
            processAjaxTables();
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>