<?php $__env->startSection('content'); ?>
    <h3 class="page-title"><?php echo app('translator')->getFromJson('global.tasks.title'); ?></h3>
    
    <?php echo Form::model($task, ['method' => 'PUT', 'route' => ['admin.tasks.update', $task->id], 'files' => true,'class'=>'formvalidation']); ?>


    <div class="panel panel-default">
        <div class="panel-heading">
            <?php echo app('translator')->getFromJson('global.app_edit'); ?>
        </div>

        <div class="panel-body">
            <div class="row">
                <div class="col-xs-4">
                <div class="form-group">
                    <?php echo Form::label('name', trans('global.tasks.fields.name').'*', ['class' => 'control-label form-label']); ?>

                    <div class="form-line">
                    <?php echo Form::text('name', old('name'), ['class' => 'form-control', 'placeholder' => 'Name', 'required' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('name')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('name')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
                </div>

                    <div class="col-xs-4">
                <div class="form-group">
                    <?php echo Form::label('status_id', trans('global.tasks.fields.status').'*', ['class' => 'control-label']); ?>

                    <?php echo Form::select('status_id', $statuses, old('status_id'), ['class' => 'form-control select2', 'required' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('status_id')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('status_id')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>

                  <div class="col-xs-4">
                <div class="form-group">
                    <?php echo Form::label('user_id', trans('global.tasks.fields.user').'', ['class' => 'control-label']); ?>

                    <?php echo Form::select('user_id', $users, old('user_id'), ['class' => 'form-control select2','placeholder' => 'Please select']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('user_id')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('user_id')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
        </div>
      <div class="row">
                
                
                
             <div class="col-xs-4">
                <div class="form-group">
                    <?php echo Form::label('start_date', trans('global.tasks.fields.start-date').'', ['class' => 'control-label form-label']); ?>

                     <?php
                            if ( ! empty( $task ) ) {
                            $start_date = ! empty( $task->start_date ) ? digiDate( $task->start_date ) : '';
                        }
                        ?>
                    <div class="form-line">
                    <?php echo Form::text('start_date', old('start_date',$start_date), ['class' => 'form-control date', 'placeholder' => 'Start Date']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('start_date')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('start_date')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
                </div>
           
                <div class="col-xs-4">
                <div class="form-group">
                    <?php echo Form::label('due_date', trans('global.tasks.fields.due-date').'', ['class' => 'control-label form-label']); ?>

                        <?php
                            if ( ! empty( $task ) ) {
                            $due_date = ! empty( $task->due_date ) ? digiDate( $task->due_date ) : '';
                        }
                        ?>
                    <div class="form-line">
                    <?php echo Form::text('due_date', old('due_date',$due_date), ['class' => 'form-control date', 'placeholder' => 'Due Date']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('due_date')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('due_date')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
                </div>

                <div class="col-xs-4">
                <div class="form-group">
                    


                    <?php echo Form::label('attachment', trans('global.tasks.fields.thumbnail').'', ['class' => 'control-label']); ?>

                    
                    <?php if($task->attachment): ?>
                        <a href="<?php echo e(route('admin.home.media-file-download', ['model' => 'Task', 'field' => 'attachment', 'record_id' => $task->id])); ?>"><?php echo app('translator')->getFromJson('others.download-file'); ?></a>
                    <?php endif; ?>
                </div>
                    <?php echo Form::file('attachment', ['class' => 'form-control']); ?>

                    <?php echo Form::hidden('attachment_max_size', 8); ?>

                    <p class="help-block"><?php echo e(trans('others.global_file_types_gallery')); ?></p>
                    <?php if($errors->has('attachment')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('attachment')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                
            </div>

            <div class="row">

                     <div class="col-xs-8">
                <div class="form-group">
                    <?php echo Form::label('description', trans('global.tasks.fields.description').'', ['class' => 'control-label']); ?>

                    <?php echo Form::textarea('description', old('description'), ['class' => 'form-control ', 'placeholder' => 'Description','rows'=>'4']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('description')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('description')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
        
              
            </div>
            
        </div>
    </div>

    <?php echo Form::submit(trans('global.app_update'), ['class' => 'btn btn-danger wave-effect']); ?>

    <?php echo Form::close(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    ##parent-placeholder-b6e13ad53d8ec41b034c49f131c64e99cf25207a##

    <script src="<?php echo e(url('adminlte/plugins/datetimepicker/moment-with-locales.min.js')); ?>"></script>
    <script src="<?php echo e(url('adminlte/plugins/datetimepicker/bootstrap-datetimepicker.min.js')); ?>"></script>
    <script>
        $(function(){
            moment.updateLocale('<?php echo e(App::getLocale()); ?>', {
                week: { dow: 1 } // Monday is the first day of the week
            });
            
            $('.date').datetimepicker({
                format: "<?php echo e(config('app.date_format_moment')); ?>",
                locale: "<?php echo e(App::getLocale()); ?>",
            });
            
        });
    </script>
            
    <script>
        $("#selectbtn-tag").click(function(){
            $("#selectall-tag > option").prop("selected","selected");
            $("#selectall-tag").trigger("change");
        });
        $("#deselectbtn-tag").click(function(){
            $("#selectall-tag > option").prop("selected","");
            $("#selectall-tag").trigger("change");
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>