<?php
$direction = 'ltr';
if (\Cookie::get('direction')) {
    // die(\Cookie::get('direction'));
    $direction = \Cookie::get('direction');
}
?>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
<title><?php echo e(getSetting('site_title', 'site_settings', trans('global.global_title'))); ?></title>
<!-- Favicon-->
<link rel="icon" href="<?php echo e(IMAGE_PATH_SETTINGS.getSetting('site_favicon', 'site_settings')); ?>" type="image/x-icon" />
<meta name="description" content="<?php echo e(getSetting('meta_description', 'seo_settings')); ?>">
<meta name="keywords" content="<?php echo e(getSetting('meta_keywords', 'seo_settings')); ?>">
<!-- Google Fonts -->
<link href="https://fonts.googleapis.com/css?family=Roboto:400,700&subset=latin,cyrillic-ext" rel="stylesheet" type="text/css">
<link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" type="text/css">

<link href="<?php echo e(url('css/cdn-styles-css/font-awesome-4.7.0/css/font-awesome.min.css')); ?>" rel="stylesheet">

<!-- Bootstrap Core Css -->
<link href="<?php echo e(themes('plugins/bootstrap/css/bootstrap.css')); ?>" rel="stylesheet" type="text/css" media="all">

<!-- Bootstrap Select Css -->
<link href="<?php echo e(themes('plugins/bootstrap-select/css/bootstrap-select.css')); ?>" rel="stylesheet" />

<link href="<?php echo e(themes('css/cdn-bsb-styles-css/jquery-ui.min.css')); ?>" rel="stylesheet" />
<link href="<?php echo e(themes('css/cdn-bsb-styles-css/dataTables.bootstrap.min.css')); ?>" rel="stylesheet" />
<link href="<?php echo e(themes('css/cdn-bsb-styles-css/responsive.bootstrap.min.css')); ?>" rel="stylesheet" />
<link href="<?php echo e(themes('css/cdn-bsb-styles-css/select.dataTables.min.css')); ?>" rel="stylesheet" />


<!-- Waves Effect Css -->
<link href="<?php echo e(themes('plugins/node-waves/waves.css')); ?>" rel="stylesheet" />

<!-- Animation Css -->
<link href="<?php echo e(themes('plugins/animate-css/animate.css')); ?>" rel="stylesheet" />

<!-- Bootstrap DatePicker Css -->
<!--<link href="<?php echo e(themes('plugins/bootstrap-datepicker/css/bootstrap-datepicker.css')); ?>" rel="stylesheet" />-->
<link href="<?php echo e(url('adminlte/plugins/datetimepicker/bootstrap-datetimepicker.min.css')); ?>" rel="stylesheet"/>

<!-- Bootstrap Chosen Css -->
<link href="<?php echo e(themes('plugins/chosen/chosen.css')); ?>" rel="stylesheet" />

<!-- Bootstrap Tagsinput Css -->
<link href="<?php echo e(themes('plugins/bootstrap-tagsinput/bootstrap-tagsinput.css')); ?>" rel="stylesheet">

<link href="<?php echo e(themes('plugins/sweetalert/sweetalert.css')); ?>" rel="stylesheet" />




<!-- Custom Css -->
<link href="<?php echo e(themes('css/style.css')); ?>" rel="stylesheet" type="text/css" media="all">
<?php if( 'rtl' === $direction ): ?>
<!-- Custom RTL Css -->
<link href="<?php echo e(themes('css/style-rtl.css')); ?>" rel="stylesheet">
<?php endif; ?>

<!-- AdminBSB Themes. You can choose a theme from css/themes instead of get all themes -->

<!-- cartpage links -->
<link href="<?php echo e(url('css/products-cart.css')); ?>" rel="stylesheet">
<link href="<?php echo e(url('css/cart-side-page.css')); ?>" rel="stylesheet">

<link href="<?php echo e(themes('css/themes/all-themes.css')); ?>" rel="stylesheet" type="text/css" media="all"/>
<link href="<?php echo e(url('css/stats-style.css')); ?>" rel="stylesheet">

<script type="text/javascript">
	var baseurl = '<?php echo e(url('/')); ?>';
	var crsf_token = '_token';
	var crsf_hash = '<?php echo e(csrf_token()); ?>';

  var currency = '<?php echo e(getDefaultCurrency()); ?>';
  var currency_position = '<?php echo e(getCurrencyPosition()); ?>';
  <?php
  $toundsand_separator = App\Settings::getSetting('toundsand_separator', 'currency_settings');
  if ( empty( $toundsand_separator ) ) {
    $toundsand_separator = ',';
  }
  $decimal_separator = App\Settings::getSetting('decimal_separator', 'currency_settings');
  if ( empty( $toundsand_separator ) ) {
    $toundsand_separator = '.';
  }
 $decimals = App\Settings::getSetting('decimals', 'currency_settings');
  if ( empty( $decimals ) ) {
    $decimals = '2';
  }
  ?>
  var toundsand_separator = '<?php echo e($toundsand_separator); ?>';
  var decimal_separator = '<?php echo e($decimal_separator); ?>';
  var decimals = '<?php echo e($decimals); ?>';
  var js_global = {};
  js_global["cartproducts"] = [];
</script>