<?php $request = app('Illuminate\Http\Request'); ?>


<?php $__env->startSection('content'); ?>
    <h3 class="page-title"><?php echo app('translator')->getFromJson('global.expense.title'); ?></h3>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('expense_create')): ?>
    <p>
        <a href="<?php echo e(route('admin.expenses.create')); ?>" class="btn btn-success"><i class="fa fa-plus"></i>&nbsp;<?php echo app('translator')->getFromJson('global.app_add_new'); ?></a>        
    </p>
    <?php endif; ?>

    <button data-toggle="collapse" data-target="#report"><?php echo app('translator')->getFromJson('custom.incomes.show-report'); ?></button>
    <div id="report" class="collapse">
        <div class="panel panel-default">
            <div class="panel-heading">
                <?php echo app('translator')->getFromJson('custom.expense.summary-in'); ?> <b><?php echo e(getDefaultCurrency()); ?></b>
            </div>
            <div class="panel-body table-responsive">
                <?php echo $__env->make('admin.expenses.report', compact( 'total_expense', 'total_expense_current_month', 'total_expense_current_week', 'total_expense_last_30_days' ) , \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            </div>
        </div>
    </div>

    <button data-toggle="collapse" data-target="#report-graph"><?php echo app('translator')->getFromJson('custom.incomes.show-graph'); ?></button>
    <div id="report-graph" class="collapse">
        <div class="panel panel-default">
            <div class="panel-heading">
                <?php echo app('translator')->getFromJson('custom.expense.summary-in'); ?> <b><?php echo e(getDefaultCurrency()); ?></b>
            </div>
            <div class="panel-body table-responsive">
                <script src="<?php echo e(url('js/cdn-js-files/chartjs250')); ?>/Chart.min.js"></script>
                <?php echo $__env->make('admin.monthly_reports.expense-bar-graph', compact( 'reportTitle_expense', 'reportLabel_expense', 'chartType_expense', 'results_expense' ) , \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            </div>
        </div>
    </div>

    

    <div class="panel panel-default">
        <div class="panel-heading">
            <?php echo app('translator')->getFromJson('global.app_list'); ?>
        </div>

        <div class="panel-body table-responsive">
            <?php echo $__env->make('admin.expenses.records-display', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?> 
    <?php echo $__env->make('admin.expenses.records-display-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>