<?php $request = app('Illuminate\Http\Request'); ?>


<?php $__env->startSection('content'); ?>
    
    <?php echo $__env->make('admin.client_projects.operations.menu', array( 'client_project' => $project), \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <h3 class="page-title"><?php echo app('translator')->getFromJson('global.time-entries.title'); ?></h3>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('time_entry_create')): ?>
    <p>
        <a href="<?php echo e(route('admin.time_entries.create', $project->id)); ?>" class="btn btn-success"><i class="fa fa-plus"></i>&nbsp;<?php echo app('translator')->getFromJson('global.app_add_new'); ?></a>   
    </p>
    <?php endif; ?>

    <p>
        <ul class="list-inline">
            <li><a href="<?php echo e(route('admin.time_entries.index', $project->id)); ?>" style="<?php echo e(request('show_deleted') == 1 ? '' : 'font-weight: 700'); ?>"><?php echo app('translator')->getFromJson('global.app_all'); ?>
                <span class="badge">  

              <?php echo e(\App\TimeEntry::where('project_id', $project->id)->count()); ?>

   
              </span>
            </a></li>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('time_entry_delete')): ?>
            |
            <li><a href="<?php echo e(route('admin.time_entries.index', $project->id)); ?>?show_deleted=1" style="<?php echo e(request('show_deleted') == 1 ? 'font-weight: 700' : ''); ?>"><?php echo app('translator')->getFromJson('global.app_trash'); ?>

                <span class="badge">
          
          <?php echo e(\App\TimeEntry::where('project_id', $project->id)->onlyTrashed()->count()); ?>

          
          </span>     

            </a></li>
            <?php endif; ?>
        </ul>
    </p>
    

    <div class="panel panel-default">
        <div class="panel-heading">
            <?php echo app('translator')->getFromJson('global.app_list'); ?>
        </div>

        <div class="panel-body table-responsive">
            <table class="table table-bordered table-striped ajaxTable <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('time_entry_delete_multi')): ?> <?php if( request('show_deleted') != 1 ): ?> dt-select <?php endif; ?> <?php endif; ?>">
                <thead>
                    <tr>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('time_entry_delete_multi')): ?>
                            <?php if( request('show_deleted') != 1 ): ?><th style="text-align:center;"><input type="checkbox" id="select-all" /></th><?php endif; ?>
                        <?php endif; ?>

                        <th><?php echo app('translator')->getFromJson('global.app_task'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.project-tasks.completed-by'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.time-entries.fields.start-date'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.time-entries.fields.end-date'); ?></th>
                        <?php if( request('show_deleted') == 1 ): ?>
                        <th>&nbsp;</th>
                        <?php else: ?>
                        <th>&nbsp;</th>
                        <?php endif; ?>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?> 
    <script>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('time_entry_delete_multi')): ?>
            <?php if( request('show_deleted') != 1 ): ?> window.route_mass_crud_entries_destroy = '<?php echo e(route('admin.time_entries.mass_destroy', $project->id)); ?>'; <?php endif; ?>
        <?php endif; ?>
        $(document).ready(function () {
            window.dtDefaultOptions.ajax = '<?php echo route('admin.time_entries.index', $project->id); ?>?show_deleted=<?php echo e(request('show_deleted')); ?>';
            window.dtDefaultOptions.columns = [<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('time_entry_delete_multi')): ?>
                <?php if( request('show_deleted') != 1 ): ?>
                    {data: 'massDelete', name: 'id', searchable: false, sortable: false},
                <?php endif; ?>
                <?php endif; ?>
                {data: 'task.name', name: 'task.name',searchable: false, sortable: false},
                {data: 'completed_by.name', name: 'completed_by.name',searchable: false, sortable: false},
                {data: 'start_date', name: 'start_date'},
                {data: 'end_date', name: 'end_date'},
                
                {data: 'actions', name: 'actions', searchable: false, sortable: false}
            ];
            processAjaxTables();
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>