<?php $request = app('Illuminate\Http\Request'); ?>


<?php $__env->startSection('content'); ?>
    <h3 class="page-title"><?php echo app('translator')->getFromJson('global.accounts.title'); ?></h3>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('account_create')): ?>
    <p>
        <a href="<?php echo e(route('admin.accounts.create')); ?>" class="btn btn-success"><i class="fa fa-plus"></i>&nbsp;<?php echo app('translator')->getFromJson('global.app_add_new'); ?></a>        
    </p>
    <?php endif; ?>

    <p>
        <ul class="list-inline">
            <li><a href="<?php echo e(route('admin.accounts.index')); ?>" style="<?php echo e(request('show_deleted') == 1 ? '' : 'font-weight: 700'); ?>"><?php echo app('translator')->getFromJson('global.app_all'); ?>
                <span class="badge"><?php echo e(\App\Account::count()); ?></span>
            </a></li> 
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('account_delete')): ?>
             |
            <li><a href="<?php echo e(route('admin.accounts.index')); ?>?show_deleted=1" style="<?php echo e(request('show_deleted') == 1 ? 'font-weight: 700' : ''); ?>"><?php echo app('translator')->getFromJson('global.app_trash'); ?>

              <span class="badge"> <?php echo e(\App\Account::onlyTrashed()->count()); ?></span>  

            </a></li>
            <?php endif; ?>
        </ul>
    </p>
    

    <div class="panel panel-default">
        <div class="panel-heading">
            <?php echo app('translator')->getFromJson('global.app_list'); ?>
        </div>

        <div class="panel-body table-responsive">
            <table class="table table-bordered table-striped ajaxTable <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('account_delete_multi')): ?> <?php if( request('show_deleted') != 1 ): ?> dt-select <?php endif; ?> <?php endif; ?>">
                <thead>
                    <tr>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('account_delete_multi')): ?>
                            <?php if( request('show_deleted') != 1 ): ?><th style="text-align:center;"><input type="checkbox" id="select-all" /></th><?php endif; ?>
                        <?php endif; ?>

                        <th><?php echo app('translator')->getFromJson('global.accounts.fields.name'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.accounts.fields.initial-balance'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.accounts.fields.account-number'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.accounts.fields.contact-person'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.accounts.fields.phone'); ?></th>
                        <?php if( request('show_deleted') == 1 ): ?>
                        <th>&nbsp;</th>
                        <?php else: ?>
                        <th>&nbsp;</th>
                        <?php endif; ?>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?> 
    <script>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('account_delete_multi')): ?>
            <?php if( request('show_deleted') != 1 ): ?> window.route_mass_crud_entries_destroy = '<?php echo e(route('admin.accounts.mass_destroy')); ?>'; <?php endif; ?>
        <?php endif; ?>
        $(document).ready(function () {
            window.dtDefaultOptions.buttons = [];
            window.dtDefaultOptions.ajax = '<?php echo route('admin.accounts.index'); ?>?show_deleted=<?php echo e(request('show_deleted')); ?>';
            window.dtDefaultOptions.columns = [<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('account_delete_multi')): ?>
                <?php if( request('show_deleted') != 1 ): ?>
                    {data: 'massDelete', name: 'id', searchable: false, sortable: false},
                <?php endif; ?>
                <?php endif; ?>{data: 'name', name: 'name'},
                {data: 'initial_balance', name: 'initial_balance'},
                {data: 'account_number', name: 'account_number'},
                {data: 'contact_person', name: 'contact_person'},
                {data: 'phone', name: 'phone'},
                
                {data: 'actions', name: 'actions', searchable: false, sortable: false}
            ];
            processAjaxTables();
        });
    </script>

    <script>
        jQuery.fn.dataTable.Api.register( 'sum()', function ( ) {
            return this.flatten().reduce( function ( a, b ) {
                if ( typeof a === 'string' ) {
                    a = a.replace(/[^\d.-]/g, '') * 1;
                }
                if ( typeof b === 'string' ) {
                    b = b.replace(/[^\d.-]/g, '') * 1;
                }

                return a + b;
            }, 0 );
        } );
    </script>

    <script>
        $(function() {
            var table = $('.ajaxTable').DataTable();
            $('.ajaxTable').on( 'draw.dt', function () {
                <?php if(request('show_deleted')): ?>
                var tablesum = table.column(1).data().sum();
                <?php else: ?>
                var tablesum = table.column(2).data().sum();
                <?php endif; ?>
                $(".dataTables_info").append('<?php echo e(trans("custom.accounts.sum-of-all-accounts")); ?><b>' + tablesum + '</b>');
            } );
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>